/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl
 * MaintnanceOrderPhaseControl}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.field.MaintnanceOrderPhaseControlField
 * MaintnanceOrderPhaseControlField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.link.MaintnanceOrderPhaseControlLink
 * MaintnanceOrderPhaseControlLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#MAINTENANCE_ORDER
 * MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#MAINTENANCE_PHASE_CONTROL
 * MAINTENANCE_PHASE_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#MAINTENANCE_PHASE_CONTROL_NAME
 * MAINTENANCE_PHASE_CONTROL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#MAINTENANCE_PHASE_CONTROL_TEXT
 * MAINTENANCE_PHASE_CONTROL_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#MAINT_PHSE_CTRL_IS_SET_AUTOMLY
 * MAINT_PHSE_CTRL_IS_SET_AUTOMLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#MAINT_PHASE_CONTROL_AUTHORITY_CODE
 * MAINT_PHASE_CONTROL_AUTHORITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#MAINT_PROCG_PHSE_CTRL_ACTVTN_CODE
 * MAINT_PROCG_PHSE_CTRL_ACTVTN_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#MAINT_PROCG_PHSE_CTRL_ACTVTN_DESC
 * MAINT_PROCG_PHSE_CTRL_ACTVTN_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#EAM_PROCESS_PHASE_CODE
 * EAM_PROCESS_PHASE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#EAM_PROCESS_SUB_PHASE_CODE
 * EAM_PROCESS_SUB_PHASE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#MAINT_OBJ_PHSE_CTRL_STATUS_IS_ACTIVE
 * MAINT_OBJ_PHSE_CTRL_STATUS_IS_ACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#MAINT_OBJ_PHASE_CTRL_CODE_SET_BY
 * MAINT_OBJ_PHASE_CTRL_CODE_SET_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#MAINT_OBJ_PHSE_CTRL_CODE_SET_DTE_TIME
 * MAINT_OBJ_PHSE_CTRL_CODE_SET_DTE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#MAINT_OBJ_PHASE_CTRL_CODE_RESET_BY
 * MAINT_OBJ_PHASE_CTRL_CODE_RESET_BY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#MAINT_OBJ_PHSE_CTRL_CODE_RSET_DTE_TME
 * MAINT_OBJ_PHSE_CTRL_CODE_RSET_DTE_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorder.MaintnanceOrderPhaseControl#TO_MAINTENANCE_ORDER
 * TO_MAINTENANCE_ORDER}</li>
 * </ul>
 *
 */
public interface MaintnanceOrderPhaseControlSelectable extends EntitySelectable<MaintnanceOrderPhaseControl>
{

}
