/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.field.LongTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.link.LongTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.selectable.LongTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Order Confirmation Long Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>LongTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LongText extends VdmEntity<LongText>
{

    /**
     * Selector for all available fields of LongText.
     *
     */
    public final static LongTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderConf</b>
     * </p>
     *
     * @return Completion confirmation number for the operation
     */
    @Key
    @SerializedName( "MaintOrderConf" )
    @JsonProperty( "MaintOrderConf" )
    @Nullable
    @ODataField( odataName = "MaintOrderConf" )
    private String maintOrderConf;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderConf</b> field to query operations.
     *
     */
    public final static LongTextField<String> MAINT_ORDER_CONF = new LongTextField<String>("MaintOrderConf");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderConfCntrValue</b>
     * </p>
     *
     * @return Confirmation counter
     */
    @Key
    @SerializedName( "MaintOrderConfCntrValue" )
    @JsonProperty( "MaintOrderConfCntrValue" )
    @Nullable
    @ODataField( odataName = "MaintOrderConfCntrValue" )
    private String maintOrderConfCntrValue;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderConfCntrValue</b> field to query operations.
     *
     */
    public final static LongTextField<String> MAINT_ORDER_CONF_CNTR_VALUE =
        new LongTextField<String>("MaintOrderConfCntrValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderConfLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "MaintOrderConfLongText" )
    @JsonProperty( "MaintOrderConfLongText" )
    @Nullable
    @ODataField( odataName = "MaintOrderConfLongText" )
    private String maintOrderConfLongText;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderConfLongText</b> field to query operations.
     *
     */
    public final static LongTextField<String> MAINT_ORDER_CONF_LONG_TEXT =
        new LongTextField<String>("MaintOrderConfLongText");
    /**
     * Navigation property <b>to_MaintOrderConfirmation</b> for <b>LongText</b> to single <b>MaintOrderConfirmation</b>.
     *
     */
    @SerializedName( "to_MaintOrderConfirmation" )
    @JsonProperty( "to_MaintOrderConfirmation" )
    @ODataField( odataName = "to_MaintOrderConfirmation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintOrderConfirmation toMaintOrderConfirmation;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintOrderConfirmation</b> navigation property to query
     * operations.
     *
     */
    public final static LongTextOneToOneLink<MaintOrderConfirmation> TO_MAINT_ORDER_CONFIRMATION =
        new LongTextOneToOneLink<MaintOrderConfirmation>("to_MaintOrderConfirmation");

    @Nonnull
    @Override
    public Class<LongText> getType()
    {
        return LongText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderConf</b>
     * </p>
     *
     * @param maintOrderConf
     *            Completion confirmation number for the operation
     */
    public void setMaintOrderConf( @Nullable final String maintOrderConf )
    {
        rememberChangedField("MaintOrderConf", this.maintOrderConf);
        this.maintOrderConf = maintOrderConf;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderConfCntrValue</b>
     * </p>
     *
     * @param maintOrderConfCntrValue
     *            Confirmation counter
     */
    public void setMaintOrderConfCntrValue( @Nullable final String maintOrderConfCntrValue )
    {
        rememberChangedField("MaintOrderConfCntrValue", this.maintOrderConfCntrValue);
        this.maintOrderConfCntrValue = maintOrderConfCntrValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderConfLongText</b>
     * </p>
     *
     * @param maintOrderConfLongText
     *            Long Text
     */
    public void setMaintOrderConfLongText( @Nullable final String maintOrderConfLongText )
    {
        rememberChangedField("MaintOrderConfLongText", this.maintOrderConfLongText);
        this.maintOrderConfLongText = maintOrderConfLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "LongText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintOrderConf", getMaintOrderConf());
        result.put("MaintOrderConfCntrValue", getMaintOrderConfCntrValue());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintOrderConf", getMaintOrderConf());
        values.put("MaintOrderConfCntrValue", getMaintOrderConfCntrValue());
        values.put("MaintOrderConfLongText", getMaintOrderConfLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintOrderConf") ) {
                final Object value = values.remove("MaintOrderConf");
                if( (value == null) || (!value.equals(getMaintOrderConf())) ) {
                    setMaintOrderConf(((String) value));
                }
            }
            if( values.containsKey("MaintOrderConfCntrValue") ) {
                final Object value = values.remove("MaintOrderConfCntrValue");
                if( (value == null) || (!value.equals(getMaintOrderConfCntrValue())) ) {
                    setMaintOrderConfCntrValue(((String) value));
                }
            }
            if( values.containsKey("MaintOrderConfLongText") ) {
                final Object value = values.remove("MaintOrderConfLongText");
                if( (value == null) || (!value.equals(getMaintOrderConfLongText())) ) {
                    setMaintOrderConfLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintOrderConfirmation") ) {
                final Object value = (values).remove("to_MaintOrderConfirmation");
                if( value instanceof Map ) {
                    if( toMaintOrderConfirmation == null ) {
                        toMaintOrderConfirmation = new MaintOrderConfirmation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintOrderConfirmation.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> LongTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LongTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LongTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LongTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderOperationConfirmationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintOrderConfirmation != null ) {
            (values).put("to_MaintOrderConfirmation", toMaintOrderConfirmation);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintOrderConfirmation</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_MaintOrderConfirmation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintOrderConfirmation</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintOrderConfirmation fetchMaintOrderConfirmation()
    {
        return fetchFieldAsSingle("to_MaintOrderConfirmation", MaintOrderConfirmation.class);
    }

    /**
     * Retrieval of associated <b>MaintOrderConfirmation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintOrderConfirmation</b>.
     * <p>
     * If the navigation property <b>to_MaintOrderConfirmation</b> of a queried <b>LongText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintOrderConfirmation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintOrderConfirmation getMaintOrderConfirmationOrFetch()
    {
        if( toMaintOrderConfirmation == null ) {
            toMaintOrderConfirmation = fetchMaintOrderConfirmation();
        }
        return toMaintOrderConfirmation;
    }

    /**
     * Retrieval of associated <b>MaintOrderConfirmation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintOrderConfirmation</b>.
     * <p>
     * If the navigation property for an entity <b>LongText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintOrderConfirmation</b> is already loaded, the result
     *         will contain the <b>MaintOrderConfirmation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintOrderConfirmation> getMaintOrderConfirmationIfPresent()
    {
        return Option.of(toMaintOrderConfirmation);
    }

    /**
     * Overwrites the associated <b>MaintOrderConfirmation</b> entity for the loaded navigation property
     * <b>to_MaintOrderConfirmation</b>.
     *
     * @param value
     *            New <b>MaintOrderConfirmation</b> entity.
     */
    public void setMaintOrderConfirmation( final MaintOrderConfirmation value )
    {
        toMaintOrderConfirmation = value;
    }

    /**
     * Helper class to allow for fluent creation of LongText instances.
     *
     */
    public final static class LongTextBuilder
    {

        private MaintOrderConfirmation toMaintOrderConfirmation;

        private LongText.LongTextBuilder toMaintOrderConfirmation( final MaintOrderConfirmation value )
        {
            toMaintOrderConfirmation = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintOrderConfirmation</b> for <b>LongText</b> to single
         * <b>MaintOrderConfirmation</b>.
         *
         * @param value
         *            The MaintOrderConfirmation to build this LongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LongText.LongTextBuilder maintOrderConfirmation( final MaintOrderConfirmation value )
        {
            return toMaintOrderConfirmation(value);
        }

    }

}
