/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.field.MaintOrderConfirmationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.link.MaintOrderConfirmationOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.selectable.MaintOrderConfirmationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Order Confirmation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintOrderConfirmationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintOrderConfirmation extends VdmEntity<MaintOrderConfirmation>
{

    /**
     * Selector for all available fields of MaintOrderConfirmation.
     *
     */
    public final static MaintOrderConfirmationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderConf</b>
     * </p>
     *
     * @return Completion confirmation number for the operation
     */
    @Key
    @SerializedName( "MaintOrderConf" )
    @JsonProperty( "MaintOrderConf" )
    @Nullable
    @ODataField( odataName = "MaintOrderConf" )
    private String maintOrderConf;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderConf</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> MAINT_ORDER_CONF =
        new MaintOrderConfirmationField<String>("MaintOrderConf");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderConfCntrValue</b>
     * </p>
     *
     * @return Confirmation counter
     */
    @Key
    @SerializedName( "MaintOrderConfCntrValue" )
    @JsonProperty( "MaintOrderConfCntrValue" )
    @Nullable
    @ODataField( odataName = "MaintOrderConfCntrValue" )
    private String maintOrderConfCntrValue;
    /**
     * Use with available fluent helpers to apply the <b>MaintOrderConfCntrValue</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> MAINT_ORDER_CONF_CNTR_VALUE =
        new MaintOrderConfirmationField<String>("MaintOrderConfCntrValue");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @SerializedName( "MaintenanceOrder" )
    @JsonProperty( "MaintenanceOrder" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrder" )
    private String maintenanceOrder;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrder</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> MAINTENANCE_ORDER =
        new MaintOrderConfirmationField<String>("MaintenanceOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @return Operation/Activity Number
     */
    @SerializedName( "MaintenanceOrderOperation" )
    @JsonProperty( "MaintenanceOrderOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderOperation" )
    private String maintenanceOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderOperation</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> MAINTENANCE_ORDER_OPERATION =
        new MaintOrderConfirmationField<String>("MaintenanceOrderOperation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @return Operation/Activity Number
     */
    @SerializedName( "MaintenanceOrderSubOperation" )
    @JsonProperty( "MaintenanceOrderSubOperation" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderSubOperation" )
    private String maintenanceOrderSubOperation;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderSubOperation</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> MAINTENANCE_ORDER_SUB_OPERATION =
        new MaintOrderConfirmationField<String>("MaintenanceOrderSubOperation");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @return Personnel number
     */
    @SerializedName( "PersonnelNumber" )
    @JsonProperty( "PersonnelNumber" )
    @Nullable
    @ODataField( odataName = "PersonnelNumber" )
    private String personnelNumber;
    /**
     * Use with available fluent helpers to apply the <b>PersonnelNumber</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> PERSONNEL_NUMBER =
        new MaintOrderConfirmationField<String>("PersonnelNumber");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>ActualWorkQuantity</b>
     * </p>
     *
     * @return Actual work
     */
    @SerializedName( "ActualWorkQuantity" )
    @JsonProperty( "ActualWorkQuantity" )
    @Nullable
    @ODataField( odataName = "ActualWorkQuantity" )
    private BigDecimal actualWorkQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ActualWorkQuantity</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<BigDecimal> ACTUAL_WORK_QUANTITY =
        new MaintOrderConfirmationField<BigDecimal>("ActualWorkQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualWorkQuantityUnit</b>
     * </p>
     *
     * @return Unit for Work
     */
    @SerializedName( "ActualWorkQuantityUnit" )
    @JsonProperty( "ActualWorkQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ActualWorkQuantityUnit" )
    private String actualWorkQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ActualWorkQuantityUnit</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> ACTUAL_WORK_QUANTITY_UNIT =
        new MaintOrderConfirmationField<String>("ActualWorkQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>ActualDuration</b>
     * </p>
     *
     * @return Actual Duration for Confirmation
     */
    @SerializedName( "ActualDuration" )
    @JsonProperty( "ActualDuration" )
    @Nullable
    @ODataField( odataName = "ActualDuration" )
    private BigDecimal actualDuration;
    /**
     * Use with available fluent helpers to apply the <b>ActualDuration</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<BigDecimal> ACTUAL_DURATION =
        new MaintOrderConfirmationField<BigDecimal>("ActualDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualDurationUnit</b>
     * </p>
     *
     * @return Unit for actual duration
     */
    @SerializedName( "ActualDurationUnit" )
    @JsonProperty( "ActualDurationUnit" )
    @Nullable
    @ODataField( odataName = "ActualDurationUnit" )
    private String actualDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ActualDurationUnit</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> ACTUAL_DURATION_UNIT =
        new MaintOrderConfirmationField<String>("ActualDurationUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationConfirmedStartDate</b>
     * </p>
     *
     * @return Confirmed Start Date of Execution
     */
    @SerializedName( "OperationConfirmedStartDate" )
    @JsonProperty( "OperationConfirmedStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OperationConfirmedStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime operationConfirmedStartDate;
    /**
     * Use with available fluent helpers to apply the <b>OperationConfirmedStartDate</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<LocalDateTime> OPERATION_CONFIRMED_START_DATE =
        new MaintOrderConfirmationField<LocalDateTime>("OperationConfirmedStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationConfirmedStartTime</b>
     * </p>
     *
     * @return Confirmed Time for 'Start Execution'
     */
    @SerializedName( "OperationConfirmedStartTime" )
    @JsonProperty( "OperationConfirmedStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OperationConfirmedStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime operationConfirmedStartTime;
    /**
     * Use with available fluent helpers to apply the <b>OperationConfirmedStartTime</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<LocalTime> OPERATION_CONFIRMED_START_TIME =
        new MaintOrderConfirmationField<LocalTime>("OperationConfirmedStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationConfirmedEndDate</b>
     * </p>
     *
     * @return Confirmed Finish Date of Execution
     */
    @SerializedName( "OperationConfirmedEndDate" )
    @JsonProperty( "OperationConfirmedEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OperationConfirmedEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime operationConfirmedEndDate;
    /**
     * Use with available fluent helpers to apply the <b>OperationConfirmedEndDate</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<LocalDateTime> OPERATION_CONFIRMED_END_DATE =
        new MaintOrderConfirmationField<LocalDateTime>("OperationConfirmedEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationConfirmedEndTime</b>
     * </p>
     *
     * @return Confirmed Time for 'Finish Execution'
     */
    @SerializedName( "OperationConfirmedEndTime" )
    @JsonProperty( "OperationConfirmedEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OperationConfirmedEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime operationConfirmedEndTime;
    /**
     * Use with available fluent helpers to apply the <b>OperationConfirmedEndTime</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<LocalTime> OPERATION_CONFIRMED_END_TIME =
        new MaintOrderConfirmationField<LocalTime>("OperationConfirmedEndTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsFinalConfirmation</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "IsFinalConfirmation" )
    @JsonProperty( "IsFinalConfirmation" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsFinalConfirmation" )
    private Boolean isFinalConfirmation;
    /**
     * Use with available fluent helpers to apply the <b>IsFinalConfirmation</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<Boolean> IS_FINAL_CONFIRMATION =
        new MaintOrderConfirmationField<Boolean>("IsFinalConfirmation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherWorkQuantityIsExpd</b>
     * </p>
     *
     * @return Indicator: No Remaining Work Expected
     */
    @SerializedName( "NoFurtherWorkQuantityIsExpd" )
    @JsonProperty( "NoFurtherWorkQuantityIsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherWorkQuantityIsExpd" )
    private Boolean noFurtherWorkQuantityIsExpd;
    /**
     * Use with available fluent helpers to apply the <b>NoFurtherWorkQuantityIsExpd</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<Boolean> NO_FURTHER_WORK_QUANTITY_IS_EXPD =
        new MaintOrderConfirmationField<Boolean>("NoFurtherWorkQuantityIsExpd");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>RemainingWorkQuantity</b>
     * </p>
     *
     * @return Remaining Work
     */
    @SerializedName( "RemainingWorkQuantity" )
    @JsonProperty( "RemainingWorkQuantity" )
    @Nullable
    @ODataField( odataName = "RemainingWorkQuantity" )
    private BigDecimal remainingWorkQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RemainingWorkQuantity</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<BigDecimal> REMAINING_WORK_QUANTITY =
        new MaintOrderConfirmationField<BigDecimal>("RemainingWorkQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RemainingWorkQuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure for Remaining Work
     */
    @SerializedName( "RemainingWorkQuantityUnit" )
    @JsonProperty( "RemainingWorkQuantityUnit" )
    @Nullable
    @ODataField( odataName = "RemainingWorkQuantityUnit" )
    private String remainingWorkQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>RemainingWorkQuantityUnit</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> REMAINING_WORK_QUANTITY_UNIT =
        new MaintOrderConfirmationField<String>("RemainingWorkQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<LocalDateTime> POSTING_DATE =
        new MaintOrderConfirmationField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ActivityType</b>
     * </p>
     *
     * @return Activity Type for Confirmation
     */
    @SerializedName( "ActivityType" )
    @JsonProperty( "ActivityType" )
    @Nullable
    @ODataField( odataName = "ActivityType" )
    private String activityType;
    /**
     * Use with available fluent helpers to apply the <b>ActivityType</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> ACTIVITY_TYPE =
        new MaintOrderConfirmationField<String>("ActivityType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OpenReservationsIsCleared</b>
     * </p>
     *
     * @return Clear Open Reservations
     */
    @SerializedName( "OpenReservationsIsCleared" )
    @JsonProperty( "OpenReservationsIsCleared" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "OpenReservationsIsCleared" )
    private Boolean openReservationsIsCleared;
    /**
     * Use with available fluent helpers to apply the <b>OpenReservationsIsCleared</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<Boolean> OPEN_RESERVATIONS_IS_CLEARED =
        new MaintOrderConfirmationField<Boolean>("OpenReservationsIsCleared");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationText</b>
     * </p>
     *
     * @return Confirmation text
     */
    @SerializedName( "ConfirmationText" )
    @JsonProperty( "ConfirmationText" )
    @Nullable
    @ODataField( odataName = "ConfirmationText" )
    private String confirmationText;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationText</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> CONFIRMATION_TEXT =
        new MaintOrderConfirmationField<String>("ConfirmationText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EmployeeWageType</b>
     * </p>
     *
     * @return Wage type
     */
    @SerializedName( "EmployeeWageType" )
    @JsonProperty( "EmployeeWageType" )
    @Nullable
    @ODataField( odataName = "EmployeeWageType" )
    private String employeeWageType;
    /**
     * Use with available fluent helpers to apply the <b>EmployeeWageType</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> EMPLOYEE_WAGE_TYPE =
        new MaintOrderConfirmationField<String>("EmployeeWageType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmployeeWageGroup</b>
     * </p>
     *
     * @return Wage Group
     */
    @SerializedName( "EmployeeWageGroup" )
    @JsonProperty( "EmployeeWageGroup" )
    @Nullable
    @ODataField( odataName = "EmployeeWageGroup" )
    private String employeeWageGroup;
    /**
     * Use with available fluent helpers to apply the <b>EmployeeWageGroup</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> EMPLOYEE_WAGE_GROUP =
        new MaintOrderConfirmationField<String>("EmployeeWageGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>VarianceReasonCode</b>
     * </p>
     *
     * @return Reason for Variance
     */
    @SerializedName( "VarianceReasonCode" )
    @JsonProperty( "VarianceReasonCode" )
    @Nullable
    @ODataField( odataName = "VarianceReasonCode" )
    private String varianceReasonCode;
    /**
     * Use with available fluent helpers to apply the <b>VarianceReasonCode</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> VARIANCE_REASON_CODE =
        new MaintOrderConfirmationField<String>("VarianceReasonCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @return Capacity ID
     */
    @SerializedName( "CapacityInternalID" )
    @JsonProperty( "CapacityInternalID" )
    @Nullable
    @ODataField( odataName = "CapacityInternalID" )
    private String capacityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CapacityInternalID</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> CAPACITY_INTERNAL_ID =
        new MaintOrderConfirmationField<String>("CapacityInternalID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NmbrOfMaintTechnicianCapSplits</b>
     * </p>
     *
     * @return Split number
     */
    @SerializedName( "NmbrOfMaintTechnicianCapSplits" )
    @JsonProperty( "NmbrOfMaintTechnicianCapSplits" )
    @Nullable
    @ODataField( odataName = "NmbrOfMaintTechnicianCapSplits" )
    private Short nmbrOfMaintTechnicianCapSplits;
    /**
     * Use with available fluent helpers to apply the <b>NmbrOfMaintTechnicianCapSplits</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<Short> NMBR_OF_MAINT_TECHNICIAN_CAP_SPLITS =
        new MaintOrderConfirmationField<Short>("NmbrOfMaintTechnicianCapSplits");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @return Number of Material Document
     */
    @SerializedName( "MaterialDocument" )
    @JsonProperty( "MaterialDocument" )
    @Nullable
    @ODataField( odataName = "MaterialDocument" )
    private String materialDocument;
    /**
     * Use with available fluent helpers to apply the <b>MaterialDocument</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> MATERIAL_DOCUMENT =
        new MaintOrderConfirmationField<String>("MaterialDocument");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingIndicatorCode</b>
     * </p>
     *
     * @return Accounting Indicator
     */
    @SerializedName( "AccountingIndicatorCode" )
    @JsonProperty( "AccountingIndicatorCode" )
    @Nullable
    @ODataField( odataName = "AccountingIndicatorCode" )
    private String accountingIndicatorCode;
    /**
     * Use with available fluent helpers to apply the <b>AccountingIndicatorCode</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<String> ACCOUNTING_INDICATOR_CODE =
        new MaintOrderConfirmationField<String>("AccountingIndicatorCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActyConfFcstdEndDate</b>
     * </p>
     *
     * @return Forecast finish date of operation from confirmation
     */
    @SerializedName( "ActyConfFcstdEndDate" )
    @JsonProperty( "ActyConfFcstdEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ActyConfFcstdEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime actyConfFcstdEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ActyConfFcstdEndDate</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<LocalDateTime> ACTY_CONF_FCSTD_END_DATE =
        new MaintOrderConfirmationField<LocalDateTime>("ActyConfFcstdEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActyConfFcstdEndTime</b>
     * </p>
     *
     * @return Forecast End Time of Operation from Confirmation
     */
    @SerializedName( "ActyConfFcstdEndTime" )
    @JsonProperty( "ActyConfFcstdEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ActyConfFcstdEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime actyConfFcstdEndTime;
    /**
     * Use with available fluent helpers to apply the <b>ActyConfFcstdEndTime</b> field to query operations.
     *
     */
    public final static MaintOrderConfirmationField<LocalTime> ACTY_CONF_FCSTD_END_TIME =
        new MaintOrderConfirmationField<LocalTime>("ActyConfFcstdEndTime");
    /**
     * Navigation property <b>to_LongText</b> for <b>MaintOrderConfirmation</b> to single <b>LongText</b>.
     *
     */
    @SerializedName( "to_LongText" )
    @JsonProperty( "to_LongText" )
    @ODataField( odataName = "to_LongText" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private LongText toLongText;
    /**
     * Use with available fluent helpers to apply the <b>to_LongText</b> navigation property to query operations.
     *
     */
    public final static MaintOrderConfirmationOneToOneLink<LongText> TO_LONG_TEXT =
        new MaintOrderConfirmationOneToOneLink<LongText>("to_LongText");

    @Nonnull
    @Override
    public Class<MaintOrderConfirmation> getType()
    {
        return MaintOrderConfirmation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderConf</b>
     * </p>
     *
     * @param maintOrderConf
     *            Completion confirmation number for the operation
     */
    public void setMaintOrderConf( @Nullable final String maintOrderConf )
    {
        rememberChangedField("MaintOrderConf", this.maintOrderConf);
        this.maintOrderConf = maintOrderConf;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintOrderConfCntrValue</b>
     * </p>
     *
     * @param maintOrderConfCntrValue
     *            Confirmation counter
     */
    public void setMaintOrderConfCntrValue( @Nullable final String maintOrderConfCntrValue )
    {
        rememberChangedField("MaintOrderConfCntrValue", this.maintOrderConfCntrValue);
        this.maintOrderConfCntrValue = maintOrderConfCntrValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     *
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderOperation</b>
     * </p>
     *
     * @param maintenanceOrderOperation
     *            Operation/Activity Number
     */
    public void setMaintenanceOrderOperation( @Nullable final String maintenanceOrderOperation )
    {
        rememberChangedField("MaintenanceOrderOperation", this.maintenanceOrderOperation);
        this.maintenanceOrderOperation = maintenanceOrderOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderSubOperation</b>
     * </p>
     *
     * @param maintenanceOrderSubOperation
     *            Operation/Activity Number
     */
    public void setMaintenanceOrderSubOperation( @Nullable final String maintenanceOrderSubOperation )
    {
        rememberChangedField("MaintenanceOrderSubOperation", this.maintenanceOrderSubOperation);
        this.maintenanceOrderSubOperation = maintenanceOrderSubOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @param personnelNumber
     *            Personnel number
     */
    public void setPersonnelNumber( @Nullable final String personnelNumber )
    {
        rememberChangedField("PersonnelNumber", this.personnelNumber);
        this.personnelNumber = personnelNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>ActualWorkQuantity</b>
     * </p>
     *
     * @param actualWorkQuantity
     *            Actual work
     */
    public void setActualWorkQuantity( @Nullable final BigDecimal actualWorkQuantity )
    {
        rememberChangedField("ActualWorkQuantity", this.actualWorkQuantity);
        this.actualWorkQuantity = actualWorkQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualWorkQuantityUnit</b>
     * </p>
     *
     * @param actualWorkQuantityUnit
     *            Unit for Work
     */
    public void setActualWorkQuantityUnit( @Nullable final String actualWorkQuantityUnit )
    {
        rememberChangedField("ActualWorkQuantityUnit", this.actualWorkQuantityUnit);
        this.actualWorkQuantityUnit = actualWorkQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>ActualDuration</b>
     * </p>
     *
     * @param actualDuration
     *            Actual Duration for Confirmation
     */
    public void setActualDuration( @Nullable final BigDecimal actualDuration )
    {
        rememberChangedField("ActualDuration", this.actualDuration);
        this.actualDuration = actualDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualDurationUnit</b>
     * </p>
     *
     * @param actualDurationUnit
     *            Unit for actual duration
     */
    public void setActualDurationUnit( @Nullable final String actualDurationUnit )
    {
        rememberChangedField("ActualDurationUnit", this.actualDurationUnit);
        this.actualDurationUnit = actualDurationUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationConfirmedStartDate</b>
     * </p>
     *
     * @param operationConfirmedStartDate
     *            Confirmed Start Date of Execution
     */
    public void setOperationConfirmedStartDate( @Nullable final LocalDateTime operationConfirmedStartDate )
    {
        rememberChangedField("OperationConfirmedStartDate", this.operationConfirmedStartDate);
        this.operationConfirmedStartDate = operationConfirmedStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationConfirmedStartTime</b>
     * </p>
     *
     * @param operationConfirmedStartTime
     *            Confirmed Time for 'Start Execution'
     */
    public void setOperationConfirmedStartTime( @Nullable final LocalTime operationConfirmedStartTime )
    {
        rememberChangedField("OperationConfirmedStartTime", this.operationConfirmedStartTime);
        this.operationConfirmedStartTime = operationConfirmedStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationConfirmedEndDate</b>
     * </p>
     *
     * @param operationConfirmedEndDate
     *            Confirmed Finish Date of Execution
     */
    public void setOperationConfirmedEndDate( @Nullable final LocalDateTime operationConfirmedEndDate )
    {
        rememberChangedField("OperationConfirmedEndDate", this.operationConfirmedEndDate);
        this.operationConfirmedEndDate = operationConfirmedEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationConfirmedEndTime</b>
     * </p>
     *
     * @param operationConfirmedEndTime
     *            Confirmed Time for 'Finish Execution'
     */
    public void setOperationConfirmedEndTime( @Nullable final LocalTime operationConfirmedEndTime )
    {
        rememberChangedField("OperationConfirmedEndTime", this.operationConfirmedEndTime);
        this.operationConfirmedEndTime = operationConfirmedEndTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsFinalConfirmation</b>
     * </p>
     *
     * @param isFinalConfirmation
     *            Checkbox
     */
    public void setIsFinalConfirmation( @Nullable final Boolean isFinalConfirmation )
    {
        rememberChangedField("IsFinalConfirmation", this.isFinalConfirmation);
        this.isFinalConfirmation = isFinalConfirmation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoFurtherWorkQuantityIsExpd</b>
     * </p>
     *
     * @param noFurtherWorkQuantityIsExpd
     *            Indicator: No Remaining Work Expected
     */
    public void setNoFurtherWorkQuantityIsExpd( @Nullable final Boolean noFurtherWorkQuantityIsExpd )
    {
        rememberChangedField("NoFurtherWorkQuantityIsExpd", this.noFurtherWorkQuantityIsExpd);
        this.noFurtherWorkQuantityIsExpd = noFurtherWorkQuantityIsExpd;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>RemainingWorkQuantity</b>
     * </p>
     *
     * @param remainingWorkQuantity
     *            Remaining Work
     */
    public void setRemainingWorkQuantity( @Nullable final BigDecimal remainingWorkQuantity )
    {
        rememberChangedField("RemainingWorkQuantity", this.remainingWorkQuantity);
        this.remainingWorkQuantity = remainingWorkQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RemainingWorkQuantityUnit</b>
     * </p>
     *
     * @param remainingWorkQuantityUnit
     *            Unit of Measure for Remaining Work
     */
    public void setRemainingWorkQuantityUnit( @Nullable final String remainingWorkQuantityUnit )
    {
        rememberChangedField("RemainingWorkQuantityUnit", this.remainingWorkQuantityUnit);
        this.remainingWorkQuantityUnit = remainingWorkQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ActivityType</b>
     * </p>
     *
     * @param activityType
     *            Activity Type for Confirmation
     */
    public void setActivityType( @Nullable final String activityType )
    {
        rememberChangedField("ActivityType", this.activityType);
        this.activityType = activityType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OpenReservationsIsCleared</b>
     * </p>
     *
     * @param openReservationsIsCleared
     *            Clear Open Reservations
     */
    public void setOpenReservationsIsCleared( @Nullable final Boolean openReservationsIsCleared )
    {
        rememberChangedField("OpenReservationsIsCleared", this.openReservationsIsCleared);
        this.openReservationsIsCleared = openReservationsIsCleared;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationText</b>
     * </p>
     *
     * @param confirmationText
     *            Confirmation text
     */
    public void setConfirmationText( @Nullable final String confirmationText )
    {
        rememberChangedField("ConfirmationText", this.confirmationText);
        this.confirmationText = confirmationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EmployeeWageType</b>
     * </p>
     *
     * @param employeeWageType
     *            Wage type
     */
    public void setEmployeeWageType( @Nullable final String employeeWageType )
    {
        rememberChangedField("EmployeeWageType", this.employeeWageType);
        this.employeeWageType = employeeWageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmployeeWageGroup</b>
     * </p>
     *
     * @param employeeWageGroup
     *            Wage Group
     */
    public void setEmployeeWageGroup( @Nullable final String employeeWageGroup )
    {
        rememberChangedField("EmployeeWageGroup", this.employeeWageGroup);
        this.employeeWageGroup = employeeWageGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>VarianceReasonCode</b>
     * </p>
     *
     * @param varianceReasonCode
     *            Reason for Variance
     */
    public void setVarianceReasonCode( @Nullable final String varianceReasonCode )
    {
        rememberChangedField("VarianceReasonCode", this.varianceReasonCode);
        this.varianceReasonCode = varianceReasonCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @param capacityInternalID
     *            Capacity ID
     */
    public void setCapacityInternalID( @Nullable final String capacityInternalID )
    {
        rememberChangedField("CapacityInternalID", this.capacityInternalID);
        this.capacityInternalID = capacityInternalID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NmbrOfMaintTechnicianCapSplits</b>
     * </p>
     *
     * @param nmbrOfMaintTechnicianCapSplits
     *            Split number
     */
    public void setNmbrOfMaintTechnicianCapSplits( @Nullable final Short nmbrOfMaintTechnicianCapSplits )
    {
        rememberChangedField("NmbrOfMaintTechnicianCapSplits", this.nmbrOfMaintTechnicianCapSplits);
        this.nmbrOfMaintTechnicianCapSplits = nmbrOfMaintTechnicianCapSplits;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaterialDocument</b>
     * </p>
     *
     * @param materialDocument
     *            Number of Material Document
     */
    public void setMaterialDocument( @Nullable final String materialDocument )
    {
        rememberChangedField("MaterialDocument", this.materialDocument);
        this.materialDocument = materialDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountingIndicatorCode</b>
     * </p>
     *
     * @param accountingIndicatorCode
     *            Accounting Indicator
     */
    public void setAccountingIndicatorCode( @Nullable final String accountingIndicatorCode )
    {
        rememberChangedField("AccountingIndicatorCode", this.accountingIndicatorCode);
        this.accountingIndicatorCode = accountingIndicatorCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActyConfFcstdEndDate</b>
     * </p>
     *
     * @param actyConfFcstdEndDate
     *            Forecast finish date of operation from confirmation
     */
    public void setActyConfFcstdEndDate( @Nullable final LocalDateTime actyConfFcstdEndDate )
    {
        rememberChangedField("ActyConfFcstdEndDate", this.actyConfFcstdEndDate);
        this.actyConfFcstdEndDate = actyConfFcstdEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActyConfFcstdEndTime</b>
     * </p>
     *
     * @param actyConfFcstdEndTime
     *            Forecast End Time of Operation from Confirmation
     */
    public void setActyConfFcstdEndTime( @Nullable final LocalTime actyConfFcstdEndTime )
    {
        rememberChangedField("ActyConfFcstdEndTime", this.actyConfFcstdEndTime);
        this.actyConfFcstdEndTime = actyConfFcstdEndTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintOrderConfirmation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintOrderConf", getMaintOrderConf());
        result.put("MaintOrderConfCntrValue", getMaintOrderConfCntrValue());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintOrderConf", getMaintOrderConf());
        values.put("MaintOrderConfCntrValue", getMaintOrderConfCntrValue());
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("MaintenanceOrderOperation", getMaintenanceOrderOperation());
        values.put("MaintenanceOrderSubOperation", getMaintenanceOrderSubOperation());
        values.put("PersonnelNumber", getPersonnelNumber());
        values.put("ActualWorkQuantity", getActualWorkQuantity());
        values.put("ActualWorkQuantityUnit", getActualWorkQuantityUnit());
        values.put("ActualDuration", getActualDuration());
        values.put("ActualDurationUnit", getActualDurationUnit());
        values.put("OperationConfirmedStartDate", getOperationConfirmedStartDate());
        values.put("OperationConfirmedStartTime", getOperationConfirmedStartTime());
        values.put("OperationConfirmedEndDate", getOperationConfirmedEndDate());
        values.put("OperationConfirmedEndTime", getOperationConfirmedEndTime());
        values.put("IsFinalConfirmation", getIsFinalConfirmation());
        values.put("NoFurtherWorkQuantityIsExpd", getNoFurtherWorkQuantityIsExpd());
        values.put("RemainingWorkQuantity", getRemainingWorkQuantity());
        values.put("RemainingWorkQuantityUnit", getRemainingWorkQuantityUnit());
        values.put("PostingDate", getPostingDate());
        values.put("ActivityType", getActivityType());
        values.put("OpenReservationsIsCleared", getOpenReservationsIsCleared());
        values.put("ConfirmationText", getConfirmationText());
        values.put("EmployeeWageType", getEmployeeWageType());
        values.put("EmployeeWageGroup", getEmployeeWageGroup());
        values.put("VarianceReasonCode", getVarianceReasonCode());
        values.put("CapacityInternalID", getCapacityInternalID());
        values.put("NmbrOfMaintTechnicianCapSplits", getNmbrOfMaintTechnicianCapSplits());
        values.put("MaterialDocument", getMaterialDocument());
        values.put("AccountingIndicatorCode", getAccountingIndicatorCode());
        values.put("ActyConfFcstdEndDate", getActyConfFcstdEndDate());
        values.put("ActyConfFcstdEndTime", getActyConfFcstdEndTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintOrderConf") ) {
                final Object value = values.remove("MaintOrderConf");
                if( (value == null) || (!value.equals(getMaintOrderConf())) ) {
                    setMaintOrderConf(((String) value));
                }
            }
            if( values.containsKey("MaintOrderConfCntrValue") ) {
                final Object value = values.remove("MaintOrderConfCntrValue");
                if( (value == null) || (!value.equals(getMaintOrderConfCntrValue())) ) {
                    setMaintOrderConfCntrValue(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderOperation") ) {
                final Object value = values.remove("MaintenanceOrderOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderOperation())) ) {
                    setMaintenanceOrderOperation(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderSubOperation") ) {
                final Object value = values.remove("MaintenanceOrderSubOperation");
                if( (value == null) || (!value.equals(getMaintenanceOrderSubOperation())) ) {
                    setMaintenanceOrderSubOperation(((String) value));
                }
            }
            if( values.containsKey("PersonnelNumber") ) {
                final Object value = values.remove("PersonnelNumber");
                if( (value == null) || (!value.equals(getPersonnelNumber())) ) {
                    setPersonnelNumber(((String) value));
                }
            }
            if( values.containsKey("ActualWorkQuantity") ) {
                final Object value = values.remove("ActualWorkQuantity");
                if( (value == null) || (!value.equals(getActualWorkQuantity())) ) {
                    setActualWorkQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActualWorkQuantityUnit") ) {
                final Object value = values.remove("ActualWorkQuantityUnit");
                if( (value == null) || (!value.equals(getActualWorkQuantityUnit())) ) {
                    setActualWorkQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ActualDuration") ) {
                final Object value = values.remove("ActualDuration");
                if( (value == null) || (!value.equals(getActualDuration())) ) {
                    setActualDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActualDurationUnit") ) {
                final Object value = values.remove("ActualDurationUnit");
                if( (value == null) || (!value.equals(getActualDurationUnit())) ) {
                    setActualDurationUnit(((String) value));
                }
            }
            if( values.containsKey("OperationConfirmedStartDate") ) {
                final Object value = values.remove("OperationConfirmedStartDate");
                if( (value == null) || (!value.equals(getOperationConfirmedStartDate())) ) {
                    setOperationConfirmedStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OperationConfirmedStartTime") ) {
                final Object value = values.remove("OperationConfirmedStartTime");
                if( (value == null) || (!value.equals(getOperationConfirmedStartTime())) ) {
                    setOperationConfirmedStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("OperationConfirmedEndDate") ) {
                final Object value = values.remove("OperationConfirmedEndDate");
                if( (value == null) || (!value.equals(getOperationConfirmedEndDate())) ) {
                    setOperationConfirmedEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OperationConfirmedEndTime") ) {
                final Object value = values.remove("OperationConfirmedEndTime");
                if( (value == null) || (!value.equals(getOperationConfirmedEndTime())) ) {
                    setOperationConfirmedEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("IsFinalConfirmation") ) {
                final Object value = values.remove("IsFinalConfirmation");
                if( (value == null) || (!value.equals(getIsFinalConfirmation())) ) {
                    setIsFinalConfirmation(((Boolean) value));
                }
            }
            if( values.containsKey("NoFurtherWorkQuantityIsExpd") ) {
                final Object value = values.remove("NoFurtherWorkQuantityIsExpd");
                if( (value == null) || (!value.equals(getNoFurtherWorkQuantityIsExpd())) ) {
                    setNoFurtherWorkQuantityIsExpd(((Boolean) value));
                }
            }
            if( values.containsKey("RemainingWorkQuantity") ) {
                final Object value = values.remove("RemainingWorkQuantity");
                if( (value == null) || (!value.equals(getRemainingWorkQuantity())) ) {
                    setRemainingWorkQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("RemainingWorkQuantityUnit") ) {
                final Object value = values.remove("RemainingWorkQuantityUnit");
                if( (value == null) || (!value.equals(getRemainingWorkQuantityUnit())) ) {
                    setRemainingWorkQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ActivityType") ) {
                final Object value = values.remove("ActivityType");
                if( (value == null) || (!value.equals(getActivityType())) ) {
                    setActivityType(((String) value));
                }
            }
            if( values.containsKey("OpenReservationsIsCleared") ) {
                final Object value = values.remove("OpenReservationsIsCleared");
                if( (value == null) || (!value.equals(getOpenReservationsIsCleared())) ) {
                    setOpenReservationsIsCleared(((Boolean) value));
                }
            }
            if( values.containsKey("ConfirmationText") ) {
                final Object value = values.remove("ConfirmationText");
                if( (value == null) || (!value.equals(getConfirmationText())) ) {
                    setConfirmationText(((String) value));
                }
            }
            if( values.containsKey("EmployeeWageType") ) {
                final Object value = values.remove("EmployeeWageType");
                if( (value == null) || (!value.equals(getEmployeeWageType())) ) {
                    setEmployeeWageType(((String) value));
                }
            }
            if( values.containsKey("EmployeeWageGroup") ) {
                final Object value = values.remove("EmployeeWageGroup");
                if( (value == null) || (!value.equals(getEmployeeWageGroup())) ) {
                    setEmployeeWageGroup(((String) value));
                }
            }
            if( values.containsKey("VarianceReasonCode") ) {
                final Object value = values.remove("VarianceReasonCode");
                if( (value == null) || (!value.equals(getVarianceReasonCode())) ) {
                    setVarianceReasonCode(((String) value));
                }
            }
            if( values.containsKey("CapacityInternalID") ) {
                final Object value = values.remove("CapacityInternalID");
                if( (value == null) || (!value.equals(getCapacityInternalID())) ) {
                    setCapacityInternalID(((String) value));
                }
            }
            if( values.containsKey("NmbrOfMaintTechnicianCapSplits") ) {
                final Object value = values.remove("NmbrOfMaintTechnicianCapSplits");
                if( (value == null) || (!value.equals(getNmbrOfMaintTechnicianCapSplits())) ) {
                    setNmbrOfMaintTechnicianCapSplits(((Short) value));
                }
            }
            if( values.containsKey("MaterialDocument") ) {
                final Object value = values.remove("MaterialDocument");
                if( (value == null) || (!value.equals(getMaterialDocument())) ) {
                    setMaterialDocument(((String) value));
                }
            }
            if( values.containsKey("AccountingIndicatorCode") ) {
                final Object value = values.remove("AccountingIndicatorCode");
                if( (value == null) || (!value.equals(getAccountingIndicatorCode())) ) {
                    setAccountingIndicatorCode(((String) value));
                }
            }
            if( values.containsKey("ActyConfFcstdEndDate") ) {
                final Object value = values.remove("ActyConfFcstdEndDate");
                if( (value == null) || (!value.equals(getActyConfFcstdEndDate())) ) {
                    setActyConfFcstdEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ActyConfFcstdEndTime") ) {
                final Object value = values.remove("ActyConfFcstdEndTime");
                if( (value == null) || (!value.equals(getActyConfFcstdEndTime())) ) {
                    setActyConfFcstdEndTime(((LocalTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_LongText") ) {
                final Object value = (values).remove("to_LongText");
                if( value instanceof Map ) {
                    if( toLongText == null ) {
                        toLongText = new LongText();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toLongText.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintOrderConfirmationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintOrderConfirmationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintOrderConfirmationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintOrderConfirmationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderOperationConfirmationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toLongText != null ) {
            (values).put("to_LongText", toLongText);
        }
        return values;
    }

    /**
     * Fetches the <b>LongText</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_LongText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>LongText</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public LongText fetchLongText()
    {
        return fetchFieldAsSingle("to_LongText", LongText.class);
    }

    /**
     * Retrieval of associated <b>LongText</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_LongText</b>.
     * <p>
     * If the navigation property <b>to_LongText</b> of a queried <b>MaintOrderConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LongText</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public LongText getLongTextOrFetch()
    {
        if( toLongText == null ) {
            toLongText = fetchLongText();
        }
        return toLongText;
    }

    /**
     * Retrieval of associated <b>LongText</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_LongText</b>.
     * <p>
     * If the navigation property for an entity <b>MaintOrderConfirmation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LongText</b> is already loaded, the result will contain
     *         the <b>LongText</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<LongText> getLongTextIfPresent()
    {
        return Option.of(toLongText);
    }

    /**
     * Overwrites the associated <b>LongText</b> entity for the loaded navigation property <b>to_LongText</b>.
     *
     * @param value
     *            New <b>LongText</b> entity.
     */
    public void setLongText( final LongText value )
    {
        toLongText = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintOrderConfirmation instances.
     *
     */
    public final static class MaintOrderConfirmationBuilder
    {

        private LongText toLongText;

        private MaintOrderConfirmation.MaintOrderConfirmationBuilder toLongText( final LongText value )
        {
            toLongText = value;
            return this;
        }

        /**
         * Navigation property <b>to_LongText</b> for <b>MaintOrderConfirmation</b> to single <b>LongText</b>.
         *
         * @param value
         *            The LongText to build this MaintOrderConfirmation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintOrderConfirmation.MaintOrderConfirmationBuilder longText( final LongText value )
        {
            return toLongText(value);
        }

    }

}
