/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.selectable.MaintOrderConfirmationSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation
 * MaintOrderConfirmation} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class MaintOrderConfirmationByKeyFluentHelper
    extends
    FluentHelperByKey<MaintOrderConfirmationByKeyFluentHelper, MaintOrderConfirmation, MaintOrderConfirmationSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation
     * MaintOrderConfirmation} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintOrderConfirmation}
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintOrderConfirmation}
     * @param maintOrderConf
     *            Completion confirmation number for the operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param maintOrderConfCntrValue
     *            Confirmation counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public MaintOrderConfirmationByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintOrderConf,
        final String maintOrderConfCntrValue )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintOrderConf", maintOrderConf);
        this.key.put("MaintOrderConfCntrValue", maintOrderConfCntrValue);
    }

    @Override
    @Nonnull
    protected Class<MaintOrderConfirmation> getEntityClass()
    {
        return MaintOrderConfirmation.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
