/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.LongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation;

/**
 * Implementation of the {@link MaintenanceOrderOperationConfirmationServiceBatchChangeSet} interface, enabling you to
 * combine multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderOperationConfirmationService
 * MaintenanceOrderOperationConfirmationService}.
 *
 */
public class DefaultMaintenanceOrderOperationConfirmationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<MaintenanceOrderOperationConfirmationServiceBatch, MaintenanceOrderOperationConfirmationServiceBatchChangeSet>
    implements
    MaintenanceOrderOperationConfirmationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderOperationConfirmationService service;

    @SuppressWarnings( "deprecation" )
    DefaultMaintenanceOrderOperationConfirmationServiceBatchChangeSet(
        @Nonnull final DefaultMaintenanceOrderOperationConfirmationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenanceOrderOperationConfirmationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultMaintenanceOrderOperationConfirmationServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaintenanceOrderOperationConfirmationServiceBatchChangeSet createMaintOrderConfirmation(
        @Nonnull final MaintOrderConfirmation maintOrderConfirmation )
    {
        return addRequestCreate(service::createMaintOrderConfirmation, maintOrderConfirmation);
    }

    @Nonnull
    @Override
    public MaintenanceOrderOperationConfirmationServiceBatchChangeSet createLongText( @Nonnull final LongText longText )
    {
        return addRequestCreate(service::createLongText, longText);
    }

}
