/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation
 * MaintOrderConfirmation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.field.MaintOrderConfirmationField
 * MaintOrderConfirmationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.link.MaintOrderConfirmationLink
 * MaintOrderConfirmationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#MAINT_ORDER_CONF
 * MAINT_ORDER_CONF}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#MAINT_ORDER_CONF_CNTR_VALUE
 * MAINT_ORDER_CONF_CNTR_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#MAINTENANCE_ORDER
 * MAINTENANCE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#MAINTENANCE_ORDER_OPERATION
 * MAINTENANCE_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#MAINTENANCE_ORDER_SUB_OPERATION
 * MAINTENANCE_ORDER_SUB_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#PERSONNEL_NUMBER
 * PERSONNEL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#ACTUAL_WORK_QUANTITY
 * ACTUAL_WORK_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#ACTUAL_WORK_QUANTITY_UNIT
 * ACTUAL_WORK_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#ACTUAL_DURATION
 * ACTUAL_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#ACTUAL_DURATION_UNIT
 * ACTUAL_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#OPERATION_CONFIRMED_START_DATE
 * OPERATION_CONFIRMED_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#OPERATION_CONFIRMED_START_TIME
 * OPERATION_CONFIRMED_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#OPERATION_CONFIRMED_END_DATE
 * OPERATION_CONFIRMED_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#OPERATION_CONFIRMED_END_TIME
 * OPERATION_CONFIRMED_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#IS_FINAL_CONFIRMATION
 * IS_FINAL_CONFIRMATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#NO_FURTHER_WORK_QUANTITY_IS_EXPD
 * NO_FURTHER_WORK_QUANTITY_IS_EXPD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#REMAINING_WORK_QUANTITY
 * REMAINING_WORK_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#REMAINING_WORK_QUANTITY_UNIT
 * REMAINING_WORK_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#ACTIVITY_TYPE
 * ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#OPEN_RESERVATIONS_IS_CLEARED
 * OPEN_RESERVATIONS_IS_CLEARED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#CONFIRMATION_TEXT
 * CONFIRMATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#EMPLOYEE_WAGE_TYPE
 * EMPLOYEE_WAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#EMPLOYEE_WAGE_GROUP
 * EMPLOYEE_WAGE_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#VARIANCE_REASON_CODE
 * VARIANCE_REASON_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#CAPACITY_INTERNAL_ID
 * CAPACITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#NMBR_OF_MAINT_TECHNICIAN_CAP_SPLITS
 * NMBR_OF_MAINT_TECHNICIAN_CAP_SPLITS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#MATERIAL_DOCUMENT
 * MATERIAL_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#ACCOUNTING_INDICATOR_CODE
 * ACCOUNTING_INDICATOR_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#ACTY_CONF_FCSTD_END_DATE
 * ACTY_CONF_FCSTD_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#ACTY_CONF_FCSTD_END_TIME
 * ACTY_CONF_FCSTD_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceorderoperationconfirmation.MaintOrderConfirmation#TO_LONG_TEXT
 * TO_LONG_TEXT}</li>
 * </ul>
 *
 */
public interface MaintOrderConfirmationSelectable extends EntitySelectable<MaintOrderConfirmation>
{

}
