/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintItemObjectListItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintItemObjectListItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintItemObjectListItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Item Object List Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintItemObjectListItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintItemObjectListItem extends VdmEntity<MaintItemObjectListItem>
{

    /**
     * Selector for all available fields of MaintItemObjectListItem.
     *
     */
    public final static MaintItemObjectListItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItem</b>
     * </p>
     *
     * @return Maintenance Item
     */
    @Key
    @SerializedName( "MaintenanceItem" )
    @JsonProperty( "MaintenanceItem" )
    @Nullable
    @ODataField( odataName = "MaintenanceItem" )
    private String maintenanceItem;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceItem</b> field to query operations.
     *
     */
    public final static MaintItemObjectListItemField<String> MAINTENANCE_ITEM =
        new MaintItemObjectListItemField<String>("MaintenanceItem");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItemObjectList</b>
     * </p>
     *
     * @return Object list number
     */
    @Key
    @SerializedName( "MaintenanceItemObjectList" )
    @JsonProperty( "MaintenanceItemObjectList" )
    @Nullable
    @ODataField( odataName = "MaintenanceItemObjectList" )
    private Long maintenanceItemObjectList;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceItemObjectList</b> field to query operations.
     *
     */
    public final static MaintItemObjectListItemField<Long> MAINTENANCE_ITEM_OBJECT_LIST =
        new MaintItemObjectListItemField<Long>("MaintenanceItemObjectList");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceObjectListItem</b>
     * </p>
     *
     * @return Object list counters
     */
    @Key
    @SerializedName( "MaintenanceObjectListItem" )
    @JsonProperty( "MaintenanceObjectListItem" )
    @Nullable
    @ODataField( odataName = "MaintenanceObjectListItem" )
    private Integer maintenanceObjectListItem;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceObjectListItem</b> field to query operations.
     *
     */
    public final static MaintItemObjectListItemField<Integer> MAINTENANCE_OBJECT_LIST_ITEM =
        new MaintItemObjectListItemField<Integer>("MaintenanceObjectListItem");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectListItemSequence</b>
     * </p>
     *
     * @return Object list sort field
     */
    @SerializedName( "MaintObjectListItemSequence" )
    @JsonProperty( "MaintObjectListItemSequence" )
    @Nullable
    @ODataField( odataName = "MaintObjectListItemSequence" )
    private String maintObjectListItemSequence;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjectListItemSequence</b> field to query operations.
     *
     */
    public final static MaintItemObjectListItemField<String> MAINT_OBJECT_LIST_ITEM_SEQUENCE =
        new MaintItemObjectListItemField<String>("MaintObjectListItemSequence");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static MaintItemObjectListItemField<String> EQUIPMENT =
        new MaintItemObjectListItemField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @return Functional Location Label
     */
    @SerializedName( "FunctionalLocationLabelName" )
    @JsonProperty( "FunctionalLocationLabelName" )
    @Nullable
    @ODataField( odataName = "FunctionalLocationLabelName" )
    private String functionalLocationLabelName;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocationLabelName</b> field to query operations.
     *
     */
    public final static MaintItemObjectListItemField<String> FUNCTIONAL_LOCATION_LABEL_NAME =
        new MaintItemObjectListItemField<String>("FunctionalLocationLabelName");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @return Assembly
     */
    @SerializedName( "Assembly" )
    @JsonProperty( "Assembly" )
    @Nullable
    @ODataField( odataName = "Assembly" )
    private String assembly;
    /**
     * Use with available fluent helpers to apply the <b>Assembly</b> field to query operations.
     *
     */
    public final static MaintItemObjectListItemField<String> ASSEMBLY =
        new MaintItemObjectListItemField<String>("Assembly");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static MaintItemObjectListItemField<String> MATERIAL =
        new MaintItemObjectListItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @return Serial Number
     */
    @SerializedName( "SerialNumber" )
    @JsonProperty( "SerialNumber" )
    @Nullable
    @ODataField( odataName = "SerialNumber" )
    private String serialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumber</b> field to query operations.
     *
     */
    public final static MaintItemObjectListItemField<String> SERIAL_NUMBER =
        new MaintItemObjectListItemField<String>("SerialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 72
     * <p>
     * Original property name from the Odata EDM: <b>UniqueItemIdentifier</b>
     * </p>
     *
     * @return Unique Item Identifier
     */
    @SerializedName( "UniqueItemIdentifier" )
    @JsonProperty( "UniqueItemIdentifier" )
    @Nullable
    @ODataField( odataName = "UniqueItemIdentifier" )
    private String uniqueItemIdentifier;
    /**
     * Use with available fluent helpers to apply the <b>UniqueItemIdentifier</b> field to query operations.
     *
     */
    public final static MaintItemObjectListItemField<String> UNIQUE_ITEM_IDENTIFIER =
        new MaintItemObjectListItemField<String>("UniqueItemIdentifier");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ServiceReferenceProduct</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "ServiceReferenceProduct" )
    @JsonProperty( "ServiceReferenceProduct" )
    @Nullable
    @ODataField( odataName = "ServiceReferenceProduct" )
    private String serviceReferenceProduct;
    /**
     * Use with available fluent helpers to apply the <b>ServiceReferenceProduct</b> field to query operations.
     *
     */
    public final static MaintItemObjectListItemField<String> SERVICE_REFERENCE_PRODUCT =
        new MaintItemObjectListItemField<String>("ServiceReferenceProduct");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjListEntryIsProcessed</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "MaintObjListEntryIsProcessed" )
    @JsonProperty( "MaintObjListEntryIsProcessed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaintObjListEntryIsProcessed" )
    private Boolean maintObjListEntryIsProcessed;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjListEntryIsProcessed</b> field to query operations.
     *
     */
    public final static MaintItemObjectListItemField<Boolean> MAINT_OBJ_LIST_ENTRY_IS_PROCESSED =
        new MaintItemObjectListItemField<Boolean>("MaintObjListEntryIsProcessed");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static MaintItemObjectListItemField<LocalDateTime> CREATION_DATE =
        new MaintItemObjectListItemField<LocalDateTime>("CreationDate");
    /**
     * Navigation property <b>to_MaintenanceItemTP</b> for <b>MaintItemObjectListItem</b> to single
     * <b>MaintenanceItem</b>.
     *
     */
    @SerializedName( "to_MaintenanceItemTP" )
    @JsonProperty( "to_MaintenanceItemTP" )
    @ODataField( odataName = "to_MaintenanceItemTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceItem toMaintenanceItemTP;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceItemTP</b> navigation property to query
     * operations.
     *
     */
    public final static MaintItemObjectListItemOneToOneLink<MaintenanceItem> TO_MAINTENANCE_ITEM_TP =
        new MaintItemObjectListItemOneToOneLink<MaintenanceItem>("to_MaintenanceItemTP");

    @Nonnull
    @Override
    public Class<MaintItemObjectListItem> getType()
    {
        return MaintItemObjectListItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItem</b>
     * </p>
     *
     * @param maintenanceItem
     *            Maintenance Item
     */
    public void setMaintenanceItem( @Nullable final String maintenanceItem )
    {
        rememberChangedField("MaintenanceItem", this.maintenanceItem);
        this.maintenanceItem = maintenanceItem;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItemObjectList</b>
     * </p>
     *
     * @param maintenanceItemObjectList
     *            Object list number
     */
    public void setMaintenanceItemObjectList( @Nullable final Long maintenanceItemObjectList )
    {
        rememberChangedField("MaintenanceItemObjectList", this.maintenanceItemObjectList);
        this.maintenanceItemObjectList = maintenanceItemObjectList;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceObjectListItem</b>
     * </p>
     *
     * @param maintenanceObjectListItem
     *            Object list counters
     */
    public void setMaintenanceObjectListItem( @Nullable final Integer maintenanceObjectListItem )
    {
        rememberChangedField("MaintenanceObjectListItem", this.maintenanceObjectListItem);
        this.maintenanceObjectListItem = maintenanceObjectListItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectListItemSequence</b>
     * </p>
     *
     * @param maintObjectListItemSequence
     *            Object list sort field
     */
    public void setMaintObjectListItemSequence( @Nullable final String maintObjectListItemSequence )
    {
        rememberChangedField("MaintObjectListItemSequence", this.maintObjectListItemSequence);
        this.maintObjectListItemSequence = maintObjectListItemSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @param functionalLocationLabelName
     *            Functional Location Label
     */
    public void setFunctionalLocationLabelName( @Nullable final String functionalLocationLabelName )
    {
        rememberChangedField("FunctionalLocationLabelName", this.functionalLocationLabelName);
        this.functionalLocationLabelName = functionalLocationLabelName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @param assembly
     *            Assembly
     */
    public void setAssembly( @Nullable final String assembly )
    {
        rememberChangedField("Assembly", this.assembly);
        this.assembly = assembly;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @param serialNumber
     *            Serial Number
     */
    public void setSerialNumber( @Nullable final String serialNumber )
    {
        rememberChangedField("SerialNumber", this.serialNumber);
        this.serialNumber = serialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 72
     * <p>
     * Original property name from the Odata EDM: <b>UniqueItemIdentifier</b>
     * </p>
     *
     * @param uniqueItemIdentifier
     *            Unique Item Identifier
     */
    public void setUniqueItemIdentifier( @Nullable final String uniqueItemIdentifier )
    {
        rememberChangedField("UniqueItemIdentifier", this.uniqueItemIdentifier);
        this.uniqueItemIdentifier = uniqueItemIdentifier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ServiceReferenceProduct</b>
     * </p>
     *
     * @param serviceReferenceProduct
     *            Product Number
     */
    public void setServiceReferenceProduct( @Nullable final String serviceReferenceProduct )
    {
        rememberChangedField("ServiceReferenceProduct", this.serviceReferenceProduct);
        this.serviceReferenceProduct = serviceReferenceProduct;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjListEntryIsProcessed</b>
     * </p>
     *
     * @param maintObjListEntryIsProcessed
     *            Checkbox
     */
    public void setMaintObjListEntryIsProcessed( @Nullable final Boolean maintObjListEntryIsProcessed )
    {
        rememberChangedField("MaintObjListEntryIsProcessed", this.maintObjListEntryIsProcessed);
        this.maintObjListEntryIsProcessed = maintObjListEntryIsProcessed;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintItemObjectListItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceItem", getMaintenanceItem());
        result.put("MaintenanceItemObjectList", getMaintenanceItemObjectList());
        result.put("MaintenanceObjectListItem", getMaintenanceObjectListItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceItem", getMaintenanceItem());
        values.put("MaintenanceItemObjectList", getMaintenanceItemObjectList());
        values.put("MaintenanceObjectListItem", getMaintenanceObjectListItem());
        values.put("MaintObjectListItemSequence", getMaintObjectListItemSequence());
        values.put("Equipment", getEquipment());
        values.put("FunctionalLocationLabelName", getFunctionalLocationLabelName());
        values.put("Assembly", getAssembly());
        values.put("Material", getMaterial());
        values.put("SerialNumber", getSerialNumber());
        values.put("UniqueItemIdentifier", getUniqueItemIdentifier());
        values.put("ServiceReferenceProduct", getServiceReferenceProduct());
        values.put("MaintObjListEntryIsProcessed", getMaintObjListEntryIsProcessed());
        values.put("CreationDate", getCreationDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceItem") ) {
                final Object value = values.remove("MaintenanceItem");
                if( (value == null) || (!value.equals(getMaintenanceItem())) ) {
                    setMaintenanceItem(((String) value));
                }
            }
            if( values.containsKey("MaintenanceItemObjectList") ) {
                final Object value = values.remove("MaintenanceItemObjectList");
                if( (value == null) || (!value.equals(getMaintenanceItemObjectList())) ) {
                    setMaintenanceItemObjectList(((Long) value));
                }
            }
            if( values.containsKey("MaintenanceObjectListItem") ) {
                final Object value = values.remove("MaintenanceObjectListItem");
                if( (value == null) || (!value.equals(getMaintenanceObjectListItem())) ) {
                    setMaintenanceObjectListItem(((Integer) value));
                }
            }
            if( values.containsKey("MaintObjectListItemSequence") ) {
                final Object value = values.remove("MaintObjectListItemSequence");
                if( (value == null) || (!value.equals(getMaintObjectListItemSequence())) ) {
                    setMaintObjectListItemSequence(((String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocationLabelName") ) {
                final Object value = values.remove("FunctionalLocationLabelName");
                if( (value == null) || (!value.equals(getFunctionalLocationLabelName())) ) {
                    setFunctionalLocationLabelName(((String) value));
                }
            }
            if( values.containsKey("Assembly") ) {
                final Object value = values.remove("Assembly");
                if( (value == null) || (!value.equals(getAssembly())) ) {
                    setAssembly(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("SerialNumber") ) {
                final Object value = values.remove("SerialNumber");
                if( (value == null) || (!value.equals(getSerialNumber())) ) {
                    setSerialNumber(((String) value));
                }
            }
            if( values.containsKey("UniqueItemIdentifier") ) {
                final Object value = values.remove("UniqueItemIdentifier");
                if( (value == null) || (!value.equals(getUniqueItemIdentifier())) ) {
                    setUniqueItemIdentifier(((String) value));
                }
            }
            if( values.containsKey("ServiceReferenceProduct") ) {
                final Object value = values.remove("ServiceReferenceProduct");
                if( (value == null) || (!value.equals(getServiceReferenceProduct())) ) {
                    setServiceReferenceProduct(((String) value));
                }
            }
            if( values.containsKey("MaintObjListEntryIsProcessed") ) {
                final Object value = values.remove("MaintObjListEntryIsProcessed");
                if( (value == null) || (!value.equals(getMaintObjListEntryIsProcessed())) ) {
                    setMaintObjListEntryIsProcessed(((Boolean) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceItemTP") ) {
                final Object value = (values).remove("to_MaintenanceItemTP");
                if( value instanceof Map ) {
                    if( toMaintenanceItemTP == null ) {
                        toMaintenanceItemTP = new MaintenanceItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceItemTP.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintItemObjectListItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintItemObjectListItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintItemObjectListItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintItemObjectListItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceItemTP != null ) {
            (values).put("to_MaintenanceItemTP", toMaintenanceItemTP);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_MaintenanceItemTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceItem fetchMaintenanceItemTP()
    {
        return fetchFieldAsSingle("to_MaintenanceItemTP", MaintenanceItem.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceItemTP</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItemTP</b> of a queried <b>MaintItemObjectListItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceItem getMaintenanceItemTPOrFetch()
    {
        if( toMaintenanceItemTP == null ) {
            toMaintenanceItemTP = fetchMaintenanceItemTP();
        }
        return toMaintenanceItemTP;
    }

    /**
     * Retrieval of associated <b>MaintenanceItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceItemTP</b>.
     * <p>
     * If the navigation property for an entity <b>MaintItemObjectListItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceItemTP</b> is already loaded, the result will
     *         contain the <b>MaintenanceItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceItem> getMaintenanceItemTPIfPresent()
    {
        return Option.of(toMaintenanceItemTP);
    }

    /**
     * Overwrites the associated <b>MaintenanceItem</b> entity for the loaded navigation property
     * <b>to_MaintenanceItemTP</b>.
     *
     * @param value
     *            New <b>MaintenanceItem</b> entity.
     */
    public void setMaintenanceItemTP( final MaintenanceItem value )
    {
        toMaintenanceItemTP = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintItemObjectListItem instances.
     *
     */
    public final static class MaintItemObjectListItemBuilder
    {

        private MaintenanceItem toMaintenanceItemTP;

        private MaintItemObjectListItem.MaintItemObjectListItemBuilder toMaintenanceItemTP(
            final MaintenanceItem value )
        {
            toMaintenanceItemTP = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceItemTP</b> for <b>MaintItemObjectListItem</b> to single
         * <b>MaintenanceItem</b>.
         *
         * @param value
         *            The MaintenanceItem to build this MaintItemObjectListItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintItemObjectListItem.MaintItemObjectListItemBuilder maintenanceItemTP( final MaintenanceItem value )
        {
            return toMaintenanceItemTP(value);
        }

    }

}
