/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintItemObjectListItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
 * MaintItemObjectListItem} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class MaintItemObjectListItemByKeyFluentHelper
    extends
    FluentHelperByKey<MaintItemObjectListItemByKeyFluentHelper, MaintItemObjectListItem, MaintItemObjectListItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     * MaintItemObjectListItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintItemObjectListItem}
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintItemObjectListItem}
     * @param maintenanceItemObjectList
     *            Object list number
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param maintenanceObjectListItem
     *            Object list counters
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public MaintItemObjectListItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintenanceItem,
        final Long maintenanceItemObjectList,
        final Integer maintenanceObjectListItem )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenanceItem", maintenanceItem);
        this.key.put("MaintenanceItemObjectList", maintenanceItemObjectList);
        this.key.put("MaintenanceObjectListItem", maintenanceObjectListItem);
    }

    @Override
    @Nonnull
    protected Class<MaintItemObjectListItem> getEntityClass()
    {
        return MaintItemObjectListItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
