/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintPlanClfnCharValueSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnCharValue
 * MaintPlanClfnCharValue} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class MaintPlanClfnCharValueByKeyFluentHelper
    extends
    FluentHelperByKey<MaintPlanClfnCharValueByKeyFluentHelper, MaintPlanClfnCharValue, MaintPlanClfnCharValueSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnCharValue
     * MaintPlanClfnCharValue} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param clfnCharcValuePositionNumber
     *            Characteristic value counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintPlanClfnCharValue}
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintPlanClfnCharValue}
     * @param classType
     *            Class Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     */
    public MaintPlanClfnCharValueByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintenancePlan,
        final String classType,
        final String clfnCharcValuePositionNumber,
        final String charcInternalID )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenancePlan", maintenancePlan);
        this.key.put("ClassType", classType);
        this.key.put("ClfnCharcValuePositionNumber", clfnCharcValuePositionNumber);
        this.key.put("CharcInternalID", charcInternalID);
    }

    @Override
    @Nonnull
    protected Class<MaintPlanClfnCharValue> getEntityClass()
    {
        return MaintPlanClfnCharValue.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
