/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintPlanClfnClassField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintPlanClfnClassLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintPlanClfnClassSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Plan Classification Class
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintPlanClfnClassType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintPlanClfnClass extends VdmEntity<MaintPlanClfnClass>
{

    /**
     * Selector for all available fields of MaintPlanClfnClass.
     *
     */
    public final static MaintPlanClfnClassSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @return Maintenance Plan
     */
    @Key
    @SerializedName( "MaintenancePlan" )
    @JsonProperty( "MaintenancePlan" )
    @Nullable
    @ODataField( odataName = "MaintenancePlan" )
    private String maintenancePlan;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlan</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<String> MAINTENANCE_PLAN =
        new MaintPlanClfnClassField<String>("MaintenancePlan");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @Key
    @SerializedName( "ClassInternalID" )
    @JsonProperty( "ClassInternalID" )
    @Nullable
    @ODataField( odataName = "ClassInternalID" )
    private String classInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClassInternalID</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<String> CLASS_INTERNAL_ID =
        new MaintPlanClfnClassField<String>("ClassInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @return Class Type
     */
    @Key
    @SerializedName( "ClassType" )
    @JsonProperty( "ClassType" )
    @Nullable
    @ODataField( odataName = "ClassType" )
    private String classType;
    /**
     * Use with available fluent helpers to apply the <b>ClassType</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<String> CLASS_TYPE = new MaintPlanClfnClassField<String>("ClassType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return The keyDate contained in this entity.
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<LocalDateTime> KEY_DATE =
        new MaintPlanClfnClassField<LocalDateTime>("KeyDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<String> CHANGE_NUMBER =
        new MaintPlanClfnClassField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ClfnStatus</b>
     * </p>
     *
     * @return Classification status
     */
    @SerializedName( "ClfnStatus" )
    @JsonProperty( "ClfnStatus" )
    @Nullable
    @ODataField( odataName = "ClfnStatus" )
    private String clfnStatus;
    /**
     * Use with available fluent helpers to apply the <b>ClfnStatus</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<String> CLFN_STATUS = new MaintPlanClfnClassField<String>("ClfnStatus");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ClassPositionNumber</b>
     * </p>
     *
     * @return Sort Item
     */
    @SerializedName( "ClassPositionNumber" )
    @JsonProperty( "ClassPositionNumber" )
    @Nullable
    @ODataField( odataName = "ClassPositionNumber" )
    private Short classPositionNumber;
    /**
     * Use with available fluent helpers to apply the <b>ClassPositionNumber</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<Short> CLASS_POSITION_NUMBER =
        new MaintPlanClfnClassField<Short>("ClassPositionNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ClassIsStandardClass</b>
     * </p>
     *
     * @return Indicator: Standard Class
     */
    @SerializedName( "ClassIsStandardClass" )
    @JsonProperty( "ClassIsStandardClass" )
    @Nullable
    @ODataField( odataName = "ClassIsStandardClass" )
    private String classIsStandardClass;
    /**
     * Use with available fluent helpers to apply the <b>ClassIsStandardClass</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<String> CLASS_IS_STANDARD_CLASS =
        new MaintPlanClfnClassField<String>("ClassIsStandardClass");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ClfnObjectInternalID</b>
     * </p>
     *
     * @return Configuration (Internal Object Number)
     */
    @SerializedName( "ClfnObjectInternalID" )
    @JsonProperty( "ClfnObjectInternalID" )
    @Nullable
    @ODataField( odataName = "ClfnObjectInternalID" )
    private String clfnObjectInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClfnObjectInternalID</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<String> CLFN_OBJECT_INTERNAL_ID =
        new MaintPlanClfnClassField<String>("ClfnObjectInternalID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<LocalDateTime> VALIDITY_END_DATE =
        new MaintPlanClfnClassField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Class</b>
     * </p>
     *
     * @return Class number
     */
    @SerializedName( "Class" )
    @JsonProperty( "Class" )
    @Nullable
    @ODataField( odataName = "Class" )
    private String classProperty;
    /**
     * Use with available fluent helpers to apply the <b>Class</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<String> CLASS_PROPERTY = new MaintPlanClfnClassField<String>("Class");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassMaintAuthGrp</b>
     * </p>
     *
     * @return Class Maintenance Authorization Group
     */
    @SerializedName( "ClassMaintAuthGrp" )
    @JsonProperty( "ClassMaintAuthGrp" )
    @Nullable
    @ODataField( odataName = "ClassMaintAuthGrp" )
    private String classMaintAuthGrp;
    /**
     * Use with available fluent helpers to apply the <b>ClassMaintAuthGrp</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<String> CLASS_MAINT_AUTH_GRP =
        new MaintPlanClfnClassField<String>("ClassMaintAuthGrp");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassClassfctnAuthGrp</b>
     * </p>
     *
     * @return Classification Authorization Group
     */
    @SerializedName( "ClassClassfctnAuthGrp" )
    @JsonProperty( "ClassClassfctnAuthGrp" )
    @Nullable
    @ODataField( odataName = "ClassClassfctnAuthGrp" )
    private String classClassfctnAuthGrp;
    /**
     * Use with available fluent helpers to apply the <b>ClassClassfctnAuthGrp</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<String> CLASS_CLASSFCTN_AUTH_GRP =
        new MaintPlanClfnClassField<String>("ClassClassfctnAuthGrp");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCallObject</b>
     * </p>
     *
     * @return Call object for maintenance plan
     */
    @SerializedName( "MaintenancePlanCallObject" )
    @JsonProperty( "MaintenancePlanCallObject" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanCallObject" )
    private String maintenancePlanCallObject;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanCallObject</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<String> MAINTENANCE_PLAN_CALL_OBJECT =
        new MaintPlanClfnClassField<String>("MaintenancePlanCallObject");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @return Technical Object Authorization Group
     */
    @SerializedName( "AuthorizationGroup" )
    @JsonProperty( "AuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "AuthorizationGroup" )
    private String authorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationGroup</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassField<String> AUTHORIZATION_GROUP =
        new MaintPlanClfnClassField<String>("AuthorizationGroup");
    /**
     * Navigation property <b>to_Characteristic</b> for <b>MaintPlanClfnClass</b> to multiple
     * <b>MaintPlanClfnClassChar</b>.
     *
     */
    @SerializedName( "to_Characteristic" )
    @JsonProperty( "to_Characteristic" )
    @ODataField( odataName = "to_Characteristic" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintPlanClfnClassChar> toCharacteristic;
    /**
     * Use with available fluent helpers to apply the <b>to_Characteristic</b> navigation property to query operations.
     *
     */
    public final static MaintPlanClfnClassLink<MaintPlanClfnClassChar> TO_CHARACTERISTIC =
        new MaintPlanClfnClassLink<MaintPlanClfnClassChar>("to_Characteristic");

    @Nonnull
    @Override
    public Class<MaintPlanClfnClass> getType()
    {
        return MaintPlanClfnClass.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     */
    public void setMaintenancePlan( @Nullable final String maintenancePlan )
    {
        rememberChangedField("MaintenancePlan", this.maintenancePlan);
        this.maintenancePlan = maintenancePlan;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @param classInternalID
     *            Internal Class Number
     */
    public void setClassInternalID( @Nullable final String classInternalID )
    {
        rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *            Class Type
     */
    public void setClassType( @Nullable final String classType )
    {
        rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            The keyDate to set.
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ClfnStatus</b>
     * </p>
     *
     * @param clfnStatus
     *            Classification status
     */
    public void setClfnStatus( @Nullable final String clfnStatus )
    {
        rememberChangedField("ClfnStatus", this.clfnStatus);
        this.clfnStatus = clfnStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ClassPositionNumber</b>
     * </p>
     *
     * @param classPositionNumber
     *            Sort Item
     */
    public void setClassPositionNumber( @Nullable final Short classPositionNumber )
    {
        rememberChangedField("ClassPositionNumber", this.classPositionNumber);
        this.classPositionNumber = classPositionNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ClassIsStandardClass</b>
     * </p>
     *
     * @param classIsStandardClass
     *            Indicator: Standard Class
     */
    public void setClassIsStandardClass( @Nullable final String classIsStandardClass )
    {
        rememberChangedField("ClassIsStandardClass", this.classIsStandardClass);
        this.classIsStandardClass = classIsStandardClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ClfnObjectInternalID</b>
     * </p>
     *
     * @param clfnObjectInternalID
     *            Configuration (Internal Object Number)
     */
    public void setClfnObjectInternalID( @Nullable final String clfnObjectInternalID )
    {
        rememberChangedField("ClfnObjectInternalID", this.clfnObjectInternalID);
        this.clfnObjectInternalID = clfnObjectInternalID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-to date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Class</b>
     * </p>
     *
     * @param classProperty
     *            Class number
     */
    public void setClassProperty( @Nullable final String classProperty )
    {
        rememberChangedField("Class", this.classProperty);
        this.classProperty = classProperty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassMaintAuthGrp</b>
     * </p>
     *
     * @param classMaintAuthGrp
     *            Class Maintenance Authorization Group
     */
    public void setClassMaintAuthGrp( @Nullable final String classMaintAuthGrp )
    {
        rememberChangedField("ClassMaintAuthGrp", this.classMaintAuthGrp);
        this.classMaintAuthGrp = classMaintAuthGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassClassfctnAuthGrp</b>
     * </p>
     *
     * @param classClassfctnAuthGrp
     *            Classification Authorization Group
     */
    public void setClassClassfctnAuthGrp( @Nullable final String classClassfctnAuthGrp )
    {
        rememberChangedField("ClassClassfctnAuthGrp", this.classClassfctnAuthGrp);
        this.classClassfctnAuthGrp = classClassfctnAuthGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCallObject</b>
     * </p>
     *
     * @param maintenancePlanCallObject
     *            Call object for maintenance plan
     */
    public void setMaintenancePlanCallObject( @Nullable final String maintenancePlanCallObject )
    {
        rememberChangedField("MaintenancePlanCallObject", this.maintenancePlanCallObject);
        this.maintenancePlanCallObject = maintenancePlanCallObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @param authorizationGroup
     *            Technical Object Authorization Group
     */
    public void setAuthorizationGroup( @Nullable final String authorizationGroup )
    {
        rememberChangedField("AuthorizationGroup", this.authorizationGroup);
        this.authorizationGroup = authorizationGroup;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintPlanClfnClass";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenancePlan", getMaintenancePlan());
        result.put("ClassInternalID", getClassInternalID());
        result.put("ClassType", getClassType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenancePlan", getMaintenancePlan());
        values.put("ClassInternalID", getClassInternalID());
        values.put("ClassType", getClassType());
        values.put("KeyDate", getKeyDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ClfnStatus", getClfnStatus());
        values.put("ClassPositionNumber", getClassPositionNumber());
        values.put("ClassIsStandardClass", getClassIsStandardClass());
        values.put("ClfnObjectInternalID", getClfnObjectInternalID());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("Class", getClassProperty());
        values.put("ClassMaintAuthGrp", getClassMaintAuthGrp());
        values.put("ClassClassfctnAuthGrp", getClassClassfctnAuthGrp());
        values.put("MaintenancePlanCallObject", getMaintenancePlanCallObject());
        values.put("AuthorizationGroup", getAuthorizationGroup());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenancePlan") ) {
                final Object value = values.remove("MaintenancePlan");
                if( (value == null) || (!value.equals(getMaintenancePlan())) ) {
                    setMaintenancePlan(((String) value));
                }
            }
            if( values.containsKey("ClassInternalID") ) {
                final Object value = values.remove("ClassInternalID");
                if( (value == null) || (!value.equals(getClassInternalID())) ) {
                    setClassInternalID(((String) value));
                }
            }
            if( values.containsKey("ClassType") ) {
                final Object value = values.remove("ClassType");
                if( (value == null) || (!value.equals(getClassType())) ) {
                    setClassType(((String) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ClfnStatus") ) {
                final Object value = values.remove("ClfnStatus");
                if( (value == null) || (!value.equals(getClfnStatus())) ) {
                    setClfnStatus(((String) value));
                }
            }
            if( values.containsKey("ClassPositionNumber") ) {
                final Object value = values.remove("ClassPositionNumber");
                if( (value == null) || (!value.equals(getClassPositionNumber())) ) {
                    setClassPositionNumber(((Short) value));
                }
            }
            if( values.containsKey("ClassIsStandardClass") ) {
                final Object value = values.remove("ClassIsStandardClass");
                if( (value == null) || (!value.equals(getClassIsStandardClass())) ) {
                    setClassIsStandardClass(((String) value));
                }
            }
            if( values.containsKey("ClfnObjectInternalID") ) {
                final Object value = values.remove("ClfnObjectInternalID");
                if( (value == null) || (!value.equals(getClfnObjectInternalID())) ) {
                    setClfnObjectInternalID(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Class") ) {
                final Object value = values.remove("Class");
                if( (value == null) || (!value.equals(getClassProperty())) ) {
                    setClassProperty(((String) value));
                }
            }
            if( values.containsKey("ClassMaintAuthGrp") ) {
                final Object value = values.remove("ClassMaintAuthGrp");
                if( (value == null) || (!value.equals(getClassMaintAuthGrp())) ) {
                    setClassMaintAuthGrp(((String) value));
                }
            }
            if( values.containsKey("ClassClassfctnAuthGrp") ) {
                final Object value = values.remove("ClassClassfctnAuthGrp");
                if( (value == null) || (!value.equals(getClassClassfctnAuthGrp())) ) {
                    setClassClassfctnAuthGrp(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanCallObject") ) {
                final Object value = values.remove("MaintenancePlanCallObject");
                if( (value == null) || (!value.equals(getMaintenancePlanCallObject())) ) {
                    setMaintenancePlanCallObject(((String) value));
                }
            }
            if( values.containsKey("AuthorizationGroup") ) {
                final Object value = values.remove("AuthorizationGroup");
                if( (value == null) || (!value.equals(getAuthorizationGroup())) ) {
                    setAuthorizationGroup(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Characteristic") ) {
                final Object value = (values).remove("to_Characteristic");
                if( value instanceof Iterable ) {
                    if( toCharacteristic == null ) {
                        toCharacteristic = Lists.newArrayList();
                    } else {
                        toCharacteristic = Lists.newArrayList(toCharacteristic);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintPlanClfnClassChar entity;
                        if( toCharacteristic.size() > i ) {
                            entity = toCharacteristic.get(i);
                        } else {
                            entity = new MaintPlanClfnClassChar();
                            toCharacteristic.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintPlanClfnClassField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintPlanClfnClassField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintPlanClfnClassField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintPlanClfnClassField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCharacteristic != null ) {
            (values).put("to_Characteristic", toCharacteristic);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintPlanClfnClassChar</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Characteristic</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintPlanClfnClassChar</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintPlanClfnClassChar> fetchCharacteristic()
    {
        return fetchFieldAsList("to_Characteristic", MaintPlanClfnClassChar.class);
    }

    /**
     * Retrieval of associated <b>MaintPlanClfnClassChar</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Characteristic</b>.
     * <p>
     * If the navigation property <b>to_Characteristic</b> of a queried <b>MaintPlanClfnClass</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintPlanClfnClassChar</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintPlanClfnClassChar> getCharacteristicOrFetch()
    {
        if( toCharacteristic == null ) {
            toCharacteristic = fetchCharacteristic();
        }
        return toCharacteristic;
    }

    /**
     * Retrieval of associated <b>MaintPlanClfnClassChar</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Characteristic</b>.
     * <p>
     * If the navigation property for an entity <b>MaintPlanClfnClass</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Characteristic</b> is already loaded, the result will
     *         contain the <b>MaintPlanClfnClassChar</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintPlanClfnClassChar>> getCharacteristicIfPresent()
    {
        return Option.of(toCharacteristic);
    }

    /**
     * Overwrites the list of associated <b>MaintPlanClfnClassChar</b> entities for the loaded navigation property
     * <b>to_Characteristic</b>.
     * <p>
     * If the navigation property <b>to_Characteristic</b> of a queried <b>MaintPlanClfnClass</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintPlanClfnClassChar</b> entities.
     */
    public void setCharacteristic( @Nonnull final List<MaintPlanClfnClassChar> value )
    {
        if( toCharacteristic == null ) {
            toCharacteristic = Lists.newArrayList();
        }
        toCharacteristic.clear();
        toCharacteristic.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintPlanClfnClassChar</b> entities. This corresponds to the OData
     * navigation property <b>to_Characteristic</b>.
     * <p>
     * If the navigation property <b>to_Characteristic</b> of a queried <b>MaintPlanClfnClass</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintPlanClfnClassChar</b> entities.
     */
    public void addCharacteristic( MaintPlanClfnClassChar... entity )
    {
        if( toCharacteristic == null ) {
            toCharacteristic = Lists.newArrayList();
        }
        toCharacteristic.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintPlanClfnClass instances.
     *
     */
    public final static class MaintPlanClfnClassBuilder
    {

        private List<MaintPlanClfnClassChar> toCharacteristic = Lists.newArrayList();

        private MaintPlanClfnClass.MaintPlanClfnClassBuilder toCharacteristic(
            final List<MaintPlanClfnClassChar> value )
        {
            toCharacteristic.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Characteristic</b> for <b>MaintPlanClfnClass</b> to multiple
         * <b>MaintPlanClfnClassChar</b>.
         *
         * @param value
         *            The MaintPlanClfnClassChars to build this MaintPlanClfnClass with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintPlanClfnClass.MaintPlanClfnClassBuilder characteristic( MaintPlanClfnClassChar... value )
        {
            return toCharacteristic(Lists.newArrayList(value));
        }

    }

}
