/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintPlanClfnClassCharField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintPlanClfnClassCharLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintPlanClfnClassCharOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintPlanClfnClassCharSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Plan Classification Class Characteristics
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintPlanClfnClassCharType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintPlanClfnClassChar extends VdmEntity<MaintPlanClfnClassChar>
{

    /**
     * Selector for all available fields of MaintPlanClfnClassChar.
     *
     */
    public final static MaintPlanClfnClassCharSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @return Maintenance Plan
     */
    @Key
    @SerializedName( "MaintenancePlan" )
    @JsonProperty( "MaintenancePlan" )
    @Nullable
    @ODataField( odataName = "MaintenancePlan" )
    private String maintenancePlan;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlan</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassCharField<String> MAINTENANCE_PLAN =
        new MaintPlanClfnClassCharField<String>("MaintenancePlan");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @Key
    @SerializedName( "ClassInternalID" )
    @JsonProperty( "ClassInternalID" )
    @Nullable
    @ODataField( odataName = "ClassInternalID" )
    private String classInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClassInternalID</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassCharField<String> CLASS_INTERNAL_ID =
        new MaintPlanClfnClassCharField<String>("ClassInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @Key
    @SerializedName( "CharcInternalID" )
    @JsonProperty( "CharcInternalID" )
    @Nullable
    @ODataField( odataName = "CharcInternalID" )
    private String charcInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharcInternalID</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassCharField<String> CHARC_INTERNAL_ID =
        new MaintPlanClfnClassCharField<String>("CharcInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @SerializedName( "Characteristic" )
    @JsonProperty( "Characteristic" )
    @Nullable
    @ODataField( odataName = "Characteristic" )
    private String characteristic;
    /**
     * Use with available fluent helpers to apply the <b>Characteristic</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassCharField<String> CHARACTERISTIC =
        new MaintPlanClfnClassCharField<String>("Characteristic");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharcDataType</b>
     * </p>
     *
     * @return Data type of characteristic
     */
    @SerializedName( "CharcDataType" )
    @JsonProperty( "CharcDataType" )
    @Nullable
    @ODataField( odataName = "CharcDataType" )
    private String charcDataType;
    /**
     * Use with available fluent helpers to apply the <b>CharcDataType</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassCharField<String> CHARC_DATA_TYPE =
        new MaintPlanClfnClassCharField<String>("CharcDataType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return The keyDate contained in this entity.
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassCharField<LocalDateTime> KEY_DATE =
        new MaintPlanClfnClassCharField<LocalDateTime>("KeyDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassCharField<String> CHANGE_NUMBER =
        new MaintPlanClfnClassCharField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @return Class Type
     */
    @SerializedName( "ClassType" )
    @JsonProperty( "ClassType" )
    @Nullable
    @ODataField( odataName = "ClassType" )
    private String classType;
    /**
     * Use with available fluent helpers to apply the <b>ClassType</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassCharField<String> CLASS_TYPE =
        new MaintPlanClfnClassCharField<String>("ClassType");
    /**
     * Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>ClfnObjectID</b>
     * </p>
     *
     * @return Key of Object to be Classified
     */
    @SerializedName( "ClfnObjectID" )
    @JsonProperty( "ClfnObjectID" )
    @Nullable
    @ODataField( odataName = "ClfnObjectID" )
    private String clfnObjectID;
    /**
     * Use with available fluent helpers to apply the <b>ClfnObjectID</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassCharField<String> CLFN_OBJECT_ID =
        new MaintPlanClfnClassCharField<String>("ClfnObjectID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassMaintAuthGrp</b>
     * </p>
     *
     * @return Class Maintenance Authorization Group
     */
    @SerializedName( "ClassMaintAuthGrp" )
    @JsonProperty( "ClassMaintAuthGrp" )
    @Nullable
    @ODataField( odataName = "ClassMaintAuthGrp" )
    private String classMaintAuthGrp;
    /**
     * Use with available fluent helpers to apply the <b>ClassMaintAuthGrp</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassCharField<String> CLASS_MAINT_AUTH_GRP =
        new MaintPlanClfnClassCharField<String>("ClassMaintAuthGrp");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassClassfctnAuthGrp</b>
     * </p>
     *
     * @return Classification Authorization Group
     */
    @SerializedName( "ClassClassfctnAuthGrp" )
    @JsonProperty( "ClassClassfctnAuthGrp" )
    @Nullable
    @ODataField( odataName = "ClassClassfctnAuthGrp" )
    private String classClassfctnAuthGrp;
    /**
     * Use with available fluent helpers to apply the <b>ClassClassfctnAuthGrp</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassCharField<String> CLASS_CLASSFCTN_AUTH_GRP =
        new MaintPlanClfnClassCharField<String>("ClassClassfctnAuthGrp");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcMaintAuthGrp</b>
     * </p>
     *
     * @return Authorization Group for Characteristics Maintenance
     */
    @SerializedName( "CharcMaintAuthGrp" )
    @JsonProperty( "CharcMaintAuthGrp" )
    @Nullable
    @ODataField( odataName = "CharcMaintAuthGrp" )
    private String charcMaintAuthGrp;
    /**
     * Use with available fluent helpers to apply the <b>CharcMaintAuthGrp</b> field to query operations.
     *
     */
    public final static MaintPlanClfnClassCharField<String> CHARC_MAINT_AUTH_GRP =
        new MaintPlanClfnClassCharField<String>("CharcMaintAuthGrp");
    /**
     * Navigation property <b>to_MaintPlanClass</b> for <b>MaintPlanClfnClassChar</b> to single
     * <b>MaintPlanClfnClass</b>.
     *
     */
    @SerializedName( "to_MaintPlanClass" )
    @JsonProperty( "to_MaintPlanClass" )
    @ODataField( odataName = "to_MaintPlanClass" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintPlanClfnClass toMaintPlanClass;
    /**
     * Navigation property <b>to_Value</b> for <b>MaintPlanClfnClassChar</b> to multiple <b>MaintPlanClfnCharValue</b>.
     *
     */
    @SerializedName( "to_Value" )
    @JsonProperty( "to_Value" )
    @ODataField( odataName = "to_Value" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintPlanClfnCharValue> toValue;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintPlanClass</b> navigation property to query operations.
     *
     */
    public final static MaintPlanClfnClassCharOneToOneLink<MaintPlanClfnClass> TO_MAINT_PLAN_CLASS =
        new MaintPlanClfnClassCharOneToOneLink<MaintPlanClfnClass>("to_MaintPlanClass");
    /**
     * Use with available fluent helpers to apply the <b>to_Value</b> navigation property to query operations.
     *
     */
    public final static MaintPlanClfnClassCharLink<MaintPlanClfnCharValue> TO_VALUE =
        new MaintPlanClfnClassCharLink<MaintPlanClfnCharValue>("to_Value");

    @Nonnull
    @Override
    public Class<MaintPlanClfnClassChar> getType()
    {
        return MaintPlanClfnClassChar.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     */
    public void setMaintenancePlan( @Nullable final String maintenancePlan )
    {
        rememberChangedField("MaintenancePlan", this.maintenancePlan);
        this.maintenancePlan = maintenancePlan;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @param classInternalID
     *            Internal Class Number
     */
    public void setClassInternalID( @Nullable final String classInternalID )
    {
        rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     */
    public void setCharcInternalID( @Nullable final String charcInternalID )
    {
        rememberChangedField("CharcInternalID", this.charcInternalID);
        this.charcInternalID = charcInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @param characteristic
     *            Characteristic Name
     */
    public void setCharacteristic( @Nullable final String characteristic )
    {
        rememberChangedField("Characteristic", this.characteristic);
        this.characteristic = characteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharcDataType</b>
     * </p>
     *
     * @param charcDataType
     *            Data type of characteristic
     */
    public void setCharcDataType( @Nullable final String charcDataType )
    {
        rememberChangedField("CharcDataType", this.charcDataType);
        this.charcDataType = charcDataType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            The keyDate to set.
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *            Class Type
     */
    public void setClassType( @Nullable final String classType )
    {
        rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>ClfnObjectID</b>
     * </p>
     *
     * @param clfnObjectID
     *            Key of Object to be Classified
     */
    public void setClfnObjectID( @Nullable final String clfnObjectID )
    {
        rememberChangedField("ClfnObjectID", this.clfnObjectID);
        this.clfnObjectID = clfnObjectID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassMaintAuthGrp</b>
     * </p>
     *
     * @param classMaintAuthGrp
     *            Class Maintenance Authorization Group
     */
    public void setClassMaintAuthGrp( @Nullable final String classMaintAuthGrp )
    {
        rememberChangedField("ClassMaintAuthGrp", this.classMaintAuthGrp);
        this.classMaintAuthGrp = classMaintAuthGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassClassfctnAuthGrp</b>
     * </p>
     *
     * @param classClassfctnAuthGrp
     *            Classification Authorization Group
     */
    public void setClassClassfctnAuthGrp( @Nullable final String classClassfctnAuthGrp )
    {
        rememberChangedField("ClassClassfctnAuthGrp", this.classClassfctnAuthGrp);
        this.classClassfctnAuthGrp = classClassfctnAuthGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcMaintAuthGrp</b>
     * </p>
     *
     * @param charcMaintAuthGrp
     *            Authorization Group for Characteristics Maintenance
     */
    public void setCharcMaintAuthGrp( @Nullable final String charcMaintAuthGrp )
    {
        rememberChangedField("CharcMaintAuthGrp", this.charcMaintAuthGrp);
        this.charcMaintAuthGrp = charcMaintAuthGrp;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintPlanClfnClassChar";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenancePlan", getMaintenancePlan());
        result.put("ClassInternalID", getClassInternalID());
        result.put("CharcInternalID", getCharcInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenancePlan", getMaintenancePlan());
        values.put("ClassInternalID", getClassInternalID());
        values.put("CharcInternalID", getCharcInternalID());
        values.put("Characteristic", getCharacteristic());
        values.put("CharcDataType", getCharcDataType());
        values.put("KeyDate", getKeyDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ClassType", getClassType());
        values.put("ClfnObjectID", getClfnObjectID());
        values.put("ClassMaintAuthGrp", getClassMaintAuthGrp());
        values.put("ClassClassfctnAuthGrp", getClassClassfctnAuthGrp());
        values.put("CharcMaintAuthGrp", getCharcMaintAuthGrp());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenancePlan") ) {
                final Object value = values.remove("MaintenancePlan");
                if( (value == null) || (!value.equals(getMaintenancePlan())) ) {
                    setMaintenancePlan(((String) value));
                }
            }
            if( values.containsKey("ClassInternalID") ) {
                final Object value = values.remove("ClassInternalID");
                if( (value == null) || (!value.equals(getClassInternalID())) ) {
                    setClassInternalID(((String) value));
                }
            }
            if( values.containsKey("CharcInternalID") ) {
                final Object value = values.remove("CharcInternalID");
                if( (value == null) || (!value.equals(getCharcInternalID())) ) {
                    setCharcInternalID(((String) value));
                }
            }
            if( values.containsKey("Characteristic") ) {
                final Object value = values.remove("Characteristic");
                if( (value == null) || (!value.equals(getCharacteristic())) ) {
                    setCharacteristic(((String) value));
                }
            }
            if( values.containsKey("CharcDataType") ) {
                final Object value = values.remove("CharcDataType");
                if( (value == null) || (!value.equals(getCharcDataType())) ) {
                    setCharcDataType(((String) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ClassType") ) {
                final Object value = values.remove("ClassType");
                if( (value == null) || (!value.equals(getClassType())) ) {
                    setClassType(((String) value));
                }
            }
            if( values.containsKey("ClfnObjectID") ) {
                final Object value = values.remove("ClfnObjectID");
                if( (value == null) || (!value.equals(getClfnObjectID())) ) {
                    setClfnObjectID(((String) value));
                }
            }
            if( values.containsKey("ClassMaintAuthGrp") ) {
                final Object value = values.remove("ClassMaintAuthGrp");
                if( (value == null) || (!value.equals(getClassMaintAuthGrp())) ) {
                    setClassMaintAuthGrp(((String) value));
                }
            }
            if( values.containsKey("ClassClassfctnAuthGrp") ) {
                final Object value = values.remove("ClassClassfctnAuthGrp");
                if( (value == null) || (!value.equals(getClassClassfctnAuthGrp())) ) {
                    setClassClassfctnAuthGrp(((String) value));
                }
            }
            if( values.containsKey("CharcMaintAuthGrp") ) {
                final Object value = values.remove("CharcMaintAuthGrp");
                if( (value == null) || (!value.equals(getCharcMaintAuthGrp())) ) {
                    setCharcMaintAuthGrp(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintPlanClass") ) {
                final Object value = (values).remove("to_MaintPlanClass");
                if( value instanceof Map ) {
                    if( toMaintPlanClass == null ) {
                        toMaintPlanClass = new MaintPlanClfnClass();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintPlanClass.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Value") ) {
                final Object value = (values).remove("to_Value");
                if( value instanceof Iterable ) {
                    if( toValue == null ) {
                        toValue = Lists.newArrayList();
                    } else {
                        toValue = Lists.newArrayList(toValue);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintPlanClfnCharValue entity;
                        if( toValue.size() > i ) {
                            entity = toValue.get(i);
                        } else {
                            entity = new MaintPlanClfnCharValue();
                            toValue.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintPlanClfnClassCharField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintPlanClfnClassCharField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintPlanClfnClassCharField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintPlanClfnClassCharField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintPlanClass != null ) {
            (values).put("to_MaintPlanClass", toMaintPlanClass);
        }
        if( toValue != null ) {
            (values).put("to_Value", toValue);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintPlanClfnClass</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintPlanClass</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintPlanClfnClass</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintPlanClfnClass fetchMaintPlanClass()
    {
        return fetchFieldAsSingle("to_MaintPlanClass", MaintPlanClfnClass.class);
    }

    /**
     * Retrieval of associated <b>MaintPlanClfnClass</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintPlanClass</b>.
     * <p>
     * If the navigation property <b>to_MaintPlanClass</b> of a queried <b>MaintPlanClfnClassChar</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintPlanClfnClass</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintPlanClfnClass getMaintPlanClassOrFetch()
    {
        if( toMaintPlanClass == null ) {
            toMaintPlanClass = fetchMaintPlanClass();
        }
        return toMaintPlanClass;
    }

    /**
     * Retrieval of associated <b>MaintPlanClfnClass</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintPlanClass</b>.
     * <p>
     * If the navigation property for an entity <b>MaintPlanClfnClassChar</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintPlanClass</b> is already loaded, the result will
     *         contain the <b>MaintPlanClfnClass</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintPlanClfnClass> getMaintPlanClassIfPresent()
    {
        return Option.of(toMaintPlanClass);
    }

    /**
     * Overwrites the associated <b>MaintPlanClfnClass</b> entity for the loaded navigation property
     * <b>to_MaintPlanClass</b>.
     *
     * @param value
     *            New <b>MaintPlanClfnClass</b> entity.
     */
    public void setMaintPlanClass( final MaintPlanClfnClass value )
    {
        toMaintPlanClass = value;
    }

    /**
     * Fetches the <b>MaintPlanClfnCharValue</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Value</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintPlanClfnCharValue</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintPlanClfnCharValue> fetchValue()
    {
        return fetchFieldAsList("to_Value", MaintPlanClfnCharValue.class);
    }

    /**
     * Retrieval of associated <b>MaintPlanClfnCharValue</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Value</b>.
     * <p>
     * If the navigation property <b>to_Value</b> of a queried <b>MaintPlanClfnClassChar</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintPlanClfnCharValue</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintPlanClfnCharValue> getValueOrFetch()
    {
        if( toValue == null ) {
            toValue = fetchValue();
        }
        return toValue;
    }

    /**
     * Retrieval of associated <b>MaintPlanClfnCharValue</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Value</b>.
     * <p>
     * If the navigation property for an entity <b>MaintPlanClfnClassChar</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Value</b> is already loaded, the result will contain the
     *         <b>MaintPlanClfnCharValue</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintPlanClfnCharValue>> getValueIfPresent()
    {
        return Option.of(toValue);
    }

    /**
     * Overwrites the list of associated <b>MaintPlanClfnCharValue</b> entities for the loaded navigation property
     * <b>to_Value</b>.
     * <p>
     * If the navigation property <b>to_Value</b> of a queried <b>MaintPlanClfnClassChar</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintPlanClfnCharValue</b> entities.
     */
    public void setValue( @Nonnull final List<MaintPlanClfnCharValue> value )
    {
        if( toValue == null ) {
            toValue = Lists.newArrayList();
        }
        toValue.clear();
        toValue.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintPlanClfnCharValue</b> entities. This corresponds to the OData
     * navigation property <b>to_Value</b>.
     * <p>
     * If the navigation property <b>to_Value</b> of a queried <b>MaintPlanClfnClassChar</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintPlanClfnCharValue</b> entities.
     */
    public void addValue( MaintPlanClfnCharValue... entity )
    {
        if( toValue == null ) {
            toValue = Lists.newArrayList();
        }
        toValue.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintPlanClfnClassChar instances.
     *
     */
    public final static class MaintPlanClfnClassCharBuilder
    {

        private MaintPlanClfnClass toMaintPlanClass;
        private List<MaintPlanClfnCharValue> toValue = Lists.newArrayList();

        private MaintPlanClfnClassChar.MaintPlanClfnClassCharBuilder toMaintPlanClass( final MaintPlanClfnClass value )
        {
            toMaintPlanClass = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintPlanClass</b> for <b>MaintPlanClfnClassChar</b> to single
         * <b>MaintPlanClfnClass</b>.
         *
         * @param value
         *            The MaintPlanClfnClass to build this MaintPlanClfnClassChar with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintPlanClfnClassChar.MaintPlanClfnClassCharBuilder maintPlanClass( final MaintPlanClfnClass value )
        {
            return toMaintPlanClass(value);
        }

        private MaintPlanClfnClassChar.MaintPlanClfnClassCharBuilder toValue( final List<MaintPlanClfnCharValue> value )
        {
            toValue.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Value</b> for <b>MaintPlanClfnClassChar</b> to multiple
         * <b>MaintPlanClfnCharValue</b>.
         *
         * @param value
         *            The MaintPlanClfnCharValues to build this MaintPlanClfnClassChar with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintPlanClfnClassChar.MaintPlanClfnClassCharBuilder value( MaintPlanClfnCharValue... value )
        {
            return toValue(Lists.newArrayList(value));
        }

    }

}
