/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintenanceItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintenanceItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintenanceItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenanceItem extends VdmEntity<MaintenanceItem>
{

    /**
     * Selector for all available fields of MaintenanceItem.
     *
     */
    public final static MaintenanceItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItem</b>
     * </p>
     *
     * @return Maintenance Item
     */
    @Key
    @SerializedName( "MaintenanceItem" )
    @JsonProperty( "MaintenanceItem" )
    @Nullable
    @ODataField( odataName = "MaintenanceItem" )
    private String maintenanceItem;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceItem</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINTENANCE_ITEM =
        new MaintenanceItemField<String>("MaintenanceItem");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItemDescription</b>
     * </p>
     *
     * @return Item Short Text
     */
    @SerializedName( "MaintenanceItemDescription" )
    @JsonProperty( "MaintenanceItemDescription" )
    @Nullable
    @ODataField( odataName = "MaintenanceItemDescription" )
    private String maintenanceItemDescription;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceItemDescription</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINTENANCE_ITEM_DESCRIPTION =
        new MaintenanceItemField<String>("MaintenanceItemDescription");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStrategy</b>
     * </p>
     *
     * @return Maintenance Strategy
     */
    @SerializedName( "MaintenanceStrategy" )
    @JsonProperty( "MaintenanceStrategy" )
    @Nullable
    @ODataField( odataName = "MaintenanceStrategy" )
    private String maintenanceStrategy;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceStrategy</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINTENANCE_STRATEGY =
        new MaintenanceItemField<String>("MaintenanceStrategy");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCategory</b>
     * </p>
     *
     * @return Maintenance plan category
     */
    @SerializedName( "MaintenancePlanCategory" )
    @JsonProperty( "MaintenancePlanCategory" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanCategory" )
    private String maintenancePlanCategory;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanCategory</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINTENANCE_PLAN_CATEGORY =
        new MaintenanceItemField<String>("MaintenancePlanCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCallObject</b>
     * </p>
     *
     * @return Call object for maintenance plan
     */
    @SerializedName( "MaintenancePlanCallObject" )
    @JsonProperty( "MaintenancePlanCallObject" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanCallObject" )
    private String maintenancePlanCallObject;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanCallObject</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINTENANCE_PLAN_CALL_OBJECT =
        new MaintenanceItemField<String>("MaintenancePlanCallObject");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @return Maintenance Plan
     */
    @SerializedName( "MaintenancePlan" )
    @JsonProperty( "MaintenancePlan" )
    @Nullable
    @ODataField( odataName = "MaintenancePlan" )
    private String maintenancePlan;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlan</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINTENANCE_PLAN =
        new MaintenanceItemField<String>("MaintenancePlan");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanItemPosition</b>
     * </p>
     *
     * @return Item in the maintenance plan
     */
    @SerializedName( "MaintenancePlanItemPosition" )
    @JsonProperty( "MaintenancePlanItemPosition" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanItemPosition" )
    private String maintenancePlanItemPosition;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanItemPosition</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINTENANCE_PLAN_ITEM_POSITION =
        new MaintenanceItemField<String>("MaintenancePlanItemPosition");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItemObjectList</b>
     * </p>
     *
     * @return Object list number
     */
    @SerializedName( "MaintenanceItemObjectList" )
    @JsonProperty( "MaintenanceItemObjectList" )
    @Nullable
    @ODataField( odataName = "MaintenanceItemObjectList" )
    private Long maintenanceItemObjectList;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceItemObjectList</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<Long> MAINTENANCE_ITEM_OBJECT_LIST =
        new MaintenanceItemField<Long>("MaintenanceItemObjectList");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @return Functional Location Label
     */
    @SerializedName( "FunctionalLocationLabelName" )
    @JsonProperty( "FunctionalLocationLabelName" )
    @Nullable
    @ODataField( odataName = "FunctionalLocationLabelName" )
    private String functionalLocationLabelName;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocationLabelName</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> FUNCTIONAL_LOCATION_LABEL_NAME =
        new MaintenanceItemField<String>("FunctionalLocationLabelName");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> EQUIPMENT = new MaintenanceItemField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @return Assembly
     */
    @SerializedName( "Assembly" )
    @JsonProperty( "Assembly" )
    @Nullable
    @ODataField( odataName = "Assembly" )
    private String assembly;
    /**
     * Use with available fluent helpers to apply the <b>Assembly</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> ASSEMBLY = new MaintenanceItemField<String>("Assembly");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalDeviceData</b>
     * </p>
     *
     * @return Additional Device Data
     */
    @SerializedName( "AdditionalDeviceData" )
    @JsonProperty( "AdditionalDeviceData" )
    @Nullable
    @ODataField( odataName = "AdditionalDeviceData" )
    private String additionalDeviceData;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalDeviceData</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> ADDITIONAL_DEVICE_DATA =
        new MaintenanceItemField<String>("AdditionalDeviceData");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     *
     * @return Task List Type
     */
    @SerializedName( "TaskListType" )
    @JsonProperty( "TaskListType" )
    @Nullable
    @ODataField( odataName = "TaskListType" )
    private String taskListType;
    /**
     * Use with available fluent helpers to apply the <b>TaskListType</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> TASK_LIST_TYPE = new MaintenanceItemField<String>("TaskListType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     *
     * @return Key for Task List Group
     */
    @SerializedName( "TaskListGroup" )
    @JsonProperty( "TaskListGroup" )
    @Nullable
    @ODataField( odataName = "TaskListGroup" )
    private String taskListGroup;
    /**
     * Use with available fluent helpers to apply the <b>TaskListGroup</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> TASK_LIST_GROUP =
        new MaintenanceItemField<String>("TaskListGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     *
     * @return Group Counter
     */
    @SerializedName( "TaskListGroupCounter" )
    @JsonProperty( "TaskListGroupCounter" )
    @Nullable
    @ODataField( odataName = "TaskListGroupCounter" )
    private String taskListGroupCounter;
    /**
     * Use with available fluent helpers to apply the <b>TaskListGroupCounter</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> TASK_LIST_GROUP_COUNTER =
        new MaintenanceItemField<String>("TaskListGroupCounter");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationSystemCondition</b>
     * </p>
     *
     * @return System Condition
     */
    @SerializedName( "OperationSystemCondition" )
    @JsonProperty( "OperationSystemCondition" )
    @Nullable
    @ODataField( odataName = "OperationSystemCondition" )
    private String operationSystemCondition;
    /**
     * Use with available fluent helpers to apply the <b>OperationSystemCondition</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> OPERATION_SYSTEM_CONDITION =
        new MaintenanceItemField<String>("OperationSystemCondition");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfTaskListExecutions</b>
     * </p>
     *
     * @return Execution factor for whole task list
     */
    @SerializedName( "NumberOfTaskListExecutions" )
    @JsonProperty( "NumberOfTaskListExecutions" )
    @Nullable
    @ODataField( odataName = "NumberOfTaskListExecutions" )
    private BigDecimal numberOfTaskListExecutions;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfTaskListExecutions</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<BigDecimal> NUMBER_OF_TASK_LIST_EXECUTIONS =
        new MaintenanceItemField<BigDecimal>("NumberOfTaskListExecutions");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifTskIsAutomlyDtmnd</b>
     * </p>
     *
     * @return Automatic task determination in the notification
     */
    @SerializedName( "MaintNotifTskIsAutomlyDtmnd" )
    @JsonProperty( "MaintNotifTskIsAutomlyDtmnd" )
    @Nullable
    @ODataField( odataName = "MaintNotifTskIsAutomlyDtmnd" )
    private String maintNotifTskIsAutomlyDtmnd;
    /**
     * Use with available fluent helpers to apply the <b>MaintNotifTskIsAutomlyDtmnd</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINT_NOTIF_TSK_IS_AUTOMLY_DTMND =
        new MaintenanceItemField<String>("MaintNotifTskIsAutomlyDtmnd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanningPlant</b>
     * </p>
     *
     * @return Maintenance Planning Plant
     */
    @SerializedName( "MaintenancePlanningPlant" )
    @JsonProperty( "MaintenancePlanningPlant" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanningPlant" )
    private String maintenancePlanningPlant;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanningPlant</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINTENANCE_PLANNING_PLANT =
        new MaintenanceItemField<String>("MaintenancePlanningPlant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlannerGroup</b>
     * </p>
     *
     * @return Planner Group for Customer Service and Plant Maintenance
     */
    @SerializedName( "MaintenancePlannerGroup" )
    @JsonProperty( "MaintenancePlannerGroup" )
    @Nullable
    @ODataField( odataName = "MaintenancePlannerGroup" )
    private String maintenancePlannerGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlannerGroup</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINTENANCE_PLANNER_GROUP =
        new MaintenanceItemField<String>("MaintenancePlannerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderType</b>
     * </p>
     *
     * @return Order Type
     */
    @SerializedName( "MaintenanceOrderType" )
    @JsonProperty( "MaintenanceOrderType" )
    @Nullable
    @ODataField( odataName = "MaintenanceOrderType" )
    private String maintenanceOrderType;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceOrderType</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINTENANCE_ORDER_TYPE =
        new MaintenanceItemField<String>("MaintenanceOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>NotificationType</b>
     * </p>
     *
     * @return Notification Type
     */
    @SerializedName( "NotificationType" )
    @JsonProperty( "NotificationType" )
    @Nullable
    @ODataField( odataName = "NotificationType" )
    private String notificationType;
    /**
     * Use with available fluent helpers to apply the <b>NotificationType</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> NOTIFICATION_TYPE =
        new MaintenanceItemField<String>("NotificationType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceActivityType</b>
     * </p>
     *
     * @return Maintenance activity type
     */
    @SerializedName( "MaintenanceActivityType" )
    @JsonProperty( "MaintenanceActivityType" )
    @Nullable
    @ODataField( odataName = "MaintenanceActivityType" )
    private String maintenanceActivityType;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceActivityType</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINTENANCE_ACTIVITY_TYPE =
        new MaintenanceItemField<String>("MaintenanceActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "MainWorkCenter" )
    @JsonProperty( "MainWorkCenter" )
    @Nullable
    @ODataField( odataName = "MainWorkCenter" )
    private String mainWorkCenter;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenter</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAIN_WORK_CENTER =
        new MaintenanceItemField<String>("MainWorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterPlant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "MainWorkCenterPlant" )
    @JsonProperty( "MainWorkCenterPlant" )
    @Nullable
    @ODataField( odataName = "MainWorkCenterPlant" )
    private String mainWorkCenterPlant;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenterPlant</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAIN_WORK_CENTER_PLANT =
        new MaintenanceItemField<String>("MainWorkCenterPlant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriority</b>
     * </p>
     *
     * @return Priority
     */
    @SerializedName( "MaintPriority" )
    @JsonProperty( "MaintPriority" )
    @Nullable
    @ODataField( odataName = "MaintPriority" )
    private String maintPriority;
    /**
     * Use with available fluent helpers to apply the <b>MaintPriority</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINT_PRIORITY = new MaintenanceItemField<String>("MaintPriority");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriorityType</b>
     * </p>
     *
     * @return Priority Type
     */
    @SerializedName( "MaintPriorityType" )
    @JsonProperty( "MaintPriorityType" )
    @Nullable
    @ODataField( odataName = "MaintPriorityType" )
    private String maintPriorityType;
    /**
     * Use with available fluent helpers to apply the <b>MaintPriorityType</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINT_PRIORITY_TYPE =
        new MaintenanceItemField<String>("MaintPriorityType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> BUSINESS_AREA = new MaintenanceItemField<String>("BusinessArea");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ImmediateReleaseIsBlocked</b>
     * </p>
     *
     * @return Do Not Release Immediately
     */
    @SerializedName( "ImmediateReleaseIsBlocked" )
    @JsonProperty( "ImmediateReleaseIsBlocked" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ImmediateReleaseIsBlocked" )
    private Boolean immediateReleaseIsBlocked;
    /**
     * Use with available fluent helpers to apply the <b>ImmediateReleaseIsBlocked</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<Boolean> IMMEDIATE_RELEASE_IS_BLOCKED =
        new MaintenanceItemField<Boolean>("ImmediateReleaseIsBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MATERIAL = new MaintenanceItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @return Serial Number
     */
    @SerializedName( "SerialNumber" )
    @JsonProperty( "SerialNumber" )
    @Nullable
    @ODataField( odataName = "SerialNumber" )
    private String serialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumber</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> SERIAL_NUMBER = new MaintenanceItemField<String>("SerialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentType</b>
     * </p>
     *
     * @return Business Transaction Type
     */
    @SerializedName( "ServiceDocumentType" )
    @JsonProperty( "ServiceDocumentType" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentType" )
    private String serviceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentType</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> SERVICE_DOCUMENT_TYPE =
        new MaintenanceItemField<String>("ServiceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ServiceContract" )
    @JsonProperty( "ServiceContract" )
    @Nullable
    @ODataField( odataName = "ServiceContract" )
    private String serviceContract;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContract</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> SERVICE_CONTRACT =
        new MaintenanceItemField<String>("ServiceContract");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "ServiceContractItem" )
    @JsonProperty( "ServiceContractItem" )
    @Nullable
    @ODataField( odataName = "ServiceContractItem" )
    private String serviceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractItem</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> SERVICE_CONTRACT_ITEM =
        new MaintenanceItemField<String>("ServiceContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplate</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ServiceOrderTemplate" )
    @JsonProperty( "ServiceOrderTemplate" )
    @Nullable
    @ODataField( odataName = "ServiceOrderTemplate" )
    private String serviceOrderTemplate;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderTemplate</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> SERVICE_ORDER_TEMPLATE =
        new MaintenanceItemField<String>("ServiceOrderTemplate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentPriority</b>
     * </p>
     *
     * @return Activity Priority
     */
    @SerializedName( "ServiceDocumentPriority" )
    @JsonProperty( "ServiceDocumentPriority" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentPriority" )
    private String serviceDocumentPriority;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentPriority</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> SERVICE_DOCUMENT_PRIORITY =
        new MaintenanceItemField<String>("ServiceDocumentPriority");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> PRODUCT = new MaintenanceItemField<String>("Product");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintCmplncCalculationMethod</b>
     * </p>
     *
     * @return Maintenance Compliance Calculation Method
     */
    @SerializedName( "MaintCmplncCalculationMethod" )
    @JsonProperty( "MaintCmplncCalculationMethod" )
    @Nullable
    @ODataField( odataName = "MaintCmplncCalculationMethod" )
    private String maintCmplncCalculationMethod;
    /**
     * Use with available fluent helpers to apply the <b>MaintCmplncCalculationMethod</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINT_CMPLNC_CALCULATION_METHOD =
        new MaintenanceItemField<String>("MaintCmplncCalculationMethod");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintCmplncStrtDteOffsetInDays</b>
     * </p>
     *
     * @return Maintenance Compliance Start Date Offset In Days
     */
    @SerializedName( "MaintCmplncStrtDteOffsetInDays" )
    @JsonProperty( "MaintCmplncStrtDteOffsetInDays" )
    @Nullable
    @ODataField( odataName = "MaintCmplncStrtDteOffsetInDays" )
    private String maintCmplncStrtDteOffsetInDays;
    /**
     * Use with available fluent helpers to apply the <b>MaintCmplncStrtDteOffsetInDays</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINT_CMPLNC_STRT_DTE_OFFSET_IN_DAYS =
        new MaintenanceItemField<String>("MaintCmplncStrtDteOffsetInDays");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintCmplncEndDateOffsetInDays</b>
     * </p>
     *
     * @return Maintenance Compliance End Date Offset In Days
     */
    @SerializedName( "MaintCmplncEndDateOffsetInDays" )
    @JsonProperty( "MaintCmplncEndDateOffsetInDays" )
    @Nullable
    @ODataField( odataName = "MaintCmplncEndDateOffsetInDays" )
    private String maintCmplncEndDateOffsetInDays;
    /**
     * Use with available fluent helpers to apply the <b>MaintCmplncEndDateOffsetInDays</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINT_CMPLNC_END_DATE_OFFSET_IN_DAYS =
        new MaintenanceItemField<String>("MaintCmplncEndDateOffsetInDays");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlant</b>
     * </p>
     *
     * @return Maintenance Plant
     */
    @SerializedName( "MaintenancePlant" )
    @JsonProperty( "MaintenancePlant" )
    @Nullable
    @ODataField( odataName = "MaintenancePlant" )
    private String maintenancePlant;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlant</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINTENANCE_PLANT =
        new MaintenanceItemField<String>("MaintenancePlant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AssetLocation</b>
     * </p>
     *
     * @return Location of maintenance object
     */
    @SerializedName( "AssetLocation" )
    @JsonProperty( "AssetLocation" )
    @Nullable
    @ODataField( odataName = "AssetLocation" )
    private String assetLocation;
    /**
     * Use with available fluent helpers to apply the <b>AssetLocation</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> ASSET_LOCATION = new MaintenanceItemField<String>("AssetLocation");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>AssetRoom</b>
     * </p>
     *
     * @return Room
     */
    @SerializedName( "AssetRoom" )
    @JsonProperty( "AssetRoom" )
    @Nullable
    @ODataField( odataName = "AssetRoom" )
    private String assetRoom;
    /**
     * Use with available fluent helpers to apply the <b>AssetRoom</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> ASSET_ROOM = new MaintenanceItemField<String>("AssetRoom");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantSection</b>
     * </p>
     *
     * @return Plant Section
     */
    @SerializedName( "PlantSection" )
    @JsonProperty( "PlantSection" )
    @Nullable
    @ODataField( odataName = "PlantSection" )
    private String plantSection;
    /**
     * Use with available fluent helpers to apply the <b>PlantSection</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> PLANT_SECTION = new MaintenanceItemField<String>("PlantSection");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> WORK_CENTER = new MaintenanceItemField<String>("WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicator</b>
     * </p>
     *
     * @return ABC Indicator for Technical Object
     */
    @SerializedName( "ABCIndicator" )
    @JsonProperty( "ABCIndicator" )
    @Nullable
    @ODataField( odataName = "ABCIndicator" )
    private String aBCIndicator;
    /**
     * Use with available fluent helpers to apply the <b>ABCIndicator</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> ABC_INDICATOR = new MaintenanceItemField<String>("ABCIndicator");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectFreeDefinedAttrib</b>
     * </p>
     *
     * @return Sort Field
     */
    @SerializedName( "MaintObjectFreeDefinedAttrib" )
    @JsonProperty( "MaintObjectFreeDefinedAttrib" )
    @Nullable
    @ODataField( odataName = "MaintObjectFreeDefinedAttrib" )
    private String maintObjectFreeDefinedAttrib;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjectFreeDefinedAttrib</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MAINT_OBJECT_FREE_DEFINED_ATTRIB =
        new MaintenanceItemField<String>("MaintObjectFreeDefinedAttrib");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> COMPANY_CODE = new MaintenanceItemField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @return Main Asset Number
     */
    @SerializedName( "MasterFixedAsset" )
    @JsonProperty( "MasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset" )
    private String masterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> MASTER_FIXED_ASSET =
        new MaintenanceItemField<String>("MasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "FixedAsset" )
    @JsonProperty( "FixedAsset" )
    @Nullable
    @ODataField( odataName = "FixedAsset" )
    private String fixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>FixedAsset</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> FIXED_ASSET = new MaintenanceItemField<String>("FixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LocAcctAssgmtBusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "LocAcctAssgmtBusinessArea" )
    @JsonProperty( "LocAcctAssgmtBusinessArea" )
    @Nullable
    @ODataField( odataName = "LocAcctAssgmtBusinessArea" )
    private String locAcctAssgmtBusinessArea;
    /**
     * Use with available fluent helpers to apply the <b>LocAcctAssgmtBusinessArea</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> LOC_ACCT_ASSGMT_BUSINESS_AREA =
        new MaintenanceItemField<String>("LocAcctAssgmtBusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> COST_CENTER = new MaintenanceItemField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> CONTROLLING_AREA =
        new MaintenanceItemField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> WBS_ELEMENT = new MaintenanceItemField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SettlementOrder</b>
     * </p>
     *
     * @return Settlement order
     */
    @SerializedName( "SettlementOrder" )
    @JsonProperty( "SettlementOrder" )
    @Nullable
    @ODataField( odataName = "SettlementOrder" )
    private String settlementOrder;
    /**
     * Use with available fluent helpers to apply the <b>SettlementOrder</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> SETTLEMENT_ORDER =
        new MaintenanceItemField<String>("SettlementOrder");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CycleSetSequence</b>
     * </p>
     *
     * @return Cycle Set Sequence
     */
    @SerializedName( "CycleSetSequence" )
    @JsonProperty( "CycleSetSequence" )
    @Nullable
    @ODataField( odataName = "CycleSetSequence" )
    private String cycleSetSequence;
    /**
     * Use with available fluent helpers to apply the <b>CycleSetSequence</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> CYCLE_SET_SEQUENCE =
        new MaintenanceItemField<String>("CycleSetSequence");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>StandingOrderNumber</b>
     * </p>
     *
     * @return Standing order number
     */
    @SerializedName( "StandingOrderNumber" )
    @JsonProperty( "StandingOrderNumber" )
    @Nullable
    @ODataField( odataName = "StandingOrderNumber" )
    private String standingOrderNumber;
    /**
     * Use with available fluent helpers to apply the <b>StandingOrderNumber</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> STANDING_ORDER_NUMBER =
        new MaintenanceItemField<String>("StandingOrderNumber");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> CREATED_BY_USER =
        new MaintenanceItemField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date of creation
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<LocalDateTime> CREATION_DATE =
        new MaintenanceItemField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<LocalDateTime> LAST_CHANGE_DATE =
        new MaintenanceItemField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<String> LAST_CHANGED_BY_USER =
        new MaintenanceItemField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static MaintenanceItemField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new MaintenanceItemField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_LongText</b> for <b>MaintenanceItem</b> to multiple <b>MaintenanceItemText</b>.
     *
     */
    @SerializedName( "to_LongText" )
    @JsonProperty( "to_LongText" )
    @ODataField( odataName = "to_LongText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceItemText> toLongText;
    /**
     * Navigation property <b>to_MaintenanceItemCause</b> for <b>MaintenanceItem</b> to multiple
     * <b>MaintenanceItemCause</b>.
     *
     */
    @SerializedName( "to_MaintenanceItemCause" )
    @JsonProperty( "to_MaintenanceItemCause" )
    @ODataField( odataName = "to_MaintenanceItemCause" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceItemCause> toMaintenanceItemCause;
    /**
     * Navigation property <b>to_MaintenanceItemReason</b> for <b>MaintenanceItem</b> to multiple
     * <b>MaintenanceItemReason</b>.
     *
     */
    @SerializedName( "to_MaintenanceItemReason" )
    @JsonProperty( "to_MaintenanceItemReason" )
    @ODataField( odataName = "to_MaintenanceItemReason" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceItemReason> toMaintenanceItemReason;
    /**
     * Navigation property <b>to_MaintItemObjectListItem</b> for <b>MaintenanceItem</b> to multiple
     * <b>MaintItemObjectListItem</b>.
     *
     */
    @SerializedName( "to_MaintItemObjectListItem" )
    @JsonProperty( "to_MaintItemObjectListItem" )
    @ODataField( odataName = "to_MaintItemObjectListItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintItemObjectListItem> toMaintItemObjectListItem;
    /**
     * Navigation property <b>to_MaintPlanCallObjects</b> for <b>MaintenanceItem</b> to multiple
     * <b>MaintenancePlanCallObject</b>.
     *
     */
    @SerializedName( "to_MaintPlanCallObjects" )
    @JsonProperty( "to_MaintPlanCallObjects" )
    @ODataField( odataName = "to_MaintPlanCallObjects" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenancePlanCallObject> toMaintPlanCallObjects;
    /**
     * Use with available fluent helpers to apply the <b>to_LongText</b> navigation property to query operations.
     *
     */
    public final static MaintenanceItemLink<MaintenanceItemText> TO_LONG_TEXT =
        new MaintenanceItemLink<MaintenanceItemText>("to_LongText");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceItemCause</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceItemLink<MaintenanceItemCause> TO_MAINTENANCE_ITEM_CAUSE =
        new MaintenanceItemLink<MaintenanceItemCause>("to_MaintenanceItemCause");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceItemReason</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceItemLink<MaintenanceItemReason> TO_MAINTENANCE_ITEM_REASON =
        new MaintenanceItemLink<MaintenanceItemReason>("to_MaintenanceItemReason");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintItemObjectListItem</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceItemLink<MaintItemObjectListItem> TO_MAINT_ITEM_OBJECT_LIST_ITEM =
        new MaintenanceItemLink<MaintItemObjectListItem>("to_MaintItemObjectListItem");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintPlanCallObjects</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceItemLink<MaintenancePlanCallObject> TO_MAINT_PLAN_CALL_OBJECTS =
        new MaintenanceItemLink<MaintenancePlanCallObject>("to_MaintPlanCallObjects");

    @Nonnull
    @Override
    public Class<MaintenanceItem> getType()
    {
        return MaintenanceItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItem</b>
     * </p>
     *
     * @param maintenanceItem
     *            Maintenance Item
     */
    public void setMaintenanceItem( @Nullable final String maintenanceItem )
    {
        rememberChangedField("MaintenanceItem", this.maintenanceItem);
        this.maintenanceItem = maintenanceItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItemDescription</b>
     * </p>
     *
     * @param maintenanceItemDescription
     *            Item Short Text
     */
    public void setMaintenanceItemDescription( @Nullable final String maintenanceItemDescription )
    {
        rememberChangedField("MaintenanceItemDescription", this.maintenanceItemDescription);
        this.maintenanceItemDescription = maintenanceItemDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStrategy</b>
     * </p>
     *
     * @param maintenanceStrategy
     *            Maintenance Strategy
     */
    public void setMaintenanceStrategy( @Nullable final String maintenanceStrategy )
    {
        rememberChangedField("MaintenanceStrategy", this.maintenanceStrategy);
        this.maintenanceStrategy = maintenanceStrategy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCategory</b>
     * </p>
     *
     * @param maintenancePlanCategory
     *            Maintenance plan category
     */
    public void setMaintenancePlanCategory( @Nullable final String maintenancePlanCategory )
    {
        rememberChangedField("MaintenancePlanCategory", this.maintenancePlanCategory);
        this.maintenancePlanCategory = maintenancePlanCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCallObject</b>
     * </p>
     *
     * @param maintenancePlanCallObject
     *            Call object for maintenance plan
     */
    public void setMaintenancePlanCallObject( @Nullable final String maintenancePlanCallObject )
    {
        rememberChangedField("MaintenancePlanCallObject", this.maintenancePlanCallObject);
        this.maintenancePlanCallObject = maintenancePlanCallObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     */
    public void setMaintenancePlan( @Nullable final String maintenancePlan )
    {
        rememberChangedField("MaintenancePlan", this.maintenancePlan);
        this.maintenancePlan = maintenancePlan;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanItemPosition</b>
     * </p>
     *
     * @param maintenancePlanItemPosition
     *            Item in the maintenance plan
     */
    public void setMaintenancePlanItemPosition( @Nullable final String maintenancePlanItemPosition )
    {
        rememberChangedField("MaintenancePlanItemPosition", this.maintenancePlanItemPosition);
        this.maintenancePlanItemPosition = maintenancePlanItemPosition;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItemObjectList</b>
     * </p>
     *
     * @param maintenanceItemObjectList
     *            Object list number
     */
    public void setMaintenanceItemObjectList( @Nullable final Long maintenanceItemObjectList )
    {
        rememberChangedField("MaintenanceItemObjectList", this.maintenanceItemObjectList);
        this.maintenanceItemObjectList = maintenanceItemObjectList;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @param functionalLocationLabelName
     *            Functional Location Label
     */
    public void setFunctionalLocationLabelName( @Nullable final String functionalLocationLabelName )
    {
        rememberChangedField("FunctionalLocationLabelName", this.functionalLocationLabelName);
        this.functionalLocationLabelName = functionalLocationLabelName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Assembly</b>
     * </p>
     *
     * @param assembly
     *            Assembly
     */
    public void setAssembly( @Nullable final String assembly )
    {
        rememberChangedField("Assembly", this.assembly);
        this.assembly = assembly;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalDeviceData</b>
     * </p>
     *
     * @param additionalDeviceData
     *            Additional Device Data
     */
    public void setAdditionalDeviceData( @Nullable final String additionalDeviceData )
    {
        rememberChangedField("AdditionalDeviceData", this.additionalDeviceData);
        this.additionalDeviceData = additionalDeviceData;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TaskListType</b>
     * </p>
     *
     * @param taskListType
     *            Task List Type
     */
    public void setTaskListType( @Nullable final String taskListType )
    {
        rememberChangedField("TaskListType", this.taskListType);
        this.taskListType = taskListType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroup</b>
     * </p>
     *
     * @param taskListGroup
     *            Key for Task List Group
     */
    public void setTaskListGroup( @Nullable final String taskListGroup )
    {
        rememberChangedField("TaskListGroup", this.taskListGroup);
        this.taskListGroup = taskListGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaskListGroupCounter</b>
     * </p>
     *
     * @param taskListGroupCounter
     *            Group Counter
     */
    public void setTaskListGroupCounter( @Nullable final String taskListGroupCounter )
    {
        rememberChangedField("TaskListGroupCounter", this.taskListGroupCounter);
        this.taskListGroupCounter = taskListGroupCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OperationSystemCondition</b>
     * </p>
     *
     * @param operationSystemCondition
     *            System Condition
     */
    public void setOperationSystemCondition( @Nullable final String operationSystemCondition )
    {
        rememberChangedField("OperationSystemCondition", this.operationSystemCondition);
        this.operationSystemCondition = operationSystemCondition;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfTaskListExecutions</b>
     * </p>
     *
     * @param numberOfTaskListExecutions
     *            Execution factor for whole task list
     */
    public void setNumberOfTaskListExecutions( @Nullable final BigDecimal numberOfTaskListExecutions )
    {
        rememberChangedField("NumberOfTaskListExecutions", this.numberOfTaskListExecutions);
        this.numberOfTaskListExecutions = numberOfTaskListExecutions;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifTskIsAutomlyDtmnd</b>
     * </p>
     *
     * @param maintNotifTskIsAutomlyDtmnd
     *            Automatic task determination in the notification
     */
    public void setMaintNotifTskIsAutomlyDtmnd( @Nullable final String maintNotifTskIsAutomlyDtmnd )
    {
        rememberChangedField("MaintNotifTskIsAutomlyDtmnd", this.maintNotifTskIsAutomlyDtmnd);
        this.maintNotifTskIsAutomlyDtmnd = maintNotifTskIsAutomlyDtmnd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanningPlant</b>
     * </p>
     *
     * @param maintenancePlanningPlant
     *            Maintenance Planning Plant
     */
    public void setMaintenancePlanningPlant( @Nullable final String maintenancePlanningPlant )
    {
        rememberChangedField("MaintenancePlanningPlant", this.maintenancePlanningPlant);
        this.maintenancePlanningPlant = maintenancePlanningPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlannerGroup</b>
     * </p>
     *
     * @param maintenancePlannerGroup
     *            Planner Group for Customer Service and Plant Maintenance
     */
    public void setMaintenancePlannerGroup( @Nullable final String maintenancePlannerGroup )
    {
        rememberChangedField("MaintenancePlannerGroup", this.maintenancePlannerGroup);
        this.maintenancePlannerGroup = maintenancePlannerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrderType</b>
     * </p>
     *
     * @param maintenanceOrderType
     *            Order Type
     */
    public void setMaintenanceOrderType( @Nullable final String maintenanceOrderType )
    {
        rememberChangedField("MaintenanceOrderType", this.maintenanceOrderType);
        this.maintenanceOrderType = maintenanceOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>NotificationType</b>
     * </p>
     *
     * @param notificationType
     *            Notification Type
     */
    public void setNotificationType( @Nullable final String notificationType )
    {
        rememberChangedField("NotificationType", this.notificationType);
        this.notificationType = notificationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceActivityType</b>
     * </p>
     *
     * @param maintenanceActivityType
     *            Maintenance activity type
     */
    public void setMaintenanceActivityType( @Nullable final String maintenanceActivityType )
    {
        rememberChangedField("MaintenanceActivityType", this.maintenanceActivityType);
        this.maintenanceActivityType = maintenanceActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenter</b>
     * </p>
     *
     * @param mainWorkCenter
     *            Work Center
     */
    public void setMainWorkCenter( @Nullable final String mainWorkCenter )
    {
        rememberChangedField("MainWorkCenter", this.mainWorkCenter);
        this.mainWorkCenter = mainWorkCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterPlant</b>
     * </p>
     *
     * @param mainWorkCenterPlant
     *            Plant
     */
    public void setMainWorkCenterPlant( @Nullable final String mainWorkCenterPlant )
    {
        rememberChangedField("MainWorkCenterPlant", this.mainWorkCenterPlant);
        this.mainWorkCenterPlant = mainWorkCenterPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriority</b>
     * </p>
     *
     * @param maintPriority
     *            Priority
     */
    public void setMaintPriority( @Nullable final String maintPriority )
    {
        rememberChangedField("MaintPriority", this.maintPriority);
        this.maintPriority = maintPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintPriorityType</b>
     * </p>
     *
     * @param maintPriorityType
     *            Priority Type
     */
    public void setMaintPriorityType( @Nullable final String maintPriorityType )
    {
        rememberChangedField("MaintPriorityType", this.maintPriorityType);
        this.maintPriorityType = maintPriorityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ImmediateReleaseIsBlocked</b>
     * </p>
     *
     * @param immediateReleaseIsBlocked
     *            Do Not Release Immediately
     */
    public void setImmediateReleaseIsBlocked( @Nullable final Boolean immediateReleaseIsBlocked )
    {
        rememberChangedField("ImmediateReleaseIsBlocked", this.immediateReleaseIsBlocked);
        this.immediateReleaseIsBlocked = immediateReleaseIsBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @param serialNumber
     *            Serial Number
     */
    public void setSerialNumber( @Nullable final String serialNumber )
    {
        rememberChangedField("SerialNumber", this.serialNumber);
        this.serialNumber = serialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentType</b>
     * </p>
     *
     * @param serviceDocumentType
     *            Business Transaction Type
     */
    public void setServiceDocumentType( @Nullable final String serviceDocumentType )
    {
        rememberChangedField("ServiceDocumentType", this.serviceDocumentType);
        this.serviceDocumentType = serviceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @param serviceContract
     *            Transaction ID
     */
    public void setServiceContract( @Nullable final String serviceContract )
    {
        rememberChangedField("ServiceContract", this.serviceContract);
        this.serviceContract = serviceContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItem</b>
     * </p>
     *
     * @param serviceContractItem
     *            Shortened Item Number in Document
     */
    public void setServiceContractItem( @Nullable final String serviceContractItem )
    {
        rememberChangedField("ServiceContractItem", this.serviceContractItem);
        this.serviceContractItem = serviceContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderTemplate</b>
     * </p>
     *
     * @param serviceOrderTemplate
     *            Transaction ID
     */
    public void setServiceOrderTemplate( @Nullable final String serviceOrderTemplate )
    {
        rememberChangedField("ServiceOrderTemplate", this.serviceOrderTemplate);
        this.serviceOrderTemplate = serviceOrderTemplate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentPriority</b>
     * </p>
     *
     * @param serviceDocumentPriority
     *            Activity Priority
     */
    public void setServiceDocumentPriority( @Nullable final String serviceDocumentPriority )
    {
        rememberChangedField("ServiceDocumentPriority", this.serviceDocumentPriority);
        this.serviceDocumentPriority = serviceDocumentPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintCmplncCalculationMethod</b>
     * </p>
     *
     * @param maintCmplncCalculationMethod
     *            Maintenance Compliance Calculation Method
     */
    public void setMaintCmplncCalculationMethod( @Nullable final String maintCmplncCalculationMethod )
    {
        rememberChangedField("MaintCmplncCalculationMethod", this.maintCmplncCalculationMethod);
        this.maintCmplncCalculationMethod = maintCmplncCalculationMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintCmplncStrtDteOffsetInDays</b>
     * </p>
     *
     * @param maintCmplncStrtDteOffsetInDays
     *            Maintenance Compliance Start Date Offset In Days
     */
    public void setMaintCmplncStrtDteOffsetInDays( @Nullable final String maintCmplncStrtDteOffsetInDays )
    {
        rememberChangedField("MaintCmplncStrtDteOffsetInDays", this.maintCmplncStrtDteOffsetInDays);
        this.maintCmplncStrtDteOffsetInDays = maintCmplncStrtDteOffsetInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintCmplncEndDateOffsetInDays</b>
     * </p>
     *
     * @param maintCmplncEndDateOffsetInDays
     *            Maintenance Compliance End Date Offset In Days
     */
    public void setMaintCmplncEndDateOffsetInDays( @Nullable final String maintCmplncEndDateOffsetInDays )
    {
        rememberChangedField("MaintCmplncEndDateOffsetInDays", this.maintCmplncEndDateOffsetInDays);
        this.maintCmplncEndDateOffsetInDays = maintCmplncEndDateOffsetInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlant</b>
     * </p>
     *
     * @param maintenancePlant
     *            Maintenance Plant
     */
    public void setMaintenancePlant( @Nullable final String maintenancePlant )
    {
        rememberChangedField("MaintenancePlant", this.maintenancePlant);
        this.maintenancePlant = maintenancePlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AssetLocation</b>
     * </p>
     *
     * @param assetLocation
     *            Location of maintenance object
     */
    public void setAssetLocation( @Nullable final String assetLocation )
    {
        rememberChangedField("AssetLocation", this.assetLocation);
        this.assetLocation = assetLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>AssetRoom</b>
     * </p>
     *
     * @param assetRoom
     *            Room
     */
    public void setAssetRoom( @Nullable final String assetRoom )
    {
        rememberChangedField("AssetRoom", this.assetRoom);
        this.assetRoom = assetRoom;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantSection</b>
     * </p>
     *
     * @param plantSection
     *            Plant Section
     */
    public void setPlantSection( @Nullable final String plantSection )
    {
        rememberChangedField("PlantSection", this.plantSection);
        this.plantSection = plantSection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicator</b>
     * </p>
     *
     * @param aBCIndicator
     *            ABC Indicator for Technical Object
     */
    public void setABCIndicator( @Nullable final String aBCIndicator )
    {
        rememberChangedField("ABCIndicator", this.aBCIndicator);
        this.aBCIndicator = aBCIndicator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectFreeDefinedAttrib</b>
     * </p>
     *
     * @param maintObjectFreeDefinedAttrib
     *            Sort Field
     */
    public void setMaintObjectFreeDefinedAttrib( @Nullable final String maintObjectFreeDefinedAttrib )
    {
        rememberChangedField("MaintObjectFreeDefinedAttrib", this.maintObjectFreeDefinedAttrib);
        this.maintObjectFreeDefinedAttrib = maintObjectFreeDefinedAttrib;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @param masterFixedAsset
     *            Main Asset Number
     */
    public void setMasterFixedAsset( @Nullable final String masterFixedAsset )
    {
        rememberChangedField("MasterFixedAsset", this.masterFixedAsset);
        this.masterFixedAsset = masterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @param fixedAsset
     *            Asset Subnumber
     */
    public void setFixedAsset( @Nullable final String fixedAsset )
    {
        rememberChangedField("FixedAsset", this.fixedAsset);
        this.fixedAsset = fixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LocAcctAssgmtBusinessArea</b>
     * </p>
     *
     * @param locAcctAssgmtBusinessArea
     *            Business Area
     */
    public void setLocAcctAssgmtBusinessArea( @Nullable final String locAcctAssgmtBusinessArea )
    {
        rememberChangedField("LocAcctAssgmtBusinessArea", this.locAcctAssgmtBusinessArea);
        this.locAcctAssgmtBusinessArea = locAcctAssgmtBusinessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SettlementOrder</b>
     * </p>
     *
     * @param settlementOrder
     *            Settlement order
     */
    public void setSettlementOrder( @Nullable final String settlementOrder )
    {
        rememberChangedField("SettlementOrder", this.settlementOrder);
        this.settlementOrder = settlementOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CycleSetSequence</b>
     * </p>
     *
     * @param cycleSetSequence
     *            Cycle Set Sequence
     */
    public void setCycleSetSequence( @Nullable final String cycleSetSequence )
    {
        rememberChangedField("CycleSetSequence", this.cycleSetSequence);
        this.cycleSetSequence = cycleSetSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>StandingOrderNumber</b>
     * </p>
     *
     * @param standingOrderNumber
     *            Standing order number
     */
    public void setStandingOrderNumber( @Nullable final String standingOrderNumber )
    {
        rememberChangedField("StandingOrderNumber", this.standingOrderNumber);
        this.standingOrderNumber = standingOrderNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date of creation
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenanceItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceItem", getMaintenanceItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceItem", getMaintenanceItem());
        values.put("MaintenanceItemDescription", getMaintenanceItemDescription());
        values.put("MaintenanceStrategy", getMaintenanceStrategy());
        values.put("MaintenancePlanCategory", getMaintenancePlanCategory());
        values.put("MaintenancePlanCallObject", getMaintenancePlanCallObject());
        values.put("MaintenancePlan", getMaintenancePlan());
        values.put("MaintenancePlanItemPosition", getMaintenancePlanItemPosition());
        values.put("MaintenanceItemObjectList", getMaintenanceItemObjectList());
        values.put("FunctionalLocationLabelName", getFunctionalLocationLabelName());
        values.put("Equipment", getEquipment());
        values.put("Assembly", getAssembly());
        values.put("AdditionalDeviceData", getAdditionalDeviceData());
        values.put("TaskListType", getTaskListType());
        values.put("TaskListGroup", getTaskListGroup());
        values.put("TaskListGroupCounter", getTaskListGroupCounter());
        values.put("OperationSystemCondition", getOperationSystemCondition());
        values.put("NumberOfTaskListExecutions", getNumberOfTaskListExecutions());
        values.put("MaintNotifTskIsAutomlyDtmnd", getMaintNotifTskIsAutomlyDtmnd());
        values.put("MaintenancePlanningPlant", getMaintenancePlanningPlant());
        values.put("MaintenancePlannerGroup", getMaintenancePlannerGroup());
        values.put("MaintenanceOrderType", getMaintenanceOrderType());
        values.put("NotificationType", getNotificationType());
        values.put("MaintenanceActivityType", getMaintenanceActivityType());
        values.put("MainWorkCenter", getMainWorkCenter());
        values.put("MainWorkCenterPlant", getMainWorkCenterPlant());
        values.put("MaintPriority", getMaintPriority());
        values.put("MaintPriorityType", getMaintPriorityType());
        values.put("BusinessArea", getBusinessArea());
        values.put("ImmediateReleaseIsBlocked", getImmediateReleaseIsBlocked());
        values.put("Material", getMaterial());
        values.put("SerialNumber", getSerialNumber());
        values.put("ServiceDocumentType", getServiceDocumentType());
        values.put("ServiceContract", getServiceContract());
        values.put("ServiceContractItem", getServiceContractItem());
        values.put("ServiceOrderTemplate", getServiceOrderTemplate());
        values.put("ServiceDocumentPriority", getServiceDocumentPriority());
        values.put("Product", getProduct());
        values.put("MaintCmplncCalculationMethod", getMaintCmplncCalculationMethod());
        values.put("MaintCmplncStrtDteOffsetInDays", getMaintCmplncStrtDteOffsetInDays());
        values.put("MaintCmplncEndDateOffsetInDays", getMaintCmplncEndDateOffsetInDays());
        values.put("MaintenancePlant", getMaintenancePlant());
        values.put("AssetLocation", getAssetLocation());
        values.put("AssetRoom", getAssetRoom());
        values.put("PlantSection", getPlantSection());
        values.put("WorkCenter", getWorkCenter());
        values.put("ABCIndicator", getABCIndicator());
        values.put("MaintObjectFreeDefinedAttrib", getMaintObjectFreeDefinedAttrib());
        values.put("CompanyCode", getCompanyCode());
        values.put("MasterFixedAsset", getMasterFixedAsset());
        values.put("FixedAsset", getFixedAsset());
        values.put("LocAcctAssgmtBusinessArea", getLocAcctAssgmtBusinessArea());
        values.put("CostCenter", getCostCenter());
        values.put("ControllingArea", getControllingArea());
        values.put("WBSElement", getWBSElement());
        values.put("SettlementOrder", getSettlementOrder());
        values.put("CycleSetSequence", getCycleSetSequence());
        values.put("StandingOrderNumber", getStandingOrderNumber());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceItem") ) {
                final Object value = values.remove("MaintenanceItem");
                if( (value == null) || (!value.equals(getMaintenanceItem())) ) {
                    setMaintenanceItem(((String) value));
                }
            }
            if( values.containsKey("MaintenanceItemDescription") ) {
                final Object value = values.remove("MaintenanceItemDescription");
                if( (value == null) || (!value.equals(getMaintenanceItemDescription())) ) {
                    setMaintenanceItemDescription(((String) value));
                }
            }
            if( values.containsKey("MaintenanceStrategy") ) {
                final Object value = values.remove("MaintenanceStrategy");
                if( (value == null) || (!value.equals(getMaintenanceStrategy())) ) {
                    setMaintenanceStrategy(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanCategory") ) {
                final Object value = values.remove("MaintenancePlanCategory");
                if( (value == null) || (!value.equals(getMaintenancePlanCategory())) ) {
                    setMaintenancePlanCategory(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanCallObject") ) {
                final Object value = values.remove("MaintenancePlanCallObject");
                if( (value == null) || (!value.equals(getMaintenancePlanCallObject())) ) {
                    setMaintenancePlanCallObject(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlan") ) {
                final Object value = values.remove("MaintenancePlan");
                if( (value == null) || (!value.equals(getMaintenancePlan())) ) {
                    setMaintenancePlan(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanItemPosition") ) {
                final Object value = values.remove("MaintenancePlanItemPosition");
                if( (value == null) || (!value.equals(getMaintenancePlanItemPosition())) ) {
                    setMaintenancePlanItemPosition(((String) value));
                }
            }
            if( values.containsKey("MaintenanceItemObjectList") ) {
                final Object value = values.remove("MaintenanceItemObjectList");
                if( (value == null) || (!value.equals(getMaintenanceItemObjectList())) ) {
                    setMaintenanceItemObjectList(((Long) value));
                }
            }
            if( values.containsKey("FunctionalLocationLabelName") ) {
                final Object value = values.remove("FunctionalLocationLabelName");
                if( (value == null) || (!value.equals(getFunctionalLocationLabelName())) ) {
                    setFunctionalLocationLabelName(((String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("Assembly") ) {
                final Object value = values.remove("Assembly");
                if( (value == null) || (!value.equals(getAssembly())) ) {
                    setAssembly(((String) value));
                }
            }
            if( values.containsKey("AdditionalDeviceData") ) {
                final Object value = values.remove("AdditionalDeviceData");
                if( (value == null) || (!value.equals(getAdditionalDeviceData())) ) {
                    setAdditionalDeviceData(((String) value));
                }
            }
            if( values.containsKey("TaskListType") ) {
                final Object value = values.remove("TaskListType");
                if( (value == null) || (!value.equals(getTaskListType())) ) {
                    setTaskListType(((String) value));
                }
            }
            if( values.containsKey("TaskListGroup") ) {
                final Object value = values.remove("TaskListGroup");
                if( (value == null) || (!value.equals(getTaskListGroup())) ) {
                    setTaskListGroup(((String) value));
                }
            }
            if( values.containsKey("TaskListGroupCounter") ) {
                final Object value = values.remove("TaskListGroupCounter");
                if( (value == null) || (!value.equals(getTaskListGroupCounter())) ) {
                    setTaskListGroupCounter(((String) value));
                }
            }
            if( values.containsKey("OperationSystemCondition") ) {
                final Object value = values.remove("OperationSystemCondition");
                if( (value == null) || (!value.equals(getOperationSystemCondition())) ) {
                    setOperationSystemCondition(((String) value));
                }
            }
            if( values.containsKey("NumberOfTaskListExecutions") ) {
                final Object value = values.remove("NumberOfTaskListExecutions");
                if( (value == null) || (!value.equals(getNumberOfTaskListExecutions())) ) {
                    setNumberOfTaskListExecutions(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaintNotifTskIsAutomlyDtmnd") ) {
                final Object value = values.remove("MaintNotifTskIsAutomlyDtmnd");
                if( (value == null) || (!value.equals(getMaintNotifTskIsAutomlyDtmnd())) ) {
                    setMaintNotifTskIsAutomlyDtmnd(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanningPlant") ) {
                final Object value = values.remove("MaintenancePlanningPlant");
                if( (value == null) || (!value.equals(getMaintenancePlanningPlant())) ) {
                    setMaintenancePlanningPlant(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlannerGroup") ) {
                final Object value = values.remove("MaintenancePlannerGroup");
                if( (value == null) || (!value.equals(getMaintenancePlannerGroup())) ) {
                    setMaintenancePlannerGroup(((String) value));
                }
            }
            if( values.containsKey("MaintenanceOrderType") ) {
                final Object value = values.remove("MaintenanceOrderType");
                if( (value == null) || (!value.equals(getMaintenanceOrderType())) ) {
                    setMaintenanceOrderType(((String) value));
                }
            }
            if( values.containsKey("NotificationType") ) {
                final Object value = values.remove("NotificationType");
                if( (value == null) || (!value.equals(getNotificationType())) ) {
                    setNotificationType(((String) value));
                }
            }
            if( values.containsKey("MaintenanceActivityType") ) {
                final Object value = values.remove("MaintenanceActivityType");
                if( (value == null) || (!value.equals(getMaintenanceActivityType())) ) {
                    setMaintenanceActivityType(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenter") ) {
                final Object value = values.remove("MainWorkCenter");
                if( (value == null) || (!value.equals(getMainWorkCenter())) ) {
                    setMainWorkCenter(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenterPlant") ) {
                final Object value = values.remove("MainWorkCenterPlant");
                if( (value == null) || (!value.equals(getMainWorkCenterPlant())) ) {
                    setMainWorkCenterPlant(((String) value));
                }
            }
            if( values.containsKey("MaintPriority") ) {
                final Object value = values.remove("MaintPriority");
                if( (value == null) || (!value.equals(getMaintPriority())) ) {
                    setMaintPriority(((String) value));
                }
            }
            if( values.containsKey("MaintPriorityType") ) {
                final Object value = values.remove("MaintPriorityType");
                if( (value == null) || (!value.equals(getMaintPriorityType())) ) {
                    setMaintPriorityType(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("ImmediateReleaseIsBlocked") ) {
                final Object value = values.remove("ImmediateReleaseIsBlocked");
                if( (value == null) || (!value.equals(getImmediateReleaseIsBlocked())) ) {
                    setImmediateReleaseIsBlocked(((Boolean) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("SerialNumber") ) {
                final Object value = values.remove("SerialNumber");
                if( (value == null) || (!value.equals(getSerialNumber())) ) {
                    setSerialNumber(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentType") ) {
                final Object value = values.remove("ServiceDocumentType");
                if( (value == null) || (!value.equals(getServiceDocumentType())) ) {
                    setServiceDocumentType(((String) value));
                }
            }
            if( values.containsKey("ServiceContract") ) {
                final Object value = values.remove("ServiceContract");
                if( (value == null) || (!value.equals(getServiceContract())) ) {
                    setServiceContract(((String) value));
                }
            }
            if( values.containsKey("ServiceContractItem") ) {
                final Object value = values.remove("ServiceContractItem");
                if( (value == null) || (!value.equals(getServiceContractItem())) ) {
                    setServiceContractItem(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderTemplate") ) {
                final Object value = values.remove("ServiceOrderTemplate");
                if( (value == null) || (!value.equals(getServiceOrderTemplate())) ) {
                    setServiceOrderTemplate(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentPriority") ) {
                final Object value = values.remove("ServiceDocumentPriority");
                if( (value == null) || (!value.equals(getServiceDocumentPriority())) ) {
                    setServiceDocumentPriority(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("MaintCmplncCalculationMethod") ) {
                final Object value = values.remove("MaintCmplncCalculationMethod");
                if( (value == null) || (!value.equals(getMaintCmplncCalculationMethod())) ) {
                    setMaintCmplncCalculationMethod(((String) value));
                }
            }
            if( values.containsKey("MaintCmplncStrtDteOffsetInDays") ) {
                final Object value = values.remove("MaintCmplncStrtDteOffsetInDays");
                if( (value == null) || (!value.equals(getMaintCmplncStrtDteOffsetInDays())) ) {
                    setMaintCmplncStrtDteOffsetInDays(((String) value));
                }
            }
            if( values.containsKey("MaintCmplncEndDateOffsetInDays") ) {
                final Object value = values.remove("MaintCmplncEndDateOffsetInDays");
                if( (value == null) || (!value.equals(getMaintCmplncEndDateOffsetInDays())) ) {
                    setMaintCmplncEndDateOffsetInDays(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlant") ) {
                final Object value = values.remove("MaintenancePlant");
                if( (value == null) || (!value.equals(getMaintenancePlant())) ) {
                    setMaintenancePlant(((String) value));
                }
            }
            if( values.containsKey("AssetLocation") ) {
                final Object value = values.remove("AssetLocation");
                if( (value == null) || (!value.equals(getAssetLocation())) ) {
                    setAssetLocation(((String) value));
                }
            }
            if( values.containsKey("AssetRoom") ) {
                final Object value = values.remove("AssetRoom");
                if( (value == null) || (!value.equals(getAssetRoom())) ) {
                    setAssetRoom(((String) value));
                }
            }
            if( values.containsKey("PlantSection") ) {
                final Object value = values.remove("PlantSection");
                if( (value == null) || (!value.equals(getPlantSection())) ) {
                    setPlantSection(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("ABCIndicator") ) {
                final Object value = values.remove("ABCIndicator");
                if( (value == null) || (!value.equals(getABCIndicator())) ) {
                    setABCIndicator(((String) value));
                }
            }
            if( values.containsKey("MaintObjectFreeDefinedAttrib") ) {
                final Object value = values.remove("MaintObjectFreeDefinedAttrib");
                if( (value == null) || (!value.equals(getMaintObjectFreeDefinedAttrib())) ) {
                    setMaintObjectFreeDefinedAttrib(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("MasterFixedAsset") ) {
                final Object value = values.remove("MasterFixedAsset");
                if( (value == null) || (!value.equals(getMasterFixedAsset())) ) {
                    setMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("FixedAsset") ) {
                final Object value = values.remove("FixedAsset");
                if( (value == null) || (!value.equals(getFixedAsset())) ) {
                    setFixedAsset(((String) value));
                }
            }
            if( values.containsKey("LocAcctAssgmtBusinessArea") ) {
                final Object value = values.remove("LocAcctAssgmtBusinessArea");
                if( (value == null) || (!value.equals(getLocAcctAssgmtBusinessArea())) ) {
                    setLocAcctAssgmtBusinessArea(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("SettlementOrder") ) {
                final Object value = values.remove("SettlementOrder");
                if( (value == null) || (!value.equals(getSettlementOrder())) ) {
                    setSettlementOrder(((String) value));
                }
            }
            if( values.containsKey("CycleSetSequence") ) {
                final Object value = values.remove("CycleSetSequence");
                if( (value == null) || (!value.equals(getCycleSetSequence())) ) {
                    setCycleSetSequence(((String) value));
                }
            }
            if( values.containsKey("StandingOrderNumber") ) {
                final Object value = values.remove("StandingOrderNumber");
                if( (value == null) || (!value.equals(getStandingOrderNumber())) ) {
                    setStandingOrderNumber(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_LongText") ) {
                final Object value = (values).remove("to_LongText");
                if( value instanceof Iterable ) {
                    if( toLongText == null ) {
                        toLongText = Lists.newArrayList();
                    } else {
                        toLongText = Lists.newArrayList(toLongText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceItemText entity;
                        if( toLongText.size() > i ) {
                            entity = toLongText.get(i);
                        } else {
                            entity = new MaintenanceItemText();
                            toLongText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintenanceItemCause") ) {
                final Object value = (values).remove("to_MaintenanceItemCause");
                if( value instanceof Iterable ) {
                    if( toMaintenanceItemCause == null ) {
                        toMaintenanceItemCause = Lists.newArrayList();
                    } else {
                        toMaintenanceItemCause = Lists.newArrayList(toMaintenanceItemCause);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceItemCause entity;
                        if( toMaintenanceItemCause.size() > i ) {
                            entity = toMaintenanceItemCause.get(i);
                        } else {
                            entity = new MaintenanceItemCause();
                            toMaintenanceItemCause.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintenanceItemReason") ) {
                final Object value = (values).remove("to_MaintenanceItemReason");
                if( value instanceof Iterable ) {
                    if( toMaintenanceItemReason == null ) {
                        toMaintenanceItemReason = Lists.newArrayList();
                    } else {
                        toMaintenanceItemReason = Lists.newArrayList(toMaintenanceItemReason);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceItemReason entity;
                        if( toMaintenanceItemReason.size() > i ) {
                            entity = toMaintenanceItemReason.get(i);
                        } else {
                            entity = new MaintenanceItemReason();
                            toMaintenanceItemReason.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintItemObjectListItem") ) {
                final Object value = (values).remove("to_MaintItemObjectListItem");
                if( value instanceof Iterable ) {
                    if( toMaintItemObjectListItem == null ) {
                        toMaintItemObjectListItem = Lists.newArrayList();
                    } else {
                        toMaintItemObjectListItem = Lists.newArrayList(toMaintItemObjectListItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintItemObjectListItem entity;
                        if( toMaintItemObjectListItem.size() > i ) {
                            entity = toMaintItemObjectListItem.get(i);
                        } else {
                            entity = new MaintItemObjectListItem();
                            toMaintItemObjectListItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintPlanCallObjects") ) {
                final Object value = (values).remove("to_MaintPlanCallObjects");
                if( value instanceof Iterable ) {
                    if( toMaintPlanCallObjects == null ) {
                        toMaintPlanCallObjects = Lists.newArrayList();
                    } else {
                        toMaintPlanCallObjects = Lists.newArrayList(toMaintPlanCallObjects);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenancePlanCallObject entity;
                        if( toMaintPlanCallObjects.size() > i ) {
                            entity = toMaintPlanCallObjects.get(i);
                        } else {
                            entity = new MaintenancePlanCallObject();
                            toMaintPlanCallObjects.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintenanceItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintenanceItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenanceItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenanceItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toLongText != null ) {
            (values).put("to_LongText", toLongText);
        }
        if( toMaintenanceItemCause != null ) {
            (values).put("to_MaintenanceItemCause", toMaintenanceItemCause);
        }
        if( toMaintenanceItemReason != null ) {
            (values).put("to_MaintenanceItemReason", toMaintenanceItemReason);
        }
        if( toMaintItemObjectListItem != null ) {
            (values).put("to_MaintItemObjectListItem", toMaintItemObjectListItem);
        }
        if( toMaintPlanCallObjects != null ) {
            (values).put("to_MaintPlanCallObjects", toMaintPlanCallObjects);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceItemText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_LongText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenanceItemText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceItemText> fetchLongText()
    {
        return fetchFieldAsList("to_LongText", MaintenanceItemText.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LongText</b>.
     * <p>
     * If the navigation property <b>to_LongText</b> of a queried <b>MaintenanceItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceItemText> getLongTextOrFetch()
    {
        if( toLongText == null ) {
            toLongText = fetchLongText();
        }
        return toLongText;
    }

    /**
     * Retrieval of associated <b>MaintenanceItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LongText</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LongText</b> is already loaded, the result will contain
     *         the <b>MaintenanceItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceItemText>> getLongTextIfPresent()
    {
        return Option.of(toLongText);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceItemText</b> entities for the loaded navigation property
     * <b>to_LongText</b>.
     * <p>
     * If the navigation property <b>to_LongText</b> of a queried <b>MaintenanceItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenanceItemText</b> entities.
     */
    public void setLongText( @Nonnull final List<MaintenanceItemText> value )
    {
        if( toLongText == null ) {
            toLongText = Lists.newArrayList();
        }
        toLongText.clear();
        toLongText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_LongText</b>.
     * <p>
     * If the navigation property <b>to_LongText</b> of a queried <b>MaintenanceItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenanceItemText</b> entities.
     */
    public void addLongText( MaintenanceItemText... entity )
    {
        if( toLongText == null ) {
            toLongText = Lists.newArrayList();
        }
        toLongText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintenanceItemCause</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_MaintenanceItemCause</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenanceItemCause</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceItemCause> fetchMaintenanceItemCause()
    {
        return fetchFieldAsList("to_MaintenanceItemCause", MaintenanceItemCause.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceItemCause</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceItemCause</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItemCause</b> of a queried <b>MaintenanceItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceItemCause</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceItemCause> getMaintenanceItemCauseOrFetch()
    {
        if( toMaintenanceItemCause == null ) {
            toMaintenanceItemCause = fetchMaintenanceItemCause();
        }
        return toMaintenanceItemCause;
    }

    /**
     * Retrieval of associated <b>MaintenanceItemCause</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceItemCause</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceItemCause</b> is already loaded, the result
     *         will contain the <b>MaintenanceItemCause</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceItemCause>> getMaintenanceItemCauseIfPresent()
    {
        return Option.of(toMaintenanceItemCause);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceItemCause</b> entities for the loaded navigation property
     * <b>to_MaintenanceItemCause</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItemCause</b> of a queried <b>MaintenanceItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenanceItemCause</b> entities.
     */
    public void setMaintenanceItemCause( @Nonnull final List<MaintenanceItemCause> value )
    {
        if( toMaintenanceItemCause == null ) {
            toMaintenanceItemCause = Lists.newArrayList();
        }
        toMaintenanceItemCause.clear();
        toMaintenanceItemCause.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceItemCause</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintenanceItemCause</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItemCause</b> of a queried <b>MaintenanceItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenanceItemCause</b> entities.
     */
    public void addMaintenanceItemCause( MaintenanceItemCause... entity )
    {
        if( toMaintenanceItemCause == null ) {
            toMaintenanceItemCause = Lists.newArrayList();
        }
        toMaintenanceItemCause.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintenanceItemReason</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_MaintenanceItemReason</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenanceItemReason</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceItemReason> fetchMaintenanceItemReason()
    {
        return fetchFieldAsList("to_MaintenanceItemReason", MaintenanceItemReason.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceItemReason</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceItemReason</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItemReason</b> of a queried <b>MaintenanceItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceItemReason</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceItemReason> getMaintenanceItemReasonOrFetch()
    {
        if( toMaintenanceItemReason == null ) {
            toMaintenanceItemReason = fetchMaintenanceItemReason();
        }
        return toMaintenanceItemReason;
    }

    /**
     * Retrieval of associated <b>MaintenanceItemReason</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceItemReason</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceItemReason</b> is already loaded, the result
     *         will contain the <b>MaintenanceItemReason</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenanceItemReason>> getMaintenanceItemReasonIfPresent()
    {
        return Option.of(toMaintenanceItemReason);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceItemReason</b> entities for the loaded navigation property
     * <b>to_MaintenanceItemReason</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItemReason</b> of a queried <b>MaintenanceItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenanceItemReason</b> entities.
     */
    public void setMaintenanceItemReason( @Nonnull final List<MaintenanceItemReason> value )
    {
        if( toMaintenanceItemReason == null ) {
            toMaintenanceItemReason = Lists.newArrayList();
        }
        toMaintenanceItemReason.clear();
        toMaintenanceItemReason.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceItemReason</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintenanceItemReason</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItemReason</b> of a queried <b>MaintenanceItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenanceItemReason</b> entities.
     */
    public void addMaintenanceItemReason( MaintenanceItemReason... entity )
    {
        if( toMaintenanceItemReason == null ) {
            toMaintenanceItemReason = Lists.newArrayList();
        }
        toMaintenanceItemReason.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintItemObjectListItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_MaintItemObjectListItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintItemObjectListItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintItemObjectListItem> fetchMaintItemObjectListItem()
    {
        return fetchFieldAsList("to_MaintItemObjectListItem", MaintItemObjectListItem.class);
    }

    /**
     * Retrieval of associated <b>MaintItemObjectListItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintItemObjectListItem</b>.
     * <p>
     * If the navigation property <b>to_MaintItemObjectListItem</b> of a queried <b>MaintenanceItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintItemObjectListItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintItemObjectListItem> getMaintItemObjectListItemOrFetch()
    {
        if( toMaintItemObjectListItem == null ) {
            toMaintItemObjectListItem = fetchMaintItemObjectListItem();
        }
        return toMaintItemObjectListItem;
    }

    /**
     * Retrieval of associated <b>MaintItemObjectListItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintItemObjectListItem</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintItemObjectListItem</b> is already loaded, the
     *         result will contain the <b>MaintItemObjectListItem</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintItemObjectListItem>> getMaintItemObjectListItemIfPresent()
    {
        return Option.of(toMaintItemObjectListItem);
    }

    /**
     * Overwrites the list of associated <b>MaintItemObjectListItem</b> entities for the loaded navigation property
     * <b>to_MaintItemObjectListItem</b>.
     * <p>
     * If the navigation property <b>to_MaintItemObjectListItem</b> of a queried <b>MaintenanceItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintItemObjectListItem</b> entities.
     */
    public void setMaintItemObjectListItem( @Nonnull final List<MaintItemObjectListItem> value )
    {
        if( toMaintItemObjectListItem == null ) {
            toMaintItemObjectListItem = Lists.newArrayList();
        }
        toMaintItemObjectListItem.clear();
        toMaintItemObjectListItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintItemObjectListItem</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintItemObjectListItem</b>.
     * <p>
     * If the navigation property <b>to_MaintItemObjectListItem</b> of a queried <b>MaintenanceItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintItemObjectListItem</b> entities.
     */
    public void addMaintItemObjectListItem( MaintItemObjectListItem... entity )
    {
        if( toMaintItemObjectListItem == null ) {
            toMaintItemObjectListItem = Lists.newArrayList();
        }
        toMaintItemObjectListItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintenancePlanCallObject</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_MaintPlanCallObjects</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenancePlanCallObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenancePlanCallObject> fetchMaintPlanCallObjects()
    {
        return fetchFieldAsList("to_MaintPlanCallObjects", MaintenancePlanCallObject.class);
    }

    /**
     * Retrieval of associated <b>MaintenancePlanCallObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintPlanCallObjects</b>.
     * <p>
     * If the navigation property <b>to_MaintPlanCallObjects</b> of a queried <b>MaintenanceItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenancePlanCallObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenancePlanCallObject> getMaintPlanCallObjectsOrFetch()
    {
        if( toMaintPlanCallObjects == null ) {
            toMaintPlanCallObjects = fetchMaintPlanCallObjects();
        }
        return toMaintPlanCallObjects;
    }

    /**
     * Retrieval of associated <b>MaintenancePlanCallObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintPlanCallObjects</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintPlanCallObjects</b> is already loaded, the result
     *         will contain the <b>MaintenancePlanCallObject</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenancePlanCallObject>> getMaintPlanCallObjectsIfPresent()
    {
        return Option.of(toMaintPlanCallObjects);
    }

    /**
     * Overwrites the list of associated <b>MaintenancePlanCallObject</b> entities for the loaded navigation property
     * <b>to_MaintPlanCallObjects</b>.
     * <p>
     * If the navigation property <b>to_MaintPlanCallObjects</b> of a queried <b>MaintenanceItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenancePlanCallObject</b> entities.
     */
    public void setMaintPlanCallObjects( @Nonnull final List<MaintenancePlanCallObject> value )
    {
        if( toMaintPlanCallObjects == null ) {
            toMaintPlanCallObjects = Lists.newArrayList();
        }
        toMaintPlanCallObjects.clear();
        toMaintPlanCallObjects.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenancePlanCallObject</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintPlanCallObjects</b>.
     * <p>
     * If the navigation property <b>to_MaintPlanCallObjects</b> of a queried <b>MaintenanceItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenancePlanCallObject</b> entities.
     */
    public void addMaintPlanCallObjects( MaintenancePlanCallObject... entity )
    {
        if( toMaintPlanCallObjects == null ) {
            toMaintPlanCallObjects = Lists.newArrayList();
        }
        toMaintPlanCallObjects.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintenanceItem instances.
     *
     */
    public final static class MaintenanceItemBuilder
    {

        private List<MaintenanceItemText> toLongText = Lists.newArrayList();
        private List<MaintenanceItemCause> toMaintenanceItemCause = Lists.newArrayList();
        private List<MaintenanceItemReason> toMaintenanceItemReason = Lists.newArrayList();
        private List<MaintItemObjectListItem> toMaintItemObjectListItem = Lists.newArrayList();
        private List<MaintenancePlanCallObject> toMaintPlanCallObjects = Lists.newArrayList();

        private MaintenanceItem.MaintenanceItemBuilder toLongText( final List<MaintenanceItemText> value )
        {
            toLongText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LongText</b> for <b>MaintenanceItem</b> to multiple <b>MaintenanceItemText</b>.
         *
         * @param value
         *            The MaintenanceItemTexts to build this MaintenanceItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceItem.MaintenanceItemBuilder longText( MaintenanceItemText... value )
        {
            return toLongText(Lists.newArrayList(value));
        }

        private MaintenanceItem.MaintenanceItemBuilder toMaintenanceItemCause( final List<MaintenanceItemCause> value )
        {
            toMaintenanceItemCause.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceItemCause</b> for <b>MaintenanceItem</b> to multiple
         * <b>MaintenanceItemCause</b>.
         *
         * @param value
         *            The MaintenanceItemCauses to build this MaintenanceItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceItem.MaintenanceItemBuilder maintenanceItemCause( MaintenanceItemCause... value )
        {
            return toMaintenanceItemCause(Lists.newArrayList(value));
        }

        private MaintenanceItem.MaintenanceItemBuilder toMaintenanceItemReason(
            final List<MaintenanceItemReason> value )
        {
            toMaintenanceItemReason.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceItemReason</b> for <b>MaintenanceItem</b> to multiple
         * <b>MaintenanceItemReason</b>.
         *
         * @param value
         *            The MaintenanceItemReasons to build this MaintenanceItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceItem.MaintenanceItemBuilder maintenanceItemReason( MaintenanceItemReason... value )
        {
            return toMaintenanceItemReason(Lists.newArrayList(value));
        }

        private MaintenanceItem.MaintenanceItemBuilder toMaintItemObjectListItem(
            final List<MaintItemObjectListItem> value )
        {
            toMaintItemObjectListItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintItemObjectListItem</b> for <b>MaintenanceItem</b> to multiple
         * <b>MaintItemObjectListItem</b>.
         *
         * @param value
         *            The MaintItemObjectListItems to build this MaintenanceItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceItem.MaintenanceItemBuilder maintItemObjectListItem( MaintItemObjectListItem... value )
        {
            return toMaintItemObjectListItem(Lists.newArrayList(value));
        }

        private MaintenanceItem.MaintenanceItemBuilder toMaintPlanCallObjects(
            final List<MaintenancePlanCallObject> value )
        {
            toMaintPlanCallObjects.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintPlanCallObjects</b> for <b>MaintenanceItem</b> to multiple
         * <b>MaintenancePlanCallObject</b>.
         *
         * @param value
         *            The MaintenancePlanCallObjects to build this MaintenanceItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceItem.MaintenanceItemBuilder maintPlanCallObjects( MaintenancePlanCallObject... value )
        {
            return toMaintPlanCallObjects(Lists.newArrayList(value));
        }

    }

}
