/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintenanceItemReasonSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
 * MaintenanceItemReason} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class MaintenanceItemReasonByKeyFluentHelper
    extends
    FluentHelperByKey<MaintenanceItemReasonByKeyFluentHelper, MaintenanceItemReason, MaintenanceItemReasonSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     * MaintenanceItemReason} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param nmbrOfMaintComplianceItems
     *            Sequential Number for Compliance
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintenanceItemReason}
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintenanceItemReason}
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     */
    public MaintenanceItemReasonByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintenanceItem,
        final String nmbrOfMaintComplianceItems )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenanceItem", maintenanceItem);
        this.key.put("NmbrOfMaintComplianceItems", nmbrOfMaintComplianceItems);
    }

    @Override
    @Nonnull
    protected Class<MaintenanceItemReason> getEntityClass()
    {
        return MaintenanceItemReason.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
