/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintenanceItemReasonTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintenanceItemReasonTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintenanceItemReasonTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Item Reason Long Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenanceItemReasonTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenanceItemReasonText extends VdmEntity<MaintenanceItemReasonText>
{

    /**
     * Selector for all available fields of MaintenanceItemReasonText.
     *
     */
    public final static MaintenanceItemReasonTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItem</b>
     * </p>
     *
     * @return Maintenance Item
     */
    @Key
    @SerializedName( "MaintenanceItem" )
    @JsonProperty( "MaintenanceItem" )
    @Nullable
    @ODataField( odataName = "MaintenanceItem" )
    private String maintenanceItem;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceItem</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonTextField<String> MAINTENANCE_ITEM =
        new MaintenanceItemReasonTextField<String>("MaintenanceItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NmbrOfMaintComplianceItems</b>
     * </p>
     *
     * @return Sequential Number for Compliance
     */
    @Key
    @SerializedName( "NmbrOfMaintComplianceItems" )
    @JsonProperty( "NmbrOfMaintComplianceItems" )
    @Nullable
    @ODataField( odataName = "NmbrOfMaintComplianceItems" )
    private String nmbrOfMaintComplianceItems;
    /**
     * Use with available fluent helpers to apply the <b>NmbrOfMaintComplianceItems</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonTextField<String> NMBR_OF_MAINT_COMPLIANCE_ITEMS =
        new MaintenanceItemReasonTextField<String>("NmbrOfMaintComplianceItems");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonTextField<String> LANGUAGE =
        new MaintenanceItemReasonTextField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlainLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "PlainLongText" )
    @JsonProperty( "PlainLongText" )
    @Nullable
    @ODataField( odataName = "PlainLongText" )
    private String plainLongText;
    /**
     * Use with available fluent helpers to apply the <b>PlainLongText</b> field to query operations.
     *
     */
    public final static MaintenanceItemReasonTextField<String> PLAIN_LONG_TEXT =
        new MaintenanceItemReasonTextField<String>("PlainLongText");
    /**
     * Navigation property <b>to_MaintenanceItemReason</b> for <b>MaintenanceItemReasonText</b> to single
     * <b>MaintenanceItemReason</b>.
     *
     */
    @SerializedName( "to_MaintenanceItemReason" )
    @JsonProperty( "to_MaintenanceItemReason" )
    @ODataField( odataName = "to_MaintenanceItemReason" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceItemReason toMaintenanceItemReason;
    /**
     * Navigation property <b>to_MaintenanceItem</b> for <b>MaintenanceItemReasonText</b> to single
     * <b>MaintenanceItem</b>.
     *
     */
    @SerializedName( "to_MaintenanceItem" )
    @JsonProperty( "to_MaintenanceItem" )
    @ODataField( odataName = "to_MaintenanceItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenanceItem toMaintenanceItem;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceItemReason</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenanceItemReasonTextOneToOneLink<MaintenanceItemReason> TO_MAINTENANCE_ITEM_REASON =
        new MaintenanceItemReasonTextOneToOneLink<MaintenanceItemReason>("to_MaintenanceItemReason");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceItem</b> navigation property to query operations.
     *
     */
    public final static MaintenanceItemReasonTextOneToOneLink<MaintenanceItem> TO_MAINTENANCE_ITEM =
        new MaintenanceItemReasonTextOneToOneLink<MaintenanceItem>("to_MaintenanceItem");

    @Nonnull
    @Override
    public Class<MaintenanceItemReasonText> getType()
    {
        return MaintenanceItemReasonText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceItem</b>
     * </p>
     *
     * @param maintenanceItem
     *            Maintenance Item
     */
    public void setMaintenanceItem( @Nullable final String maintenanceItem )
    {
        rememberChangedField("MaintenanceItem", this.maintenanceItem);
        this.maintenanceItem = maintenanceItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NmbrOfMaintComplianceItems</b>
     * </p>
     *
     * @param nmbrOfMaintComplianceItems
     *            Sequential Number for Compliance
     */
    public void setNmbrOfMaintComplianceItems( @Nullable final String nmbrOfMaintComplianceItems )
    {
        rememberChangedField("NmbrOfMaintComplianceItems", this.nmbrOfMaintComplianceItems);
        this.nmbrOfMaintComplianceItems = nmbrOfMaintComplianceItems;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlainLongText</b>
     * </p>
     *
     * @param plainLongText
     *            Long Text
     */
    public void setPlainLongText( @Nullable final String plainLongText )
    {
        rememberChangedField("PlainLongText", this.plainLongText);
        this.plainLongText = plainLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenanceItemReasonText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenanceItem", getMaintenanceItem());
        result.put("NmbrOfMaintComplianceItems", getNmbrOfMaintComplianceItems());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenanceItem", getMaintenanceItem());
        values.put("NmbrOfMaintComplianceItems", getNmbrOfMaintComplianceItems());
        values.put("Language", getLanguage());
        values.put("PlainLongText", getPlainLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenanceItem") ) {
                final Object value = values.remove("MaintenanceItem");
                if( (value == null) || (!value.equals(getMaintenanceItem())) ) {
                    setMaintenanceItem(((String) value));
                }
            }
            if( values.containsKey("NmbrOfMaintComplianceItems") ) {
                final Object value = values.remove("NmbrOfMaintComplianceItems");
                if( (value == null) || (!value.equals(getNmbrOfMaintComplianceItems())) ) {
                    setNmbrOfMaintComplianceItems(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("PlainLongText") ) {
                final Object value = values.remove("PlainLongText");
                if( (value == null) || (!value.equals(getPlainLongText())) ) {
                    setPlainLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenanceItemReason") ) {
                final Object value = (values).remove("to_MaintenanceItemReason");
                if( value instanceof Map ) {
                    if( toMaintenanceItemReason == null ) {
                        toMaintenanceItemReason = new MaintenanceItemReason();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceItemReason.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_MaintenanceItem") ) {
                final Object value = (values).remove("to_MaintenanceItem");
                if( value instanceof Map ) {
                    if( toMaintenanceItem == null ) {
                        toMaintenanceItem = new MaintenanceItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenanceItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintenanceItemReasonTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintenanceItemReasonTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenanceItemReasonTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenanceItemReasonTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenanceItemReason != null ) {
            (values).put("to_MaintenanceItemReason", toMaintenanceItemReason);
        }
        if( toMaintenanceItem != null ) {
            (values).put("to_MaintenanceItem", toMaintenanceItem);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceItemReason</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintenanceItemReason</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceItemReason</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceItemReason fetchMaintenanceItemReason()
    {
        return fetchFieldAsSingle("to_MaintenanceItemReason", MaintenanceItemReason.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceItemReason</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceItemReason</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItemReason</b> of a queried <b>MaintenanceItemReasonText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceItemReason</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceItemReason getMaintenanceItemReasonOrFetch()
    {
        if( toMaintenanceItemReason == null ) {
            toMaintenanceItemReason = fetchMaintenanceItemReason();
        }
        return toMaintenanceItemReason;
    }

    /**
     * Retrieval of associated <b>MaintenanceItemReason</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_MaintenanceItemReason</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceItemReasonText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceItemReason</b> is already loaded, the result
     *         will contain the <b>MaintenanceItemReason</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceItemReason> getMaintenanceItemReasonIfPresent()
    {
        return Option.of(toMaintenanceItemReason);
    }

    /**
     * Overwrites the associated <b>MaintenanceItemReason</b> entity for the loaded navigation property
     * <b>to_MaintenanceItemReason</b>.
     *
     * @param value
     *            New <b>MaintenanceItemReason</b> entity.
     */
    public void setMaintenanceItemReason( final MaintenanceItemReason value )
    {
        toMaintenanceItemReason = value;
    }

    /**
     * Fetches the <b>MaintenanceItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_MaintenanceItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenanceItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceItem fetchMaintenanceItem()
    {
        return fetchFieldAsSingle("to_MaintenanceItem", MaintenanceItem.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceItem</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceItem</b> of a queried <b>MaintenanceItemReasonText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenanceItem getMaintenanceItemOrFetch()
    {
        if( toMaintenanceItem == null ) {
            toMaintenanceItem = fetchMaintenanceItem();
        }
        return toMaintenanceItem;
    }

    /**
     * Retrieval of associated <b>MaintenanceItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenanceItem</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenanceItemReasonText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceItem</b> is already loaded, the result will
     *         contain the <b>MaintenanceItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenanceItem> getMaintenanceItemIfPresent()
    {
        return Option.of(toMaintenanceItem);
    }

    /**
     * Overwrites the associated <b>MaintenanceItem</b> entity for the loaded navigation property
     * <b>to_MaintenanceItem</b>.
     *
     * @param value
     *            New <b>MaintenanceItem</b> entity.
     */
    public void setMaintenanceItem( final MaintenanceItem value )
    {
        toMaintenanceItem = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintenanceItemReasonText instances.
     *
     */
    public final static class MaintenanceItemReasonTextBuilder
    {

        private MaintenanceItemReason toMaintenanceItemReason;
        private MaintenanceItem toMaintenanceItem;
        private String maintenanceItem = null;

        private MaintenanceItemReasonText.MaintenanceItemReasonTextBuilder toMaintenanceItemReason(
            final MaintenanceItemReason value )
        {
            toMaintenanceItemReason = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceItemReason</b> for <b>MaintenanceItemReasonText</b> to single
         * <b>MaintenanceItemReason</b>.
         *
         * @param value
         *            The MaintenanceItemReason to build this MaintenanceItemReasonText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceItemReasonText.MaintenanceItemReasonTextBuilder maintenanceItemReason(
            final MaintenanceItemReason value )
        {
            return toMaintenanceItemReason(value);
        }

        private MaintenanceItemReasonText.MaintenanceItemReasonTextBuilder toMaintenanceItem(
            final MaintenanceItem value )
        {
            toMaintenanceItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceItem</b> for <b>MaintenanceItemReasonText</b> to single
         * <b>MaintenanceItem</b>.
         *
         * @param value
         *            The MaintenanceItem to build this MaintenanceItemReasonText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceItemReasonText.MaintenanceItemReasonTextBuilder maintenanceItem( final MaintenanceItem value )
        {
            return toMaintenanceItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 16
         * <p>
         * Original property name from the Odata EDM: <b>MaintenanceItem</b>
         * </p>
         *
         * @param value
         *            The maintenanceItem to build this MaintenanceItemReasonText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenanceItemReasonText.MaintenanceItemReasonTextBuilder maintenanceItem( final String value )
        {
            maintenanceItem = value;
            return this;
        }

    }

}
