/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintenanceItemTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText MaintenanceItemText}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class MaintenanceItemTextByKeyFluentHelper
    extends
    FluentHelperByKey<MaintenanceItemTextByKeyFluentHelper, MaintenanceItemText, MaintenanceItemTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText
     * MaintenanceItemText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintenanceItemText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintenanceItemText}
     * @param maintenanceItem
     *            Maintenance Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public MaintenanceItemTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintenanceItem,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenanceItem", maintenanceItem);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<MaintenanceItemText> getEntityClass()
    {
        return MaintenanceItemText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
