/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintenancePlanField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintenancePlanLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintenancePlanSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Plan
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenancePlanType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenancePlan extends VdmEntity<MaintenancePlan>
{

    /**
     * Selector for all available fields of MaintenancePlan.
     *
     */
    public final static MaintenancePlanSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @return Maintenance Plan
     */
    @Key
    @SerializedName( "MaintenancePlan" )
    @JsonProperty( "MaintenancePlan" )
    @Nullable
    @ODataField( odataName = "MaintenancePlan" )
    private String maintenancePlan;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlan</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINTENANCE_PLAN =
        new MaintenancePlanField<String>("MaintenancePlan");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanDesc</b>
     * </p>
     *
     * @return Maintenance Plan Text
     */
    @SerializedName( "MaintenancePlanDesc" )
    @JsonProperty( "MaintenancePlanDesc" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanDesc" )
    private String maintenancePlanDesc;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanDesc</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINTENANCE_PLAN_DESC =
        new MaintenancePlanField<String>("MaintenancePlanDesc");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Date of creation
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<LocalDateTime> CREATION_DATE =
        new MaintenancePlanField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> CREATED_BY_USER =
        new MaintenancePlanField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<LocalDateTime> LAST_CHANGE_DATE =
        new MaintenancePlanField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> LAST_CHANGED_BY_USER =
        new MaintenancePlanField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStrategy</b>
     * </p>
     *
     * @return Maintenance Strategy
     */
    @SerializedName( "MaintenanceStrategy" )
    @JsonProperty( "MaintenanceStrategy" )
    @Nullable
    @ODataField( odataName = "MaintenanceStrategy" )
    private String maintenanceStrategy;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceStrategy</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINTENANCE_STRATEGY =
        new MaintenancePlanField<String>("MaintenanceStrategy");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingDuration</b>
     * </p>
     *
     * @return Scheduling Period
     */
    @SerializedName( "SchedulingDuration" )
    @JsonProperty( "SchedulingDuration" )
    @Nullable
    @ODataField( odataName = "SchedulingDuration" )
    private String schedulingDuration;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingDuration</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> SCHEDULING_DURATION =
        new MaintenancePlanField<String>("SchedulingDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingDurationUnit</b>
     * </p>
     *
     * @return Unit for Scheduling Period
     */
    @SerializedName( "SchedulingDurationUnit" )
    @JsonProperty( "SchedulingDurationUnit" )
    @Nullable
    @ODataField( odataName = "SchedulingDurationUnit" )
    private String schedulingDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingDurationUnit</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> SCHEDULING_DURATION_UNIT =
        new MaintenancePlanField<String>("SchedulingDurationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfMaintenanceItems</b>
     * </p>
     *
     * @return Number of maintenance items in the maintenance plan
     */
    @SerializedName( "NumberOfMaintenanceItems" )
    @JsonProperty( "NumberOfMaintenanceItems" )
    @Nullable
    @ODataField( odataName = "NumberOfMaintenanceItems" )
    private String numberOfMaintenanceItems;
    /**
     * Use with available fluent helpers to apply the <b>NumberOfMaintenanceItems</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> NUMBER_OF_MAINTENANCE_ITEMS =
        new MaintenancePlanField<String>("NumberOfMaintenanceItems");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CycleModificationRatio</b>
     * </p>
     *
     * @return Cycle modification factor
     */
    @SerializedName( "CycleModificationRatio" )
    @JsonProperty( "CycleModificationRatio" )
    @Nullable
    @ODataField( odataName = "CycleModificationRatio" )
    private BigDecimal cycleModificationRatio;
    /**
     * Use with available fluent helpers to apply the <b>CycleModificationRatio</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<BigDecimal> CYCLE_MODIFICATION_RATIO =
        new MaintenancePlanField<BigDecimal>("CycleModificationRatio");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanSchedgIndicator</b>
     * </p>
     *
     * @return Scheduling indicator
     */
    @SerializedName( "MaintPlanSchedgIndicator" )
    @JsonProperty( "MaintPlanSchedgIndicator" )
    @Nullable
    @ODataField( odataName = "MaintPlanSchedgIndicator" )
    private String maintPlanSchedgIndicator;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanSchedgIndicator</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINT_PLAN_SCHEDG_INDICATOR =
        new MaintenancePlanField<String>("MaintPlanSchedgIndicator");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CallHorizonPercent</b>
     * </p>
     *
     * @return Call horizon for maintenance plan calls
     */
    @SerializedName( "CallHorizonPercent" )
    @JsonProperty( "CallHorizonPercent" )
    @Nullable
    @ODataField( odataName = "CallHorizonPercent" )
    private String callHorizonPercent;
    /**
     * Use with available fluent helpers to apply the <b>CallHorizonPercent</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> CALL_HORIZON_PERCENT =
        new MaintenancePlanField<String>("CallHorizonPercent");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CallHorizonInDays</b>
     * </p>
     *
     * @return Call horizon for maintenance plan calls
     */
    @SerializedName( "CallHorizonInDays" )
    @JsonProperty( "CallHorizonInDays" )
    @Nullable
    @ODataField( odataName = "CallHorizonInDays" )
    private String callHorizonInDays;
    /**
     * Use with available fluent helpers to apply the <b>CallHorizonInDays</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> CALL_HORIZON_IN_DAYS =
        new MaintenancePlanField<String>("CallHorizonInDays");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceCallHorizonCalcType</b>
     * </p>
     *
     * @return Calculation Type of Call Horizon
     */
    @SerializedName( "MaintenanceCallHorizonCalcType" )
    @JsonProperty( "MaintenanceCallHorizonCalcType" )
    @Nullable
    @ODataField( odataName = "MaintenanceCallHorizonCalcType" )
    private String maintenanceCallHorizonCalcType;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceCallHorizonCalcType</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINTENANCE_CALL_HORIZON_CALC_TYPE =
        new MaintenancePlanField<String>("MaintenanceCallHorizonCalcType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @return Technical Object Authorization Group
     */
    @SerializedName( "AuthorizationGroup" )
    @JsonProperty( "AuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "AuthorizationGroup" )
    private String authorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationGroup</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> AUTHORIZATION_GROUP =
        new MaintenancePlanField<String>("AuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanInternalID</b>
     * </p>
     *
     * @return Object Number
     */
    @SerializedName( "MaintenancePlanInternalID" )
    @JsonProperty( "MaintenancePlanInternalID" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanInternalID" )
    private String maintenancePlanInternalID;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanInternalID</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINTENANCE_PLAN_INTERNAL_ID =
        new MaintenancePlanField<String>("MaintenancePlanInternalID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceCall</b>
     * </p>
     *
     * @return Maintenance Plan Call Number
     */
    @SerializedName( "MaintenanceCall" )
    @JsonProperty( "MaintenanceCall" )
    @Nullable
    @ODataField( odataName = "MaintenanceCall" )
    private Integer maintenanceCall;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceCall</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<Integer> MAINTENANCE_CALL =
        new MaintenancePlanField<Integer>("MaintenanceCall");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCategory</b>
     * </p>
     *
     * @return Maintenance plan category
     */
    @SerializedName( "MaintenancePlanCategory" )
    @JsonProperty( "MaintenancePlanCategory" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanCategory" )
    private String maintenancePlanCategory;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanCategory</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINTENANCE_PLAN_CATEGORY =
        new MaintenancePlanField<String>("MaintenancePlanCategory");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanFreeDefinedAttrib</b>
     * </p>
     *
     * @return Sort field for maintenance plans
     */
    @SerializedName( "MaintPlanFreeDefinedAttrib" )
    @JsonProperty( "MaintPlanFreeDefinedAttrib" )
    @Nullable
    @ODataField( odataName = "MaintPlanFreeDefinedAttrib" )
    private String maintPlanFreeDefinedAttrib;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanFreeDefinedAttrib</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINT_PLAN_FREE_DEFINED_ATTRIB =
        new MaintenancePlanField<String>("MaintPlanFreeDefinedAttrib");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BasicStartDate</b>
     * </p>
     *
     * @return Start date
     */
    @SerializedName( "BasicStartDate" )
    @JsonProperty( "BasicStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BasicStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime basicStartDate;
    /**
     * Use with available fluent helpers to apply the <b>BasicStartDate</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<LocalDateTime> BASIC_START_DATE =
        new MaintenancePlanField<LocalDateTime>("BasicStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingStartDate</b>
     * </p>
     *
     * @return Start Date for Scheduling
     */
    @SerializedName( "SchedulingStartDate" )
    @JsonProperty( "SchedulingStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SchedulingStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime schedulingStartDate;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingStartDate</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<LocalDateTime> SCHEDULING_START_DATE =
        new MaintenancePlanField<LocalDateTime>("SchedulingStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingStartTime</b>
     * </p>
     *
     * @return Start Time for Scheduling
     */
    @SerializedName( "SchedulingStartTime" )
    @JsonProperty( "SchedulingStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "SchedulingStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime schedulingStartTime;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingStartTime</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<LocalTime> SCHEDULING_START_TIME =
        new MaintenancePlanField<LocalTime>("SchedulingStartTime");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanStartCntrReadingValue</b>
     * </p>
     *
     * @return The maintPlanStartCntrReadingValue contained in this entity.
     */
    @SerializedName( "MaintPlanStartCntrReadingValue" )
    @JsonProperty( "MaintPlanStartCntrReadingValue" )
    @Nullable
    @ODataField( odataName = "MaintPlanStartCntrReadingValue" )
    private String maintPlanStartCntrReadingValue;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanStartCntrReadingValue</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINT_PLAN_START_CNTR_READING_VALUE =
        new MaintenancePlanField<String>("MaintPlanStartCntrReadingValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlnStrtBufDurationInDays</b>
     * </p>
     *
     * @return Scheduling to reoccur when lead float reached
     */
    @SerializedName( "MaintPlnStrtBufDurationInDays" )
    @JsonProperty( "MaintPlnStrtBufDurationInDays" )
    @Nullable
    @ODataField( odataName = "MaintPlnStrtBufDurationInDays" )
    private String maintPlnStrtBufDurationInDays;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlnStrtBufDurationInDays</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINT_PLN_STRT_BUF_DURATION_IN_DAYS =
        new MaintenancePlanField<String>("MaintPlnStrtBufDurationInDays");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanStartBufferUnit</b>
     * </p>
     *
     * @return Unit for Scheduling Period
     */
    @SerializedName( "MaintPlanStartBufferUnit" )
    @JsonProperty( "MaintPlanStartBufferUnit" )
    @Nullable
    @ODataField( odataName = "MaintPlanStartBufferUnit" )
    private String maintPlanStartBufferUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanStartBufferUnit</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINT_PLAN_START_BUFFER_UNIT =
        new MaintenancePlanField<String>("MaintPlanStartBufferUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @return Factory calendar key
     */
    @SerializedName( "FactoryCalendar" )
    @JsonProperty( "FactoryCalendar" )
    @Nullable
    @ODataField( odataName = "FactoryCalendar" )
    private String factoryCalendar;
    /**
     * Use with available fluent helpers to apply the <b>FactoryCalendar</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> FACTORY_CALENDAR =
        new MaintenancePlanField<String>("FactoryCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LateCompletionShiftInPercent</b>
     * </p>
     *
     * @return Shift Factor for Late Completion
     */
    @SerializedName( "LateCompletionShiftInPercent" )
    @JsonProperty( "LateCompletionShiftInPercent" )
    @Nullable
    @ODataField( odataName = "LateCompletionShiftInPercent" )
    private String lateCompletionShiftInPercent;
    /**
     * Use with available fluent helpers to apply the <b>LateCompletionShiftInPercent</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> LATE_COMPLETION_SHIFT_IN_PERCENT =
        new MaintenancePlanField<String>("LateCompletionShiftInPercent");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LateCompletionTolerancePercent</b>
     * </p>
     *
     * @return Tolerance for Late Completion (%)
     */
    @SerializedName( "LateCompletionTolerancePercent" )
    @JsonProperty( "LateCompletionTolerancePercent" )
    @Nullable
    @ODataField( odataName = "LateCompletionTolerancePercent" )
    private String lateCompletionTolerancePercent;
    /**
     * Use with available fluent helpers to apply the <b>LateCompletionTolerancePercent</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> LATE_COMPLETION_TOLERANCE_PERCENT =
        new MaintenancePlanField<String>("LateCompletionTolerancePercent");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EarlyCompletionShiftInPercent</b>
     * </p>
     *
     * @return Shift Factor for Early Completion
     */
    @SerializedName( "EarlyCompletionShiftInPercent" )
    @JsonProperty( "EarlyCompletionShiftInPercent" )
    @Nullable
    @ODataField( odataName = "EarlyCompletionShiftInPercent" )
    private String earlyCompletionShiftInPercent;
    /**
     * Use with available fluent helpers to apply the <b>EarlyCompletionShiftInPercent</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> EARLY_COMPLETION_SHIFT_IN_PERCENT =
        new MaintenancePlanField<String>("EarlyCompletionShiftInPercent");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EarlyCompletionTolerancePct</b>
     * </p>
     *
     * @return Tolerance for Early Completion (%)
     */
    @SerializedName( "EarlyCompletionTolerancePct" )
    @JsonProperty( "EarlyCompletionTolerancePct" )
    @Nullable
    @ODataField( odataName = "EarlyCompletionTolerancePct" )
    private String earlyCompletionTolerancePct;
    /**
     * Use with available fluent helpers to apply the <b>EarlyCompletionTolerancePct</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> EARLY_COMPLETION_TOLERANCE_PCT =
        new MaintenancePlanField<String>("EarlyCompletionTolerancePct");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrCallObjCompltnIsRqd</b>
     * </p>
     *
     * @return Only Create New Call Object After Completing Predecessor
     */
    @SerializedName( "PrdcssrCallObjCompltnIsRqd" )
    @JsonProperty( "PrdcssrCallObjCompltnIsRqd" )
    @Nullable
    @ODataField( odataName = "PrdcssrCallObjCompltnIsRqd" )
    private String prdcssrCallObjCompltnIsRqd;
    /**
     * Use with available fluent helpers to apply the <b>PrdcssrCallObjCompltnIsRqd</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> PRDCSSR_CALL_OBJ_COMPLTN_IS_RQD =
        new MaintenancePlanField<String>("PrdcssrCallObjCompltnIsRqd");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanLogicalOperatorCode</b>
     * </p>
     *
     * @return Indicator for OR or AND link
     */
    @SerializedName( "MaintPlanLogicalOperatorCode" )
    @JsonProperty( "MaintPlanLogicalOperatorCode" )
    @Nullable
    @ODataField( odataName = "MaintPlanLogicalOperatorCode" )
    private String maintPlanLogicalOperatorCode;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanLogicalOperatorCode</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINT_PLAN_LOGICAL_OPERATOR_CODE =
        new MaintenancePlanField<String>("MaintPlanLogicalOperatorCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingEndDate</b>
     * </p>
     *
     * @return End Date for Scheduling
     */
    @SerializedName( "SchedulingEndDate" )
    @JsonProperty( "SchedulingEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SchedulingEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime schedulingEndDate;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingEndDate</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<LocalDateTime> SCHEDULING_END_DATE =
        new MaintenancePlanField<LocalDateTime>("SchedulingEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanEndCntrReadingValue</b>
     * </p>
     *
     * @return The maintPlanEndCntrReadingValue contained in this entity.
     */
    @SerializedName( "MaintPlanEndCntrReadingValue" )
    @JsonProperty( "MaintPlanEndCntrReadingValue" )
    @Nullable
    @ODataField( odataName = "MaintPlanEndCntrReadingValue" )
    private String maintPlanEndCntrReadingValue;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanEndCntrReadingValue</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINT_PLAN_END_CNTR_READING_VALUE =
        new MaintenancePlanField<String>("MaintPlanEndCntrReadingValue");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new MaintenancePlanField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleCounterPlanShiftFactor</b>
     * </p>
     *
     * @return Shift Factor for Multiple Counter Plan
     */
    @SerializedName( "MultipleCounterPlanShiftFactor" )
    @JsonProperty( "MultipleCounterPlanShiftFactor" )
    @Nullable
    @ODataField( odataName = "MultipleCounterPlanShiftFactor" )
    private String multipleCounterPlanShiftFactor;
    /**
     * Use with available fluent helpers to apply the <b>MultipleCounterPlanShiftFactor</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MULTIPLE_COUNTER_PLAN_SHIFT_FACTOR =
        new MaintenancePlanField<String>("MultipleCounterPlanShiftFactor");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceLeadFloatInDays</b>
     * </p>
     *
     * @return Lead Float in Days
     */
    @SerializedName( "MaintenanceLeadFloatInDays" )
    @JsonProperty( "MaintenanceLeadFloatInDays" )
    @Nullable
    @ODataField( odataName = "MaintenanceLeadFloatInDays" )
    private String maintenanceLeadFloatInDays;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceLeadFloatInDays</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINTENANCE_LEAD_FLOAT_IN_DAYS =
        new MaintenancePlanField<String>("MaintenanceLeadFloatInDays");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCallObject</b>
     * </p>
     *
     * @return Call object for maintenance plan
     */
    @SerializedName( "MaintenancePlanCallObject" )
    @JsonProperty( "MaintenancePlanCallObject" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanCallObject" )
    private String maintenancePlanCallObject;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanCallObject</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINTENANCE_PLAN_CALL_OBJECT =
        new MaintenancePlanField<String>("MaintenancePlanCallObject");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanSystemStatus</b>
     * </p>
     *
     * @return Text
     */
    @SerializedName( "MaintenancePlanSystemStatus" )
    @JsonProperty( "MaintenancePlanSystemStatus" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanSystemStatus" )
    private String maintenancePlanSystemStatus;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanSystemStatus</b> field to query operations.
     *
     */
    public final static MaintenancePlanField<String> MAINTENANCE_PLAN_SYSTEM_STATUS =
        new MaintenancePlanField<String>("MaintenancePlanSystemStatus");
    /**
     * Navigation property <b>to_Item</b> for <b>MaintenancePlan</b> to multiple <b>MaintenanceItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenanceItem> toItem;
    /**
     * Navigation property <b>to_LongText</b> for <b>MaintenancePlan</b> to multiple <b>MaintenancePlanText</b>.
     *
     */
    @SerializedName( "to_LongText" )
    @JsonProperty( "to_LongText" )
    @ODataField( odataName = "to_LongText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenancePlanText> toLongText;
    /**
     * Navigation property <b>to_MaintenanceCycle</b> for <b>MaintenancePlan</b> to multiple
     * <b>MaintenancePlanCycle</b>.
     *
     */
    @SerializedName( "to_MaintenanceCycle" )
    @JsonProperty( "to_MaintenanceCycle" )
    @ODataField( odataName = "to_MaintenanceCycle" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenancePlanCycle> toMaintenanceCycle;
    /**
     * Navigation property <b>to_MaintPlanClfnClass</b> for <b>MaintenancePlan</b> to multiple
     * <b>MaintPlanClfnClass</b>.
     *
     */
    @SerializedName( "to_MaintPlanClfnClass" )
    @JsonProperty( "to_MaintPlanClfnClass" )
    @ODataField( odataName = "to_MaintPlanClfnClass" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintPlanClfnClass> toMaintPlanClfnClass;
    /**
     * Navigation property <b>to_Schedules</b> for <b>MaintenancePlan</b> to multiple <b>MaintenancePlanSchedule</b>.
     *
     */
    @SerializedName( "to_Schedules" )
    @JsonProperty( "to_Schedules" )
    @ODataField( odataName = "to_Schedules" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenancePlanSchedule> toSchedules;
    /**
     * Navigation property <b>to_StrategyCycle</b> for <b>MaintenancePlan</b> to multiple
     * <b>MaintenancePlanStrategyCycle</b>.
     *
     */
    @SerializedName( "to_StrategyCycle" )
    @JsonProperty( "to_StrategyCycle" )
    @ODataField( odataName = "to_StrategyCycle" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenancePlanStrategyCycle> toStrategyCycle;
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static MaintenancePlanLink<MaintenanceItem> TO_ITEM =
        new MaintenancePlanLink<MaintenanceItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_LongText</b> navigation property to query operations.
     *
     */
    public final static MaintenancePlanLink<MaintenancePlanText> TO_LONG_TEXT =
        new MaintenancePlanLink<MaintenancePlanText>("to_LongText");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenanceCycle</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenancePlanLink<MaintenancePlanCycle> TO_MAINTENANCE_CYCLE =
        new MaintenancePlanLink<MaintenancePlanCycle>("to_MaintenanceCycle");
    /**
     * Use with available fluent helpers to apply the <b>to_MaintPlanClfnClass</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenancePlanLink<MaintPlanClfnClass> TO_MAINT_PLAN_CLFN_CLASS =
        new MaintenancePlanLink<MaintPlanClfnClass>("to_MaintPlanClfnClass");
    /**
     * Use with available fluent helpers to apply the <b>to_Schedules</b> navigation property to query operations.
     *
     */
    public final static MaintenancePlanLink<MaintenancePlanSchedule> TO_SCHEDULES =
        new MaintenancePlanLink<MaintenancePlanSchedule>("to_Schedules");
    /**
     * Use with available fluent helpers to apply the <b>to_StrategyCycle</b> navigation property to query operations.
     *
     */
    public final static MaintenancePlanLink<MaintenancePlanStrategyCycle> TO_STRATEGY_CYCLE =
        new MaintenancePlanLink<MaintenancePlanStrategyCycle>("to_StrategyCycle");

    @Nonnull
    @Override
    public Class<MaintenancePlan> getType()
    {
        return MaintenancePlan.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     */
    public void setMaintenancePlan( @Nullable final String maintenancePlan )
    {
        rememberChangedField("MaintenancePlan", this.maintenancePlan);
        this.maintenancePlan = maintenancePlan;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanDesc</b>
     * </p>
     *
     * @param maintenancePlanDesc
     *            Maintenance Plan Text
     */
    public void setMaintenancePlanDesc( @Nullable final String maintenancePlanDesc )
    {
        rememberChangedField("MaintenancePlanDesc", this.maintenancePlanDesc);
        this.maintenancePlanDesc = maintenancePlanDesc;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Date of creation
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStrategy</b>
     * </p>
     *
     * @param maintenanceStrategy
     *            Maintenance Strategy
     */
    public void setMaintenanceStrategy( @Nullable final String maintenanceStrategy )
    {
        rememberChangedField("MaintenanceStrategy", this.maintenanceStrategy);
        this.maintenanceStrategy = maintenanceStrategy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingDuration</b>
     * </p>
     *
     * @param schedulingDuration
     *            Scheduling Period
     */
    public void setSchedulingDuration( @Nullable final String schedulingDuration )
    {
        rememberChangedField("SchedulingDuration", this.schedulingDuration);
        this.schedulingDuration = schedulingDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingDurationUnit</b>
     * </p>
     *
     * @param schedulingDurationUnit
     *            Unit for Scheduling Period
     */
    public void setSchedulingDurationUnit( @Nullable final String schedulingDurationUnit )
    {
        rememberChangedField("SchedulingDurationUnit", this.schedulingDurationUnit);
        this.schedulingDurationUnit = schedulingDurationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>NumberOfMaintenanceItems</b>
     * </p>
     *
     * @param numberOfMaintenanceItems
     *            Number of maintenance items in the maintenance plan
     */
    public void setNumberOfMaintenanceItems( @Nullable final String numberOfMaintenanceItems )
    {
        rememberChangedField("NumberOfMaintenanceItems", this.numberOfMaintenanceItems);
        this.numberOfMaintenanceItems = numberOfMaintenanceItems;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CycleModificationRatio</b>
     * </p>
     *
     * @param cycleModificationRatio
     *            Cycle modification factor
     */
    public void setCycleModificationRatio( @Nullable final BigDecimal cycleModificationRatio )
    {
        rememberChangedField("CycleModificationRatio", this.cycleModificationRatio);
        this.cycleModificationRatio = cycleModificationRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanSchedgIndicator</b>
     * </p>
     *
     * @param maintPlanSchedgIndicator
     *            Scheduling indicator
     */
    public void setMaintPlanSchedgIndicator( @Nullable final String maintPlanSchedgIndicator )
    {
        rememberChangedField("MaintPlanSchedgIndicator", this.maintPlanSchedgIndicator);
        this.maintPlanSchedgIndicator = maintPlanSchedgIndicator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CallHorizonPercent</b>
     * </p>
     *
     * @param callHorizonPercent
     *            Call horizon for maintenance plan calls
     */
    public void setCallHorizonPercent( @Nullable final String callHorizonPercent )
    {
        rememberChangedField("CallHorizonPercent", this.callHorizonPercent);
        this.callHorizonPercent = callHorizonPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CallHorizonInDays</b>
     * </p>
     *
     * @param callHorizonInDays
     *            Call horizon for maintenance plan calls
     */
    public void setCallHorizonInDays( @Nullable final String callHorizonInDays )
    {
        rememberChangedField("CallHorizonInDays", this.callHorizonInDays);
        this.callHorizonInDays = callHorizonInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceCallHorizonCalcType</b>
     * </p>
     *
     * @param maintenanceCallHorizonCalcType
     *            Calculation Type of Call Horizon
     */
    public void setMaintenanceCallHorizonCalcType( @Nullable final String maintenanceCallHorizonCalcType )
    {
        rememberChangedField("MaintenanceCallHorizonCalcType", this.maintenanceCallHorizonCalcType);
        this.maintenanceCallHorizonCalcType = maintenanceCallHorizonCalcType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @param authorizationGroup
     *            Technical Object Authorization Group
     */
    public void setAuthorizationGroup( @Nullable final String authorizationGroup )
    {
        rememberChangedField("AuthorizationGroup", this.authorizationGroup);
        this.authorizationGroup = authorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanInternalID</b>
     * </p>
     *
     * @param maintenancePlanInternalID
     *            Object Number
     */
    public void setMaintenancePlanInternalID( @Nullable final String maintenancePlanInternalID )
    {
        rememberChangedField("MaintenancePlanInternalID", this.maintenancePlanInternalID);
        this.maintenancePlanInternalID = maintenancePlanInternalID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceCall</b>
     * </p>
     *
     * @param maintenanceCall
     *            Maintenance Plan Call Number
     */
    public void setMaintenanceCall( @Nullable final Integer maintenanceCall )
    {
        rememberChangedField("MaintenanceCall", this.maintenanceCall);
        this.maintenanceCall = maintenanceCall;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCategory</b>
     * </p>
     *
     * @param maintenancePlanCategory
     *            Maintenance plan category
     */
    public void setMaintenancePlanCategory( @Nullable final String maintenancePlanCategory )
    {
        rememberChangedField("MaintenancePlanCategory", this.maintenancePlanCategory);
        this.maintenancePlanCategory = maintenancePlanCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanFreeDefinedAttrib</b>
     * </p>
     *
     * @param maintPlanFreeDefinedAttrib
     *            Sort field for maintenance plans
     */
    public void setMaintPlanFreeDefinedAttrib( @Nullable final String maintPlanFreeDefinedAttrib )
    {
        rememberChangedField("MaintPlanFreeDefinedAttrib", this.maintPlanFreeDefinedAttrib);
        this.maintPlanFreeDefinedAttrib = maintPlanFreeDefinedAttrib;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BasicStartDate</b>
     * </p>
     *
     * @param basicStartDate
     *            Start date
     */
    public void setBasicStartDate( @Nullable final LocalDateTime basicStartDate )
    {
        rememberChangedField("BasicStartDate", this.basicStartDate);
        this.basicStartDate = basicStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingStartDate</b>
     * </p>
     *
     * @param schedulingStartDate
     *            Start Date for Scheduling
     */
    public void setSchedulingStartDate( @Nullable final LocalDateTime schedulingStartDate )
    {
        rememberChangedField("SchedulingStartDate", this.schedulingStartDate);
        this.schedulingStartDate = schedulingStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingStartTime</b>
     * </p>
     *
     * @param schedulingStartTime
     *            Start Time for Scheduling
     */
    public void setSchedulingStartTime( @Nullable final LocalTime schedulingStartTime )
    {
        rememberChangedField("SchedulingStartTime", this.schedulingStartTime);
        this.schedulingStartTime = schedulingStartTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanStartCntrReadingValue</b>
     * </p>
     *
     * @param maintPlanStartCntrReadingValue
     *            The maintPlanStartCntrReadingValue to set.
     */
    public void setMaintPlanStartCntrReadingValue( @Nullable final String maintPlanStartCntrReadingValue )
    {
        rememberChangedField("MaintPlanStartCntrReadingValue", this.maintPlanStartCntrReadingValue);
        this.maintPlanStartCntrReadingValue = maintPlanStartCntrReadingValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlnStrtBufDurationInDays</b>
     * </p>
     *
     * @param maintPlnStrtBufDurationInDays
     *            Scheduling to reoccur when lead float reached
     */
    public void setMaintPlnStrtBufDurationInDays( @Nullable final String maintPlnStrtBufDurationInDays )
    {
        rememberChangedField("MaintPlnStrtBufDurationInDays", this.maintPlnStrtBufDurationInDays);
        this.maintPlnStrtBufDurationInDays = maintPlnStrtBufDurationInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanStartBufferUnit</b>
     * </p>
     *
     * @param maintPlanStartBufferUnit
     *            Unit for Scheduling Period
     */
    public void setMaintPlanStartBufferUnit( @Nullable final String maintPlanStartBufferUnit )
    {
        rememberChangedField("MaintPlanStartBufferUnit", this.maintPlanStartBufferUnit);
        this.maintPlanStartBufferUnit = maintPlanStartBufferUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @param factoryCalendar
     *            Factory calendar key
     */
    public void setFactoryCalendar( @Nullable final String factoryCalendar )
    {
        rememberChangedField("FactoryCalendar", this.factoryCalendar);
        this.factoryCalendar = factoryCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LateCompletionShiftInPercent</b>
     * </p>
     *
     * @param lateCompletionShiftInPercent
     *            Shift Factor for Late Completion
     */
    public void setLateCompletionShiftInPercent( @Nullable final String lateCompletionShiftInPercent )
    {
        rememberChangedField("LateCompletionShiftInPercent", this.lateCompletionShiftInPercent);
        this.lateCompletionShiftInPercent = lateCompletionShiftInPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LateCompletionTolerancePercent</b>
     * </p>
     *
     * @param lateCompletionTolerancePercent
     *            Tolerance for Late Completion (%)
     */
    public void setLateCompletionTolerancePercent( @Nullable final String lateCompletionTolerancePercent )
    {
        rememberChangedField("LateCompletionTolerancePercent", this.lateCompletionTolerancePercent);
        this.lateCompletionTolerancePercent = lateCompletionTolerancePercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EarlyCompletionShiftInPercent</b>
     * </p>
     *
     * @param earlyCompletionShiftInPercent
     *            Shift Factor for Early Completion
     */
    public void setEarlyCompletionShiftInPercent( @Nullable final String earlyCompletionShiftInPercent )
    {
        rememberChangedField("EarlyCompletionShiftInPercent", this.earlyCompletionShiftInPercent);
        this.earlyCompletionShiftInPercent = earlyCompletionShiftInPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EarlyCompletionTolerancePct</b>
     * </p>
     *
     * @param earlyCompletionTolerancePct
     *            Tolerance for Early Completion (%)
     */
    public void setEarlyCompletionTolerancePct( @Nullable final String earlyCompletionTolerancePct )
    {
        rememberChangedField("EarlyCompletionTolerancePct", this.earlyCompletionTolerancePct);
        this.earlyCompletionTolerancePct = earlyCompletionTolerancePct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrCallObjCompltnIsRqd</b>
     * </p>
     *
     * @param prdcssrCallObjCompltnIsRqd
     *            Only Create New Call Object After Completing Predecessor
     */
    public void setPrdcssrCallObjCompltnIsRqd( @Nullable final String prdcssrCallObjCompltnIsRqd )
    {
        rememberChangedField("PrdcssrCallObjCompltnIsRqd", this.prdcssrCallObjCompltnIsRqd);
        this.prdcssrCallObjCompltnIsRqd = prdcssrCallObjCompltnIsRqd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanLogicalOperatorCode</b>
     * </p>
     *
     * @param maintPlanLogicalOperatorCode
     *            Indicator for OR or AND link
     */
    public void setMaintPlanLogicalOperatorCode( @Nullable final String maintPlanLogicalOperatorCode )
    {
        rememberChangedField("MaintPlanLogicalOperatorCode", this.maintPlanLogicalOperatorCode);
        this.maintPlanLogicalOperatorCode = maintPlanLogicalOperatorCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingEndDate</b>
     * </p>
     *
     * @param schedulingEndDate
     *            End Date for Scheduling
     */
    public void setSchedulingEndDate( @Nullable final LocalDateTime schedulingEndDate )
    {
        rememberChangedField("SchedulingEndDate", this.schedulingEndDate);
        this.schedulingEndDate = schedulingEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanEndCntrReadingValue</b>
     * </p>
     *
     * @param maintPlanEndCntrReadingValue
     *            The maintPlanEndCntrReadingValue to set.
     */
    public void setMaintPlanEndCntrReadingValue( @Nullable final String maintPlanEndCntrReadingValue )
    {
        rememberChangedField("MaintPlanEndCntrReadingValue", this.maintPlanEndCntrReadingValue);
        this.maintPlanEndCntrReadingValue = maintPlanEndCntrReadingValue;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MultipleCounterPlanShiftFactor</b>
     * </p>
     *
     * @param multipleCounterPlanShiftFactor
     *            Shift Factor for Multiple Counter Plan
     */
    public void setMultipleCounterPlanShiftFactor( @Nullable final String multipleCounterPlanShiftFactor )
    {
        rememberChangedField("MultipleCounterPlanShiftFactor", this.multipleCounterPlanShiftFactor);
        this.multipleCounterPlanShiftFactor = multipleCounterPlanShiftFactor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceLeadFloatInDays</b>
     * </p>
     *
     * @param maintenanceLeadFloatInDays
     *            Lead Float in Days
     */
    public void setMaintenanceLeadFloatInDays( @Nullable final String maintenanceLeadFloatInDays )
    {
        rememberChangedField("MaintenanceLeadFloatInDays", this.maintenanceLeadFloatInDays);
        this.maintenanceLeadFloatInDays = maintenanceLeadFloatInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCallObject</b>
     * </p>
     *
     * @param maintenancePlanCallObject
     *            Call object for maintenance plan
     */
    public void setMaintenancePlanCallObject( @Nullable final String maintenancePlanCallObject )
    {
        rememberChangedField("MaintenancePlanCallObject", this.maintenancePlanCallObject);
        this.maintenancePlanCallObject = maintenancePlanCallObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanSystemStatus</b>
     * </p>
     *
     * @param maintenancePlanSystemStatus
     *            Text
     */
    public void setMaintenancePlanSystemStatus( @Nullable final String maintenancePlanSystemStatus )
    {
        rememberChangedField("MaintenancePlanSystemStatus", this.maintenancePlanSystemStatus);
        this.maintenancePlanSystemStatus = maintenancePlanSystemStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenancePlan";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenancePlan", getMaintenancePlan());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenancePlan", getMaintenancePlan());
        values.put("MaintenancePlanDesc", getMaintenancePlanDesc());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("MaintenanceStrategy", getMaintenanceStrategy());
        values.put("SchedulingDuration", getSchedulingDuration());
        values.put("SchedulingDurationUnit", getSchedulingDurationUnit());
        values.put("NumberOfMaintenanceItems", getNumberOfMaintenanceItems());
        values.put("CycleModificationRatio", getCycleModificationRatio());
        values.put("MaintPlanSchedgIndicator", getMaintPlanSchedgIndicator());
        values.put("CallHorizonPercent", getCallHorizonPercent());
        values.put("CallHorizonInDays", getCallHorizonInDays());
        values.put("MaintenanceCallHorizonCalcType", getMaintenanceCallHorizonCalcType());
        values.put("AuthorizationGroup", getAuthorizationGroup());
        values.put("MaintenancePlanInternalID", getMaintenancePlanInternalID());
        values.put("MaintenanceCall", getMaintenanceCall());
        values.put("MaintenancePlanCategory", getMaintenancePlanCategory());
        values.put("MaintPlanFreeDefinedAttrib", getMaintPlanFreeDefinedAttrib());
        values.put("BasicStartDate", getBasicStartDate());
        values.put("SchedulingStartDate", getSchedulingStartDate());
        values.put("SchedulingStartTime", getSchedulingStartTime());
        values.put("MaintPlanStartCntrReadingValue", getMaintPlanStartCntrReadingValue());
        values.put("MaintPlnStrtBufDurationInDays", getMaintPlnStrtBufDurationInDays());
        values.put("MaintPlanStartBufferUnit", getMaintPlanStartBufferUnit());
        values.put("FactoryCalendar", getFactoryCalendar());
        values.put("LateCompletionShiftInPercent", getLateCompletionShiftInPercent());
        values.put("LateCompletionTolerancePercent", getLateCompletionTolerancePercent());
        values.put("EarlyCompletionShiftInPercent", getEarlyCompletionShiftInPercent());
        values.put("EarlyCompletionTolerancePct", getEarlyCompletionTolerancePct());
        values.put("PrdcssrCallObjCompltnIsRqd", getPrdcssrCallObjCompltnIsRqd());
        values.put("MaintPlanLogicalOperatorCode", getMaintPlanLogicalOperatorCode());
        values.put("SchedulingEndDate", getSchedulingEndDate());
        values.put("MaintPlanEndCntrReadingValue", getMaintPlanEndCntrReadingValue());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("MultipleCounterPlanShiftFactor", getMultipleCounterPlanShiftFactor());
        values.put("MaintenanceLeadFloatInDays", getMaintenanceLeadFloatInDays());
        values.put("MaintenancePlanCallObject", getMaintenancePlanCallObject());
        values.put("MaintenancePlanSystemStatus", getMaintenancePlanSystemStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenancePlan") ) {
                final Object value = values.remove("MaintenancePlan");
                if( (value == null) || (!value.equals(getMaintenancePlan())) ) {
                    setMaintenancePlan(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanDesc") ) {
                final Object value = values.remove("MaintenancePlanDesc");
                if( (value == null) || (!value.equals(getMaintenancePlanDesc())) ) {
                    setMaintenancePlanDesc(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("MaintenanceStrategy") ) {
                final Object value = values.remove("MaintenanceStrategy");
                if( (value == null) || (!value.equals(getMaintenanceStrategy())) ) {
                    setMaintenanceStrategy(((String) value));
                }
            }
            if( values.containsKey("SchedulingDuration") ) {
                final Object value = values.remove("SchedulingDuration");
                if( (value == null) || (!value.equals(getSchedulingDuration())) ) {
                    setSchedulingDuration(((String) value));
                }
            }
            if( values.containsKey("SchedulingDurationUnit") ) {
                final Object value = values.remove("SchedulingDurationUnit");
                if( (value == null) || (!value.equals(getSchedulingDurationUnit())) ) {
                    setSchedulingDurationUnit(((String) value));
                }
            }
            if( values.containsKey("NumberOfMaintenanceItems") ) {
                final Object value = values.remove("NumberOfMaintenanceItems");
                if( (value == null) || (!value.equals(getNumberOfMaintenanceItems())) ) {
                    setNumberOfMaintenanceItems(((String) value));
                }
            }
            if( values.containsKey("CycleModificationRatio") ) {
                final Object value = values.remove("CycleModificationRatio");
                if( (value == null) || (!value.equals(getCycleModificationRatio())) ) {
                    setCycleModificationRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaintPlanSchedgIndicator") ) {
                final Object value = values.remove("MaintPlanSchedgIndicator");
                if( (value == null) || (!value.equals(getMaintPlanSchedgIndicator())) ) {
                    setMaintPlanSchedgIndicator(((String) value));
                }
            }
            if( values.containsKey("CallHorizonPercent") ) {
                final Object value = values.remove("CallHorizonPercent");
                if( (value == null) || (!value.equals(getCallHorizonPercent())) ) {
                    setCallHorizonPercent(((String) value));
                }
            }
            if( values.containsKey("CallHorizonInDays") ) {
                final Object value = values.remove("CallHorizonInDays");
                if( (value == null) || (!value.equals(getCallHorizonInDays())) ) {
                    setCallHorizonInDays(((String) value));
                }
            }
            if( values.containsKey("MaintenanceCallHorizonCalcType") ) {
                final Object value = values.remove("MaintenanceCallHorizonCalcType");
                if( (value == null) || (!value.equals(getMaintenanceCallHorizonCalcType())) ) {
                    setMaintenanceCallHorizonCalcType(((String) value));
                }
            }
            if( values.containsKey("AuthorizationGroup") ) {
                final Object value = values.remove("AuthorizationGroup");
                if( (value == null) || (!value.equals(getAuthorizationGroup())) ) {
                    setAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanInternalID") ) {
                final Object value = values.remove("MaintenancePlanInternalID");
                if( (value == null) || (!value.equals(getMaintenancePlanInternalID())) ) {
                    setMaintenancePlanInternalID(((String) value));
                }
            }
            if( values.containsKey("MaintenanceCall") ) {
                final Object value = values.remove("MaintenanceCall");
                if( (value == null) || (!value.equals(getMaintenanceCall())) ) {
                    setMaintenanceCall(((Integer) value));
                }
            }
            if( values.containsKey("MaintenancePlanCategory") ) {
                final Object value = values.remove("MaintenancePlanCategory");
                if( (value == null) || (!value.equals(getMaintenancePlanCategory())) ) {
                    setMaintenancePlanCategory(((String) value));
                }
            }
            if( values.containsKey("MaintPlanFreeDefinedAttrib") ) {
                final Object value = values.remove("MaintPlanFreeDefinedAttrib");
                if( (value == null) || (!value.equals(getMaintPlanFreeDefinedAttrib())) ) {
                    setMaintPlanFreeDefinedAttrib(((String) value));
                }
            }
            if( values.containsKey("BasicStartDate") ) {
                final Object value = values.remove("BasicStartDate");
                if( (value == null) || (!value.equals(getBasicStartDate())) ) {
                    setBasicStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SchedulingStartDate") ) {
                final Object value = values.remove("SchedulingStartDate");
                if( (value == null) || (!value.equals(getSchedulingStartDate())) ) {
                    setSchedulingStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SchedulingStartTime") ) {
                final Object value = values.remove("SchedulingStartTime");
                if( (value == null) || (!value.equals(getSchedulingStartTime())) ) {
                    setSchedulingStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MaintPlanStartCntrReadingValue") ) {
                final Object value = values.remove("MaintPlanStartCntrReadingValue");
                if( (value == null) || (!value.equals(getMaintPlanStartCntrReadingValue())) ) {
                    setMaintPlanStartCntrReadingValue(((String) value));
                }
            }
            if( values.containsKey("MaintPlnStrtBufDurationInDays") ) {
                final Object value = values.remove("MaintPlnStrtBufDurationInDays");
                if( (value == null) || (!value.equals(getMaintPlnStrtBufDurationInDays())) ) {
                    setMaintPlnStrtBufDurationInDays(((String) value));
                }
            }
            if( values.containsKey("MaintPlanStartBufferUnit") ) {
                final Object value = values.remove("MaintPlanStartBufferUnit");
                if( (value == null) || (!value.equals(getMaintPlanStartBufferUnit())) ) {
                    setMaintPlanStartBufferUnit(((String) value));
                }
            }
            if( values.containsKey("FactoryCalendar") ) {
                final Object value = values.remove("FactoryCalendar");
                if( (value == null) || (!value.equals(getFactoryCalendar())) ) {
                    setFactoryCalendar(((String) value));
                }
            }
            if( values.containsKey("LateCompletionShiftInPercent") ) {
                final Object value = values.remove("LateCompletionShiftInPercent");
                if( (value == null) || (!value.equals(getLateCompletionShiftInPercent())) ) {
                    setLateCompletionShiftInPercent(((String) value));
                }
            }
            if( values.containsKey("LateCompletionTolerancePercent") ) {
                final Object value = values.remove("LateCompletionTolerancePercent");
                if( (value == null) || (!value.equals(getLateCompletionTolerancePercent())) ) {
                    setLateCompletionTolerancePercent(((String) value));
                }
            }
            if( values.containsKey("EarlyCompletionShiftInPercent") ) {
                final Object value = values.remove("EarlyCompletionShiftInPercent");
                if( (value == null) || (!value.equals(getEarlyCompletionShiftInPercent())) ) {
                    setEarlyCompletionShiftInPercent(((String) value));
                }
            }
            if( values.containsKey("EarlyCompletionTolerancePct") ) {
                final Object value = values.remove("EarlyCompletionTolerancePct");
                if( (value == null) || (!value.equals(getEarlyCompletionTolerancePct())) ) {
                    setEarlyCompletionTolerancePct(((String) value));
                }
            }
            if( values.containsKey("PrdcssrCallObjCompltnIsRqd") ) {
                final Object value = values.remove("PrdcssrCallObjCompltnIsRqd");
                if( (value == null) || (!value.equals(getPrdcssrCallObjCompltnIsRqd())) ) {
                    setPrdcssrCallObjCompltnIsRqd(((String) value));
                }
            }
            if( values.containsKey("MaintPlanLogicalOperatorCode") ) {
                final Object value = values.remove("MaintPlanLogicalOperatorCode");
                if( (value == null) || (!value.equals(getMaintPlanLogicalOperatorCode())) ) {
                    setMaintPlanLogicalOperatorCode(((String) value));
                }
            }
            if( values.containsKey("SchedulingEndDate") ) {
                final Object value = values.remove("SchedulingEndDate");
                if( (value == null) || (!value.equals(getSchedulingEndDate())) ) {
                    setSchedulingEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaintPlanEndCntrReadingValue") ) {
                final Object value = values.remove("MaintPlanEndCntrReadingValue");
                if( (value == null) || (!value.equals(getMaintPlanEndCntrReadingValue())) ) {
                    setMaintPlanEndCntrReadingValue(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("MultipleCounterPlanShiftFactor") ) {
                final Object value = values.remove("MultipleCounterPlanShiftFactor");
                if( (value == null) || (!value.equals(getMultipleCounterPlanShiftFactor())) ) {
                    setMultipleCounterPlanShiftFactor(((String) value));
                }
            }
            if( values.containsKey("MaintenanceLeadFloatInDays") ) {
                final Object value = values.remove("MaintenanceLeadFloatInDays");
                if( (value == null) || (!value.equals(getMaintenanceLeadFloatInDays())) ) {
                    setMaintenanceLeadFloatInDays(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanCallObject") ) {
                final Object value = values.remove("MaintenancePlanCallObject");
                if( (value == null) || (!value.equals(getMaintenancePlanCallObject())) ) {
                    setMaintenancePlanCallObject(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanSystemStatus") ) {
                final Object value = values.remove("MaintenancePlanSystemStatus");
                if( (value == null) || (!value.equals(getMaintenancePlanSystemStatus())) ) {
                    setMaintenancePlanSystemStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenanceItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new MaintenanceItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_LongText") ) {
                final Object value = (values).remove("to_LongText");
                if( value instanceof Iterable ) {
                    if( toLongText == null ) {
                        toLongText = Lists.newArrayList();
                    } else {
                        toLongText = Lists.newArrayList(toLongText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenancePlanText entity;
                        if( toLongText.size() > i ) {
                            entity = toLongText.get(i);
                        } else {
                            entity = new MaintenancePlanText();
                            toLongText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintenanceCycle") ) {
                final Object value = (values).remove("to_MaintenanceCycle");
                if( value instanceof Iterable ) {
                    if( toMaintenanceCycle == null ) {
                        toMaintenanceCycle = Lists.newArrayList();
                    } else {
                        toMaintenanceCycle = Lists.newArrayList(toMaintenanceCycle);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenancePlanCycle entity;
                        if( toMaintenanceCycle.size() > i ) {
                            entity = toMaintenanceCycle.get(i);
                        } else {
                            entity = new MaintenancePlanCycle();
                            toMaintenanceCycle.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_MaintPlanClfnClass") ) {
                final Object value = (values).remove("to_MaintPlanClfnClass");
                if( value instanceof Iterable ) {
                    if( toMaintPlanClfnClass == null ) {
                        toMaintPlanClfnClass = Lists.newArrayList();
                    } else {
                        toMaintPlanClfnClass = Lists.newArrayList(toMaintPlanClfnClass);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintPlanClfnClass entity;
                        if( toMaintPlanClfnClass.size() > i ) {
                            entity = toMaintPlanClfnClass.get(i);
                        } else {
                            entity = new MaintPlanClfnClass();
                            toMaintPlanClfnClass.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Schedules") ) {
                final Object value = (values).remove("to_Schedules");
                if( value instanceof Iterable ) {
                    if( toSchedules == null ) {
                        toSchedules = Lists.newArrayList();
                    } else {
                        toSchedules = Lists.newArrayList(toSchedules);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenancePlanSchedule entity;
                        if( toSchedules.size() > i ) {
                            entity = toSchedules.get(i);
                        } else {
                            entity = new MaintenancePlanSchedule();
                            toSchedules.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_StrategyCycle") ) {
                final Object value = (values).remove("to_StrategyCycle");
                if( value instanceof Iterable ) {
                    if( toStrategyCycle == null ) {
                        toStrategyCycle = Lists.newArrayList();
                    } else {
                        toStrategyCycle = Lists.newArrayList(toStrategyCycle);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenancePlanStrategyCycle entity;
                        if( toStrategyCycle.size() > i ) {
                            entity = toStrategyCycle.get(i);
                        } else {
                            entity = new MaintenancePlanStrategyCycle();
                            toStrategyCycle.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintenancePlanField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintenancePlanField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenancePlanField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenancePlanField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toLongText != null ) {
            (values).put("to_LongText", toLongText);
        }
        if( toMaintenanceCycle != null ) {
            (values).put("to_MaintenanceCycle", toMaintenanceCycle);
        }
        if( toMaintPlanClfnClass != null ) {
            (values).put("to_MaintPlanClfnClass", toMaintPlanClfnClass);
        }
        if( toSchedules != null ) {
            (values).put("to_Schedules", toSchedules);
        }
        if( toStrategyCycle != null ) {
            (values).put("to_StrategyCycle", toStrategyCycle);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenanceItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenanceItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", MaintenanceItem.class);
    }

    /**
     * Retrieval of associated <b>MaintenanceItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenanceItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenanceItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>MaintenanceItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenancePlan</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>MaintenanceItem</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<MaintenanceItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>MaintenanceItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenanceItem</b> entities.
     */
    public void setItem( @Nonnull final List<MaintenanceItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenanceItem</b> entities. This corresponds to the OData navigation
     * property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenanceItem</b> entities.
     */
    public void addItem( MaintenanceItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintenancePlanText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_LongText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenancePlanText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenancePlanText> fetchLongText()
    {
        return fetchFieldAsList("to_LongText", MaintenancePlanText.class);
    }

    /**
     * Retrieval of associated <b>MaintenancePlanText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LongText</b>.
     * <p>
     * If the navigation property <b>to_LongText</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenancePlanText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenancePlanText> getLongTextOrFetch()
    {
        if( toLongText == null ) {
            toLongText = fetchLongText();
        }
        return toLongText;
    }

    /**
     * Retrieval of associated <b>MaintenancePlanText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LongText</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenancePlan</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LongText</b> is already loaded, the result will contain
     *         the <b>MaintenancePlanText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenancePlanText>> getLongTextIfPresent()
    {
        return Option.of(toLongText);
    }

    /**
     * Overwrites the list of associated <b>MaintenancePlanText</b> entities for the loaded navigation property
     * <b>to_LongText</b>.
     * <p>
     * If the navigation property <b>to_LongText</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenancePlanText</b> entities.
     */
    public void setLongText( @Nonnull final List<MaintenancePlanText> value )
    {
        if( toLongText == null ) {
            toLongText = Lists.newArrayList();
        }
        toLongText.clear();
        toLongText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenancePlanText</b> entities. This corresponds to the OData
     * navigation property <b>to_LongText</b>.
     * <p>
     * If the navigation property <b>to_LongText</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenancePlanText</b> entities.
     */
    public void addLongText( MaintenancePlanText... entity )
    {
        if( toLongText == null ) {
            toLongText = Lists.newArrayList();
        }
        toLongText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintenancePlanCycle</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_MaintenanceCycle</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenancePlanCycle</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenancePlanCycle> fetchMaintenanceCycle()
    {
        return fetchFieldAsList("to_MaintenanceCycle", MaintenancePlanCycle.class);
    }

    /**
     * Retrieval of associated <b>MaintenancePlanCycle</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceCycle</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceCycle</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenancePlanCycle</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenancePlanCycle> getMaintenanceCycleOrFetch()
    {
        if( toMaintenanceCycle == null ) {
            toMaintenanceCycle = fetchMaintenanceCycle();
        }
        return toMaintenanceCycle;
    }

    /**
     * Retrieval of associated <b>MaintenancePlanCycle</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenanceCycle</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenancePlan</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenanceCycle</b> is already loaded, the result will
     *         contain the <b>MaintenancePlanCycle</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenancePlanCycle>> getMaintenanceCycleIfPresent()
    {
        return Option.of(toMaintenanceCycle);
    }

    /**
     * Overwrites the list of associated <b>MaintenancePlanCycle</b> entities for the loaded navigation property
     * <b>to_MaintenanceCycle</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceCycle</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenancePlanCycle</b> entities.
     */
    public void setMaintenanceCycle( @Nonnull final List<MaintenancePlanCycle> value )
    {
        if( toMaintenanceCycle == null ) {
            toMaintenanceCycle = Lists.newArrayList();
        }
        toMaintenanceCycle.clear();
        toMaintenanceCycle.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenancePlanCycle</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintenanceCycle</b>.
     * <p>
     * If the navigation property <b>to_MaintenanceCycle</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenancePlanCycle</b> entities.
     */
    public void addMaintenanceCycle( MaintenancePlanCycle... entity )
    {
        if( toMaintenanceCycle == null ) {
            toMaintenanceCycle = Lists.newArrayList();
        }
        toMaintenanceCycle.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintPlanClfnClass</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_MaintPlanClfnClass</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintPlanClfnClass</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintPlanClfnClass> fetchMaintPlanClfnClass()
    {
        return fetchFieldAsList("to_MaintPlanClfnClass", MaintPlanClfnClass.class);
    }

    /**
     * Retrieval of associated <b>MaintPlanClfnClass</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintPlanClfnClass</b>.
     * <p>
     * If the navigation property <b>to_MaintPlanClfnClass</b> of a queried <b>MaintenancePlan</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintPlanClfnClass</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintPlanClfnClass> getMaintPlanClfnClassOrFetch()
    {
        if( toMaintPlanClfnClass == null ) {
            toMaintPlanClfnClass = fetchMaintPlanClfnClass();
        }
        return toMaintPlanClfnClass;
    }

    /**
     * Retrieval of associated <b>MaintPlanClfnClass</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintPlanClfnClass</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenancePlan</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintPlanClfnClass</b> is already loaded, the result
     *         will contain the <b>MaintPlanClfnClass</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintPlanClfnClass>> getMaintPlanClfnClassIfPresent()
    {
        return Option.of(toMaintPlanClfnClass);
    }

    /**
     * Overwrites the list of associated <b>MaintPlanClfnClass</b> entities for the loaded navigation property
     * <b>to_MaintPlanClfnClass</b>.
     * <p>
     * If the navigation property <b>to_MaintPlanClfnClass</b> of a queried <b>MaintenancePlan</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintPlanClfnClass</b> entities.
     */
    public void setMaintPlanClfnClass( @Nonnull final List<MaintPlanClfnClass> value )
    {
        if( toMaintPlanClfnClass == null ) {
            toMaintPlanClfnClass = Lists.newArrayList();
        }
        toMaintPlanClfnClass.clear();
        toMaintPlanClfnClass.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintPlanClfnClass</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintPlanClfnClass</b>.
     * <p>
     * If the navigation property <b>to_MaintPlanClfnClass</b> of a queried <b>MaintenancePlan</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintPlanClfnClass</b> entities.
     */
    public void addMaintPlanClfnClass( MaintPlanClfnClass... entity )
    {
        if( toMaintPlanClfnClass == null ) {
            toMaintPlanClfnClass = Lists.newArrayList();
        }
        toMaintPlanClfnClass.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintenancePlanSchedule</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Schedules</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenancePlanSchedule</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenancePlanSchedule> fetchSchedules()
    {
        return fetchFieldAsList("to_Schedules", MaintenancePlanSchedule.class);
    }

    /**
     * Retrieval of associated <b>MaintenancePlanSchedule</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Schedules</b>.
     * <p>
     * If the navigation property <b>to_Schedules</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenancePlanSchedule</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenancePlanSchedule> getSchedulesOrFetch()
    {
        if( toSchedules == null ) {
            toSchedules = fetchSchedules();
        }
        return toSchedules;
    }

    /**
     * Retrieval of associated <b>MaintenancePlanSchedule</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Schedules</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenancePlan</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Schedules</b> is already loaded, the result will contain
     *         the <b>MaintenancePlanSchedule</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenancePlanSchedule>> getSchedulesIfPresent()
    {
        return Option.of(toSchedules);
    }

    /**
     * Overwrites the list of associated <b>MaintenancePlanSchedule</b> entities for the loaded navigation property
     * <b>to_Schedules</b>.
     * <p>
     * If the navigation property <b>to_Schedules</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenancePlanSchedule</b> entities.
     */
    public void setSchedules( @Nonnull final List<MaintenancePlanSchedule> value )
    {
        if( toSchedules == null ) {
            toSchedules = Lists.newArrayList();
        }
        toSchedules.clear();
        toSchedules.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenancePlanSchedule</b> entities. This corresponds to the OData
     * navigation property <b>to_Schedules</b>.
     * <p>
     * If the navigation property <b>to_Schedules</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenancePlanSchedule</b> entities.
     */
    public void addSchedules( MaintenancePlanSchedule... entity )
    {
        if( toSchedules == null ) {
            toSchedules = Lists.newArrayList();
        }
        toSchedules.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>MaintenancePlanStrategyCycle</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_StrategyCycle</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenancePlanStrategyCycle</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenancePlanStrategyCycle> fetchStrategyCycle()
    {
        return fetchFieldAsList("to_StrategyCycle", MaintenancePlanStrategyCycle.class);
    }

    /**
     * Retrieval of associated <b>MaintenancePlanStrategyCycle</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StrategyCycle</b>.
     * <p>
     * If the navigation property <b>to_StrategyCycle</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenancePlanStrategyCycle</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenancePlanStrategyCycle> getStrategyCycleOrFetch()
    {
        if( toStrategyCycle == null ) {
            toStrategyCycle = fetchStrategyCycle();
        }
        return toStrategyCycle;
    }

    /**
     * Retrieval of associated <b>MaintenancePlanStrategyCycle</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_StrategyCycle</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenancePlan</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_StrategyCycle</b> is already loaded, the result will
     *         contain the <b>MaintenancePlanStrategyCycle</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenancePlanStrategyCycle>> getStrategyCycleIfPresent()
    {
        return Option.of(toStrategyCycle);
    }

    /**
     * Overwrites the list of associated <b>MaintenancePlanStrategyCycle</b> entities for the loaded navigation property
     * <b>to_StrategyCycle</b>.
     * <p>
     * If the navigation property <b>to_StrategyCycle</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenancePlanStrategyCycle</b> entities.
     */
    public void setStrategyCycle( @Nonnull final List<MaintenancePlanStrategyCycle> value )
    {
        if( toStrategyCycle == null ) {
            toStrategyCycle = Lists.newArrayList();
        }
        toStrategyCycle.clear();
        toStrategyCycle.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenancePlanStrategyCycle</b> entities. This corresponds to the
     * OData navigation property <b>to_StrategyCycle</b>.
     * <p>
     * If the navigation property <b>to_StrategyCycle</b> of a queried <b>MaintenancePlan</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenancePlanStrategyCycle</b> entities.
     */
    public void addStrategyCycle( MaintenancePlanStrategyCycle... entity )
    {
        if( toStrategyCycle == null ) {
            toStrategyCycle = Lists.newArrayList();
        }
        toStrategyCycle.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintenancePlan instances.
     *
     */
    public final static class MaintenancePlanBuilder
    {

        private List<MaintenanceItem> toItem = Lists.newArrayList();
        private List<MaintenancePlanText> toLongText = Lists.newArrayList();
        private List<MaintenancePlanCycle> toMaintenanceCycle = Lists.newArrayList();
        private List<MaintPlanClfnClass> toMaintPlanClfnClass = Lists.newArrayList();
        private List<MaintenancePlanSchedule> toSchedules = Lists.newArrayList();
        private List<MaintenancePlanStrategyCycle> toStrategyCycle = Lists.newArrayList();

        private MaintenancePlan.MaintenancePlanBuilder toItem( final List<MaintenanceItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>MaintenancePlan</b> to multiple <b>MaintenanceItem</b>.
         *
         * @param value
         *            The MaintenanceItems to build this MaintenancePlan with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenancePlan.MaintenancePlanBuilder item( MaintenanceItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

        private MaintenancePlan.MaintenancePlanBuilder toLongText( final List<MaintenancePlanText> value )
        {
            toLongText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LongText</b> for <b>MaintenancePlan</b> to multiple <b>MaintenancePlanText</b>.
         *
         * @param value
         *            The MaintenancePlanTexts to build this MaintenancePlan with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenancePlan.MaintenancePlanBuilder longText( MaintenancePlanText... value )
        {
            return toLongText(Lists.newArrayList(value));
        }

        private MaintenancePlan.MaintenancePlanBuilder toMaintenanceCycle( final List<MaintenancePlanCycle> value )
        {
            toMaintenanceCycle.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintenanceCycle</b> for <b>MaintenancePlan</b> to multiple
         * <b>MaintenancePlanCycle</b>.
         *
         * @param value
         *            The MaintenancePlanCycles to build this MaintenancePlan with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenancePlan.MaintenancePlanBuilder maintenanceCycle( MaintenancePlanCycle... value )
        {
            return toMaintenanceCycle(Lists.newArrayList(value));
        }

        private MaintenancePlan.MaintenancePlanBuilder toMaintPlanClfnClass( final List<MaintPlanClfnClass> value )
        {
            toMaintPlanClfnClass.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintPlanClfnClass</b> for <b>MaintenancePlan</b> to multiple
         * <b>MaintPlanClfnClass</b>.
         *
         * @param value
         *            The MaintPlanClfnClasss to build this MaintenancePlan with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenancePlan.MaintenancePlanBuilder maintPlanClfnClass( MaintPlanClfnClass... value )
        {
            return toMaintPlanClfnClass(Lists.newArrayList(value));
        }

        private MaintenancePlan.MaintenancePlanBuilder toSchedules( final List<MaintenancePlanSchedule> value )
        {
            toSchedules.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Schedules</b> for <b>MaintenancePlan</b> to multiple
         * <b>MaintenancePlanSchedule</b>.
         *
         * @param value
         *            The MaintenancePlanSchedules to build this MaintenancePlan with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenancePlan.MaintenancePlanBuilder schedules( MaintenancePlanSchedule... value )
        {
            return toSchedules(Lists.newArrayList(value));
        }

        private MaintenancePlan.MaintenancePlanBuilder toStrategyCycle( final List<MaintenancePlanStrategyCycle> value )
        {
            toStrategyCycle.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_StrategyCycle</b> for <b>MaintenancePlan</b> to multiple
         * <b>MaintenancePlanStrategyCycle</b>.
         *
         * @param value
         *            The MaintenancePlanStrategyCycles to build this MaintenancePlan with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenancePlan.MaintenancePlanBuilder strategyCycle( MaintenancePlanStrategyCycle... value )
        {
            return toStrategyCycle(Lists.newArrayList(value));
        }

    }

}
