/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintenancePlanCycleField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintenancePlanCycleOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintenancePlanCycleSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Plan Cycle
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenancePlanCycleType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenancePlanCycle extends VdmEntity<MaintenancePlanCycle>
{

    /**
     * Selector for all available fields of MaintenancePlanCycle.
     *
     */
    public final static MaintenancePlanCycleSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @return Maintenance Plan
     */
    @Key
    @SerializedName( "MaintenancePlan" )
    @JsonProperty( "MaintenancePlan" )
    @Nullable
    @ODataField( odataName = "MaintenancePlan" )
    private String maintenancePlan;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlan</b> field to query operations.
     *
     */
    public final static MaintenancePlanCycleField<String> MAINTENANCE_PLAN =
        new MaintenancePlanCycleField<String>("MaintenancePlan");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCycle</b>
     * </p>
     *
     * @return Counter in Control Tables
     */
    @Key
    @SerializedName( "MaintenancePlanCycle" )
    @JsonProperty( "MaintenancePlanCycle" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanCycle" )
    private String maintenancePlanCycle;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanCycle</b> field to query operations.
     *
     */
    public final static MaintenancePlanCycleField<String> MAINTENANCE_PLAN_CYCLE =
        new MaintenancePlanCycleField<String>("MaintenancePlanCycle");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStrategy</b>
     * </p>
     *
     * @return Maintenance Strategy
     */
    @SerializedName( "MaintenanceStrategy" )
    @JsonProperty( "MaintenanceStrategy" )
    @Nullable
    @ODataField( odataName = "MaintenanceStrategy" )
    private String maintenanceStrategy;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceStrategy</b> field to query operations.
     *
     */
    public final static MaintenancePlanCycleField<String> MAINTENANCE_STRATEGY =
        new MaintenancePlanCycleField<String>("MaintenanceStrategy");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CycleSetSequence</b>
     * </p>
     *
     * @return Cycle Set Sequence
     */
    @SerializedName( "CycleSetSequence" )
    @JsonProperty( "CycleSetSequence" )
    @Nullable
    @ODataField( odataName = "CycleSetSequence" )
    private String cycleSetSequence;
    /**
     * Use with available fluent helpers to apply the <b>CycleSetSequence</b> field to query operations.
     *
     */
    public final static MaintenancePlanCycleField<String> CYCLE_SET_SEQUENCE =
        new MaintenancePlanCycleField<String>("CycleSetSequence");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycRcrrcIntervalQty</b>
     * </p>
     *
     * @return Maintenance Plan Cycle Interval
     */
    @SerializedName( "MaintPlanCycRcrrcIntervalQty" )
    @JsonProperty( "MaintPlanCycRcrrcIntervalQty" )
    @Nullable
    @ODataField( odataName = "MaintPlanCycRcrrcIntervalQty" )
    private Double maintPlanCycRcrrcIntervalQty;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanCycRcrrcIntervalQty</b> field to query operations.
     *
     */
    public final static MaintenancePlanCycleField<Double> MAINT_PLAN_CYC_RCRRC_INTERVAL_QTY =
        new MaintenancePlanCycleField<Double>("MaintPlanCycRcrrcIntervalQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycRcrrcIntervalUnit</b>
     * </p>
     *
     * @return Unit for the performance of maintenance tasks
     */
    @SerializedName( "MaintPlanCycRcrrcIntervalUnit" )
    @JsonProperty( "MaintPlanCycRcrrcIntervalUnit" )
    @Nullable
    @ODataField( odataName = "MaintPlanCycRcrrcIntervalUnit" )
    private String maintPlanCycRcrrcIntervalUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanCycRcrrcIntervalUnit</b> field to query operations.
     *
     */
    public final static MaintenancePlanCycleField<String> MAINT_PLAN_CYC_RCRRC_INTERVAL_UNIT =
        new MaintenancePlanCycleField<String>("MaintPlanCycRcrrcIntervalUnit");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycleDesc</b>
     * </p>
     *
     * @return Text for maintenance package/cycle (time/performance)
     */
    @SerializedName( "MaintPlanCycleDesc" )
    @JsonProperty( "MaintPlanCycleDesc" )
    @Nullable
    @ODataField( odataName = "MaintPlanCycleDesc" )
    private String maintPlanCycleDesc;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanCycleDesc</b> field to query operations.
     *
     */
    public final static MaintenancePlanCycleField<String> MAINT_PLAN_CYCLE_DESC =
        new MaintenancePlanCycleField<String>("MaintPlanCycleDesc");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPoint</b>
     * </p>
     *
     * @return Measuring Point
     */
    @SerializedName( "MeasuringPoint" )
    @JsonProperty( "MeasuringPoint" )
    @Nullable
    @ODataField( odataName = "MeasuringPoint" )
    private String measuringPoint;
    /**
     * Use with available fluent helpers to apply the <b>MeasuringPoint</b> field to query operations.
     *
     */
    public final static MaintenancePlanCycleField<String> MEASURING_POINT =
        new MaintenancePlanCycleField<String>("MeasuringPoint");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycleStartOffsetValue</b>
     * </p>
     *
     * @return Maintenance Plan Cycle Interval
     */
    @SerializedName( "MaintPlanCycleStartOffsetValue" )
    @JsonProperty( "MaintPlanCycleStartOffsetValue" )
    @Nullable
    @ODataField( odataName = "MaintPlanCycleStartOffsetValue" )
    private Double maintPlanCycleStartOffsetValue;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanCycleStartOffsetValue</b> field to query operations.
     *
     */
    public final static MaintenancePlanCycleField<Double> MAINT_PLAN_CYCLE_START_OFFSET_VALUE =
        new MaintenancePlanCycleField<Double>("MaintPlanCycleStartOffsetValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintCycleNextPlndCntrRdng</b>
     * </p>
     *
     * @return Maintenance Plan Cycle Interval
     */
    @SerializedName( "MaintCycleNextPlndCntrRdng" )
    @JsonProperty( "MaintCycleNextPlndCntrRdng" )
    @Nullable
    @ODataField( odataName = "MaintCycleNextPlndCntrRdng" )
    private Double maintCycleNextPlndCntrRdng;
    /**
     * Use with available fluent helpers to apply the <b>MaintCycleNextPlndCntrRdng</b> field to query operations.
     *
     */
    public final static MaintenancePlanCycleField<Double> MAINT_CYCLE_NEXT_PLND_CNTR_RDNG =
        new MaintenancePlanCycleField<Double>("MaintCycleNextPlndCntrRdng");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCycleIsInactive</b>
     * </p>
     *
     * @return Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    @SerializedName( "MaintenancePlanCycleIsInactive" )
    @JsonProperty( "MaintenancePlanCycleIsInactive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaintenancePlanCycleIsInactive" )
    private Boolean maintenancePlanCycleIsInactive;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanCycleIsInactive</b> field to query operations.
     *
     */
    public final static MaintenancePlanCycleField<Boolean> MAINTENANCE_PLAN_CYCLE_IS_INACTIVE =
        new MaintenancePlanCycleField<Boolean>("MaintenancePlanCycleIsInactive");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CycleSetSequenceRepeatFactor</b>
     * </p>
     *
     * @return Repeat Factor for Cycle Set Sequence
     */
    @SerializedName( "CycleSetSequenceRepeatFactor" )
    @JsonProperty( "CycleSetSequenceRepeatFactor" )
    @Nullable
    @ODataField( odataName = "CycleSetSequenceRepeatFactor" )
    private String cycleSetSequenceRepeatFactor;
    /**
     * Use with available fluent helpers to apply the <b>CycleSetSequenceRepeatFactor</b> field to query operations.
     *
     */
    public final static MaintenancePlanCycleField<String> CYCLE_SET_SEQUENCE_REPEAT_FACTOR =
        new MaintenancePlanCycleField<String>("CycleSetSequenceRepeatFactor");
    /**
     * Navigation property <b>to_MaintenancePlan</b> for <b>MaintenancePlanCycle</b> to single <b>MaintenancePlan</b>.
     *
     */
    @SerializedName( "to_MaintenancePlan" )
    @JsonProperty( "to_MaintenancePlan" )
    @ODataField( odataName = "to_MaintenancePlan" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenancePlan toMaintenancePlan;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenancePlan</b> navigation property to query operations.
     *
     */
    public final static MaintenancePlanCycleOneToOneLink<MaintenancePlan> TO_MAINTENANCE_PLAN =
        new MaintenancePlanCycleOneToOneLink<MaintenancePlan>("to_MaintenancePlan");

    @Nonnull
    @Override
    public Class<MaintenancePlanCycle> getType()
    {
        return MaintenancePlanCycle.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     */
    public void setMaintenancePlan( @Nullable final String maintenancePlan )
    {
        rememberChangedField("MaintenancePlan", this.maintenancePlan);
        this.maintenancePlan = maintenancePlan;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCycle</b>
     * </p>
     *
     * @param maintenancePlanCycle
     *            Counter in Control Tables
     */
    public void setMaintenancePlanCycle( @Nullable final String maintenancePlanCycle )
    {
        rememberChangedField("MaintenancePlanCycle", this.maintenancePlanCycle);
        this.maintenancePlanCycle = maintenancePlanCycle;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStrategy</b>
     * </p>
     *
     * @param maintenanceStrategy
     *            Maintenance Strategy
     */
    public void setMaintenanceStrategy( @Nullable final String maintenanceStrategy )
    {
        rememberChangedField("MaintenanceStrategy", this.maintenanceStrategy);
        this.maintenanceStrategy = maintenanceStrategy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CycleSetSequence</b>
     * </p>
     *
     * @param cycleSetSequence
     *            Cycle Set Sequence
     */
    public void setCycleSetSequence( @Nullable final String cycleSetSequence )
    {
        rememberChangedField("CycleSetSequence", this.cycleSetSequence);
        this.cycleSetSequence = cycleSetSequence;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycRcrrcIntervalQty</b>
     * </p>
     *
     * @param maintPlanCycRcrrcIntervalQty
     *            Maintenance Plan Cycle Interval
     */
    public void setMaintPlanCycRcrrcIntervalQty( @Nullable final Double maintPlanCycRcrrcIntervalQty )
    {
        rememberChangedField("MaintPlanCycRcrrcIntervalQty", this.maintPlanCycRcrrcIntervalQty);
        this.maintPlanCycRcrrcIntervalQty = maintPlanCycRcrrcIntervalQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycRcrrcIntervalUnit</b>
     * </p>
     *
     * @param maintPlanCycRcrrcIntervalUnit
     *            Unit for the performance of maintenance tasks
     */
    public void setMaintPlanCycRcrrcIntervalUnit( @Nullable final String maintPlanCycRcrrcIntervalUnit )
    {
        rememberChangedField("MaintPlanCycRcrrcIntervalUnit", this.maintPlanCycRcrrcIntervalUnit);
        this.maintPlanCycRcrrcIntervalUnit = maintPlanCycRcrrcIntervalUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycleDesc</b>
     * </p>
     *
     * @param maintPlanCycleDesc
     *            Text for maintenance package/cycle (time/performance)
     */
    public void setMaintPlanCycleDesc( @Nullable final String maintPlanCycleDesc )
    {
        rememberChangedField("MaintPlanCycleDesc", this.maintPlanCycleDesc);
        this.maintPlanCycleDesc = maintPlanCycleDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPoint</b>
     * </p>
     *
     * @param measuringPoint
     *            Measuring Point
     */
    public void setMeasuringPoint( @Nullable final String measuringPoint )
    {
        rememberChangedField("MeasuringPoint", this.measuringPoint);
        this.measuringPoint = measuringPoint;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycleStartOffsetValue</b>
     * </p>
     *
     * @param maintPlanCycleStartOffsetValue
     *            Maintenance Plan Cycle Interval
     */
    public void setMaintPlanCycleStartOffsetValue( @Nullable final Double maintPlanCycleStartOffsetValue )
    {
        rememberChangedField("MaintPlanCycleStartOffsetValue", this.maintPlanCycleStartOffsetValue);
        this.maintPlanCycleStartOffsetValue = maintPlanCycleStartOffsetValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintCycleNextPlndCntrRdng</b>
     * </p>
     *
     * @param maintCycleNextPlndCntrRdng
     *            Maintenance Plan Cycle Interval
     */
    public void setMaintCycleNextPlndCntrRdng( @Nullable final Double maintCycleNextPlndCntrRdng )
    {
        rememberChangedField("MaintCycleNextPlndCntrRdng", this.maintCycleNextPlndCntrRdng);
        this.maintCycleNextPlndCntrRdng = maintCycleNextPlndCntrRdng;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCycleIsInactive</b>
     * </p>
     *
     * @param maintenancePlanCycleIsInactive
     *            Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    public void setMaintenancePlanCycleIsInactive( @Nullable final Boolean maintenancePlanCycleIsInactive )
    {
        rememberChangedField("MaintenancePlanCycleIsInactive", this.maintenancePlanCycleIsInactive);
        this.maintenancePlanCycleIsInactive = maintenancePlanCycleIsInactive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CycleSetSequenceRepeatFactor</b>
     * </p>
     *
     * @param cycleSetSequenceRepeatFactor
     *            Repeat Factor for Cycle Set Sequence
     */
    public void setCycleSetSequenceRepeatFactor( @Nullable final String cycleSetSequenceRepeatFactor )
    {
        rememberChangedField("CycleSetSequenceRepeatFactor", this.cycleSetSequenceRepeatFactor);
        this.cycleSetSequenceRepeatFactor = cycleSetSequenceRepeatFactor;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenancePlanCycle";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenancePlan", getMaintenancePlan());
        result.put("MaintenancePlanCycle", getMaintenancePlanCycle());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenancePlan", getMaintenancePlan());
        values.put("MaintenancePlanCycle", getMaintenancePlanCycle());
        values.put("MaintenanceStrategy", getMaintenanceStrategy());
        values.put("CycleSetSequence", getCycleSetSequence());
        values.put("MaintPlanCycRcrrcIntervalQty", getMaintPlanCycRcrrcIntervalQty());
        values.put("MaintPlanCycRcrrcIntervalUnit", getMaintPlanCycRcrrcIntervalUnit());
        values.put("MaintPlanCycleDesc", getMaintPlanCycleDesc());
        values.put("MeasuringPoint", getMeasuringPoint());
        values.put("MaintPlanCycleStartOffsetValue", getMaintPlanCycleStartOffsetValue());
        values.put("MaintCycleNextPlndCntrRdng", getMaintCycleNextPlndCntrRdng());
        values.put("MaintenancePlanCycleIsInactive", getMaintenancePlanCycleIsInactive());
        values.put("CycleSetSequenceRepeatFactor", getCycleSetSequenceRepeatFactor());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenancePlan") ) {
                final Object value = values.remove("MaintenancePlan");
                if( (value == null) || (!value.equals(getMaintenancePlan())) ) {
                    setMaintenancePlan(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanCycle") ) {
                final Object value = values.remove("MaintenancePlanCycle");
                if( (value == null) || (!value.equals(getMaintenancePlanCycle())) ) {
                    setMaintenancePlanCycle(((String) value));
                }
            }
            if( values.containsKey("MaintenanceStrategy") ) {
                final Object value = values.remove("MaintenanceStrategy");
                if( (value == null) || (!value.equals(getMaintenanceStrategy())) ) {
                    setMaintenanceStrategy(((String) value));
                }
            }
            if( values.containsKey("CycleSetSequence") ) {
                final Object value = values.remove("CycleSetSequence");
                if( (value == null) || (!value.equals(getCycleSetSequence())) ) {
                    setCycleSetSequence(((String) value));
                }
            }
            if( values.containsKey("MaintPlanCycRcrrcIntervalQty") ) {
                final Object value = values.remove("MaintPlanCycRcrrcIntervalQty");
                if( (value == null) || (!value.equals(getMaintPlanCycRcrrcIntervalQty())) ) {
                    setMaintPlanCycRcrrcIntervalQty(((Double) value));
                }
            }
            if( values.containsKey("MaintPlanCycRcrrcIntervalUnit") ) {
                final Object value = values.remove("MaintPlanCycRcrrcIntervalUnit");
                if( (value == null) || (!value.equals(getMaintPlanCycRcrrcIntervalUnit())) ) {
                    setMaintPlanCycRcrrcIntervalUnit(((String) value));
                }
            }
            if( values.containsKey("MaintPlanCycleDesc") ) {
                final Object value = values.remove("MaintPlanCycleDesc");
                if( (value == null) || (!value.equals(getMaintPlanCycleDesc())) ) {
                    setMaintPlanCycleDesc(((String) value));
                }
            }
            if( values.containsKey("MeasuringPoint") ) {
                final Object value = values.remove("MeasuringPoint");
                if( (value == null) || (!value.equals(getMeasuringPoint())) ) {
                    setMeasuringPoint(((String) value));
                }
            }
            if( values.containsKey("MaintPlanCycleStartOffsetValue") ) {
                final Object value = values.remove("MaintPlanCycleStartOffsetValue");
                if( (value == null) || (!value.equals(getMaintPlanCycleStartOffsetValue())) ) {
                    setMaintPlanCycleStartOffsetValue(((Double) value));
                }
            }
            if( values.containsKey("MaintCycleNextPlndCntrRdng") ) {
                final Object value = values.remove("MaintCycleNextPlndCntrRdng");
                if( (value == null) || (!value.equals(getMaintCycleNextPlndCntrRdng())) ) {
                    setMaintCycleNextPlndCntrRdng(((Double) value));
                }
            }
            if( values.containsKey("MaintenancePlanCycleIsInactive") ) {
                final Object value = values.remove("MaintenancePlanCycleIsInactive");
                if( (value == null) || (!value.equals(getMaintenancePlanCycleIsInactive())) ) {
                    setMaintenancePlanCycleIsInactive(((Boolean) value));
                }
            }
            if( values.containsKey("CycleSetSequenceRepeatFactor") ) {
                final Object value = values.remove("CycleSetSequenceRepeatFactor");
                if( (value == null) || (!value.equals(getCycleSetSequenceRepeatFactor())) ) {
                    setCycleSetSequenceRepeatFactor(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenancePlan") ) {
                final Object value = (values).remove("to_MaintenancePlan");
                if( value instanceof Map ) {
                    if( toMaintenancePlan == null ) {
                        toMaintenancePlan = new MaintenancePlan();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenancePlan.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintenancePlanCycleField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintenancePlanCycleField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenancePlanCycleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenancePlanCycleField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenancePlan != null ) {
            (values).put("to_MaintenancePlan", toMaintenancePlan);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenancePlan</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_MaintenancePlan</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenancePlan</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenancePlan fetchMaintenancePlan()
    {
        return fetchFieldAsSingle("to_MaintenancePlan", MaintenancePlan.class);
    }

    /**
     * Retrieval of associated <b>MaintenancePlan</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenancePlan</b>.
     * <p>
     * If the navigation property <b>to_MaintenancePlan</b> of a queried <b>MaintenancePlanCycle</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenancePlan</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenancePlan getMaintenancePlanOrFetch()
    {
        if( toMaintenancePlan == null ) {
            toMaintenancePlan = fetchMaintenancePlan();
        }
        return toMaintenancePlan;
    }

    /**
     * Retrieval of associated <b>MaintenancePlan</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenancePlan</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenancePlanCycle</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenancePlan</b> is already loaded, the result will
     *         contain the <b>MaintenancePlan</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenancePlan> getMaintenancePlanIfPresent()
    {
        return Option.of(toMaintenancePlan);
    }

    /**
     * Overwrites the associated <b>MaintenancePlan</b> entity for the loaded navigation property
     * <b>to_MaintenancePlan</b>.
     *
     * @param value
     *            New <b>MaintenancePlan</b> entity.
     */
    public void setMaintenancePlan( final MaintenancePlan value )
    {
        toMaintenancePlan = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintenancePlanCycle instances.
     *
     */
    public final static class MaintenancePlanCycleBuilder
    {

        private MaintenancePlan toMaintenancePlan;
        private String maintenancePlan = null;

        private MaintenancePlanCycle.MaintenancePlanCycleBuilder toMaintenancePlan( final MaintenancePlan value )
        {
            toMaintenancePlan = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenancePlan</b> for <b>MaintenancePlanCycle</b> to single
         * <b>MaintenancePlan</b>.
         *
         * @param value
         *            The MaintenancePlan to build this MaintenancePlanCycle with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenancePlanCycle.MaintenancePlanCycleBuilder maintenancePlan( final MaintenancePlan value )
        {
            return toMaintenancePlan(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>MaintenancePlan</b>
         * </p>
         *
         * @param value
         *            The maintenancePlan to build this MaintenancePlanCycle with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenancePlanCycle.MaintenancePlanCycleBuilder maintenancePlan( final String value )
        {
            maintenancePlan = value;
            return this;
        }

    }

}
