/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintenancePlanCycleSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle MaintenancePlanCycle}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class MaintenancePlanCycleByKeyFluentHelper
    extends
    FluentHelperByKey<MaintenancePlanCycleByKeyFluentHelper, MaintenancePlanCycle, MaintenancePlanCycleSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle
     * MaintenancePlanCycle} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintenancePlanCycle}
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintenancePlanCycle}
     * @param maintenancePlanCycle
     *            Counter in Control Tables
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public MaintenancePlanCycleByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintenancePlan,
        final String maintenancePlanCycle )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenancePlan", maintenancePlan);
        this.key.put("MaintenancePlanCycle", maintenancePlanCycle);
    }

    @Override
    @Nonnull
    protected Class<MaintenancePlanCycle> getEntityClass()
    {
        return MaintenancePlanCycle.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
