/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintenancePlanScheduleField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintenancePlanScheduleLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintenancePlanScheduleSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Scheduled Calls of Maintenance Plan
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenancePlanScheduleType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenancePlanSchedule extends VdmEntity<MaintenancePlanSchedule>
{

    /**
     * Selector for all available fields of MaintenancePlanSchedule.
     *
     */
    public final static MaintenancePlanScheduleSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @return Maintenance Plan
     */
    @Key
    @SerializedName( "MaintenancePlan" )
    @JsonProperty( "MaintenancePlan" )
    @Nullable
    @ODataField( odataName = "MaintenancePlan" )
    private String maintenancePlan;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlan</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<String> MAINTENANCE_PLAN =
        new MaintenancePlanScheduleField<String>("MaintenancePlan");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCallNumber</b>
     * </p>
     *
     * @return Maintenance Plan Call Number
     */
    @Key
    @SerializedName( "MaintenancePlanCallNumber" )
    @JsonProperty( "MaintenancePlanCallNumber" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanCallNumber" )
    private Integer maintenancePlanCallNumber;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanCallNumber</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<Integer> MAINTENANCE_PLAN_CALL_NUMBER =
        new MaintenancePlanScheduleField<Integer>("MaintenancePlanCallNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePackage</b>
     * </p>
     *
     * @return Maintenance Package Number
     */
    @Key
    @SerializedName( "MaintenancePackage" )
    @JsonProperty( "MaintenancePackage" )
    @Nullable
    @ODataField( odataName = "MaintenancePackage" )
    private String maintenancePackage;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePackage</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<String> MAINTENANCE_PACKAGE =
        new MaintenancePlanScheduleField<String>("MaintenancePackage");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingType</b>
     * </p>
     *
     * @return Scheduling type
     */
    @SerializedName( "SchedulingType" )
    @JsonProperty( "SchedulingType" )
    @Nullable
    @ODataField( odataName = "SchedulingType" )
    private String schedulingType;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingType</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<String> SCHEDULING_TYPE =
        new MaintenancePlanScheduleField<String>("SchedulingType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingStatus</b>
     * </p>
     *
     * @return Single-Character Flag
     */
    @SerializedName( "SchedulingStatus" )
    @JsonProperty( "SchedulingStatus" )
    @Nullable
    @ODataField( odataName = "SchedulingStatus" )
    private String schedulingStatus;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingStatus</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<String> SCHEDULING_STATUS =
        new MaintenancePlanScheduleField<String>("SchedulingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPoint</b>
     * </p>
     *
     * @return Measuring Point
     */
    @SerializedName( "MeasuringPoint" )
    @JsonProperty( "MeasuringPoint" )
    @Nullable
    @ODataField( odataName = "MeasuringPoint" )
    private String measuringPoint;
    /**
     * Use with available fluent helpers to apply the <b>MeasuringPoint</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<String> MEASURING_POINT =
        new MaintenancePlanScheduleField<String>("MeasuringPoint");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskPerformanceUnit</b>
     * </p>
     *
     * @return Unit for the performance of maintenance tasks
     */
    @SerializedName( "MaintenanceTaskPerformanceUnit" )
    @JsonProperty( "MaintenanceTaskPerformanceUnit" )
    @Nullable
    @ODataField( odataName = "MaintenanceTaskPerformanceUnit" )
    private String maintenanceTaskPerformanceUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceTaskPerformanceUnit</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<String> MAINTENANCE_TASK_PERFORMANCE_UNIT =
        new MaintenancePlanScheduleField<String>("MaintenanceTaskPerformanceUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceCallNextPlannedDate</b>
     * </p>
     *
     * @return Next planned date
     */
    @SerializedName( "MaintenanceCallNextPlannedDate" )
    @JsonProperty( "MaintenanceCallNextPlannedDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintenanceCallNextPlannedDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime maintenanceCallNextPlannedDate;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceCallNextPlannedDate</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<LocalDateTime> MAINTENANCE_CALL_NEXT_PLANNED_DATE =
        new MaintenancePlanScheduleField<LocalDateTime>("MaintenanceCallNextPlannedDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceCallDate</b>
     * </p>
     *
     * @return Call date
     */
    @SerializedName( "MaintenanceCallDate" )
    @JsonProperty( "MaintenanceCallDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintenanceCallDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime maintenanceCallDate;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceCallDate</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<LocalDateTime> MAINTENANCE_CALL_DATE =
        new MaintenancePlanScheduleField<LocalDateTime>("MaintenanceCallDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CompletionDate</b>
     * </p>
     *
     * @return Date of last completion in maintenance plan
     */
    @SerializedName( "CompletionDate" )
    @JsonProperty( "CompletionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CompletionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime completionDate;
    /**
     * Use with available fluent helpers to apply the <b>CompletionDate</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<LocalDateTime> COMPLETION_DATE =
        new MaintenancePlanScheduleField<LocalDateTime>("CompletionDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CompletionTime</b>
     * </p>
     *
     * @return The completionTime contained in this entity.
     */
    @SerializedName( "CompletionTime" )
    @JsonProperty( "CompletionTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CompletionTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime completionTime;
    /**
     * Use with available fluent helpers to apply the <b>CompletionTime</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<LocalTime> COMPLETION_TIME =
        new MaintenancePlanScheduleField<LocalTime>("CompletionTime");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CycleSetSequence</b>
     * </p>
     *
     * @return Cycle Set Sequence
     */
    @SerializedName( "CycleSetSequence" )
    @JsonProperty( "CycleSetSequence" )
    @Nullable
    @ODataField( odataName = "CycleSetSequence" )
    private String cycleSetSequence;
    /**
     * Use with available fluent helpers to apply the <b>CycleSetSequence</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<String> CYCLE_SET_SEQUENCE =
        new MaintenancePlanScheduleField<String>("CycleSetSequence");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintCallCompltnCntrRdng</b>
     * </p>
     *
     * @return Counter reading confirmation
     */
    @SerializedName( "MaintCallCompltnCntrRdng" )
    @JsonProperty( "MaintCallCompltnCntrRdng" )
    @Nullable
    @ODataField( odataName = "MaintCallCompltnCntrRdng" )
    private Double maintCallCompltnCntrRdng;
    /**
     * Use with available fluent helpers to apply the <b>MaintCallCompltnCntrRdng</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<Double> MAINT_CALL_COMPLTN_CNTR_RDNG =
        new MaintenancePlanScheduleField<Double>("MaintCallCompltnCntrRdng");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceCallIsOutstanding</b>
     * </p>
     *
     * @return Scheduling status: call outstanding
     */
    @SerializedName( "MaintenanceCallIsOutstanding" )
    @JsonProperty( "MaintenanceCallIsOutstanding" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaintenanceCallIsOutstanding" )
    private Boolean maintenanceCallIsOutstanding;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceCallIsOutstanding</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<Boolean> MAINTENANCE_CALL_IS_OUTSTANDING =
        new MaintenancePlanScheduleField<Boolean>("MaintenanceCallIsOutstanding");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintCallIsInvokedOnPlndDate</b>
     * </p>
     *
     * @return Scheduling status: planned date called
     */
    @SerializedName( "MaintCallIsInvokedOnPlndDate" )
    @JsonProperty( "MaintCallIsInvokedOnPlndDate" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaintCallIsInvokedOnPlndDate" )
    private Boolean maintCallIsInvokedOnPlndDate;
    /**
     * Use with available fluent helpers to apply the <b>MaintCallIsInvokedOnPlndDate</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<Boolean> MAINT_CALL_IS_INVOKED_ON_PLND_DATE =
        new MaintenancePlanScheduleField<Boolean>("MaintCallIsInvokedOnPlndDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintCallHorizonIsNotReached</b>
     * </p>
     *
     * @return Scheduling status: call horizon not reached
     */
    @SerializedName( "MaintCallHorizonIsNotReached" )
    @JsonProperty( "MaintCallHorizonIsNotReached" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaintCallHorizonIsNotReached" )
    private Boolean maintCallHorizonIsNotReached;
    /**
     * Use with available fluent helpers to apply the <b>MaintCallHorizonIsNotReached</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<Boolean> MAINT_CALL_HORIZON_IS_NOT_REACHED =
        new MaintenancePlanScheduleField<Boolean>("MaintCallHorizonIsNotReached");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanLastScheduledDate</b>
     * </p>
     *
     * @return Date of the call
     */
    @SerializedName( "MaintPlanLastScheduledDate" )
    @JsonProperty( "MaintPlanLastScheduledDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintPlanLastScheduledDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime maintPlanLastScheduledDate;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanLastScheduledDate</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<LocalDateTime> MAINT_PLAN_LAST_SCHEDULED_DATE =
        new MaintenancePlanScheduleField<LocalDateTime>("MaintPlanLastScheduledDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ReleasedByUserName</b>
     * </p>
     *
     * @return Name of the person who made the call
     */
    @SerializedName( "ReleasedByUserName" )
    @JsonProperty( "ReleasedByUserName" )
    @Nullable
    @ODataField( odataName = "ReleasedByUserName" )
    private String releasedByUserName;
    /**
     * Use with available fluent helpers to apply the <b>ReleasedByUserName</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<String> RELEASED_BY_USER_NAME =
        new MaintenancePlanScheduleField<String>("ReleasedByUserName");
    /**
     * Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlnCnctntdDuePackagesTxt</b>
     * </p>
     *
     * @return The maintPlnCnctntdDuePackagesTxt contained in this entity.
     */
    @SerializedName( "MaintPlnCnctntdDuePackagesTxt" )
    @JsonProperty( "MaintPlnCnctntdDuePackagesTxt" )
    @Nullable
    @ODataField( odataName = "MaintPlnCnctntdDuePackagesTxt" )
    private String maintPlnCnctntdDuePackagesTxt;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlnCnctntdDuePackagesTxt</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<String> MAINT_PLN_CNCTNTD_DUE_PACKAGES_TXT =
        new MaintenancePlanScheduleField<String>("MaintPlnCnctntdDuePackagesTxt");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanPrdcssrCallCompltnDte</b>
     * </p>
     *
     * @return Completion for Predecessor
     */
    @SerializedName( "MaintPlanPrdcssrCallCompltnDte" )
    @JsonProperty( "MaintPlanPrdcssrCallCompltnDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintPlanPrdcssrCallCompltnDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime maintPlanPrdcssrCallCompltnDte;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanPrdcssrCallCompltnDte</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<LocalDateTime> MAINT_PLAN_PRDCSSR_CALL_COMPLTN_DTE =
        new MaintenancePlanScheduleField<LocalDateTime>("MaintPlanPrdcssrCallCompltnDte");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanManualCallDate</b>
     * </p>
     *
     * @return Manual call date
     */
    @SerializedName( "MaintenancePlanManualCallDate" )
    @JsonProperty( "MaintenancePlanManualCallDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintenancePlanManualCallDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime maintenancePlanManualCallDate;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanManualCallDate</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<LocalDateTime> MAINTENANCE_PLAN_MANUAL_CALL_DATE =
        new MaintenancePlanScheduleField<LocalDateTime>("MaintenancePlanManualCallDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceCallLastPlannedDate</b>
     * </p>
     *
     * @return Last planned date
     */
    @SerializedName( "MaintenanceCallLastPlannedDate" )
    @JsonProperty( "MaintenanceCallLastPlannedDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MaintenanceCallLastPlannedDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime maintenanceCallLastPlannedDate;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceCallLastPlannedDate</b> field to query operations.
     *
     */
    public final static MaintenancePlanScheduleField<LocalDateTime> MAINTENANCE_CALL_LAST_PLANNED_DATE =
        new MaintenancePlanScheduleField<LocalDateTime>("MaintenanceCallLastPlannedDate");
    /**
     * Navigation property <b>to_MaintenancePlanCallObjects</b> for <b>MaintenancePlanSchedule</b> to multiple
     * <b>MaintenancePlanCallObject</b>.
     *
     */
    @SerializedName( "to_MaintenancePlanCallObjects" )
    @JsonProperty( "to_MaintenancePlanCallObjects" )
    @ODataField( odataName = "to_MaintenancePlanCallObjects" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<MaintenancePlanCallObject> toMaintenancePlanCallObjects;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenancePlanCallObjects</b> navigation property to query
     * operations.
     *
     */
    public final static MaintenancePlanScheduleLink<MaintenancePlanCallObject> TO_MAINTENANCE_PLAN_CALL_OBJECTS =
        new MaintenancePlanScheduleLink<MaintenancePlanCallObject>("to_MaintenancePlanCallObjects");

    @Nonnull
    @Override
    public Class<MaintenancePlanSchedule> getType()
    {
        return MaintenancePlanSchedule.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     */
    public void setMaintenancePlan( @Nullable final String maintenancePlan )
    {
        rememberChangedField("MaintenancePlan", this.maintenancePlan);
        this.maintenancePlan = maintenancePlan;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCallNumber</b>
     * </p>
     *
     * @param maintenancePlanCallNumber
     *            Maintenance Plan Call Number
     */
    public void setMaintenancePlanCallNumber( @Nullable final Integer maintenancePlanCallNumber )
    {
        rememberChangedField("MaintenancePlanCallNumber", this.maintenancePlanCallNumber);
        this.maintenancePlanCallNumber = maintenancePlanCallNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePackage</b>
     * </p>
     *
     * @param maintenancePackage
     *            Maintenance Package Number
     */
    public void setMaintenancePackage( @Nullable final String maintenancePackage )
    {
        rememberChangedField("MaintenancePackage", this.maintenancePackage);
        this.maintenancePackage = maintenancePackage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingType</b>
     * </p>
     *
     * @param schedulingType
     *            Scheduling type
     */
    public void setSchedulingType( @Nullable final String schedulingType )
    {
        rememberChangedField("SchedulingType", this.schedulingType);
        this.schedulingType = schedulingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingStatus</b>
     * </p>
     *
     * @param schedulingStatus
     *            Single-Character Flag
     */
    public void setSchedulingStatus( @Nullable final String schedulingStatus )
    {
        rememberChangedField("SchedulingStatus", this.schedulingStatus);
        this.schedulingStatus = schedulingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MeasuringPoint</b>
     * </p>
     *
     * @param measuringPoint
     *            Measuring Point
     */
    public void setMeasuringPoint( @Nullable final String measuringPoint )
    {
        rememberChangedField("MeasuringPoint", this.measuringPoint);
        this.measuringPoint = measuringPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceTaskPerformanceUnit</b>
     * </p>
     *
     * @param maintenanceTaskPerformanceUnit
     *            Unit for the performance of maintenance tasks
     */
    public void setMaintenanceTaskPerformanceUnit( @Nullable final String maintenanceTaskPerformanceUnit )
    {
        rememberChangedField("MaintenanceTaskPerformanceUnit", this.maintenanceTaskPerformanceUnit);
        this.maintenanceTaskPerformanceUnit = maintenanceTaskPerformanceUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceCallNextPlannedDate</b>
     * </p>
     *
     * @param maintenanceCallNextPlannedDate
     *            Next planned date
     */
    public void setMaintenanceCallNextPlannedDate( @Nullable final LocalDateTime maintenanceCallNextPlannedDate )
    {
        rememberChangedField("MaintenanceCallNextPlannedDate", this.maintenanceCallNextPlannedDate);
        this.maintenanceCallNextPlannedDate = maintenanceCallNextPlannedDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceCallDate</b>
     * </p>
     *
     * @param maintenanceCallDate
     *            Call date
     */
    public void setMaintenanceCallDate( @Nullable final LocalDateTime maintenanceCallDate )
    {
        rememberChangedField("MaintenanceCallDate", this.maintenanceCallDate);
        this.maintenanceCallDate = maintenanceCallDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CompletionDate</b>
     * </p>
     *
     * @param completionDate
     *            Date of last completion in maintenance plan
     */
    public void setCompletionDate( @Nullable final LocalDateTime completionDate )
    {
        rememberChangedField("CompletionDate", this.completionDate);
        this.completionDate = completionDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CompletionTime</b>
     * </p>
     *
     * @param completionTime
     *            The completionTime to set.
     */
    public void setCompletionTime( @Nullable final LocalTime completionTime )
    {
        rememberChangedField("CompletionTime", this.completionTime);
        this.completionTime = completionTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CycleSetSequence</b>
     * </p>
     *
     * @param cycleSetSequence
     *            Cycle Set Sequence
     */
    public void setCycleSetSequence( @Nullable final String cycleSetSequence )
    {
        rememberChangedField("CycleSetSequence", this.cycleSetSequence);
        this.cycleSetSequence = cycleSetSequence;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintCallCompltnCntrRdng</b>
     * </p>
     *
     * @param maintCallCompltnCntrRdng
     *            Counter reading confirmation
     */
    public void setMaintCallCompltnCntrRdng( @Nullable final Double maintCallCompltnCntrRdng )
    {
        rememberChangedField("MaintCallCompltnCntrRdng", this.maintCallCompltnCntrRdng);
        this.maintCallCompltnCntrRdng = maintCallCompltnCntrRdng;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceCallIsOutstanding</b>
     * </p>
     *
     * @param maintenanceCallIsOutstanding
     *            Scheduling status: call outstanding
     */
    public void setMaintenanceCallIsOutstanding( @Nullable final Boolean maintenanceCallIsOutstanding )
    {
        rememberChangedField("MaintenanceCallIsOutstanding", this.maintenanceCallIsOutstanding);
        this.maintenanceCallIsOutstanding = maintenanceCallIsOutstanding;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintCallIsInvokedOnPlndDate</b>
     * </p>
     *
     * @param maintCallIsInvokedOnPlndDate
     *            Scheduling status: planned date called
     */
    public void setMaintCallIsInvokedOnPlndDate( @Nullable final Boolean maintCallIsInvokedOnPlndDate )
    {
        rememberChangedField("MaintCallIsInvokedOnPlndDate", this.maintCallIsInvokedOnPlndDate);
        this.maintCallIsInvokedOnPlndDate = maintCallIsInvokedOnPlndDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintCallHorizonIsNotReached</b>
     * </p>
     *
     * @param maintCallHorizonIsNotReached
     *            Scheduling status: call horizon not reached
     */
    public void setMaintCallHorizonIsNotReached( @Nullable final Boolean maintCallHorizonIsNotReached )
    {
        rememberChangedField("MaintCallHorizonIsNotReached", this.maintCallHorizonIsNotReached);
        this.maintCallHorizonIsNotReached = maintCallHorizonIsNotReached;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanLastScheduledDate</b>
     * </p>
     *
     * @param maintPlanLastScheduledDate
     *            Date of the call
     */
    public void setMaintPlanLastScheduledDate( @Nullable final LocalDateTime maintPlanLastScheduledDate )
    {
        rememberChangedField("MaintPlanLastScheduledDate", this.maintPlanLastScheduledDate);
        this.maintPlanLastScheduledDate = maintPlanLastScheduledDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ReleasedByUserName</b>
     * </p>
     *
     * @param releasedByUserName
     *            Name of the person who made the call
     */
    public void setReleasedByUserName( @Nullable final String releasedByUserName )
    {
        rememberChangedField("ReleasedByUserName", this.releasedByUserName);
        this.releasedByUserName = releasedByUserName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 256
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlnCnctntdDuePackagesTxt</b>
     * </p>
     *
     * @param maintPlnCnctntdDuePackagesTxt
     *            The maintPlnCnctntdDuePackagesTxt to set.
     */
    public void setMaintPlnCnctntdDuePackagesTxt( @Nullable final String maintPlnCnctntdDuePackagesTxt )
    {
        rememberChangedField("MaintPlnCnctntdDuePackagesTxt", this.maintPlnCnctntdDuePackagesTxt);
        this.maintPlnCnctntdDuePackagesTxt = maintPlnCnctntdDuePackagesTxt;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanPrdcssrCallCompltnDte</b>
     * </p>
     *
     * @param maintPlanPrdcssrCallCompltnDte
     *            Completion for Predecessor
     */
    public void setMaintPlanPrdcssrCallCompltnDte( @Nullable final LocalDateTime maintPlanPrdcssrCallCompltnDte )
    {
        rememberChangedField("MaintPlanPrdcssrCallCompltnDte", this.maintPlanPrdcssrCallCompltnDte);
        this.maintPlanPrdcssrCallCompltnDte = maintPlanPrdcssrCallCompltnDte;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanManualCallDate</b>
     * </p>
     *
     * @param maintenancePlanManualCallDate
     *            Manual call date
     */
    public void setMaintenancePlanManualCallDate( @Nullable final LocalDateTime maintenancePlanManualCallDate )
    {
        rememberChangedField("MaintenancePlanManualCallDate", this.maintenancePlanManualCallDate);
        this.maintenancePlanManualCallDate = maintenancePlanManualCallDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceCallLastPlannedDate</b>
     * </p>
     *
     * @param maintenanceCallLastPlannedDate
     *            Last planned date
     */
    public void setMaintenanceCallLastPlannedDate( @Nullable final LocalDateTime maintenanceCallLastPlannedDate )
    {
        rememberChangedField("MaintenanceCallLastPlannedDate", this.maintenanceCallLastPlannedDate);
        this.maintenanceCallLastPlannedDate = maintenanceCallLastPlannedDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenancePlanSchedule";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenancePlan", getMaintenancePlan());
        result.put("MaintenancePlanCallNumber", getMaintenancePlanCallNumber());
        result.put("MaintenancePackage", getMaintenancePackage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenancePlan", getMaintenancePlan());
        values.put("MaintenancePlanCallNumber", getMaintenancePlanCallNumber());
        values.put("MaintenancePackage", getMaintenancePackage());
        values.put("SchedulingType", getSchedulingType());
        values.put("SchedulingStatus", getSchedulingStatus());
        values.put("MeasuringPoint", getMeasuringPoint());
        values.put("MaintenanceTaskPerformanceUnit", getMaintenanceTaskPerformanceUnit());
        values.put("MaintenanceCallNextPlannedDate", getMaintenanceCallNextPlannedDate());
        values.put("MaintenanceCallDate", getMaintenanceCallDate());
        values.put("CompletionDate", getCompletionDate());
        values.put("CompletionTime", getCompletionTime());
        values.put("CycleSetSequence", getCycleSetSequence());
        values.put("MaintCallCompltnCntrRdng", getMaintCallCompltnCntrRdng());
        values.put("MaintenanceCallIsOutstanding", getMaintenanceCallIsOutstanding());
        values.put("MaintCallIsInvokedOnPlndDate", getMaintCallIsInvokedOnPlndDate());
        values.put("MaintCallHorizonIsNotReached", getMaintCallHorizonIsNotReached());
        values.put("MaintPlanLastScheduledDate", getMaintPlanLastScheduledDate());
        values.put("ReleasedByUserName", getReleasedByUserName());
        values.put("MaintPlnCnctntdDuePackagesTxt", getMaintPlnCnctntdDuePackagesTxt());
        values.put("MaintPlanPrdcssrCallCompltnDte", getMaintPlanPrdcssrCallCompltnDte());
        values.put("MaintenancePlanManualCallDate", getMaintenancePlanManualCallDate());
        values.put("MaintenanceCallLastPlannedDate", getMaintenanceCallLastPlannedDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenancePlan") ) {
                final Object value = values.remove("MaintenancePlan");
                if( (value == null) || (!value.equals(getMaintenancePlan())) ) {
                    setMaintenancePlan(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanCallNumber") ) {
                final Object value = values.remove("MaintenancePlanCallNumber");
                if( (value == null) || (!value.equals(getMaintenancePlanCallNumber())) ) {
                    setMaintenancePlanCallNumber(((Integer) value));
                }
            }
            if( values.containsKey("MaintenancePackage") ) {
                final Object value = values.remove("MaintenancePackage");
                if( (value == null) || (!value.equals(getMaintenancePackage())) ) {
                    setMaintenancePackage(((String) value));
                }
            }
            if( values.containsKey("SchedulingType") ) {
                final Object value = values.remove("SchedulingType");
                if( (value == null) || (!value.equals(getSchedulingType())) ) {
                    setSchedulingType(((String) value));
                }
            }
            if( values.containsKey("SchedulingStatus") ) {
                final Object value = values.remove("SchedulingStatus");
                if( (value == null) || (!value.equals(getSchedulingStatus())) ) {
                    setSchedulingStatus(((String) value));
                }
            }
            if( values.containsKey("MeasuringPoint") ) {
                final Object value = values.remove("MeasuringPoint");
                if( (value == null) || (!value.equals(getMeasuringPoint())) ) {
                    setMeasuringPoint(((String) value));
                }
            }
            if( values.containsKey("MaintenanceTaskPerformanceUnit") ) {
                final Object value = values.remove("MaintenanceTaskPerformanceUnit");
                if( (value == null) || (!value.equals(getMaintenanceTaskPerformanceUnit())) ) {
                    setMaintenanceTaskPerformanceUnit(((String) value));
                }
            }
            if( values.containsKey("MaintenanceCallNextPlannedDate") ) {
                final Object value = values.remove("MaintenanceCallNextPlannedDate");
                if( (value == null) || (!value.equals(getMaintenanceCallNextPlannedDate())) ) {
                    setMaintenanceCallNextPlannedDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaintenanceCallDate") ) {
                final Object value = values.remove("MaintenanceCallDate");
                if( (value == null) || (!value.equals(getMaintenanceCallDate())) ) {
                    setMaintenanceCallDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CompletionDate") ) {
                final Object value = values.remove("CompletionDate");
                if( (value == null) || (!value.equals(getCompletionDate())) ) {
                    setCompletionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CompletionTime") ) {
                final Object value = values.remove("CompletionTime");
                if( (value == null) || (!value.equals(getCompletionTime())) ) {
                    setCompletionTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CycleSetSequence") ) {
                final Object value = values.remove("CycleSetSequence");
                if( (value == null) || (!value.equals(getCycleSetSequence())) ) {
                    setCycleSetSequence(((String) value));
                }
            }
            if( values.containsKey("MaintCallCompltnCntrRdng") ) {
                final Object value = values.remove("MaintCallCompltnCntrRdng");
                if( (value == null) || (!value.equals(getMaintCallCompltnCntrRdng())) ) {
                    setMaintCallCompltnCntrRdng(((Double) value));
                }
            }
            if( values.containsKey("MaintenanceCallIsOutstanding") ) {
                final Object value = values.remove("MaintenanceCallIsOutstanding");
                if( (value == null) || (!value.equals(getMaintenanceCallIsOutstanding())) ) {
                    setMaintenanceCallIsOutstanding(((Boolean) value));
                }
            }
            if( values.containsKey("MaintCallIsInvokedOnPlndDate") ) {
                final Object value = values.remove("MaintCallIsInvokedOnPlndDate");
                if( (value == null) || (!value.equals(getMaintCallIsInvokedOnPlndDate())) ) {
                    setMaintCallIsInvokedOnPlndDate(((Boolean) value));
                }
            }
            if( values.containsKey("MaintCallHorizonIsNotReached") ) {
                final Object value = values.remove("MaintCallHorizonIsNotReached");
                if( (value == null) || (!value.equals(getMaintCallHorizonIsNotReached())) ) {
                    setMaintCallHorizonIsNotReached(((Boolean) value));
                }
            }
            if( values.containsKey("MaintPlanLastScheduledDate") ) {
                final Object value = values.remove("MaintPlanLastScheduledDate");
                if( (value == null) || (!value.equals(getMaintPlanLastScheduledDate())) ) {
                    setMaintPlanLastScheduledDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ReleasedByUserName") ) {
                final Object value = values.remove("ReleasedByUserName");
                if( (value == null) || (!value.equals(getReleasedByUserName())) ) {
                    setReleasedByUserName(((String) value));
                }
            }
            if( values.containsKey("MaintPlnCnctntdDuePackagesTxt") ) {
                final Object value = values.remove("MaintPlnCnctntdDuePackagesTxt");
                if( (value == null) || (!value.equals(getMaintPlnCnctntdDuePackagesTxt())) ) {
                    setMaintPlnCnctntdDuePackagesTxt(((String) value));
                }
            }
            if( values.containsKey("MaintPlanPrdcssrCallCompltnDte") ) {
                final Object value = values.remove("MaintPlanPrdcssrCallCompltnDte");
                if( (value == null) || (!value.equals(getMaintPlanPrdcssrCallCompltnDte())) ) {
                    setMaintPlanPrdcssrCallCompltnDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaintenancePlanManualCallDate") ) {
                final Object value = values.remove("MaintenancePlanManualCallDate");
                if( (value == null) || (!value.equals(getMaintenancePlanManualCallDate())) ) {
                    setMaintenancePlanManualCallDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MaintenanceCallLastPlannedDate") ) {
                final Object value = values.remove("MaintenanceCallLastPlannedDate");
                if( (value == null) || (!value.equals(getMaintenanceCallLastPlannedDate())) ) {
                    setMaintenanceCallLastPlannedDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenancePlanCallObjects") ) {
                final Object value = (values).remove("to_MaintenancePlanCallObjects");
                if( value instanceof Iterable ) {
                    if( toMaintenancePlanCallObjects == null ) {
                        toMaintenancePlanCallObjects = Lists.newArrayList();
                    } else {
                        toMaintenancePlanCallObjects = Lists.newArrayList(toMaintenancePlanCallObjects);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        MaintenancePlanCallObject entity;
                        if( toMaintenancePlanCallObjects.size() > i ) {
                            entity = toMaintenancePlanCallObjects.get(i);
                        } else {
                            entity = new MaintenancePlanCallObject();
                            toMaintenancePlanCallObjects.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintenancePlanScheduleField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintenancePlanScheduleField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenancePlanScheduleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenancePlanScheduleField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenancePlanCallObjects != null ) {
            (values).put("to_MaintenancePlanCallObjects", toMaintenancePlanCallObjects);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenancePlanCallObject</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_MaintenancePlanCallObjects</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>MaintenancePlanCallObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenancePlanCallObject> fetchMaintenancePlanCallObjects()
    {
        return fetchFieldAsList("to_MaintenancePlanCallObjects", MaintenancePlanCallObject.class);
    }

    /**
     * Retrieval of associated <b>MaintenancePlanCallObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenancePlanCallObjects</b>.
     * <p>
     * If the navigation property <b>to_MaintenancePlanCallObjects</b> of a queried <b>MaintenancePlanSchedule</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenancePlanCallObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<MaintenancePlanCallObject> getMaintenancePlanCallObjectsOrFetch()
    {
        if( toMaintenancePlanCallObjects == null ) {
            toMaintenancePlanCallObjects = fetchMaintenancePlanCallObjects();
        }
        return toMaintenancePlanCallObjects;
    }

    /**
     * Retrieval of associated <b>MaintenancePlanCallObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_MaintenancePlanCallObjects</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenancePlanSchedule</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenancePlanCallObjects</b> is already loaded, the
     *         result will contain the <b>MaintenancePlanCallObject</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<MaintenancePlanCallObject>> getMaintenancePlanCallObjectsIfPresent()
    {
        return Option.of(toMaintenancePlanCallObjects);
    }

    /**
     * Overwrites the list of associated <b>MaintenancePlanCallObject</b> entities for the loaded navigation property
     * <b>to_MaintenancePlanCallObjects</b>.
     * <p>
     * If the navigation property <b>to_MaintenancePlanCallObjects</b> of a queried <b>MaintenancePlanSchedule</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>MaintenancePlanCallObject</b> entities.
     */
    public void setMaintenancePlanCallObjects( @Nonnull final List<MaintenancePlanCallObject> value )
    {
        if( toMaintenancePlanCallObjects == null ) {
            toMaintenancePlanCallObjects = Lists.newArrayList();
        }
        toMaintenancePlanCallObjects.clear();
        toMaintenancePlanCallObjects.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>MaintenancePlanCallObject</b> entities. This corresponds to the OData
     * navigation property <b>to_MaintenancePlanCallObjects</b>.
     * <p>
     * If the navigation property <b>to_MaintenancePlanCallObjects</b> of a queried <b>MaintenancePlanSchedule</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>MaintenancePlanCallObject</b> entities.
     */
    public void addMaintenancePlanCallObjects( MaintenancePlanCallObject... entity )
    {
        if( toMaintenancePlanCallObjects == null ) {
            toMaintenancePlanCallObjects = Lists.newArrayList();
        }
        toMaintenancePlanCallObjects.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of MaintenancePlanSchedule instances.
     *
     */
    public final static class MaintenancePlanScheduleBuilder
    {

        private List<MaintenancePlanCallObject> toMaintenancePlanCallObjects = Lists.newArrayList();

        private MaintenancePlanSchedule.MaintenancePlanScheduleBuilder toMaintenancePlanCallObjects(
            final List<MaintenancePlanCallObject> value )
        {
            toMaintenancePlanCallObjects.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_MaintenancePlanCallObjects</b> for <b>MaintenancePlanSchedule</b> to multiple
         * <b>MaintenancePlanCallObject</b>.
         *
         * @param value
         *            The MaintenancePlanCallObjects to build this MaintenancePlanSchedule with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenancePlanSchedule.MaintenancePlanScheduleBuilder maintenancePlanCallObjects(
            MaintenancePlanCallObject... value )
        {
            return toMaintenancePlanCallObjects(Lists.newArrayList(value));
        }

    }

}
