/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintenancePlanStrategyCycleField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintenancePlanStrategyCycleSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Maintenance Cycles of Strategy Plan
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenancePlanStrategyCycle_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenancePlanStrategyCycle extends VdmEntity<MaintenancePlanStrategyCycle>
{

    /**
     * Selector for all available fields of MaintenancePlanStrategyCycle.
     *
     */
    public final static MaintenancePlanStrategyCycleSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @return Maintenance Plan
     */
    @Key
    @SerializedName( "MaintenancePlan" )
    @JsonProperty( "MaintenancePlan" )
    @Nullable
    @ODataField( odataName = "MaintenancePlan" )
    private String maintenancePlan;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlan</b> field to query operations.
     *
     */
    public final static MaintenancePlanStrategyCycleField<String> MAINTENANCE_PLAN =
        new MaintenancePlanStrategyCycleField<String>("MaintenancePlan");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCycle</b>
     * </p>
     *
     * @return Counter in Control Tables
     */
    @Key
    @SerializedName( "MaintenancePlanCycle" )
    @JsonProperty( "MaintenancePlanCycle" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanCycle" )
    private String maintenancePlanCycle;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanCycle</b> field to query operations.
     *
     */
    public final static MaintenancePlanStrategyCycleField<String> MAINTENANCE_PLAN_CYCLE =
        new MaintenancePlanStrategyCycleField<String>("MaintenancePlanCycle");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStrategy</b>
     * </p>
     *
     * @return Maintenance Strategy
     */
    @SerializedName( "MaintenanceStrategy" )
    @JsonProperty( "MaintenanceStrategy" )
    @Nullable
    @ODataField( odataName = "MaintenanceStrategy" )
    private String maintenanceStrategy;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceStrategy</b> field to query operations.
     *
     */
    public final static MaintenancePlanStrategyCycleField<String> MAINTENANCE_STRATEGY =
        new MaintenancePlanStrategyCycleField<String>("MaintenanceStrategy");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycRcrrcIntervalQty</b>
     * </p>
     *
     * @return Maintenance Plan Cycle Interval
     */
    @SerializedName( "MaintPlanCycRcrrcIntervalQty" )
    @JsonProperty( "MaintPlanCycRcrrcIntervalQty" )
    @Nullable
    @ODataField( odataName = "MaintPlanCycRcrrcIntervalQty" )
    private Double maintPlanCycRcrrcIntervalQty;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanCycRcrrcIntervalQty</b> field to query operations.
     *
     */
    public final static MaintenancePlanStrategyCycleField<Double> MAINT_PLAN_CYC_RCRRC_INTERVAL_QTY =
        new MaintenancePlanStrategyCycleField<Double>("MaintPlanCycRcrrcIntervalQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycRcrrcIntervalUnit</b>
     * </p>
     *
     * @return Unit for the performance of maintenance tasks
     */
    @SerializedName( "MaintPlanCycRcrrcIntervalUnit" )
    @JsonProperty( "MaintPlanCycRcrrcIntervalUnit" )
    @Nullable
    @ODataField( odataName = "MaintPlanCycRcrrcIntervalUnit" )
    private String maintPlanCycRcrrcIntervalUnit;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanCycRcrrcIntervalUnit</b> field to query operations.
     *
     */
    public final static MaintenancePlanStrategyCycleField<String> MAINT_PLAN_CYC_RCRRC_INTERVAL_UNIT =
        new MaintenancePlanStrategyCycleField<String>("MaintPlanCycRcrrcIntervalUnit");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycleDesc</b>
     * </p>
     *
     * @return Text for maintenance package/cycle (time/performance)
     */
    @SerializedName( "MaintPlanCycleDesc" )
    @JsonProperty( "MaintPlanCycleDesc" )
    @Nullable
    @ODataField( odataName = "MaintPlanCycleDesc" )
    private String maintPlanCycleDesc;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanCycleDesc</b> field to query operations.
     *
     */
    public final static MaintenancePlanStrategyCycleField<String> MAINT_PLAN_CYCLE_DESC =
        new MaintenancePlanStrategyCycleField<String>("MaintPlanCycleDesc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycleStartOffsetValue</b>
     * </p>
     *
     * @return Maintenance Plan Cycle Interval
     */
    @SerializedName( "MaintPlanCycleStartOffsetValue" )
    @JsonProperty( "MaintPlanCycleStartOffsetValue" )
    @Nullable
    @ODataField( odataName = "MaintPlanCycleStartOffsetValue" )
    private Double maintPlanCycleStartOffsetValue;
    /**
     * Use with available fluent helpers to apply the <b>MaintPlanCycleStartOffsetValue</b> field to query operations.
     *
     */
    public final static MaintenancePlanStrategyCycleField<Double> MAINT_PLAN_CYCLE_START_OFFSET_VALUE =
        new MaintenancePlanStrategyCycleField<Double>("MaintPlanCycleStartOffsetValue");

    @Nonnull
    @Override
    public Class<MaintenancePlanStrategyCycle> getType()
    {
        return MaintenancePlanStrategyCycle.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     */
    public void setMaintenancePlan( @Nullable final String maintenancePlan )
    {
        rememberChangedField("MaintenancePlan", this.maintenancePlan);
        this.maintenancePlan = maintenancePlan;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanCycle</b>
     * </p>
     *
     * @param maintenancePlanCycle
     *            Counter in Control Tables
     */
    public void setMaintenancePlanCycle( @Nullable final String maintenancePlanCycle )
    {
        rememberChangedField("MaintenancePlanCycle", this.maintenancePlanCycle);
        this.maintenancePlanCycle = maintenancePlanCycle;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStrategy</b>
     * </p>
     *
     * @param maintenanceStrategy
     *            Maintenance Strategy
     */
    public void setMaintenanceStrategy( @Nullable final String maintenanceStrategy )
    {
        rememberChangedField("MaintenanceStrategy", this.maintenanceStrategy);
        this.maintenanceStrategy = maintenanceStrategy;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycRcrrcIntervalQty</b>
     * </p>
     *
     * @param maintPlanCycRcrrcIntervalQty
     *            Maintenance Plan Cycle Interval
     */
    public void setMaintPlanCycRcrrcIntervalQty( @Nullable final Double maintPlanCycRcrrcIntervalQty )
    {
        rememberChangedField("MaintPlanCycRcrrcIntervalQty", this.maintPlanCycRcrrcIntervalQty);
        this.maintPlanCycRcrrcIntervalQty = maintPlanCycRcrrcIntervalQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycRcrrcIntervalUnit</b>
     * </p>
     *
     * @param maintPlanCycRcrrcIntervalUnit
     *            Unit for the performance of maintenance tasks
     */
    public void setMaintPlanCycRcrrcIntervalUnit( @Nullable final String maintPlanCycRcrrcIntervalUnit )
    {
        rememberChangedField("MaintPlanCycRcrrcIntervalUnit", this.maintPlanCycRcrrcIntervalUnit);
        this.maintPlanCycRcrrcIntervalUnit = maintPlanCycRcrrcIntervalUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycleDesc</b>
     * </p>
     *
     * @param maintPlanCycleDesc
     *            Text for maintenance package/cycle (time/performance)
     */
    public void setMaintPlanCycleDesc( @Nullable final String maintPlanCycleDesc )
    {
        rememberChangedField("MaintPlanCycleDesc", this.maintPlanCycleDesc);
        this.maintPlanCycleDesc = maintPlanCycleDesc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintPlanCycleStartOffsetValue</b>
     * </p>
     *
     * @param maintPlanCycleStartOffsetValue
     *            Maintenance Plan Cycle Interval
     */
    public void setMaintPlanCycleStartOffsetValue( @Nullable final Double maintPlanCycleStartOffsetValue )
    {
        rememberChangedField("MaintPlanCycleStartOffsetValue", this.maintPlanCycleStartOffsetValue);
        this.maintPlanCycleStartOffsetValue = maintPlanCycleStartOffsetValue;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenancePlanStrategyCycle";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenancePlan", getMaintenancePlan());
        result.put("MaintenancePlanCycle", getMaintenancePlanCycle());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenancePlan", getMaintenancePlan());
        values.put("MaintenancePlanCycle", getMaintenancePlanCycle());
        values.put("MaintenanceStrategy", getMaintenanceStrategy());
        values.put("MaintPlanCycRcrrcIntervalQty", getMaintPlanCycRcrrcIntervalQty());
        values.put("MaintPlanCycRcrrcIntervalUnit", getMaintPlanCycRcrrcIntervalUnit());
        values.put("MaintPlanCycleDesc", getMaintPlanCycleDesc());
        values.put("MaintPlanCycleStartOffsetValue", getMaintPlanCycleStartOffsetValue());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenancePlan") ) {
                final Object value = values.remove("MaintenancePlan");
                if( (value == null) || (!value.equals(getMaintenancePlan())) ) {
                    setMaintenancePlan(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanCycle") ) {
                final Object value = values.remove("MaintenancePlanCycle");
                if( (value == null) || (!value.equals(getMaintenancePlanCycle())) ) {
                    setMaintenancePlanCycle(((String) value));
                }
            }
            if( values.containsKey("MaintenanceStrategy") ) {
                final Object value = values.remove("MaintenanceStrategy");
                if( (value == null) || (!value.equals(getMaintenanceStrategy())) ) {
                    setMaintenanceStrategy(((String) value));
                }
            }
            if( values.containsKey("MaintPlanCycRcrrcIntervalQty") ) {
                final Object value = values.remove("MaintPlanCycRcrrcIntervalQty");
                if( (value == null) || (!value.equals(getMaintPlanCycRcrrcIntervalQty())) ) {
                    setMaintPlanCycRcrrcIntervalQty(((Double) value));
                }
            }
            if( values.containsKey("MaintPlanCycRcrrcIntervalUnit") ) {
                final Object value = values.remove("MaintPlanCycRcrrcIntervalUnit");
                if( (value == null) || (!value.equals(getMaintPlanCycRcrrcIntervalUnit())) ) {
                    setMaintPlanCycRcrrcIntervalUnit(((String) value));
                }
            }
            if( values.containsKey("MaintPlanCycleDesc") ) {
                final Object value = values.remove("MaintPlanCycleDesc");
                if( (value == null) || (!value.equals(getMaintPlanCycleDesc())) ) {
                    setMaintPlanCycleDesc(((String) value));
                }
            }
            if( values.containsKey("MaintPlanCycleStartOffsetValue") ) {
                final Object value = values.remove("MaintPlanCycleStartOffsetValue");
                if( (value == null) || (!value.equals(getMaintPlanCycleStartOffsetValue())) ) {
                    setMaintPlanCycleStartOffsetValue(((Double) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> MaintenancePlanStrategyCycleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new MaintenancePlanStrategyCycleField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenancePlanStrategyCycleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenancePlanStrategyCycleField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService.DEFAULT_SERVICE_PATH);
    }

}
