/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintenancePlanStrategyCycleSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle
 * MaintenancePlanStrategyCycle} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class MaintenancePlanStrategyCycleByKeyFluentHelper
    extends
    FluentHelperByKey<MaintenancePlanStrategyCycleByKeyFluentHelper, MaintenancePlanStrategyCycle, MaintenancePlanStrategyCycleSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle
     * MaintenancePlanStrategyCycle} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code MaintenancePlanStrategyCycle}
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code MaintenancePlanStrategyCycle}
     * @param maintenancePlanCycle
     *            Counter in Control Tables
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public MaintenancePlanStrategyCycleByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String maintenancePlan,
        final String maintenancePlanCycle )
    {
        super(servicePath, entityCollection);
        this.key.put("MaintenancePlan", maintenancePlan);
        this.key.put("MaintenancePlanCycle", maintenancePlanCycle);
    }

    @Override
    @Nonnull
    protected Class<MaintenancePlanStrategyCycle> getEntityClass()
    {
        return MaintenancePlanStrategyCycle.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
