/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintenancePlanTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintenancePlanTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable.MaintenancePlanTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Maintenance Plan Long Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintenancePlanTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class MaintenancePlanText extends VdmEntity<MaintenancePlanText>
{

    /**
     * Selector for all available fields of MaintenancePlanText.
     *
     */
    public final static MaintenancePlanTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @return Maintenance Plan
     */
    @Key
    @SerializedName( "MaintenancePlan" )
    @JsonProperty( "MaintenancePlan" )
    @Nullable
    @ODataField( odataName = "MaintenancePlan" )
    private String maintenancePlan;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlan</b> field to query operations.
     *
     */
    public final static MaintenancePlanTextField<String> MAINTENANCE_PLAN =
        new MaintenancePlanTextField<String>("MaintenancePlan");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static MaintenancePlanTextField<String> LANGUAGE = new MaintenancePlanTextField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "MaintenancePlanLongText" )
    @JsonProperty( "MaintenancePlanLongText" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanLongText" )
    private String maintenancePlanLongText;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanLongText</b> field to query operations.
     *
     */
    public final static MaintenancePlanTextField<String> MAINTENANCE_PLAN_LONG_TEXT =
        new MaintenancePlanTextField<String>("MaintenancePlanLongText");
    /**
     * Navigation property <b>to_MaintenancePlan</b> for <b>MaintenancePlanText</b> to single <b>MaintenancePlan</b>.
     *
     */
    @SerializedName( "to_MaintenancePlan" )
    @JsonProperty( "to_MaintenancePlan" )
    @ODataField( odataName = "to_MaintenancePlan" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private MaintenancePlan toMaintenancePlan;
    /**
     * Use with available fluent helpers to apply the <b>to_MaintenancePlan</b> navigation property to query operations.
     *
     */
    public final static MaintenancePlanTextOneToOneLink<MaintenancePlan> TO_MAINTENANCE_PLAN =
        new MaintenancePlanTextOneToOneLink<MaintenancePlan>("to_MaintenancePlan");

    @Nonnull
    @Override
    public Class<MaintenancePlanText> getType()
    {
        return MaintenancePlanText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlan</b>
     * </p>
     *
     * @param maintenancePlan
     *            Maintenance Plan
     */
    public void setMaintenancePlan( @Nullable final String maintenancePlan )
    {
        rememberChangedField("MaintenancePlan", this.maintenancePlan);
        this.maintenancePlan = maintenancePlan;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanLongText</b>
     * </p>
     *
     * @param maintenancePlanLongText
     *            Long Text
     */
    public void setMaintenancePlanLongText( @Nullable final String maintenancePlanLongText )
    {
        rememberChangedField("MaintenancePlanLongText", this.maintenancePlanLongText);
        this.maintenancePlanLongText = maintenancePlanLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "MaintenancePlanText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaintenancePlan", getMaintenancePlan());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaintenancePlan", getMaintenancePlan());
        values.put("Language", getLanguage());
        values.put("MaintenancePlanLongText", getMaintenancePlanLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintenancePlan") ) {
                final Object value = values.remove("MaintenancePlan");
                if( (value == null) || (!value.equals(getMaintenancePlan())) ) {
                    setMaintenancePlan(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanLongText") ) {
                final Object value = values.remove("MaintenancePlanLongText");
                if( (value == null) || (!value.equals(getMaintenancePlanLongText())) ) {
                    setMaintenancePlanLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_MaintenancePlan") ) {
                final Object value = (values).remove("to_MaintenancePlan");
                if( value instanceof Map ) {
                    if( toMaintenancePlan == null ) {
                        toMaintenancePlan = new MaintenancePlan();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toMaintenancePlan.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> MaintenancePlanTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new MaintenancePlanTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> MaintenancePlanTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new MaintenancePlanTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toMaintenancePlan != null ) {
            (values).put("to_MaintenancePlan", toMaintenancePlan);
        }
        return values;
    }

    /**
     * Fetches the <b>MaintenancePlan</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_MaintenancePlan</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>MaintenancePlan</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenancePlan fetchMaintenancePlan()
    {
        return fetchFieldAsSingle("to_MaintenancePlan", MaintenancePlan.class);
    }

    /**
     * Retrieval of associated <b>MaintenancePlan</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenancePlan</b>.
     * <p>
     * If the navigation property <b>to_MaintenancePlan</b> of a queried <b>MaintenancePlanText</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>MaintenancePlan</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public MaintenancePlan getMaintenancePlanOrFetch()
    {
        if( toMaintenancePlan == null ) {
            toMaintenancePlan = fetchMaintenancePlan();
        }
        return toMaintenancePlan;
    }

    /**
     * Retrieval of associated <b>MaintenancePlan</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_MaintenancePlan</b>.
     * <p>
     * If the navigation property for an entity <b>MaintenancePlanText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_MaintenancePlan</b> is already loaded, the result will
     *         contain the <b>MaintenancePlan</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<MaintenancePlan> getMaintenancePlanIfPresent()
    {
        return Option.of(toMaintenancePlan);
    }

    /**
     * Overwrites the associated <b>MaintenancePlan</b> entity for the loaded navigation property
     * <b>to_MaintenancePlan</b>.
     *
     * @param value
     *            New <b>MaintenancePlan</b> entity.
     */
    public void setMaintenancePlan( final MaintenancePlan value )
    {
        toMaintenancePlan = value;
    }

    /**
     * Helper class to allow for fluent creation of MaintenancePlanText instances.
     *
     */
    public final static class MaintenancePlanTextBuilder
    {

        private MaintenancePlan toMaintenancePlan;
        private String maintenancePlan = null;

        private MaintenancePlanText.MaintenancePlanTextBuilder toMaintenancePlan( final MaintenancePlan value )
        {
            toMaintenancePlan = value;
            return this;
        }

        /**
         * Navigation property <b>to_MaintenancePlan</b> for <b>MaintenancePlanText</b> to single
         * <b>MaintenancePlan</b>.
         *
         * @param value
         *            The MaintenancePlan to build this MaintenancePlanText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenancePlanText.MaintenancePlanTextBuilder maintenancePlan( final MaintenancePlan value )
        {
            return toMaintenancePlan(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>MaintenancePlan</b>
         * </p>
         *
         * @param value
         *            The maintenancePlan to build this MaintenancePlanText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public MaintenancePlanText.MaintenancePlanTextBuilder maintenancePlan( final String value )
        {
            maintenancePlan = value;
            return this;
        }

    }

}
