/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan;

import java.net.URI;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>StartScheduleInCycle</b> OData function import.
 *
 */
public class StartScheduleInCycleFluentHelper
    extends
    SingleValuedFluentHelperFunction<StartScheduleInCycleFluentHelper, MaintenancePlan, MaintenancePlan>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>StartScheduleInCycle</b> OData function import with the
     * provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the fluent
     * helper object.
     *
     * @param completionTime
     *            Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CompletionTime</b>
     *            </p>
     * @param maintPlnCallCompltnCntrRdngVal
     *            Compl.CountRead.
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 22
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintPlnCallCompltnCntrRdngVal</b>
     *            </p>
     * @param maintPlanSchedFutrCallsAreKept
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintPlanSchedFutrCallsAreKept</b>
     *            </p>
     * @param maintenancePlan
     *            Maintenance Plan
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePlan</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param maintPlanCycleOffsetValue
     *            Offset
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintPlanCycleOffsetValue</b>
     *            </p>
     * @param completionDate
     *            Completion date
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CompletionDate</b>
     *            </p>
     * @param maintenanceTaskPerformanceUnit
     *            Unit
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenanceTaskPerformanceUnit</b>
     *            </p>
     * @param maintenancePackage
     *            Package
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintenancePackage</b>
     *            </p>
     */
    public StartScheduleInCycleFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String maintenancePlan,
        @Nullable final String maintenancePackage,
        @Nullable final Integer maintPlanCycleOffsetValue,
        @Nullable final String maintenanceTaskPerformanceUnit,
        @Nullable final Boolean maintPlanSchedFutrCallsAreKept,
        @Nullable final LocalDateTime completionDate,
        @Nullable final LocalTime completionTime,
        @Nullable final String maintPlnCallCompltnCntrRdngVal )
    {
        super(servicePath);
        values.put("MaintenancePlan", maintenancePlan);
        if( maintenancePackage != null ) {
            values.put("MaintenancePackage", maintenancePackage);
        }
        if( maintPlanCycleOffsetValue != null ) {
            values.put("MaintPlanCycleOffsetValue", maintPlanCycleOffsetValue);
        }
        if( maintenanceTaskPerformanceUnit != null ) {
            values.put("MaintenanceTaskPerformanceUnit", maintenanceTaskPerformanceUnit);
        }
        if( maintPlanSchedFutrCallsAreKept != null ) {
            values.put("MaintPlanSchedFutrCallsAreKept", maintPlanSchedFutrCallsAreKept);
        }
        if( completionDate != null ) {
            values.put("CompletionDate", completionDate);
        }
        if( completionTime != null ) {
            values.put("CompletionTime", completionTime);
        }
        if( maintPlnCallCompltnCntrRdngVal != null ) {
            values.put("MaintPlnCallCompltnCntrRdngVal", maintPlnCallCompltnCntrRdngVal);
        }
    }

    @Override
    @Nonnull
    protected Class<MaintenancePlan> getEntityClass()
    {
        return MaintenancePlan.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "StartScheduleInCycle";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public MaintenancePlan executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
