/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link MaintenancePlanServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService MaintenancePlanService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultMaintenancePlanServiceBatch
    extends
    BatchFluentHelperBasic<MaintenancePlanServiceBatch, MaintenancePlanServiceBatchChangeSet>
    implements
    MaintenancePlanServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultMaintenancePlanServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaintenancePlanServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultMaintenancePlanServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultMaintenancePlanServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultMaintenancePlanServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultMaintenancePlanServiceBatchChangeSet(this, service);
    }

}
