/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanText;

/**
 * Implementation of the {@link MaintenancePlanServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService MaintenancePlanService}.
 *
 */
public class DefaultMaintenancePlanServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<MaintenancePlanServiceBatch, MaintenancePlanServiceBatchChangeSet>
    implements
    MaintenancePlanServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService service;

    @SuppressWarnings( "deprecation" )
    DefaultMaintenancePlanServiceBatchChangeSet(
        @Nonnull final DefaultMaintenancePlanServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultMaintenancePlanServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet createMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem )
    {
        return addRequestCreate(service::createMaintenanceItem, maintenanceItem);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet updateMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem )
    {
        return addRequestUpdate(service::updateMaintenanceItem, maintenanceItem);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet createMaintenanceItemCause(
        @Nonnull final MaintenanceItemCause maintenanceItemCause )
    {
        return addRequestCreate(service::createMaintenanceItemCause, maintenanceItemCause);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet updateMaintenanceItemCause(
        @Nonnull final MaintenanceItemCause maintenanceItemCause )
    {
        return addRequestUpdate(service::updateMaintenanceItemCause, maintenanceItemCause);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet deleteMaintenanceItemCause(
        @Nonnull final MaintenanceItemCause maintenanceItemCause )
    {
        return addRequestDelete(service::deleteMaintenanceItemCause, maintenanceItemCause);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet updateMaintenanceItemCauseText(
        @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText )
    {
        return addRequestUpdate(service::updateMaintenanceItemCauseText, maintenanceItemCauseText);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet deleteMaintenanceItemCauseText(
        @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText )
    {
        return addRequestDelete(service::deleteMaintenanceItemCauseText, maintenanceItemCauseText);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet createMaintenanceItemReason(
        @Nonnull final MaintenanceItemReason maintenanceItemReason )
    {
        return addRequestCreate(service::createMaintenanceItemReason, maintenanceItemReason);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet updateMaintenanceItemReason(
        @Nonnull final MaintenanceItemReason maintenanceItemReason )
    {
        return addRequestUpdate(service::updateMaintenanceItemReason, maintenanceItemReason);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet deleteMaintenanceItemReason(
        @Nonnull final MaintenanceItemReason maintenanceItemReason )
    {
        return addRequestDelete(service::deleteMaintenanceItemReason, maintenanceItemReason);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet updateMaintenanceItemReasonText(
        @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText )
    {
        return addRequestUpdate(service::updateMaintenanceItemReasonText, maintenanceItemReasonText);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet deleteMaintenanceItemReasonText(
        @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText )
    {
        return addRequestDelete(service::deleteMaintenanceItemReasonText, maintenanceItemReasonText);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet updateMaintenanceItemText(
        @Nonnull final MaintenanceItemText maintenanceItemText )
    {
        return addRequestUpdate(service::updateMaintenanceItemText, maintenanceItemText);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet createMaintenancePlan( @Nonnull final MaintenancePlan maintenancePlan )
    {
        return addRequestCreate(service::createMaintenancePlan, maintenancePlan);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet updateMaintenancePlan( @Nonnull final MaintenancePlan maintenancePlan )
    {
        return addRequestUpdate(service::updateMaintenancePlan, maintenancePlan);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet updateMaintenancePlanCycle(
        @Nonnull final MaintenancePlanCycle maintenancePlanCycle )
    {
        return addRequestUpdate(service::updateMaintenancePlanCycle, maintenancePlanCycle);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet updateMaintenancePlanText(
        @Nonnull final MaintenancePlanText maintenancePlanText )
    {
        return addRequestUpdate(service::updateMaintenancePlanText, maintenancePlanText);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet updateMaintItemObjectListItem(
        @Nonnull final MaintItemObjectListItem maintItemObjectListItem )
    {
        return addRequestUpdate(service::updateMaintItemObjectListItem, maintItemObjectListItem);
    }

    @Nonnull
    @Override
    public MaintenancePlanServiceBatchChangeSet deleteMaintItemObjectListItem(
        @Nonnull final MaintItemObjectListItem maintItemObjectListItem )
    {
        return addRequestDelete(service::deleteMaintItemObjectListItem, maintItemObjectListItem);
    }

}
