/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.MaintenancePlanService MaintenancePlanService}.
 *
 */
public interface MaintenancePlanServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<MaintenancePlanServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<MaintenancePlanServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem
     * MaintenanceItem} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem
     *            MaintenanceItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet createMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem
     * MaintenanceItem} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItem
     *            MaintenanceItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet updateMaintenanceItem( @Nonnull final MaintenanceItem maintenanceItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     * MaintenanceItemCause} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     *            MaintenanceItemCause} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        createMaintenanceItemCause( @Nonnull final MaintenanceItemCause maintenanceItemCause );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     * MaintenanceItemCause} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     *            MaintenanceItemCause} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        updateMaintenanceItemCause( @Nonnull final MaintenanceItemCause maintenanceItemCause );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     * MaintenanceItemCause} entity in the S/4HANA system.
     *
     * @param maintenanceItemCause
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCause
     *            MaintenanceItemCause} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        deleteMaintenanceItemCause( @Nonnull final MaintenanceItemCause maintenanceItemCause );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
     * MaintenanceItemCauseText} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemCauseText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
     *            MaintenanceItemCauseText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        updateMaintenanceItemCauseText( @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
     * MaintenanceItemCauseText} entity in the S/4HANA system.
     *
     * @param maintenanceItemCauseText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
     *            MaintenanceItemCauseText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        deleteMaintenanceItemCauseText( @Nonnull final MaintenanceItemCauseText maintenanceItemCauseText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     * MaintenanceItemReason} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemReason
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     *            MaintenanceItemReason} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        createMaintenanceItemReason( @Nonnull final MaintenanceItemReason maintenanceItemReason );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     * MaintenanceItemReason} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemReason
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     *            MaintenanceItemReason} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        updateMaintenanceItemReason( @Nonnull final MaintenanceItemReason maintenanceItemReason );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     * MaintenanceItemReason} entity in the S/4HANA system.
     *
     * @param maintenanceItemReason
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReason
     *            MaintenanceItemReason} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        deleteMaintenanceItemReason( @Nonnull final MaintenanceItemReason maintenanceItemReason );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
     * MaintenanceItemReasonText} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemReasonText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
     *            MaintenanceItemReasonText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        updateMaintenanceItemReasonText( @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
     * MaintenanceItemReasonText} entity in the S/4HANA system.
     *
     * @param maintenanceItemReasonText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
     *            MaintenanceItemReasonText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        deleteMaintenanceItemReasonText( @Nonnull final MaintenanceItemReasonText maintenanceItemReasonText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText
     * MaintenanceItemText} entity and save it to the S/4HANA system.
     *
     * @param maintenanceItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemText
     *            MaintenanceItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        updateMaintenanceItemText( @Nonnull final MaintenanceItemText maintenanceItemText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan
     * MaintenancePlan} entity and save it to the S/4HANA system.
     *
     * @param maintenancePlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan
     *            MaintenancePlan} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet createMaintenancePlan( @Nonnull final MaintenancePlan maintenancePlan );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan
     * MaintenancePlan} entity and save it to the S/4HANA system.
     *
     * @param maintenancePlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan
     *            MaintenancePlan} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet updateMaintenancePlan( @Nonnull final MaintenancePlan maintenancePlan );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle
     * MaintenancePlanCycle} entity and save it to the S/4HANA system.
     *
     * @param maintenancePlanCycle
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle
     *            MaintenancePlanCycle} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        updateMaintenancePlanCycle( @Nonnull final MaintenancePlanCycle maintenancePlanCycle );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanText
     * MaintenancePlanText} entity and save it to the S/4HANA system.
     *
     * @param maintenancePlanText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanText
     *            MaintenancePlanText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        updateMaintenancePlanText( @Nonnull final MaintenancePlanText maintenancePlanText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     * MaintItemObjectListItem} entity and save it to the S/4HANA system.
     *
     * @param maintItemObjectListItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     *            MaintItemObjectListItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        updateMaintItemObjectListItem( @Nonnull final MaintItemObjectListItem maintItemObjectListItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     * MaintItemObjectListItem} entity in the S/4HANA system.
     *
     * @param maintItemObjectListItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintItemObjectListItem
     *            MaintItemObjectListItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    MaintenancePlanServiceBatchChangeSet
        deleteMaintItemObjectListItem( @Nonnull final MaintItemObjectListItem maintItemObjectListItem );

}
