/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass MaintPlanClfnClass}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintPlanClfnClassField
 * MaintPlanClfnClassField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintPlanClfnClassLink
 * MaintPlanClfnClassLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#MAINTENANCE_PLAN
 * MAINTENANCE_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#CLASS_INTERNAL_ID
 * CLASS_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#CLASS_TYPE
 * CLASS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#CLFN_STATUS
 * CLFN_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#CLASS_POSITION_NUMBER
 * CLASS_POSITION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#CLASS_IS_STANDARD_CLASS
 * CLASS_IS_STANDARD_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#CLFN_OBJECT_INTERNAL_ID
 * CLFN_OBJECT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#CLASS_PROPERTY
 * CLASS_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#CLASS_MAINT_AUTH_GRP
 * CLASS_MAINT_AUTH_GRP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#CLASS_CLASSFCTN_AUTH_GRP
 * CLASS_CLASSFCTN_AUTH_GRP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#MAINTENANCE_PLAN_CALL_OBJECT
 * MAINTENANCE_PLAN_CALL_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintPlanClfnClass#TO_CHARACTERISTIC
 * TO_CHARACTERISTIC}</li>
 * </ul>
 *
 */
public interface MaintPlanClfnClassSelectable extends EntitySelectable<MaintPlanClfnClass>
{

}
