/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText
 * MaintenanceItemCauseText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintenanceItemCauseTextField
 * MaintenanceItemCauseTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintenanceItemCauseTextLink
 * MaintenanceItemCauseTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText#MAINTENANCE_ITEM
 * MAINTENANCE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText#NMBR_OF_MAINT_COMPLIANCE_ITEMS
 * NMBR_OF_MAINT_COMPLIANCE_ITEMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText#PLAIN_LONG_TEXT
 * PLAIN_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText#TO_MAINTENANCE_ITEM_CAUSE
 * TO_MAINTENANCE_ITEM_CAUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemCauseText#TO_MAINTENANCE_ITEM
 * TO_MAINTENANCE_ITEM}</li>
 * </ul>
 *
 */
public interface MaintenanceItemCauseTextSelectable extends EntitySelectable<MaintenanceItemCauseText>
{

}
