/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText
 * MaintenanceItemReasonText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintenanceItemReasonTextField
 * MaintenanceItemReasonTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintenanceItemReasonTextLink
 * MaintenanceItemReasonTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText#MAINTENANCE_ITEM
 * MAINTENANCE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText#NMBR_OF_MAINT_COMPLIANCE_ITEMS
 * NMBR_OF_MAINT_COMPLIANCE_ITEMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText#PLAIN_LONG_TEXT
 * PLAIN_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText#TO_MAINTENANCE_ITEM_REASON
 * TO_MAINTENANCE_ITEM_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenanceItemReasonText#TO_MAINTENANCE_ITEM
 * TO_MAINTENANCE_ITEM}</li>
 * </ul>
 *
 */
public interface MaintenanceItemReasonTextSelectable extends EntitySelectable<MaintenanceItemReasonText>
{

}
