/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle
 * MaintenancePlanCycle}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintenancePlanCycleField
 * MaintenancePlanCycleField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintenancePlanCycleLink
 * MaintenancePlanCycleLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle#MAINTENANCE_PLAN
 * MAINTENANCE_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle#MAINTENANCE_PLAN_CYCLE
 * MAINTENANCE_PLAN_CYCLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle#MAINTENANCE_STRATEGY
 * MAINTENANCE_STRATEGY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle#CYCLE_SET_SEQUENCE
 * CYCLE_SET_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle#MAINT_PLAN_CYC_RCRRC_INTERVAL_QTY
 * MAINT_PLAN_CYC_RCRRC_INTERVAL_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle#MAINT_PLAN_CYC_RCRRC_INTERVAL_UNIT
 * MAINT_PLAN_CYC_RCRRC_INTERVAL_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle#MAINT_PLAN_CYCLE_DESC
 * MAINT_PLAN_CYCLE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle#MEASURING_POINT
 * MEASURING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle#MAINT_PLAN_CYCLE_START_OFFSET_VALUE
 * MAINT_PLAN_CYCLE_START_OFFSET_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle#MAINT_CYCLE_NEXT_PLND_CNTR_RDNG
 * MAINT_CYCLE_NEXT_PLND_CNTR_RDNG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle#MAINTENANCE_PLAN_CYCLE_IS_INACTIVE
 * MAINTENANCE_PLAN_CYCLE_IS_INACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle#CYCLE_SET_SEQUENCE_REPEAT_FACTOR
 * CYCLE_SET_SEQUENCE_REPEAT_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanCycle#TO_MAINTENANCE_PLAN
 * TO_MAINTENANCE_PLAN}</li>
 * </ul>
 *
 */
public interface MaintenancePlanCycleSelectable extends EntitySelectable<MaintenancePlanCycle>
{

}
