/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule
 * MaintenancePlanSchedule}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintenancePlanScheduleField
 * MaintenancePlanScheduleField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintenancePlanScheduleLink
 * MaintenancePlanScheduleLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINTENANCE_PLAN
 * MAINTENANCE_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINTENANCE_PLAN_CALL_NUMBER
 * MAINTENANCE_PLAN_CALL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINTENANCE_PACKAGE
 * MAINTENANCE_PACKAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#SCHEDULING_TYPE
 * SCHEDULING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#SCHEDULING_STATUS
 * SCHEDULING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MEASURING_POINT
 * MEASURING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINTENANCE_TASK_PERFORMANCE_UNIT
 * MAINTENANCE_TASK_PERFORMANCE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINTENANCE_CALL_NEXT_PLANNED_DATE
 * MAINTENANCE_CALL_NEXT_PLANNED_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINTENANCE_CALL_DATE
 * MAINTENANCE_CALL_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#COMPLETION_DATE
 * COMPLETION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#COMPLETION_TIME
 * COMPLETION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#CYCLE_SET_SEQUENCE
 * CYCLE_SET_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINT_CALL_COMPLTN_CNTR_RDNG
 * MAINT_CALL_COMPLTN_CNTR_RDNG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINTENANCE_CALL_IS_OUTSTANDING
 * MAINTENANCE_CALL_IS_OUTSTANDING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINT_CALL_IS_INVOKED_ON_PLND_DATE
 * MAINT_CALL_IS_INVOKED_ON_PLND_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINT_CALL_HORIZON_IS_NOT_REACHED
 * MAINT_CALL_HORIZON_IS_NOT_REACHED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINT_PLAN_LAST_SCHEDULED_DATE
 * MAINT_PLAN_LAST_SCHEDULED_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#RELEASED_BY_USER_NAME
 * RELEASED_BY_USER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINT_PLN_CNCTNTD_DUE_PACKAGES_TXT
 * MAINT_PLN_CNCTNTD_DUE_PACKAGES_TXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINT_PLAN_PRDCSSR_CALL_COMPLTN_DTE
 * MAINT_PLAN_PRDCSSR_CALL_COMPLTN_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINTENANCE_PLAN_MANUAL_CALL_DATE
 * MAINTENANCE_PLAN_MANUAL_CALL_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#MAINTENANCE_CALL_LAST_PLANNED_DATE
 * MAINTENANCE_CALL_LAST_PLANNED_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanSchedule#TO_MAINTENANCE_PLAN_CALL_OBJECTS
 * TO_MAINTENANCE_PLAN_CALL_OBJECTS}</li>
 * </ul>
 *
 */
public interface MaintenancePlanScheduleSelectable extends EntitySelectable<MaintenancePlanSchedule>
{

}
