/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan MaintenancePlan}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintenancePlanField
 * MaintenancePlanField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintenancePlanLink
 * MaintenancePlanLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINTENANCE_PLAN
 * MAINTENANCE_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINTENANCE_PLAN_DESC
 * MAINTENANCE_PLAN_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINTENANCE_STRATEGY
 * MAINTENANCE_STRATEGY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#SCHEDULING_DURATION
 * SCHEDULING_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#SCHEDULING_DURATION_UNIT
 * SCHEDULING_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#NUMBER_OF_MAINTENANCE_ITEMS
 * NUMBER_OF_MAINTENANCE_ITEMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#CYCLE_MODIFICATION_RATIO
 * CYCLE_MODIFICATION_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINT_PLAN_SCHEDG_INDICATOR
 * MAINT_PLAN_SCHEDG_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#CALL_HORIZON_PERCENT
 * CALL_HORIZON_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#CALL_HORIZON_IN_DAYS
 * CALL_HORIZON_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINTENANCE_CALL_HORIZON_CALC_TYPE
 * MAINTENANCE_CALL_HORIZON_CALC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINTENANCE_PLAN_INTERNAL_ID
 * MAINTENANCE_PLAN_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINTENANCE_CALL
 * MAINTENANCE_CALL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINTENANCE_PLAN_CATEGORY
 * MAINTENANCE_PLAN_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINT_PLAN_FREE_DEFINED_ATTRIB
 * MAINT_PLAN_FREE_DEFINED_ATTRIB}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#BASIC_START_DATE
 * BASIC_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#SCHEDULING_START_DATE
 * SCHEDULING_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#SCHEDULING_START_TIME
 * SCHEDULING_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINT_PLAN_START_CNTR_READING_VALUE
 * MAINT_PLAN_START_CNTR_READING_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINT_PLN_STRT_BUF_DURATION_IN_DAYS
 * MAINT_PLN_STRT_BUF_DURATION_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINT_PLAN_START_BUFFER_UNIT
 * MAINT_PLAN_START_BUFFER_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#FACTORY_CALENDAR
 * FACTORY_CALENDAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#LATE_COMPLETION_SHIFT_IN_PERCENT
 * LATE_COMPLETION_SHIFT_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#LATE_COMPLETION_TOLERANCE_PERCENT
 * LATE_COMPLETION_TOLERANCE_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#EARLY_COMPLETION_SHIFT_IN_PERCENT
 * EARLY_COMPLETION_SHIFT_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#EARLY_COMPLETION_TOLERANCE_PCT
 * EARLY_COMPLETION_TOLERANCE_PCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#PRDCSSR_CALL_OBJ_COMPLTN_IS_RQD
 * PRDCSSR_CALL_OBJ_COMPLTN_IS_RQD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINT_PLAN_LOGICAL_OPERATOR_CODE
 * MAINT_PLAN_LOGICAL_OPERATOR_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#SCHEDULING_END_DATE
 * SCHEDULING_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINT_PLAN_END_CNTR_READING_VALUE
 * MAINT_PLAN_END_CNTR_READING_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MULTIPLE_COUNTER_PLAN_SHIFT_FACTOR
 * MULTIPLE_COUNTER_PLAN_SHIFT_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINTENANCE_LEAD_FLOAT_IN_DAYS
 * MAINTENANCE_LEAD_FLOAT_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINTENANCE_PLAN_CALL_OBJECT
 * MAINTENANCE_PLAN_CALL_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#MAINTENANCE_PLAN_SYSTEM_STATUS
 * MAINTENANCE_PLAN_SYSTEM_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#TO_ITEM TO_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#TO_LONG_TEXT
 * TO_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#TO_MAINTENANCE_CYCLE
 * TO_MAINTENANCE_CYCLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#TO_MAINT_PLAN_CLFN_CLASS
 * TO_MAINT_PLAN_CLFN_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#TO_SCHEDULES
 * TO_SCHEDULES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlan#TO_STRATEGY_CYCLE
 * TO_STRATEGY_CYCLE}</li>
 * </ul>
 *
 */
public interface MaintenancePlanSelectable extends EntitySelectable<MaintenancePlan>
{

}
