/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle
 * MaintenancePlanStrategyCycle}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.field.MaintenancePlanStrategyCycleField
 * MaintenancePlanStrategyCycleField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.link.MaintenancePlanStrategyCycleLink
 * MaintenancePlanStrategyCycleLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle#MAINTENANCE_PLAN
 * MAINTENANCE_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle#MAINTENANCE_PLAN_CYCLE
 * MAINTENANCE_PLAN_CYCLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle#MAINTENANCE_STRATEGY
 * MAINTENANCE_STRATEGY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle#MAINT_PLAN_CYC_RCRRC_INTERVAL_QTY
 * MAINT_PLAN_CYC_RCRRC_INTERVAL_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle#MAINT_PLAN_CYC_RCRRC_INTERVAL_UNIT
 * MAINT_PLAN_CYC_RCRRC_INTERVAL_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle#MAINT_PLAN_CYCLE_DESC
 * MAINT_PLAN_CYCLE_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.maintenanceplan.MaintenancePlanStrategyCycle#MAINT_PLAN_CYCLE_START_OFFSET_VALUE
 * MAINT_PLAN_CYCLE_START_OFFSET_VALUE}</li>
 * </ul>
 *
 */
public interface MaintenancePlanStrategyCycleSelectable extends EntitySelectable<MaintenancePlanStrategyCycle>
{

}
