/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.field.ImportDataSetField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.selectable.ImportDataSetSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Accrual Input Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ImportDataSet</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ImportDataSet extends VdmEntity<ImportDataSet>
{

    /**
     * Selector for all available fields of ImportDataSet.
     *
     */
    public final static ImportDataSetSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Wbselement_ID</b>
     * </p>
     *
     * @return WBS Element
     */
    @Key
    @SerializedName( "Wbselement_ID" )
    @JsonProperty( "Wbselement_ID" )
    @Nullable
    @ODataField( odataName = "Wbselement_ID" )
    private String wbselement_ID;
    /**
     * Use with available fluent helpers to apply the <b>Wbselement_ID</b> field to query operations.
     *
     */
    public final static ImportDataSetField<String> WBSELEMENT_ID = new ImportDataSetField<String>("Wbselement_ID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Fiscal_Period</b>
     * </p>
     *
     * @return Period
     */
    @Key
    @SerializedName( "Fiscal_Period" )
    @JsonProperty( "Fiscal_Period" )
    @Nullable
    @ODataField( odataName = "Fiscal_Period" )
    private String fiscal_Period;
    /**
     * Use with available fluent helpers to apply the <b>Fiscal_Period</b> field to query operations.
     *
     */
    public final static ImportDataSetField<String> FISCAL_PERIOD = new ImportDataSetField<String>("Fiscal_Period");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Fiscal_Year</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "Fiscal_Year" )
    @JsonProperty( "Fiscal_Year" )
    @Nullable
    @ODataField( odataName = "Fiscal_Year" )
    private String fiscal_Year;
    /**
     * Use with available fluent helpers to apply the <b>Fiscal_Year</b> field to query operations.
     *
     */
    public final static ImportDataSetField<String> FISCAL_YEAR = new ImportDataSetField<String>("Fiscal_Year");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger
     */
    @Key
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static ImportDataSetField<String> LEDGER = new ImportDataSetField<String>("Ledger");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Balance_Sheet_Account</b>
     * </p>
     *
     * @return Balance Sheet Account
     */
    @Key
    @SerializedName( "Balance_Sheet_Account" )
    @JsonProperty( "Balance_Sheet_Account" )
    @Nullable
    @ODataField( odataName = "Balance_Sheet_Account" )
    private String balance_Sheet_Account;
    /**
     * Use with available fluent helpers to apply the <b>Balance_Sheet_Account</b> field to query operations.
     *
     */
    public final static ImportDataSetField<String> BALANCE_SHEET_ACCOUNT =
        new ImportDataSetField<String>("Balance_Sheet_Account");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Income_Statement_Account</b>
     * </p>
     *
     * @return Income Statement Account
     */
    @Key
    @SerializedName( "Income_Statement_Account" )
    @JsonProperty( "Income_Statement_Account" )
    @Nullable
    @ODataField( odataName = "Income_Statement_Account" )
    private String income_Statement_Account;
    /**
     * Use with available fluent helpers to apply the <b>Income_Statement_Account</b> field to query operations.
     *
     */
    public final static ImportDataSetField<String> INCOME_STATEMENT_ACCOUNT =
        new ImportDataSetField<String>("Income_Statement_Account");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Accrual_Amount</b>
     * </p>
     *
     * @return Accrual Amount
     */
    @SerializedName( "Accrual_Amount" )
    @JsonProperty( "Accrual_Amount" )
    @Nullable
    @ODataField( odataName = "Accrual_Amount" )
    private BigDecimal accrual_Amount;
    /**
     * Use with available fluent helpers to apply the <b>Accrual_Amount</b> field to query operations.
     *
     */
    public final static ImportDataSetField<BigDecimal> ACCRUAL_AMOUNT =
        new ImportDataSetField<BigDecimal>("Accrual_Amount");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Journal_Text</b>
     * </p>
     *
     * @return Journal Text
     */
    @SerializedName( "Journal_Text" )
    @JsonProperty( "Journal_Text" )
    @Nullable
    @ODataField( odataName = "Journal_Text" )
    private String journal_Text;
    /**
     * Use with available fluent helpers to apply the <b>Journal_Text</b> field to query operations.
     *
     */
    public final static ImportDataSetField<String> JOURNAL_TEXT = new ImportDataSetField<String>("Journal_Text");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Company_Code_Currency</b>
     * </p>
     *
     * @return Company Code Currency
     */
    @SerializedName( "Company_Code_Currency" )
    @JsonProperty( "Company_Code_Currency" )
    @Nullable
    @ODataField( odataName = "Company_Code_Currency" )
    private String company_Code_Currency;
    /**
     * Use with available fluent helpers to apply the <b>Company_Code_Currency</b> field to query operations.
     *
     */
    public final static ImportDataSetField<String> COMPANY_CODE_CURRENCY =
        new ImportDataSetField<String>("Company_Code_Currency");

    @Nonnull
    @Override
    public Class<ImportDataSet> getType()
    {
        return ImportDataSet.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Wbselement_ID</b>
     * </p>
     *
     * @param wbselement_ID
     *            WBS Element
     */
    public void setWbselement_ID( @Nullable final String wbselement_ID )
    {
        rememberChangedField("Wbselement_ID", this.wbselement_ID);
        this.wbselement_ID = wbselement_ID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Fiscal_Period</b>
     * </p>
     *
     * @param fiscal_Period
     *            Period
     */
    public void setFiscal_Period( @Nullable final String fiscal_Period )
    {
        rememberChangedField("Fiscal_Period", this.fiscal_Period);
        this.fiscal_Period = fiscal_Period;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Fiscal_Year</b>
     * </p>
     *
     * @param fiscal_Year
     *            Fiscal Year
     */
    public void setFiscal_Year( @Nullable final String fiscal_Year )
    {
        rememberChangedField("Fiscal_Year", this.fiscal_Year);
        this.fiscal_Year = fiscal_Year;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Balance_Sheet_Account</b>
     * </p>
     *
     * @param balance_Sheet_Account
     *            Balance Sheet Account
     */
    public void setBalance_Sheet_Account( @Nullable final String balance_Sheet_Account )
    {
        rememberChangedField("Balance_Sheet_Account", this.balance_Sheet_Account);
        this.balance_Sheet_Account = balance_Sheet_Account;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Income_Statement_Account</b>
     * </p>
     *
     * @param income_Statement_Account
     *            Income Statement Account
     */
    public void setIncome_Statement_Account( @Nullable final String income_Statement_Account )
    {
        rememberChangedField("Income_Statement_Account", this.income_Statement_Account);
        this.income_Statement_Account = income_Statement_Account;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Accrual_Amount</b>
     * </p>
     *
     * @param accrual_Amount
     *            Accrual Amount
     */
    public void setAccrual_Amount( @Nullable final BigDecimal accrual_Amount )
    {
        rememberChangedField("Accrual_Amount", this.accrual_Amount);
        this.accrual_Amount = accrual_Amount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Journal_Text</b>
     * </p>
     *
     * @param journal_Text
     *            Journal Text
     */
    public void setJournal_Text( @Nullable final String journal_Text )
    {
        rememberChangedField("Journal_Text", this.journal_Text);
        this.journal_Text = journal_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Company_Code_Currency</b>
     * </p>
     *
     * @param company_Code_Currency
     *            Company Code Currency
     */
    public void setCompany_Code_Currency( @Nullable final String company_Code_Currency )
    {
        rememberChangedField("Company_Code_Currency", this.company_Code_Currency);
        this.company_Code_Currency = company_Code_Currency;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ImportData";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Wbselement_ID", getWbselement_ID());
        result.put("Fiscal_Period", getFiscal_Period());
        result.put("Fiscal_Year", getFiscal_Year());
        result.put("Ledger", getLedger());
        result.put("Balance_Sheet_Account", getBalance_Sheet_Account());
        result.put("Income_Statement_Account", getIncome_Statement_Account());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Wbselement_ID", getWbselement_ID());
        values.put("Fiscal_Period", getFiscal_Period());
        values.put("Fiscal_Year", getFiscal_Year());
        values.put("Ledger", getLedger());
        values.put("Balance_Sheet_Account", getBalance_Sheet_Account());
        values.put("Income_Statement_Account", getIncome_Statement_Account());
        values.put("Accrual_Amount", getAccrual_Amount());
        values.put("Journal_Text", getJournal_Text());
        values.put("Company_Code_Currency", getCompany_Code_Currency());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Wbselement_ID") ) {
                final Object value = values.remove("Wbselement_ID");
                if( (value == null) || (!value.equals(getWbselement_ID())) ) {
                    setWbselement_ID(((String) value));
                }
            }
            if( values.containsKey("Fiscal_Period") ) {
                final Object value = values.remove("Fiscal_Period");
                if( (value == null) || (!value.equals(getFiscal_Period())) ) {
                    setFiscal_Period(((String) value));
                }
            }
            if( values.containsKey("Fiscal_Year") ) {
                final Object value = values.remove("Fiscal_Year");
                if( (value == null) || (!value.equals(getFiscal_Year())) ) {
                    setFiscal_Year(((String) value));
                }
            }
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("Balance_Sheet_Account") ) {
                final Object value = values.remove("Balance_Sheet_Account");
                if( (value == null) || (!value.equals(getBalance_Sheet_Account())) ) {
                    setBalance_Sheet_Account(((String) value));
                }
            }
            if( values.containsKey("Income_Statement_Account") ) {
                final Object value = values.remove("Income_Statement_Account");
                if( (value == null) || (!value.equals(getIncome_Statement_Account())) ) {
                    setIncome_Statement_Account(((String) value));
                }
            }
            if( values.containsKey("Accrual_Amount") ) {
                final Object value = values.remove("Accrual_Amount");
                if( (value == null) || (!value.equals(getAccrual_Amount())) ) {
                    setAccrual_Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Journal_Text") ) {
                final Object value = values.remove("Journal_Text");
                if( (value == null) || (!value.equals(getJournal_Text())) ) {
                    setJournal_Text(((String) value));
                }
            }
            if( values.containsKey("Company_Code_Currency") ) {
                final Object value = values.remove("Company_Code_Currency");
                if( (value == null) || (!value.equals(getCompany_Code_Currency())) ) {
                    setCompany_Code_Currency(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ImportDataSetField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ImportDataSetField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ImportDataSetField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ImportDataSetField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ManualContractAccrualService.DEFAULT_SERVICE_PATH);
    }

}
