/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual;

import java.net.URI;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.CollectionValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>post_manual_accruals</b> OData function import.
 *
 */
public class Post_manual_accrualsFluentHelper
    extends
    CollectionValuedFluentHelperFunction<Post_manual_accrualsFluentHelper, ReturnDataSet, List<ReturnDataSet>>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>post_manual_accruals</b> OData function import with the
     * provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the fluent
     * helper object.
     *
     * @param accrualDataJSON
     *            Constraints: none
     *            <p>
     *            Original parameter name from the Odata EDM: <b>accrualDataJSON</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     */
    public Post_manual_accrualsFluentHelper( @Nonnull final String servicePath, @Nonnull final String accrualDataJSON )
    {
        super(servicePath);
        values.put("accrualDataJSON", accrualDataJSON);
    }

    @Override
    @Nonnull
    protected Class<ReturnDataSet> getEntityClass()
    {
        return ReturnDataSet.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "post_manual_accruals";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpGet(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nonnull
    public List<ReturnDataSet> executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeMultiple(destination);
    }

}
