/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.field.ReturnDataSetField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.selectable.ReturnDataSetSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Accrual Output Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ReturnDataSet</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ReturnDataSet extends VdmEntity<ReturnDataSet>
{

    /**
     * Selector for all available fields of ReturnDataSet.
     *
     */
    public final static ReturnDataSetSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Wbselement_ID</b>
     * </p>
     *
     * @return WBS Element
     */
    @Key
    @SerializedName( "Wbselement_ID" )
    @JsonProperty( "Wbselement_ID" )
    @Nullable
    @ODataField( odataName = "Wbselement_ID" )
    private String wbselement_ID;
    /**
     * Use with available fluent helpers to apply the <b>Wbselement_ID</b> field to query operations.
     *
     */
    public final static ReturnDataSetField<String> WBSELEMENT_ID = new ReturnDataSetField<String>("Wbselement_ID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Company_Code</b>
     * </p>
     *
     * @return Company Code
     */
    @Key
    @SerializedName( "Company_Code" )
    @JsonProperty( "Company_Code" )
    @Nullable
    @ODataField( odataName = "Company_Code" )
    private String company_Code;
    /**
     * Use with available fluent helpers to apply the <b>Company_Code</b> field to query operations.
     *
     */
    public final static ReturnDataSetField<String> COMPANY_CODE = new ReturnDataSetField<String>("Company_Code");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger
     */
    @Key
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static ReturnDataSetField<String> LEDGER = new ReturnDataSetField<String>("Ledger");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Success_Status</b>
     * </p>
     *
     * @return Success status
     */
    @Key
    @SerializedName( "Success_Status" )
    @JsonProperty( "Success_Status" )
    @Nullable
    @ODataField( odataName = "Success_Status" )
    private String success_Status;
    /**
     * Use with available fluent helpers to apply the <b>Success_Status</b> field to query operations.
     *
     */
    public final static ReturnDataSetField<String> SUCCESS_STATUS = new ReturnDataSetField<String>("Success_Status");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Document_Ref</b>
     * </p>
     *
     * @return Document Reference Number
     */
    @Key
    @SerializedName( "Document_Ref" )
    @JsonProperty( "Document_Ref" )
    @Nullable
    @ODataField( odataName = "Document_Ref" )
    private String document_Ref;
    /**
     * Use with available fluent helpers to apply the <b>Document_Ref</b> field to query operations.
     *
     */
    public final static ReturnDataSetField<String> DOCUMENT_REF = new ReturnDataSetField<String>("Document_Ref");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Error_Msg</b>
     * </p>
     *
     * @return Error Message
     */
    @Key
    @SerializedName( "Error_Msg" )
    @JsonProperty( "Error_Msg" )
    @Nullable
    @ODataField( odataName = "Error_Msg" )
    private String error_Msg;
    /**
     * Use with available fluent helpers to apply the <b>Error_Msg</b> field to query operations.
     *
     */
    public final static ReturnDataSetField<String> ERROR_MSG = new ReturnDataSetField<String>("Error_Msg");

    @Nonnull
    @Override
    public Class<ReturnDataSet> getType()
    {
        return ReturnDataSet.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Wbselement_ID</b>
     * </p>
     *
     * @param wbselement_ID
     *            WBS Element
     */
    public void setWbselement_ID( @Nullable final String wbselement_ID )
    {
        rememberChangedField("Wbselement_ID", this.wbselement_ID);
        this.wbselement_ID = wbselement_ID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Company_Code</b>
     * </p>
     *
     * @param company_Code
     *            Company Code
     */
    public void setCompany_Code( @Nullable final String company_Code )
    {
        rememberChangedField("Company_Code", this.company_Code);
        this.company_Code = company_Code;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Success_Status</b>
     * </p>
     *
     * @param success_Status
     *            Success status
     */
    public void setSuccess_Status( @Nullable final String success_Status )
    {
        rememberChangedField("Success_Status", this.success_Status);
        this.success_Status = success_Status;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Document_Ref</b>
     * </p>
     *
     * @param document_Ref
     *            Document Reference Number
     */
    public void setDocument_Ref( @Nullable final String document_Ref )
    {
        rememberChangedField("Document_Ref", this.document_Ref);
        this.document_Ref = document_Ref;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Error_Msg</b>
     * </p>
     *
     * @param error_Msg
     *            Error Message
     */
    public void setError_Msg( @Nullable final String error_Msg )
    {
        rememberChangedField("Error_Msg", this.error_Msg);
        this.error_Msg = error_Msg;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ReturnData";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Wbselement_ID", getWbselement_ID());
        result.put("Company_Code", getCompany_Code());
        result.put("Ledger", getLedger());
        result.put("Success_Status", getSuccess_Status());
        result.put("Document_Ref", getDocument_Ref());
        result.put("Error_Msg", getError_Msg());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Wbselement_ID", getWbselement_ID());
        values.put("Company_Code", getCompany_Code());
        values.put("Ledger", getLedger());
        values.put("Success_Status", getSuccess_Status());
        values.put("Document_Ref", getDocument_Ref());
        values.put("Error_Msg", getError_Msg());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Wbselement_ID") ) {
                final Object value = values.remove("Wbselement_ID");
                if( (value == null) || (!value.equals(getWbselement_ID())) ) {
                    setWbselement_ID(((String) value));
                }
            }
            if( values.containsKey("Company_Code") ) {
                final Object value = values.remove("Company_Code");
                if( (value == null) || (!value.equals(getCompany_Code())) ) {
                    setCompany_Code(((String) value));
                }
            }
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("Success_Status") ) {
                final Object value = values.remove("Success_Status");
                if( (value == null) || (!value.equals(getSuccess_Status())) ) {
                    setSuccess_Status(((String) value));
                }
            }
            if( values.containsKey("Document_Ref") ) {
                final Object value = values.remove("Document_Ref");
                if( (value == null) || (!value.equals(getDocument_Ref())) ) {
                    setDocument_Ref(((String) value));
                }
            }
            if( values.containsKey("Error_Msg") ) {
                final Object value = values.remove("Error_Msg");
                if( (value == null) || (!value.equals(getError_Msg())) ) {
                    setError_Msg(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ReturnDataSetField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ReturnDataSetField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ReturnDataSetField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ReturnDataSetField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ManualContractAccrualService.DEFAULT_SERVICE_PATH);
    }

}
