/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link ManualContractAccrualServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ManualContractAccrualService ManualContractAccrualService}.
 *
 */
public class DefaultManualContractAccrualServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ManualContractAccrualServiceBatch, ManualContractAccrualServiceBatchChangeSet>
    implements
    ManualContractAccrualServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ManualContractAccrualService service;

    @SuppressWarnings( "deprecation" )
    DefaultManualContractAccrualServiceBatchChangeSet(
        @Nonnull final DefaultManualContractAccrualServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ManualContractAccrualService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultManualContractAccrualServiceBatchChangeSet getThis()
    {
        return this;
    }

}
