/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ImportDataSet;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ImportDataSet ImportDataSet}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.field.ImportDataSetField
 * ImportDataSetField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.link.ImportDataSetLink
 * ImportDataSetLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ImportDataSet#WBSELEMENT_ID
 * WBSELEMENT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ImportDataSet#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ImportDataSet#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ImportDataSet#LEDGER
 * LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ImportDataSet#BALANCE_SHEET_ACCOUNT
 * BALANCE_SHEET_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ImportDataSet#INCOME_STATEMENT_ACCOUNT
 * INCOME_STATEMENT_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ImportDataSet#ACCRUAL_AMOUNT
 * ACCRUAL_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ImportDataSet#JOURNAL_TEXT
 * JOURNAL_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ImportDataSet#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * </ul>
 *
 */
public interface ImportDataSetSelectable extends EntitySelectable<ImportDataSet>
{

}
