/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ReturnDataSet;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ReturnDataSet ReturnDataSet}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.field.ReturnDataSetField
 * ReturnDataSetField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.link.ReturnDataSetLink
 * ReturnDataSetLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ReturnDataSet#WBSELEMENT_ID
 * WBSELEMENT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ReturnDataSet#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ReturnDataSet#LEDGER
 * LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ReturnDataSet#SUCCESS_STATUS
 * SUCCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ReturnDataSet#DOCUMENT_REF
 * DOCUMENT_REF}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.manualcontractaccrual.ReturnDataSet#ERROR_MSG
 * ERROR_MSG}</li>
 * </ul>
 *
 */
public interface ReturnDataSetSelectable extends EntitySelectable<ReturnDataSet>
{

}
