/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BaseUnitField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.BaseUnitLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.BaseUnitSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Unit of Measure
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BaseUnitType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BaseUnit extends VdmEntity<BaseUnit>
{

    /**
     * Selector for all available fields of BaseUnit.
     *
     */
    public final static BaseUnitSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @return Base Unit
     */
    @Key
    @SerializedName( "UnitOfMeasure" )
    @JsonProperty( "UnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasure" )
    private String unitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasure</b> field to query operations.
     *
     */
    public final static BaseUnitField<String> UNIT_OF_MEASURE = new BaseUnitField<String>("UnitOfMeasure");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure_Text</b>
     * </p>
     *
     * @return Base Unit Description
     */
    @SerializedName( "UnitOfMeasure_Text" )
    @JsonProperty( "UnitOfMeasure_Text" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasure_Text" )
    private String unitOfMeasure_Text;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasure_Text</b> field to query operations.
     *
     */
    public final static BaseUnitField<String> UNIT_OF_MEASURE_TEXT = new BaseUnitField<String>("UnitOfMeasure_Text");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "UnitOfMeasureISOCode" )
    @JsonProperty( "UnitOfMeasureISOCode" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasureISOCode" )
    private String unitOfMeasureISOCode;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasureISOCode</b> field to query operations.
     *
     */
    public final static BaseUnitField<String> UNIT_OF_MEASURE_ISO_CODE =
        new BaseUnitField<String>("UnitOfMeasureISOCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureNumberOfDecimals</b>
     * </p>
     *
     * @return No. of decimal places for rounding
     */
    @SerializedName( "UnitOfMeasureNumberOfDecimals" )
    @JsonProperty( "UnitOfMeasureNumberOfDecimals" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasureNumberOfDecimals" )
    private Short unitOfMeasureNumberOfDecimals;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasureNumberOfDecimals</b> field to query operations.
     *
     */
    public final static BaseUnitField<Short> UNIT_OF_MEASURE_NUMBER_OF_DECIMALS =
        new BaseUnitField<Short>("UnitOfMeasureNumberOfDecimals");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureDspNmbrOfDcmls</b>
     * </p>
     *
     * @return Number of Decimal Places for Number Display
     */
    @SerializedName( "UnitOfMeasureDspNmbrOfDcmls" )
    @JsonProperty( "UnitOfMeasureDspNmbrOfDcmls" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasureDspNmbrOfDcmls" )
    private Short unitOfMeasureDspNmbrOfDcmls;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasureDspNmbrOfDcmls</b> field to query operations.
     *
     */
    public final static BaseUnitField<Short> UNIT_OF_MEASURE_DSP_NMBR_OF_DCMLS =
        new BaseUnitField<Short>("UnitOfMeasureDspNmbrOfDcmls");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureSAPCode</b>
     * </p>
     *
     * @return Unit of Measurement, Internal SAP Code (No Conversion)
     */
    @SerializedName( "UnitOfMeasureSAPCode" )
    @JsonProperty( "UnitOfMeasureSAPCode" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasureSAPCode" )
    private String unitOfMeasureSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasureSAPCode</b> field to query operations.
     *
     */
    public final static BaseUnitField<String> UNIT_OF_MEASURE_SAP_CODE =
        new BaseUnitField<String>("UnitOfMeasureSAPCode");
    /**
     * Navigation property <b>to_CnsldtnBaseUnitT</b> for <b>BaseUnit</b> to multiple <b>BaseUnitText</b>.
     *
     */
    @SerializedName( "to_CnsldtnBaseUnitT" )
    @JsonProperty( "to_CnsldtnBaseUnitT" )
    @ODataField( odataName = "to_CnsldtnBaseUnitT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BaseUnitText> toCnsldtnBaseUnitT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnBaseUnitT</b> navigation property to query
     * operations.
     *
     */
    public final static BaseUnitLink<BaseUnitText> TO_CNSLDTN_BASE_UNIT_T =
        new BaseUnitLink<BaseUnitText>("to_CnsldtnBaseUnitT");

    @Nonnull
    @Override
    public Class<BaseUnit> getType()
    {
        return BaseUnit.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @param unitOfMeasure
     *            Base Unit
     */
    public void setUnitOfMeasure( @Nullable final String unitOfMeasure )
    {
        rememberChangedField("UnitOfMeasure", this.unitOfMeasure);
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure_Text</b>
     * </p>
     *
     * @param unitOfMeasure_Text
     *            Base Unit Description
     */
    public void setUnitOfMeasure_Text( @Nullable final String unitOfMeasure_Text )
    {
        rememberChangedField("UnitOfMeasure_Text", this.unitOfMeasure_Text);
        this.unitOfMeasure_Text = unitOfMeasure_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureISOCode</b>
     * </p>
     *
     * @param unitOfMeasureISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setUnitOfMeasureISOCode( @Nullable final String unitOfMeasureISOCode )
    {
        rememberChangedField("UnitOfMeasureISOCode", this.unitOfMeasureISOCode);
        this.unitOfMeasureISOCode = unitOfMeasureISOCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureNumberOfDecimals</b>
     * </p>
     *
     * @param unitOfMeasureNumberOfDecimals
     *            No. of decimal places for rounding
     */
    public void setUnitOfMeasureNumberOfDecimals( @Nullable final Short unitOfMeasureNumberOfDecimals )
    {
        rememberChangedField("UnitOfMeasureNumberOfDecimals", this.unitOfMeasureNumberOfDecimals);
        this.unitOfMeasureNumberOfDecimals = unitOfMeasureNumberOfDecimals;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureDspNmbrOfDcmls</b>
     * </p>
     *
     * @param unitOfMeasureDspNmbrOfDcmls
     *            Number of Decimal Places for Number Display
     */
    public void setUnitOfMeasureDspNmbrOfDcmls( @Nullable final Short unitOfMeasureDspNmbrOfDcmls )
    {
        rememberChangedField("UnitOfMeasureDspNmbrOfDcmls", this.unitOfMeasureDspNmbrOfDcmls);
        this.unitOfMeasureDspNmbrOfDcmls = unitOfMeasureDspNmbrOfDcmls;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureSAPCode</b>
     * </p>
     *
     * @param unitOfMeasureSAPCode
     *            Unit of Measurement, Internal SAP Code (No Conversion)
     */
    public void setUnitOfMeasureSAPCode( @Nullable final String unitOfMeasureSAPCode )
    {
        rememberChangedField("UnitOfMeasureSAPCode", this.unitOfMeasureSAPCode);
        this.unitOfMeasureSAPCode = unitOfMeasureSAPCode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BaseUnit";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("UnitOfMeasure", getUnitOfMeasure());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("UnitOfMeasure", getUnitOfMeasure());
        values.put("UnitOfMeasure_Text", getUnitOfMeasure_Text());
        values.put("UnitOfMeasureISOCode", getUnitOfMeasureISOCode());
        values.put("UnitOfMeasureNumberOfDecimals", getUnitOfMeasureNumberOfDecimals());
        values.put("UnitOfMeasureDspNmbrOfDcmls", getUnitOfMeasureDspNmbrOfDcmls());
        values.put("UnitOfMeasureSAPCode", getUnitOfMeasureSAPCode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("UnitOfMeasure") ) {
                final Object value = values.remove("UnitOfMeasure");
                if( (value == null) || (!value.equals(getUnitOfMeasure())) ) {
                    setUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasure_Text") ) {
                final Object value = values.remove("UnitOfMeasure_Text");
                if( (value == null) || (!value.equals(getUnitOfMeasure_Text())) ) {
                    setUnitOfMeasure_Text(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasureISOCode") ) {
                final Object value = values.remove("UnitOfMeasureISOCode");
                if( (value == null) || (!value.equals(getUnitOfMeasureISOCode())) ) {
                    setUnitOfMeasureISOCode(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasureNumberOfDecimals") ) {
                final Object value = values.remove("UnitOfMeasureNumberOfDecimals");
                if( (value == null) || (!value.equals(getUnitOfMeasureNumberOfDecimals())) ) {
                    setUnitOfMeasureNumberOfDecimals(((Short) value));
                }
            }
            if( values.containsKey("UnitOfMeasureDspNmbrOfDcmls") ) {
                final Object value = values.remove("UnitOfMeasureDspNmbrOfDcmls");
                if( (value == null) || (!value.equals(getUnitOfMeasureDspNmbrOfDcmls())) ) {
                    setUnitOfMeasureDspNmbrOfDcmls(((Short) value));
                }
            }
            if( values.containsKey("UnitOfMeasureSAPCode") ) {
                final Object value = values.remove("UnitOfMeasureSAPCode");
                if( (value == null) || (!value.equals(getUnitOfMeasureSAPCode())) ) {
                    setUnitOfMeasureSAPCode(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnBaseUnitT") ) {
                final Object value = (values).remove("to_CnsldtnBaseUnitT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnBaseUnitT == null ) {
                        toCnsldtnBaseUnitT = Lists.newArrayList();
                    } else {
                        toCnsldtnBaseUnitT = Lists.newArrayList(toCnsldtnBaseUnitT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BaseUnitText entity;
                        if( toCnsldtnBaseUnitT.size() > i ) {
                            entity = toCnsldtnBaseUnitT.get(i);
                        } else {
                            entity = new BaseUnitText();
                            toCnsldtnBaseUnitT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BaseUnitField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BaseUnitField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BaseUnitField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BaseUnitField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnBaseUnitT != null ) {
            (values).put("to_CnsldtnBaseUnitT", toCnsldtnBaseUnitT);
        }
        return values;
    }

    /**
     * Fetches the <b>BaseUnitText</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnBaseUnitT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BaseUnitText</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BaseUnitText> fetchCnsldtnBaseUnitT()
    {
        return fetchFieldAsList("to_CnsldtnBaseUnitT", BaseUnitText.class);
    }

    /**
     * Retrieval of associated <b>BaseUnitText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnBaseUnitT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBaseUnitT</b> of a queried <b>BaseUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BaseUnitText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BaseUnitText> getCnsldtnBaseUnitTOrFetch()
    {
        if( toCnsldtnBaseUnitT == null ) {
            toCnsldtnBaseUnitT = fetchCnsldtnBaseUnitT();
        }
        return toCnsldtnBaseUnitT;
    }

    /**
     * Retrieval of associated <b>BaseUnitText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnBaseUnitT</b>.
     * <p>
     * If the navigation property for an entity <b>BaseUnit</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnBaseUnitT</b> is already loaded, the result will
     *         contain the <b>BaseUnitText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BaseUnitText>> getCnsldtnBaseUnitTIfPresent()
    {
        return Option.of(toCnsldtnBaseUnitT);
    }

    /**
     * Overwrites the list of associated <b>BaseUnitText</b> entities for the loaded navigation property
     * <b>to_CnsldtnBaseUnitT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBaseUnitT</b> of a queried <b>BaseUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BaseUnitText</b> entities.
     */
    public void setCnsldtnBaseUnitT( @Nonnull final List<BaseUnitText> value )
    {
        if( toCnsldtnBaseUnitT == null ) {
            toCnsldtnBaseUnitT = Lists.newArrayList();
        }
        toCnsldtnBaseUnitT.clear();
        toCnsldtnBaseUnitT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BaseUnitText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnBaseUnitT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBaseUnitT</b> of a queried <b>BaseUnit</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BaseUnitText</b> entities.
     */
    public void addCnsldtnBaseUnitT( BaseUnitText... entity )
    {
        if( toCnsldtnBaseUnitT == null ) {
            toCnsldtnBaseUnitT = Lists.newArrayList();
        }
        toCnsldtnBaseUnitT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BaseUnit instances.
     *
     */
    public final static class BaseUnitBuilder
    {

        private List<BaseUnitText> toCnsldtnBaseUnitT = Lists.newArrayList();

        private BaseUnit.BaseUnitBuilder toCnsldtnBaseUnitT( final List<BaseUnitText> value )
        {
            toCnsldtnBaseUnitT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnBaseUnitT</b> for <b>BaseUnit</b> to multiple <b>BaseUnitText</b>.
         *
         * @param value
         *            The BaseUnitTexts to build this BaseUnit with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BaseUnit.BaseUnitBuilder cnsldtnBaseUnitT( BaseUnitText... value )
        {
            return toCnsldtnBaseUnitT(Lists.newArrayList(value));
        }

    }

}
