/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BaseUnitTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.BaseUnitTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.BaseUnitTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Unit of Measure - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BaseUnitTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BaseUnitText extends VdmEntity<BaseUnitText>
{

    /**
     * Selector for all available fields of BaseUnitText.
     *
     */
    public final static BaseUnitTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BaseUnitTextField<String> LANGUAGE = new BaseUnitTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @return Base Unit
     */
    @Key
    @SerializedName( "UnitOfMeasure" )
    @JsonProperty( "UnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasure" )
    private String unitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasure</b> field to query operations.
     *
     */
    public final static BaseUnitTextField<String> UNIT_OF_MEASURE = new BaseUnitTextField<String>("UnitOfMeasure");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnitText</b>
     * </p>
     *
     * @return Base Unit Description
     */
    @SerializedName( "BaseUnitText" )
    @JsonProperty( "BaseUnitText" )
    @Nullable
    @ODataField( odataName = "BaseUnitText" )
    private String baseUnitText;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnitText</b> field to query operations.
     *
     */
    public final static BaseUnitTextField<String> BASE_UNIT_TEXT = new BaseUnitTextField<String>("BaseUnitText");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure_E</b>
     * </p>
     *
     * @return External Unit of Measurement in Commercial Format (3-Char.)
     */
    @SerializedName( "UnitOfMeasure_E" )
    @JsonProperty( "UnitOfMeasure_E" )
    @Nullable
    @ODataField( odataName = "UnitOfMeasure_E" )
    private String unitOfMeasure_E;
    /**
     * Use with available fluent helpers to apply the <b>UnitOfMeasure_E</b> field to query operations.
     *
     */
    public final static BaseUnitTextField<String> UNIT_OF_MEASURE_E = new BaseUnitTextField<String>("UnitOfMeasure_E");
    /**
     * Navigation property <b>to_CnsldtnBaseUnit</b> for <b>BaseUnitText</b> to single <b>BaseUnit</b>.
     *
     */
    @SerializedName( "to_CnsldtnBaseUnit" )
    @JsonProperty( "to_CnsldtnBaseUnit" )
    @ODataField( odataName = "to_CnsldtnBaseUnit" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BaseUnit toCnsldtnBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnBaseUnit</b> navigation property to query operations.
     *
     */
    public final static BaseUnitTextOneToOneLink<BaseUnit> TO_CNSLDTN_BASE_UNIT =
        new BaseUnitTextOneToOneLink<BaseUnit>("to_CnsldtnBaseUnit");

    @Nonnull
    @Override
    public Class<BaseUnitText> getType()
    {
        return BaseUnitText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     *
     * @param unitOfMeasure
     *            Base Unit
     */
    public void setUnitOfMeasure( @Nullable final String unitOfMeasure )
    {
        rememberChangedField("UnitOfMeasure", this.unitOfMeasure);
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnitText</b>
     * </p>
     *
     * @param baseUnitText
     *            Base Unit Description
     */
    public void setBaseUnitText( @Nullable final String baseUnitText )
    {
        rememberChangedField("BaseUnitText", this.baseUnitText);
        this.baseUnitText = baseUnitText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure_E</b>
     * </p>
     *
     * @param unitOfMeasure_E
     *            External Unit of Measurement in Commercial Format (3-Char.)
     */
    public void setUnitOfMeasure_E( @Nullable final String unitOfMeasure_E )
    {
        rememberChangedField("UnitOfMeasure_E", this.unitOfMeasure_E);
        this.unitOfMeasure_E = unitOfMeasure_E;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BaseUnitText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("UnitOfMeasure", getUnitOfMeasure());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("UnitOfMeasure", getUnitOfMeasure());
        values.put("BaseUnitText", getBaseUnitText());
        values.put("UnitOfMeasure_E", getUnitOfMeasure_E());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasure") ) {
                final Object value = values.remove("UnitOfMeasure");
                if( (value == null) || (!value.equals(getUnitOfMeasure())) ) {
                    setUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("BaseUnitText") ) {
                final Object value = values.remove("BaseUnitText");
                if( (value == null) || (!value.equals(getBaseUnitText())) ) {
                    setBaseUnitText(((String) value));
                }
            }
            if( values.containsKey("UnitOfMeasure_E") ) {
                final Object value = values.remove("UnitOfMeasure_E");
                if( (value == null) || (!value.equals(getUnitOfMeasure_E())) ) {
                    setUnitOfMeasure_E(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnBaseUnit") ) {
                final Object value = (values).remove("to_CnsldtnBaseUnit");
                if( value instanceof Map ) {
                    if( toCnsldtnBaseUnit == null ) {
                        toCnsldtnBaseUnit = new BaseUnit();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnBaseUnit.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BaseUnitTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BaseUnitTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BaseUnitTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BaseUnitTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnBaseUnit != null ) {
            (values).put("to_CnsldtnBaseUnit", toCnsldtnBaseUnit);
        }
        return values;
    }

    /**
     * Fetches the <b>BaseUnit</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnBaseUnit</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BaseUnit</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BaseUnit fetchCnsldtnBaseUnit()
    {
        return fetchFieldAsSingle("to_CnsldtnBaseUnit", BaseUnit.class);
    }

    /**
     * Retrieval of associated <b>BaseUnit</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnBaseUnit</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBaseUnit</b> of a queried <b>BaseUnitText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BaseUnit</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BaseUnit getCnsldtnBaseUnitOrFetch()
    {
        if( toCnsldtnBaseUnit == null ) {
            toCnsldtnBaseUnit = fetchCnsldtnBaseUnit();
        }
        return toCnsldtnBaseUnit;
    }

    /**
     * Retrieval of associated <b>BaseUnit</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnBaseUnit</b>.
     * <p>
     * If the navigation property for an entity <b>BaseUnitText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnBaseUnit</b> is already loaded, the result will
     *         contain the <b>BaseUnit</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<BaseUnit> getCnsldtnBaseUnitIfPresent()
    {
        return Option.of(toCnsldtnBaseUnit);
    }

    /**
     * Overwrites the associated <b>BaseUnit</b> entity for the loaded navigation property <b>to_CnsldtnBaseUnit</b>.
     *
     * @param value
     *            New <b>BaseUnit</b> entity.
     */
    public void setCnsldtnBaseUnit( final BaseUnit value )
    {
        toCnsldtnBaseUnit = value;
    }

    /**
     * Helper class to allow for fluent creation of BaseUnitText instances.
     *
     */
    public final static class BaseUnitTextBuilder
    {

        private BaseUnit toCnsldtnBaseUnit;

        private BaseUnitText.BaseUnitTextBuilder toCnsldtnBaseUnit( final BaseUnit value )
        {
            toCnsldtnBaseUnit = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnBaseUnit</b> for <b>BaseUnitText</b> to single <b>BaseUnit</b>.
         *
         * @param value
         *            The BaseUnit to build this BaseUnitText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BaseUnitText.BaseUnitTextBuilder cnsldtnBaseUnit( final BaseUnit value )
        {
            return toCnsldtnBaseUnit(value);
        }

    }

}
