/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BillToPartyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.BillToPartyLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.BillToPartySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Bill to Party
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BillToPartyType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BillToParty extends VdmEntity<BillToParty>
{

    /**
     * Selector for all available fields of BillToParty.
     *
     */
    public final static BillToPartySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Consolidation Customer
     */
    @Key
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static BillToPartyField<String> CUSTOMER = new BillToPartyField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Customer_Text</b>
     * </p>
     *
     * @return Bill-To Party Description
     */
    @SerializedName( "Customer_Text" )
    @JsonProperty( "Customer_Text" )
    @Nullable
    @ODataField( odataName = "Customer_Text" )
    private String customer_Text;
    /**
     * Use with available fluent helpers to apply the <b>Customer_Text</b> field to query operations.
     *
     */
    public final static BillToPartyField<String> CUSTOMER_TEXT = new BillToPartyField<String>("Customer_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static BillToPartyField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new BillToPartyField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnBillToPartyT</b> for <b>BillToParty</b> to multiple <b>BillToPartyText</b>.
     *
     */
    @SerializedName( "to_CnsldtnBillToPartyT" )
    @JsonProperty( "to_CnsldtnBillToPartyT" )
    @ODataField( odataName = "to_CnsldtnBillToPartyT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillToPartyText> toCnsldtnBillToPartyT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnBillToPartyT</b> navigation property to query
     * operations.
     *
     */
    public final static BillToPartyLink<BillToPartyText> TO_CNSLDTN_BILL_TO_PARTY_T =
        new BillToPartyLink<BillToPartyText>("to_CnsldtnBillToPartyT");

    @Nonnull
    @Override
    public Class<BillToParty> getType()
    {
        return BillToParty.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Consolidation Customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Customer_Text</b>
     * </p>
     *
     * @param customer_Text
     *            Bill-To Party Description
     */
    public void setCustomer_Text( @Nullable final String customer_Text )
    {
        rememberChangedField("Customer_Text", this.customer_Text);
        this.customer_Text = customer_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BillToParty";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Customer", getCustomer());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Customer", getCustomer());
        values.put("Customer_Text", getCustomer_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Customer_Text") ) {
                final Object value = values.remove("Customer_Text");
                if( (value == null) || (!value.equals(getCustomer_Text())) ) {
                    setCustomer_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnBillToPartyT") ) {
                final Object value = (values).remove("to_CnsldtnBillToPartyT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnBillToPartyT == null ) {
                        toCnsldtnBillToPartyT = Lists.newArrayList();
                    } else {
                        toCnsldtnBillToPartyT = Lists.newArrayList(toCnsldtnBillToPartyT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillToPartyText entity;
                        if( toCnsldtnBillToPartyT.size() > i ) {
                            entity = toCnsldtnBillToPartyT.get(i);
                        } else {
                            entity = new BillToPartyText();
                            toCnsldtnBillToPartyT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BillToPartyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BillToPartyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BillToPartyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BillToPartyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnBillToPartyT != null ) {
            (values).put("to_CnsldtnBillToPartyT", toCnsldtnBillToPartyT);
        }
        return values;
    }

    /**
     * Fetches the <b>BillToPartyText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnBillToPartyT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillToPartyText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillToPartyText> fetchCnsldtnBillToPartyT()
    {
        return fetchFieldAsList("to_CnsldtnBillToPartyT", BillToPartyText.class);
    }

    /**
     * Retrieval of associated <b>BillToPartyText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnBillToPartyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBillToPartyT</b> of a queried <b>BillToParty</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillToPartyText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillToPartyText> getCnsldtnBillToPartyTOrFetch()
    {
        if( toCnsldtnBillToPartyT == null ) {
            toCnsldtnBillToPartyT = fetchCnsldtnBillToPartyT();
        }
        return toCnsldtnBillToPartyT;
    }

    /**
     * Retrieval of associated <b>BillToPartyText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnBillToPartyT</b>.
     * <p>
     * If the navigation property for an entity <b>BillToParty</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnBillToPartyT</b> is already loaded, the result
     *         will contain the <b>BillToPartyText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BillToPartyText>> getCnsldtnBillToPartyTIfPresent()
    {
        return Option.of(toCnsldtnBillToPartyT);
    }

    /**
     * Overwrites the list of associated <b>BillToPartyText</b> entities for the loaded navigation property
     * <b>to_CnsldtnBillToPartyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBillToPartyT</b> of a queried <b>BillToParty</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillToPartyText</b> entities.
     */
    public void setCnsldtnBillToPartyT( @Nonnull final List<BillToPartyText> value )
    {
        if( toCnsldtnBillToPartyT == null ) {
            toCnsldtnBillToPartyT = Lists.newArrayList();
        }
        toCnsldtnBillToPartyT.clear();
        toCnsldtnBillToPartyT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillToPartyText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnBillToPartyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBillToPartyT</b> of a queried <b>BillToParty</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillToPartyText</b> entities.
     */
    public void addCnsldtnBillToPartyT( BillToPartyText... entity )
    {
        if( toCnsldtnBillToPartyT == null ) {
            toCnsldtnBillToPartyT = Lists.newArrayList();
        }
        toCnsldtnBillToPartyT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BillToParty instances.
     *
     */
    public final static class BillToPartyBuilder
    {

        private List<BillToPartyText> toCnsldtnBillToPartyT = Lists.newArrayList();

        private BillToParty.BillToPartyBuilder toCnsldtnBillToPartyT( final List<BillToPartyText> value )
        {
            toCnsldtnBillToPartyT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnBillToPartyT</b> for <b>BillToParty</b> to multiple <b>BillToPartyText</b>.
         *
         * @param value
         *            The BillToPartyTexts to build this BillToParty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillToParty.BillToPartyBuilder cnsldtnBillToPartyT( BillToPartyText... value )
        {
            return toCnsldtnBillToPartyT(Lists.newArrayList(value));
        }

    }

}
