/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BillToPartyTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.BillToPartyTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.BillToPartyTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Bill to Party - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BillToPartyTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BillToPartyText extends VdmEntity<BillToPartyText>
{

    /**
     * Selector for all available fields of BillToPartyText.
     *
     */
    public final static BillToPartyTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BillToPartyTextField<String> LANGUAGE = new BillToPartyTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Bill-To Party
     */
    @Key
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static BillToPartyTextField<String> CUSTOMER = new BillToPartyTextField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BillToPartyText</b>
     * </p>
     *
     * @return Bill-To Party Description
     */
    @SerializedName( "BillToPartyText" )
    @JsonProperty( "BillToPartyText" )
    @Nullable
    @ODataField( odataName = "BillToPartyText" )
    private String billToPartyText;
    /**
     * Use with available fluent helpers to apply the <b>BillToPartyText</b> field to query operations.
     *
     */
    public final static BillToPartyTextField<String> BILL_TO_PARTY_TEXT =
        new BillToPartyTextField<String>("BillToPartyText");
    /**
     * Navigation property <b>to_CnsldtnBillToParty</b> for <b>BillToPartyText</b> to single <b>BillToParty</b>.
     *
     */
    @SerializedName( "to_CnsldtnBillToParty" )
    @JsonProperty( "to_CnsldtnBillToParty" )
    @ODataField( odataName = "to_CnsldtnBillToParty" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BillToParty toCnsldtnBillToParty;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnBillToParty</b> navigation property to query
     * operations.
     *
     */
    public final static BillToPartyTextOneToOneLink<BillToParty> TO_CNSLDTN_BILL_TO_PARTY =
        new BillToPartyTextOneToOneLink<BillToParty>("to_CnsldtnBillToParty");

    @Nonnull
    @Override
    public Class<BillToPartyText> getType()
    {
        return BillToPartyText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Bill-To Party
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BillToPartyText</b>
     * </p>
     *
     * @param billToPartyText
     *            Bill-To Party Description
     */
    public void setBillToPartyText( @Nullable final String billToPartyText )
    {
        rememberChangedField("BillToPartyText", this.billToPartyText);
        this.billToPartyText = billToPartyText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BillToPartyText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("Customer", getCustomer());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("Customer", getCustomer());
        values.put("BillToPartyText", getBillToPartyText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("BillToPartyText") ) {
                final Object value = values.remove("BillToPartyText");
                if( (value == null) || (!value.equals(getBillToPartyText())) ) {
                    setBillToPartyText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnBillToParty") ) {
                final Object value = (values).remove("to_CnsldtnBillToParty");
                if( value instanceof Map ) {
                    if( toCnsldtnBillToParty == null ) {
                        toCnsldtnBillToParty = new BillToParty();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnBillToParty.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BillToPartyTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BillToPartyTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BillToPartyTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BillToPartyTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnBillToParty != null ) {
            (values).put("to_CnsldtnBillToParty", toCnsldtnBillToParty);
        }
        return values;
    }

    /**
     * Fetches the <b>BillToParty</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnBillToParty</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BillToParty</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillToParty fetchCnsldtnBillToParty()
    {
        return fetchFieldAsSingle("to_CnsldtnBillToParty", BillToParty.class);
    }

    /**
     * Retrieval of associated <b>BillToParty</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnBillToParty</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBillToParty</b> of a queried <b>BillToPartyText</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillToParty</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillToParty getCnsldtnBillToPartyOrFetch()
    {
        if( toCnsldtnBillToParty == null ) {
            toCnsldtnBillToParty = fetchCnsldtnBillToParty();
        }
        return toCnsldtnBillToParty;
    }

    /**
     * Retrieval of associated <b>BillToParty</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnBillToParty</b>.
     * <p>
     * If the navigation property for an entity <b>BillToPartyText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnBillToParty</b> is already loaded, the result
     *         will contain the <b>BillToParty</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BillToParty> getCnsldtnBillToPartyIfPresent()
    {
        return Option.of(toCnsldtnBillToParty);
    }

    /**
     * Overwrites the associated <b>BillToParty</b> entity for the loaded navigation property
     * <b>to_CnsldtnBillToParty</b>.
     *
     * @param value
     *            New <b>BillToParty</b> entity.
     */
    public void setCnsldtnBillToParty( final BillToParty value )
    {
        toCnsldtnBillToParty = value;
    }

    /**
     * Helper class to allow for fluent creation of BillToPartyText instances.
     *
     */
    public final static class BillToPartyTextBuilder
    {

        private BillToParty toCnsldtnBillToParty;

        private BillToPartyText.BillToPartyTextBuilder toCnsldtnBillToParty( final BillToParty value )
        {
            toCnsldtnBillToParty = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnBillToParty</b> for <b>BillToPartyText</b> to single <b>BillToParty</b>.
         *
         * @param value
         *            The BillToParty to build this BillToPartyText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillToPartyText.BillToPartyTextBuilder cnsldtnBillToParty( final BillToParty value )
        {
            return toCnsldtnBillToParty(value);
        }

    }

}
