/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BillingDocumentTypeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.BillingDocumentTypeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.BillingDocumentTypeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Billing Type
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BillingDocumentTypeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BillingDocumentType extends VdmEntity<BillingDocumentType>
{

    /**
     * Selector for all available fields of BillingDocumentType.
     *
     */
    public final static BillingDocumentTypeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType</b>
     * </p>
     *
     * @return Billing Document Type
     */
    @Key
    @SerializedName( "BillingDocumentType" )
    @JsonProperty( "BillingDocumentType" )
    @Nullable
    @ODataField( odataName = "BillingDocumentType" )
    private String billingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentType</b> field to query operations.
     *
     */
    public final static BillingDocumentTypeField<String> BILLING_DOCUMENT_TYPE =
        new BillingDocumentTypeField<String>("BillingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType_Text</b>
     * </p>
     *
     * @return Billing Document Type Description
     */
    @SerializedName( "BillingDocumentType_Text" )
    @JsonProperty( "BillingDocumentType_Text" )
    @Nullable
    @ODataField( odataName = "BillingDocumentType_Text" )
    private String billingDocumentType_Text;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentType_Text</b> field to query operations.
     *
     */
    public final static BillingDocumentTypeField<String> BILLING_DOCUMENT_TYPE_TEXT =
        new BillingDocumentTypeField<String>("BillingDocumentType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static BillingDocumentTypeField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new BillingDocumentTypeField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnBillingTypeT</b> for <b>BillingDocumentType</b> to multiple
     * <b>BillingDocumentTypeText</b>.
     *
     */
    @SerializedName( "to_CnsldtnBillingTypeT" )
    @JsonProperty( "to_CnsldtnBillingTypeT" )
    @ODataField( odataName = "to_CnsldtnBillingTypeT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BillingDocumentTypeText> toCnsldtnBillingTypeT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnBillingTypeT</b> navigation property to query
     * operations.
     *
     */
    public final static BillingDocumentTypeLink<BillingDocumentTypeText> TO_CNSLDTN_BILLING_TYPE_T =
        new BillingDocumentTypeLink<BillingDocumentTypeText>("to_CnsldtnBillingTypeT");

    @Nonnull
    @Override
    public Class<BillingDocumentType> getType()
    {
        return BillingDocumentType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType</b>
     * </p>
     *
     * @param billingDocumentType
     *            Billing Document Type
     */
    public void setBillingDocumentType( @Nullable final String billingDocumentType )
    {
        rememberChangedField("BillingDocumentType", this.billingDocumentType);
        this.billingDocumentType = billingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType_Text</b>
     * </p>
     *
     * @param billingDocumentType_Text
     *            Billing Document Type Description
     */
    public void setBillingDocumentType_Text( @Nullable final String billingDocumentType_Text )
    {
        rememberChangedField("BillingDocumentType_Text", this.billingDocumentType_Text);
        this.billingDocumentType_Text = billingDocumentType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BillingDocumentType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BillingDocumentType", getBillingDocumentType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BillingDocumentType", getBillingDocumentType());
        values.put("BillingDocumentType_Text", getBillingDocumentType_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BillingDocumentType") ) {
                final Object value = values.remove("BillingDocumentType");
                if( (value == null) || (!value.equals(getBillingDocumentType())) ) {
                    setBillingDocumentType(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentType_Text") ) {
                final Object value = values.remove("BillingDocumentType_Text");
                if( (value == null) || (!value.equals(getBillingDocumentType_Text())) ) {
                    setBillingDocumentType_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnBillingTypeT") ) {
                final Object value = (values).remove("to_CnsldtnBillingTypeT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnBillingTypeT == null ) {
                        toCnsldtnBillingTypeT = Lists.newArrayList();
                    } else {
                        toCnsldtnBillingTypeT = Lists.newArrayList(toCnsldtnBillingTypeT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BillingDocumentTypeText entity;
                        if( toCnsldtnBillingTypeT.size() > i ) {
                            entity = toCnsldtnBillingTypeT.get(i);
                        } else {
                            entity = new BillingDocumentTypeText();
                            toCnsldtnBillingTypeT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BillingDocumentTypeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BillingDocumentTypeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BillingDocumentTypeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BillingDocumentTypeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnBillingTypeT != null ) {
            (values).put("to_CnsldtnBillingTypeT", toCnsldtnBillingTypeT);
        }
        return values;
    }

    /**
     * Fetches the <b>BillingDocumentTypeText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnBillingTypeT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BillingDocumentTypeText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentTypeText> fetchCnsldtnBillingTypeT()
    {
        return fetchFieldAsList("to_CnsldtnBillingTypeT", BillingDocumentTypeText.class);
    }

    /**
     * Retrieval of associated <b>BillingDocumentTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnBillingTypeT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBillingTypeT</b> of a queried <b>BillingDocumentType</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocumentTypeText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BillingDocumentTypeText> getCnsldtnBillingTypeTOrFetch()
    {
        if( toCnsldtnBillingTypeT == null ) {
            toCnsldtnBillingTypeT = fetchCnsldtnBillingTypeT();
        }
        return toCnsldtnBillingTypeT;
    }

    /**
     * Retrieval of associated <b>BillingDocumentTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnBillingTypeT</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocumentType</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnBillingTypeT</b> is already loaded, the result
     *         will contain the <b>BillingDocumentTypeText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BillingDocumentTypeText>> getCnsldtnBillingTypeTIfPresent()
    {
        return Option.of(toCnsldtnBillingTypeT);
    }

    /**
     * Overwrites the list of associated <b>BillingDocumentTypeText</b> entities for the loaded navigation property
     * <b>to_CnsldtnBillingTypeT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBillingTypeT</b> of a queried <b>BillingDocumentType</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BillingDocumentTypeText</b> entities.
     */
    public void setCnsldtnBillingTypeT( @Nonnull final List<BillingDocumentTypeText> value )
    {
        if( toCnsldtnBillingTypeT == null ) {
            toCnsldtnBillingTypeT = Lists.newArrayList();
        }
        toCnsldtnBillingTypeT.clear();
        toCnsldtnBillingTypeT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BillingDocumentTypeText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnBillingTypeT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBillingTypeT</b> of a queried <b>BillingDocumentType</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BillingDocumentTypeText</b> entities.
     */
    public void addCnsldtnBillingTypeT( BillingDocumentTypeText... entity )
    {
        if( toCnsldtnBillingTypeT == null ) {
            toCnsldtnBillingTypeT = Lists.newArrayList();
        }
        toCnsldtnBillingTypeT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BillingDocumentType instances.
     *
     */
    public final static class BillingDocumentTypeBuilder
    {

        private List<BillingDocumentTypeText> toCnsldtnBillingTypeT = Lists.newArrayList();

        private BillingDocumentType.BillingDocumentTypeBuilder toCnsldtnBillingTypeT(
            final List<BillingDocumentTypeText> value )
        {
            toCnsldtnBillingTypeT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnBillingTypeT</b> for <b>BillingDocumentType</b> to multiple
         * <b>BillingDocumentTypeText</b>.
         *
         * @param value
         *            The BillingDocumentTypeTexts to build this BillingDocumentType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentType.BillingDocumentTypeBuilder cnsldtnBillingTypeT( BillingDocumentTypeText... value )
        {
            return toCnsldtnBillingTypeT(Lists.newArrayList(value));
        }

    }

}
