/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BillingDocumentTypeTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.BillingDocumentTypeTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.BillingDocumentTypeTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Billing Type - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BillingDocumentTypeTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BillingDocumentTypeText extends VdmEntity<BillingDocumentTypeText>
{

    /**
     * Selector for all available fields of BillingDocumentTypeText.
     *
     */
    public final static BillingDocumentTypeTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BillingDocumentTypeTextField<String> LANGUAGE =
        new BillingDocumentTypeTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType</b>
     * </p>
     *
     * @return Billing Document Type
     */
    @Key
    @SerializedName( "BillingDocumentType" )
    @JsonProperty( "BillingDocumentType" )
    @Nullable
    @ODataField( odataName = "BillingDocumentType" )
    private String billingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentType</b> field to query operations.
     *
     */
    public final static BillingDocumentTypeTextField<String> BILLING_DOCUMENT_TYPE =
        new BillingDocumentTypeTextField<String>("BillingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentTypeText</b>
     * </p>
     *
     * @return Billing Document Type Description
     */
    @SerializedName( "BillingDocumentTypeText" )
    @JsonProperty( "BillingDocumentTypeText" )
    @Nullable
    @ODataField( odataName = "BillingDocumentTypeText" )
    private String billingDocumentTypeText;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentTypeText</b> field to query operations.
     *
     */
    public final static BillingDocumentTypeTextField<String> BILLING_DOCUMENT_TYPE_TEXT =
        new BillingDocumentTypeTextField<String>("BillingDocumentTypeText");
    /**
     * Navigation property <b>to_CnsldtnBillingType</b> for <b>BillingDocumentTypeText</b> to single
     * <b>BillingDocumentType</b>.
     *
     */
    @SerializedName( "to_CnsldtnBillingType" )
    @JsonProperty( "to_CnsldtnBillingType" )
    @ODataField( odataName = "to_CnsldtnBillingType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BillingDocumentType toCnsldtnBillingType;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnBillingType</b> navigation property to query
     * operations.
     *
     */
    public final static BillingDocumentTypeTextOneToOneLink<BillingDocumentType> TO_CNSLDTN_BILLING_TYPE =
        new BillingDocumentTypeTextOneToOneLink<BillingDocumentType>("to_CnsldtnBillingType");

    @Nonnull
    @Override
    public Class<BillingDocumentTypeText> getType()
    {
        return BillingDocumentTypeText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentType</b>
     * </p>
     *
     * @param billingDocumentType
     *            Billing Document Type
     */
    public void setBillingDocumentType( @Nullable final String billingDocumentType )
    {
        rememberChangedField("BillingDocumentType", this.billingDocumentType);
        this.billingDocumentType = billingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentTypeText</b>
     * </p>
     *
     * @param billingDocumentTypeText
     *            Billing Document Type Description
     */
    public void setBillingDocumentTypeText( @Nullable final String billingDocumentTypeText )
    {
        rememberChangedField("BillingDocumentTypeText", this.billingDocumentTypeText);
        this.billingDocumentTypeText = billingDocumentTypeText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BillingDocumentTypeText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("BillingDocumentType", getBillingDocumentType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("BillingDocumentType", getBillingDocumentType());
        values.put("BillingDocumentTypeText", getBillingDocumentTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentType") ) {
                final Object value = values.remove("BillingDocumentType");
                if( (value == null) || (!value.equals(getBillingDocumentType())) ) {
                    setBillingDocumentType(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentTypeText") ) {
                final Object value = values.remove("BillingDocumentTypeText");
                if( (value == null) || (!value.equals(getBillingDocumentTypeText())) ) {
                    setBillingDocumentTypeText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnBillingType") ) {
                final Object value = (values).remove("to_CnsldtnBillingType");
                if( value instanceof Map ) {
                    if( toCnsldtnBillingType == null ) {
                        toCnsldtnBillingType = new BillingDocumentType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnBillingType.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BillingDocumentTypeTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BillingDocumentTypeTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BillingDocumentTypeTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BillingDocumentTypeTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnBillingType != null ) {
            (values).put("to_CnsldtnBillingType", toCnsldtnBillingType);
        }
        return values;
    }

    /**
     * Fetches the <b>BillingDocumentType</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnBillingType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BillingDocumentType</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillingDocumentType fetchCnsldtnBillingType()
    {
        return fetchFieldAsSingle("to_CnsldtnBillingType", BillingDocumentType.class);
    }

    /**
     * Retrieval of associated <b>BillingDocumentType</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnBillingType</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBillingType</b> of a queried <b>BillingDocumentTypeText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BillingDocumentType</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BillingDocumentType getCnsldtnBillingTypeOrFetch()
    {
        if( toCnsldtnBillingType == null ) {
            toCnsldtnBillingType = fetchCnsldtnBillingType();
        }
        return toCnsldtnBillingType;
    }

    /**
     * Retrieval of associated <b>BillingDocumentType</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnBillingType</b>.
     * <p>
     * If the navigation property for an entity <b>BillingDocumentTypeText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnBillingType</b> is already loaded, the result
     *         will contain the <b>BillingDocumentType</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BillingDocumentType> getCnsldtnBillingTypeIfPresent()
    {
        return Option.of(toCnsldtnBillingType);
    }

    /**
     * Overwrites the associated <b>BillingDocumentType</b> entity for the loaded navigation property
     * <b>to_CnsldtnBillingType</b>.
     *
     * @param value
     *            New <b>BillingDocumentType</b> entity.
     */
    public void setCnsldtnBillingType( final BillingDocumentType value )
    {
        toCnsldtnBillingType = value;
    }

    /**
     * Helper class to allow for fluent creation of BillingDocumentTypeText instances.
     *
     */
    public final static class BillingDocumentTypeTextBuilder
    {

        private BillingDocumentType toCnsldtnBillingType;

        private BillingDocumentTypeText.BillingDocumentTypeTextBuilder toCnsldtnBillingType(
            final BillingDocumentType value )
        {
            toCnsldtnBillingType = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnBillingType</b> for <b>BillingDocumentTypeText</b> to single
         * <b>BillingDocumentType</b>.
         *
         * @param value
         *            The BillingDocumentType to build this BillingDocumentTypeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BillingDocumentTypeText.BillingDocumentTypeTextBuilder cnsldtnBillingType(
            final BillingDocumentType value )
        {
            return toCnsldtnBillingType(value);
        }

    }

}
