/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BreakdownBySubassignmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.BreakdownBySubassignmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Breakdown by Subassignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BreakdownBySubassignmentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BreakdownBySubassignment extends VdmEntity<BreakdownBySubassignment>
{

    /**
     * Selector for all available fields of BreakdownBySubassignment.
     *
     */
    public final static BreakdownBySubassignmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static BreakdownBySubassignmentField<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new BreakdownBySubassignmentField<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static BreakdownBySubassignmentField<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new BreakdownBySubassignmentField<String>("ConsolidationChartOfAccounts_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory</b>
     * </p>
     *
     * @return Breakdown Category
     */
    @Key
    @SerializedName( "BreakdownCategory" )
    @JsonProperty( "BreakdownCategory" )
    @Nullable
    @ODataField( odataName = "BreakdownCategory" )
    private String breakdownCategory;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownCategory</b> field to query operations.
     *
     */
    public final static BreakdownBySubassignmentField<String> BREAKDOWN_CATEGORY =
        new BreakdownBySubassignmentField<String>("BreakdownCategory");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory_Text</b>
     * </p>
     *
     * @return Breakdown Category Description
     */
    @SerializedName( "BreakdownCategory_Text" )
    @JsonProperty( "BreakdownCategory_Text" )
    @Nullable
    @ODataField( odataName = "BreakdownCategory_Text" )
    private String breakdownCategory_Text;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownCategory_Text</b> field to query operations.
     *
     */
    public final static BreakdownBySubassignmentField<String> BREAKDOWN_CATEGORY_TEXT =
        new BreakdownBySubassignmentField<String>("BreakdownCategory_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSubassignment</b>
     * </p>
     *
     * @return Subassignment
     */
    @Key
    @SerializedName( "CnsldtnSubassignment" )
    @JsonProperty( "CnsldtnSubassignment" )
    @Nullable
    @ODataField( odataName = "CnsldtnSubassignment" )
    private String cnsldtnSubassignment;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnSubassignment</b> field to query operations.
     *
     */
    public final static BreakdownBySubassignmentField<String> CNSLDTN_SUBASSIGNMENT =
        new BreakdownBySubassignmentField<String>("CnsldtnSubassignment");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSubassignment_Text</b>
     * </p>
     *
     * @return Subassignment Description
     */
    @SerializedName( "CnsldtnSubassignment_Text" )
    @JsonProperty( "CnsldtnSubassignment_Text" )
    @Nullable
    @ODataField( odataName = "CnsldtnSubassignment_Text" )
    private String cnsldtnSubassignment_Text;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnSubassignment_Text</b> field to query operations.
     *
     */
    public final static BreakdownBySubassignmentField<String> CNSLDTN_SUBASSIGNMENT_TEXT =
        new BreakdownBySubassignmentField<String>("CnsldtnSubassignment_Text");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownType</b>
     * </p>
     *
     * @return Breakdown Type
     */
    @SerializedName( "BreakdownType" )
    @JsonProperty( "BreakdownType" )
    @Nullable
    @ODataField( odataName = "BreakdownType" )
    private String breakdownType;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownType</b> field to query operations.
     *
     */
    public final static BreakdownBySubassignmentField<String> BREAKDOWN_TYPE =
        new BreakdownBySubassignmentField<String>("BreakdownType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownType_Text</b>
     * </p>
     *
     * @return Breakdown Type Description
     */
    @SerializedName( "BreakdownType_Text" )
    @JsonProperty( "BreakdownType_Text" )
    @Nullable
    @ODataField( odataName = "BreakdownType_Text" )
    private String breakdownType_Text;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownType_Text</b> field to query operations.
     *
     */
    public final static BreakdownBySubassignmentField<String> BREAKDOWN_TYPE_TEXT =
        new BreakdownBySubassignmentField<String>("BreakdownType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnFixedValueOfSubassgmt</b>
     * </p>
     *
     * @return Subassignment Fixed Value
     */
    @SerializedName( "CnsldtnFixedValueOfSubassgmt" )
    @JsonProperty( "CnsldtnFixedValueOfSubassgmt" )
    @Nullable
    @ODataField( odataName = "CnsldtnFixedValueOfSubassgmt" )
    private String cnsldtnFixedValueOfSubassgmt;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnFixedValueOfSubassgmt</b> field to query operations.
     *
     */
    public final static BreakdownBySubassignmentField<String> CNSLDTN_FIXED_VALUE_OF_SUBASSGMT =
        new BreakdownBySubassignmentField<String>("CnsldtnFixedValueOfSubassgmt");

    @Nonnull
    @Override
    public Class<BreakdownBySubassignment> getType()
    {
        return BreakdownBySubassignment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory</b>
     * </p>
     *
     * @param breakdownCategory
     *            Breakdown Category
     */
    public void setBreakdownCategory( @Nullable final String breakdownCategory )
    {
        rememberChangedField("BreakdownCategory", this.breakdownCategory);
        this.breakdownCategory = breakdownCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory_Text</b>
     * </p>
     *
     * @param breakdownCategory_Text
     *            Breakdown Category Description
     */
    public void setBreakdownCategory_Text( @Nullable final String breakdownCategory_Text )
    {
        rememberChangedField("BreakdownCategory_Text", this.breakdownCategory_Text);
        this.breakdownCategory_Text = breakdownCategory_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSubassignment</b>
     * </p>
     *
     * @param cnsldtnSubassignment
     *            Subassignment
     */
    public void setCnsldtnSubassignment( @Nullable final String cnsldtnSubassignment )
    {
        rememberChangedField("CnsldtnSubassignment", this.cnsldtnSubassignment);
        this.cnsldtnSubassignment = cnsldtnSubassignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSubassignment_Text</b>
     * </p>
     *
     * @param cnsldtnSubassignment_Text
     *            Subassignment Description
     */
    public void setCnsldtnSubassignment_Text( @Nullable final String cnsldtnSubassignment_Text )
    {
        rememberChangedField("CnsldtnSubassignment_Text", this.cnsldtnSubassignment_Text);
        this.cnsldtnSubassignment_Text = cnsldtnSubassignment_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownType</b>
     * </p>
     *
     * @param breakdownType
     *            Breakdown Type
     */
    public void setBreakdownType( @Nullable final String breakdownType )
    {
        rememberChangedField("BreakdownType", this.breakdownType);
        this.breakdownType = breakdownType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownType_Text</b>
     * </p>
     *
     * @param breakdownType_Text
     *            Breakdown Type Description
     */
    public void setBreakdownType_Text( @Nullable final String breakdownType_Text )
    {
        rememberChangedField("BreakdownType_Text", this.breakdownType_Text);
        this.breakdownType_Text = breakdownType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnFixedValueOfSubassgmt</b>
     * </p>
     *
     * @param cnsldtnFixedValueOfSubassgmt
     *            Subassignment Fixed Value
     */
    public void setCnsldtnFixedValueOfSubassgmt( @Nullable final String cnsldtnFixedValueOfSubassgmt )
    {
        rememberChangedField("CnsldtnFixedValueOfSubassgmt", this.cnsldtnFixedValueOfSubassgmt);
        this.cnsldtnFixedValueOfSubassgmt = cnsldtnFixedValueOfSubassgmt;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BreakdownBySubassignment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("BreakdownCategory", getBreakdownCategory());
        result.put("CnsldtnSubassignment", getCnsldtnSubassignment());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("BreakdownCategory", getBreakdownCategory());
        values.put("BreakdownCategory_Text", getBreakdownCategory_Text());
        values.put("CnsldtnSubassignment", getCnsldtnSubassignment());
        values.put("CnsldtnSubassignment_Text", getCnsldtnSubassignment_Text());
        values.put("BreakdownType", getBreakdownType());
        values.put("BreakdownType_Text", getBreakdownType_Text());
        values.put("CnsldtnFixedValueOfSubassgmt", getCnsldtnFixedValueOfSubassgmt());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("BreakdownCategory") ) {
                final Object value = values.remove("BreakdownCategory");
                if( (value == null) || (!value.equals(getBreakdownCategory())) ) {
                    setBreakdownCategory(((String) value));
                }
            }
            if( values.containsKey("BreakdownCategory_Text") ) {
                final Object value = values.remove("BreakdownCategory_Text");
                if( (value == null) || (!value.equals(getBreakdownCategory_Text())) ) {
                    setBreakdownCategory_Text(((String) value));
                }
            }
            if( values.containsKey("CnsldtnSubassignment") ) {
                final Object value = values.remove("CnsldtnSubassignment");
                if( (value == null) || (!value.equals(getCnsldtnSubassignment())) ) {
                    setCnsldtnSubassignment(((String) value));
                }
            }
            if( values.containsKey("CnsldtnSubassignment_Text") ) {
                final Object value = values.remove("CnsldtnSubassignment_Text");
                if( (value == null) || (!value.equals(getCnsldtnSubassignment_Text())) ) {
                    setCnsldtnSubassignment_Text(((String) value));
                }
            }
            if( values.containsKey("BreakdownType") ) {
                final Object value = values.remove("BreakdownType");
                if( (value == null) || (!value.equals(getBreakdownType())) ) {
                    setBreakdownType(((String) value));
                }
            }
            if( values.containsKey("BreakdownType_Text") ) {
                final Object value = values.remove("BreakdownType_Text");
                if( (value == null) || (!value.equals(getBreakdownType_Text())) ) {
                    setBreakdownType_Text(((String) value));
                }
            }
            if( values.containsKey("CnsldtnFixedValueOfSubassgmt") ) {
                final Object value = values.remove("CnsldtnFixedValueOfSubassgmt");
                if( (value == null) || (!value.equals(getCnsldtnFixedValueOfSubassgmt())) ) {
                    setCnsldtnFixedValueOfSubassgmt(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BreakdownBySubassignmentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BreakdownBySubassignmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BreakdownBySubassignmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BreakdownBySubassignmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

}
