/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BreakdownCategoryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.BreakdownCategoryLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.BreakdownCategorySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Breakdown Category
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BreakdownCategoryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BreakdownCategory extends VdmEntity<BreakdownCategory>
{

    /**
     * Selector for all available fields of BreakdownCategory.
     *
     */
    public final static BreakdownCategorySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static BreakdownCategoryField<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new BreakdownCategoryField<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static BreakdownCategoryField<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new BreakdownCategoryField<String>("ConsolidationChartOfAccounts_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory</b>
     * </p>
     *
     * @return Breakdown Category
     */
    @Key
    @SerializedName( "BreakdownCategory" )
    @JsonProperty( "BreakdownCategory" )
    @Nullable
    @ODataField( odataName = "BreakdownCategory" )
    private String breakdownCategory;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownCategory</b> field to query operations.
     *
     */
    public final static BreakdownCategoryField<String> BREAKDOWN_CATEGORY =
        new BreakdownCategoryField<String>("BreakdownCategory");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory_Text</b>
     * </p>
     *
     * @return Breakdown Category Description
     */
    @SerializedName( "BreakdownCategory_Text" )
    @JsonProperty( "BreakdownCategory_Text" )
    @Nullable
    @ODataField( odataName = "BreakdownCategory_Text" )
    private String breakdownCategory_Text;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownCategory_Text</b> field to query operations.
     *
     */
    public final static BreakdownCategoryField<String> BREAKDOWN_CATEGORY_TEXT =
        new BreakdownCategoryField<String>("BreakdownCategory_Text");
    /**
     * Navigation property <b>to_CnsldtnBreakdownCategoryT</b> for <b>BreakdownCategory</b> to multiple
     * <b>BreakdownCategoryText</b>.
     *
     */
    @SerializedName( "to_CnsldtnBreakdownCategoryT" )
    @JsonProperty( "to_CnsldtnBreakdownCategoryT" )
    @ODataField( odataName = "to_CnsldtnBreakdownCategoryT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BreakdownCategoryText> toCnsldtnBreakdownCategoryT;
    /**
     * Navigation property <b>to_CnsldtnBrkdwnBySubassgmt</b> for <b>BreakdownCategory</b> to multiple
     * <b>BreakdownBySubassignment</b>.
     *
     */
    @SerializedName( "to_CnsldtnBrkdwnBySubassgmt" )
    @JsonProperty( "to_CnsldtnBrkdwnBySubassgmt" )
    @ODataField( odataName = "to_CnsldtnBrkdwnBySubassgmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BreakdownBySubassignment> toCnsldtnBrkdwnBySubassgmt;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnBreakdownCategoryT</b> navigation property to query
     * operations.
     *
     */
    public final static BreakdownCategoryLink<BreakdownCategoryText> TO_CNSLDTN_BREAKDOWN_CATEGORY_T =
        new BreakdownCategoryLink<BreakdownCategoryText>("to_CnsldtnBreakdownCategoryT");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnBrkdwnBySubassgmt</b> navigation property to query
     * operations.
     *
     */
    public final static BreakdownCategoryLink<BreakdownBySubassignment> TO_CNSLDTN_BRKDWN_BY_SUBASSGMT =
        new BreakdownCategoryLink<BreakdownBySubassignment>("to_CnsldtnBrkdwnBySubassgmt");

    @Nonnull
    @Override
    public Class<BreakdownCategory> getType()
    {
        return BreakdownCategory.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory</b>
     * </p>
     *
     * @param breakdownCategory
     *            Breakdown Category
     */
    public void setBreakdownCategory( @Nullable final String breakdownCategory )
    {
        rememberChangedField("BreakdownCategory", this.breakdownCategory);
        this.breakdownCategory = breakdownCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory_Text</b>
     * </p>
     *
     * @param breakdownCategory_Text
     *            Breakdown Category Description
     */
    public void setBreakdownCategory_Text( @Nullable final String breakdownCategory_Text )
    {
        rememberChangedField("BreakdownCategory_Text", this.breakdownCategory_Text);
        this.breakdownCategory_Text = breakdownCategory_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BreakdownCategory";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("BreakdownCategory", getBreakdownCategory());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("BreakdownCategory", getBreakdownCategory());
        values.put("BreakdownCategory_Text", getBreakdownCategory_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("BreakdownCategory") ) {
                final Object value = values.remove("BreakdownCategory");
                if( (value == null) || (!value.equals(getBreakdownCategory())) ) {
                    setBreakdownCategory(((String) value));
                }
            }
            if( values.containsKey("BreakdownCategory_Text") ) {
                final Object value = values.remove("BreakdownCategory_Text");
                if( (value == null) || (!value.equals(getBreakdownCategory_Text())) ) {
                    setBreakdownCategory_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnBreakdownCategoryT") ) {
                final Object value = (values).remove("to_CnsldtnBreakdownCategoryT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnBreakdownCategoryT == null ) {
                        toCnsldtnBreakdownCategoryT = Lists.newArrayList();
                    } else {
                        toCnsldtnBreakdownCategoryT = Lists.newArrayList(toCnsldtnBreakdownCategoryT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BreakdownCategoryText entity;
                        if( toCnsldtnBreakdownCategoryT.size() > i ) {
                            entity = toCnsldtnBreakdownCategoryT.get(i);
                        } else {
                            entity = new BreakdownCategoryText();
                            toCnsldtnBreakdownCategoryT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnBrkdwnBySubassgmt") ) {
                final Object value = (values).remove("to_CnsldtnBrkdwnBySubassgmt");
                if( value instanceof Iterable ) {
                    if( toCnsldtnBrkdwnBySubassgmt == null ) {
                        toCnsldtnBrkdwnBySubassgmt = Lists.newArrayList();
                    } else {
                        toCnsldtnBrkdwnBySubassgmt = Lists.newArrayList(toCnsldtnBrkdwnBySubassgmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BreakdownBySubassignment entity;
                        if( toCnsldtnBrkdwnBySubassgmt.size() > i ) {
                            entity = toCnsldtnBrkdwnBySubassgmt.get(i);
                        } else {
                            entity = new BreakdownBySubassignment();
                            toCnsldtnBrkdwnBySubassgmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BreakdownCategoryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BreakdownCategoryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BreakdownCategoryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BreakdownCategoryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnBreakdownCategoryT != null ) {
            (values).put("to_CnsldtnBreakdownCategoryT", toCnsldtnBreakdownCategoryT);
        }
        if( toCnsldtnBrkdwnBySubassgmt != null ) {
            (values).put("to_CnsldtnBrkdwnBySubassgmt", toCnsldtnBrkdwnBySubassgmt);
        }
        return values;
    }

    /**
     * Fetches the <b>BreakdownCategoryText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnBreakdownCategoryT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BreakdownCategoryText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BreakdownCategoryText> fetchCnsldtnBreakdownCategoryT()
    {
        return fetchFieldAsList("to_CnsldtnBreakdownCategoryT", BreakdownCategoryText.class);
    }

    /**
     * Retrieval of associated <b>BreakdownCategoryText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnBreakdownCategoryT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBreakdownCategoryT</b> of a queried <b>BreakdownCategory</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BreakdownCategoryText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BreakdownCategoryText> getCnsldtnBreakdownCategoryTOrFetch()
    {
        if( toCnsldtnBreakdownCategoryT == null ) {
            toCnsldtnBreakdownCategoryT = fetchCnsldtnBreakdownCategoryT();
        }
        return toCnsldtnBreakdownCategoryT;
    }

    /**
     * Retrieval of associated <b>BreakdownCategoryText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnBreakdownCategoryT</b>.
     * <p>
     * If the navigation property for an entity <b>BreakdownCategory</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnBreakdownCategoryT</b> is already loaded, the
     *         result will contain the <b>BreakdownCategoryText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BreakdownCategoryText>> getCnsldtnBreakdownCategoryTIfPresent()
    {
        return Option.of(toCnsldtnBreakdownCategoryT);
    }

    /**
     * Overwrites the list of associated <b>BreakdownCategoryText</b> entities for the loaded navigation property
     * <b>to_CnsldtnBreakdownCategoryT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBreakdownCategoryT</b> of a queried <b>BreakdownCategory</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BreakdownCategoryText</b> entities.
     */
    public void setCnsldtnBreakdownCategoryT( @Nonnull final List<BreakdownCategoryText> value )
    {
        if( toCnsldtnBreakdownCategoryT == null ) {
            toCnsldtnBreakdownCategoryT = Lists.newArrayList();
        }
        toCnsldtnBreakdownCategoryT.clear();
        toCnsldtnBreakdownCategoryT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BreakdownCategoryText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnBreakdownCategoryT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBreakdownCategoryT</b> of a queried <b>BreakdownCategory</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BreakdownCategoryText</b> entities.
     */
    public void addCnsldtnBreakdownCategoryT( BreakdownCategoryText... entity )
    {
        if( toCnsldtnBreakdownCategoryT == null ) {
            toCnsldtnBreakdownCategoryT = Lists.newArrayList();
        }
        toCnsldtnBreakdownCategoryT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BreakdownBySubassignment</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnBrkdwnBySubassgmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BreakdownBySubassignment</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BreakdownBySubassignment> fetchCnsldtnBrkdwnBySubassgmt()
    {
        return fetchFieldAsList("to_CnsldtnBrkdwnBySubassgmt", BreakdownBySubassignment.class);
    }

    /**
     * Retrieval of associated <b>BreakdownBySubassignment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnBrkdwnBySubassgmt</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBrkdwnBySubassgmt</b> of a queried <b>BreakdownCategory</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BreakdownBySubassignment</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BreakdownBySubassignment> getCnsldtnBrkdwnBySubassgmtOrFetch()
    {
        if( toCnsldtnBrkdwnBySubassgmt == null ) {
            toCnsldtnBrkdwnBySubassgmt = fetchCnsldtnBrkdwnBySubassgmt();
        }
        return toCnsldtnBrkdwnBySubassgmt;
    }

    /**
     * Retrieval of associated <b>BreakdownBySubassignment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnBrkdwnBySubassgmt</b>.
     * <p>
     * If the navigation property for an entity <b>BreakdownCategory</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnBrkdwnBySubassgmt</b> is already loaded, the
     *         result will contain the <b>BreakdownBySubassignment</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BreakdownBySubassignment>> getCnsldtnBrkdwnBySubassgmtIfPresent()
    {
        return Option.of(toCnsldtnBrkdwnBySubassgmt);
    }

    /**
     * Overwrites the list of associated <b>BreakdownBySubassignment</b> entities for the loaded navigation property
     * <b>to_CnsldtnBrkdwnBySubassgmt</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBrkdwnBySubassgmt</b> of a queried <b>BreakdownCategory</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BreakdownBySubassignment</b> entities.
     */
    public void setCnsldtnBrkdwnBySubassgmt( @Nonnull final List<BreakdownBySubassignment> value )
    {
        if( toCnsldtnBrkdwnBySubassgmt == null ) {
            toCnsldtnBrkdwnBySubassgmt = Lists.newArrayList();
        }
        toCnsldtnBrkdwnBySubassgmt.clear();
        toCnsldtnBrkdwnBySubassgmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BreakdownBySubassignment</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnBrkdwnBySubassgmt</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBrkdwnBySubassgmt</b> of a queried <b>BreakdownCategory</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BreakdownBySubassignment</b> entities.
     */
    public void addCnsldtnBrkdwnBySubassgmt( BreakdownBySubassignment... entity )
    {
        if( toCnsldtnBrkdwnBySubassgmt == null ) {
            toCnsldtnBrkdwnBySubassgmt = Lists.newArrayList();
        }
        toCnsldtnBrkdwnBySubassgmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BreakdownCategory instances.
     *
     */
    public final static class BreakdownCategoryBuilder
    {

        private List<BreakdownCategoryText> toCnsldtnBreakdownCategoryT = Lists.newArrayList();
        private List<BreakdownBySubassignment> toCnsldtnBrkdwnBySubassgmt = Lists.newArrayList();

        private BreakdownCategory.BreakdownCategoryBuilder toCnsldtnBreakdownCategoryT(
            final List<BreakdownCategoryText> value )
        {
            toCnsldtnBreakdownCategoryT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnBreakdownCategoryT</b> for <b>BreakdownCategory</b> to multiple
         * <b>BreakdownCategoryText</b>.
         *
         * @param value
         *            The BreakdownCategoryTexts to build this BreakdownCategory with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BreakdownCategory.BreakdownCategoryBuilder cnsldtnBreakdownCategoryT( BreakdownCategoryText... value )
        {
            return toCnsldtnBreakdownCategoryT(Lists.newArrayList(value));
        }

        private BreakdownCategory.BreakdownCategoryBuilder toCnsldtnBrkdwnBySubassgmt(
            final List<BreakdownBySubassignment> value )
        {
            toCnsldtnBrkdwnBySubassgmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnBrkdwnBySubassgmt</b> for <b>BreakdownCategory</b> to multiple
         * <b>BreakdownBySubassignment</b>.
         *
         * @param value
         *            The BreakdownBySubassignments to build this BreakdownCategory with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BreakdownCategory.BreakdownCategoryBuilder cnsldtnBrkdwnBySubassgmt( BreakdownBySubassignment... value )
        {
            return toCnsldtnBrkdwnBySubassgmt(Lists.newArrayList(value));
        }

    }

}
