/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BreakdownCategoryTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.BreakdownCategoryTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.BreakdownCategoryTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Breakdown Category - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BreakdownCategoryTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BreakdownCategoryText extends VdmEntity<BreakdownCategoryText>
{

    /**
     * Selector for all available fields of BreakdownCategoryText.
     *
     */
    public final static BreakdownCategoryTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BreakdownCategoryTextField<String> LANGUAGE =
        new BreakdownCategoryTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static BreakdownCategoryTextField<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new BreakdownCategoryTextField<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static BreakdownCategoryTextField<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new BreakdownCategoryTextField<String>("ConsolidationChartOfAccounts_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory</b>
     * </p>
     *
     * @return Breakdown Category
     */
    @Key
    @SerializedName( "BreakdownCategory" )
    @JsonProperty( "BreakdownCategory" )
    @Nullable
    @ODataField( odataName = "BreakdownCategory" )
    private String breakdownCategory;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownCategory</b> field to query operations.
     *
     */
    public final static BreakdownCategoryTextField<String> BREAKDOWN_CATEGORY =
        new BreakdownCategoryTextField<String>("BreakdownCategory");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategoryText</b>
     * </p>
     *
     * @return Breakdown Category Description
     */
    @SerializedName( "BreakdownCategoryText" )
    @JsonProperty( "BreakdownCategoryText" )
    @Nullable
    @ODataField( odataName = "BreakdownCategoryText" )
    private String breakdownCategoryText;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownCategoryText</b> field to query operations.
     *
     */
    public final static BreakdownCategoryTextField<String> BREAKDOWN_CATEGORY_TEXT =
        new BreakdownCategoryTextField<String>("BreakdownCategoryText");
    /**
     * Navigation property <b>to_CnsldtnBreakdownCategory</b> for <b>BreakdownCategoryText</b> to single
     * <b>BreakdownCategory</b>.
     *
     */
    @SerializedName( "to_CnsldtnBreakdownCategory" )
    @JsonProperty( "to_CnsldtnBreakdownCategory" )
    @ODataField( odataName = "to_CnsldtnBreakdownCategory" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BreakdownCategory toCnsldtnBreakdownCategory;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnBreakdownCategory</b> navigation property to query
     * operations.
     *
     */
    public final static BreakdownCategoryTextOneToOneLink<BreakdownCategory> TO_CNSLDTN_BREAKDOWN_CATEGORY =
        new BreakdownCategoryTextOneToOneLink<BreakdownCategory>("to_CnsldtnBreakdownCategory");

    @Nonnull
    @Override
    public Class<BreakdownCategoryText> getType()
    {
        return BreakdownCategoryText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategory</b>
     * </p>
     *
     * @param breakdownCategory
     *            Breakdown Category
     */
    public void setBreakdownCategory( @Nullable final String breakdownCategory )
    {
        rememberChangedField("BreakdownCategory", this.breakdownCategory);
        this.breakdownCategory = breakdownCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownCategoryText</b>
     * </p>
     *
     * @param breakdownCategoryText
     *            Breakdown Category Description
     */
    public void setBreakdownCategoryText( @Nullable final String breakdownCategoryText )
    {
        rememberChangedField("BreakdownCategoryText", this.breakdownCategoryText);
        this.breakdownCategoryText = breakdownCategoryText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BreakdownCategoryText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("BreakdownCategory", getBreakdownCategory());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("BreakdownCategory", getBreakdownCategory());
        values.put("BreakdownCategoryText", getBreakdownCategoryText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("BreakdownCategory") ) {
                final Object value = values.remove("BreakdownCategory");
                if( (value == null) || (!value.equals(getBreakdownCategory())) ) {
                    setBreakdownCategory(((String) value));
                }
            }
            if( values.containsKey("BreakdownCategoryText") ) {
                final Object value = values.remove("BreakdownCategoryText");
                if( (value == null) || (!value.equals(getBreakdownCategoryText())) ) {
                    setBreakdownCategoryText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnBreakdownCategory") ) {
                final Object value = (values).remove("to_CnsldtnBreakdownCategory");
                if( value instanceof Map ) {
                    if( toCnsldtnBreakdownCategory == null ) {
                        toCnsldtnBreakdownCategory = new BreakdownCategory();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnBreakdownCategory.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BreakdownCategoryTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BreakdownCategoryTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BreakdownCategoryTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BreakdownCategoryTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnBreakdownCategory != null ) {
            (values).put("to_CnsldtnBreakdownCategory", toCnsldtnBreakdownCategory);
        }
        return values;
    }

    /**
     * Fetches the <b>BreakdownCategory</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnBreakdownCategory</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BreakdownCategory</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BreakdownCategory fetchCnsldtnBreakdownCategory()
    {
        return fetchFieldAsSingle("to_CnsldtnBreakdownCategory", BreakdownCategory.class);
    }

    /**
     * Retrieval of associated <b>BreakdownCategory</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnBreakdownCategory</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBreakdownCategory</b> of a queried <b>BreakdownCategoryText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BreakdownCategory</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BreakdownCategory getCnsldtnBreakdownCategoryOrFetch()
    {
        if( toCnsldtnBreakdownCategory == null ) {
            toCnsldtnBreakdownCategory = fetchCnsldtnBreakdownCategory();
        }
        return toCnsldtnBreakdownCategory;
    }

    /**
     * Retrieval of associated <b>BreakdownCategory</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnBreakdownCategory</b>.
     * <p>
     * If the navigation property for an entity <b>BreakdownCategoryText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnBreakdownCategory</b> is already loaded, the
     *         result will contain the <b>BreakdownCategory</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BreakdownCategory> getCnsldtnBreakdownCategoryIfPresent()
    {
        return Option.of(toCnsldtnBreakdownCategory);
    }

    /**
     * Overwrites the associated <b>BreakdownCategory</b> entity for the loaded navigation property
     * <b>to_CnsldtnBreakdownCategory</b>.
     *
     * @param value
     *            New <b>BreakdownCategory</b> entity.
     */
    public void setCnsldtnBreakdownCategory( final BreakdownCategory value )
    {
        toCnsldtnBreakdownCategory = value;
    }

    /**
     * Helper class to allow for fluent creation of BreakdownCategoryText instances.
     *
     */
    public final static class BreakdownCategoryTextBuilder
    {

        private BreakdownCategory toCnsldtnBreakdownCategory;

        private BreakdownCategoryText.BreakdownCategoryTextBuilder toCnsldtnBreakdownCategory(
            final BreakdownCategory value )
        {
            toCnsldtnBreakdownCategory = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnBreakdownCategory</b> for <b>BreakdownCategoryText</b> to single
         * <b>BreakdownCategory</b>.
         *
         * @param value
         *            The BreakdownCategory to build this BreakdownCategoryText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BreakdownCategoryText.BreakdownCategoryTextBuilder cnsldtnBreakdownCategory(
            final BreakdownCategory value )
        {
            return toCnsldtnBreakdownCategory(value);
        }

    }

}
