/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.BreakdownCategoryTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BreakdownCategoryText
 * BreakdownCategoryText} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class BreakdownCategoryTextByKeyFluentHelper
    extends
    FluentHelperByKey<BreakdownCategoryTextByKeyFluentHelper, BreakdownCategoryText, BreakdownCategoryTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.BreakdownCategoryText
     * BreakdownCategoryText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BreakdownCategoryText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code BreakdownCategoryText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param breakdownCategory
     *            Breakdown Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public BreakdownCategoryTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String language,
        final String consolidationChartOfAccounts,
        final String breakdownCategory )
    {
        super(servicePath, entityCollection);
        this.key.put("Language", language);
        this.key.put("ConsolidationChartOfAccounts", consolidationChartOfAccounts);
        this.key.put("BreakdownCategory", breakdownCategory);
    }

    @Override
    @Nonnull
    protected Class<BreakdownCategoryText> getEntityClass()
    {
        return BreakdownCategoryText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
