/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.BreakdownTypeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.BreakdownTypeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.BreakdownTypeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Consolidation Breakdown Type
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BreakdownTypeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BreakdownType extends VdmEntity<BreakdownType>
{

    /**
     * Selector for all available fields of BreakdownType.
     *
     */
    public final static BreakdownTypeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownType</b>
     * </p>
     *
     * @return Breakdown Type
     */
    @Key
    @SerializedName( "BreakdownType" )
    @JsonProperty( "BreakdownType" )
    @Nullable
    @ODataField( odataName = "BreakdownType" )
    private String breakdownType;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownType</b> field to query operations.
     *
     */
    public final static BreakdownTypeField<String> BREAKDOWN_TYPE = new BreakdownTypeField<String>("BreakdownType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownType_Text</b>
     * </p>
     *
     * @return Breakdown Type Description
     */
    @SerializedName( "BreakdownType_Text" )
    @JsonProperty( "BreakdownType_Text" )
    @Nullable
    @ODataField( odataName = "BreakdownType_Text" )
    private String breakdownType_Text;
    /**
     * Use with available fluent helpers to apply the <b>BreakdownType_Text</b> field to query operations.
     *
     */
    public final static BreakdownTypeField<String> BREAKDOWN_TYPE_TEXT =
        new BreakdownTypeField<String>("BreakdownType_Text");
    /**
     * Navigation property <b>to_CnsldtnBreakdownTypeT</b> for <b>BreakdownType</b> to multiple
     * <b>BreakdownTypeText</b>.
     *
     */
    @SerializedName( "to_CnsldtnBreakdownTypeT" )
    @JsonProperty( "to_CnsldtnBreakdownTypeT" )
    @ODataField( odataName = "to_CnsldtnBreakdownTypeT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BreakdownTypeText> toCnsldtnBreakdownTypeT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnBreakdownTypeT</b> navigation property to query
     * operations.
     *
     */
    public final static BreakdownTypeLink<BreakdownTypeText> TO_CNSLDTN_BREAKDOWN_TYPE_T =
        new BreakdownTypeLink<BreakdownTypeText>("to_CnsldtnBreakdownTypeT");

    @Nonnull
    @Override
    public Class<BreakdownType> getType()
    {
        return BreakdownType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownType</b>
     * </p>
     *
     * @param breakdownType
     *            Breakdown Type
     */
    public void setBreakdownType( @Nullable final String breakdownType )
    {
        rememberChangedField("BreakdownType", this.breakdownType);
        this.breakdownType = breakdownType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BreakdownType_Text</b>
     * </p>
     *
     * @param breakdownType_Text
     *            Breakdown Type Description
     */
    public void setBreakdownType_Text( @Nullable final String breakdownType_Text )
    {
        rememberChangedField("BreakdownType_Text", this.breakdownType_Text);
        this.breakdownType_Text = breakdownType_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "BreakdownType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BreakdownType", getBreakdownType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BreakdownType", getBreakdownType());
        values.put("BreakdownType_Text", getBreakdownType_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BreakdownType") ) {
                final Object value = values.remove("BreakdownType");
                if( (value == null) || (!value.equals(getBreakdownType())) ) {
                    setBreakdownType(((String) value));
                }
            }
            if( values.containsKey("BreakdownType_Text") ) {
                final Object value = values.remove("BreakdownType_Text");
                if( (value == null) || (!value.equals(getBreakdownType_Text())) ) {
                    setBreakdownType_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnBreakdownTypeT") ) {
                final Object value = (values).remove("to_CnsldtnBreakdownTypeT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnBreakdownTypeT == null ) {
                        toCnsldtnBreakdownTypeT = Lists.newArrayList();
                    } else {
                        toCnsldtnBreakdownTypeT = Lists.newArrayList(toCnsldtnBreakdownTypeT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BreakdownTypeText entity;
                        if( toCnsldtnBreakdownTypeT.size() > i ) {
                            entity = toCnsldtnBreakdownTypeT.get(i);
                        } else {
                            entity = new BreakdownTypeText();
                            toCnsldtnBreakdownTypeT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BreakdownTypeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BreakdownTypeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BreakdownTypeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BreakdownTypeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnBreakdownTypeT != null ) {
            (values).put("to_CnsldtnBreakdownTypeT", toCnsldtnBreakdownTypeT);
        }
        return values;
    }

    /**
     * Fetches the <b>BreakdownTypeText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnBreakdownTypeT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BreakdownTypeText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BreakdownTypeText> fetchCnsldtnBreakdownTypeT()
    {
        return fetchFieldAsList("to_CnsldtnBreakdownTypeT", BreakdownTypeText.class);
    }

    /**
     * Retrieval of associated <b>BreakdownTypeText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnBreakdownTypeT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBreakdownTypeT</b> of a queried <b>BreakdownType</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BreakdownTypeText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BreakdownTypeText> getCnsldtnBreakdownTypeTOrFetch()
    {
        if( toCnsldtnBreakdownTypeT == null ) {
            toCnsldtnBreakdownTypeT = fetchCnsldtnBreakdownTypeT();
        }
        return toCnsldtnBreakdownTypeT;
    }

    /**
     * Retrieval of associated <b>BreakdownTypeText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnBreakdownTypeT</b>.
     * <p>
     * If the navigation property for an entity <b>BreakdownType</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnBreakdownTypeT</b> is already loaded, the result
     *         will contain the <b>BreakdownTypeText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BreakdownTypeText>> getCnsldtnBreakdownTypeTIfPresent()
    {
        return Option.of(toCnsldtnBreakdownTypeT);
    }

    /**
     * Overwrites the list of associated <b>BreakdownTypeText</b> entities for the loaded navigation property
     * <b>to_CnsldtnBreakdownTypeT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBreakdownTypeT</b> of a queried <b>BreakdownType</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BreakdownTypeText</b> entities.
     */
    public void setCnsldtnBreakdownTypeT( @Nonnull final List<BreakdownTypeText> value )
    {
        if( toCnsldtnBreakdownTypeT == null ) {
            toCnsldtnBreakdownTypeT = Lists.newArrayList();
        }
        toCnsldtnBreakdownTypeT.clear();
        toCnsldtnBreakdownTypeT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BreakdownTypeText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnBreakdownTypeT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnBreakdownTypeT</b> of a queried <b>BreakdownType</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BreakdownTypeText</b> entities.
     */
    public void addCnsldtnBreakdownTypeT( BreakdownTypeText... entity )
    {
        if( toCnsldtnBreakdownTypeT == null ) {
            toCnsldtnBreakdownTypeT = Lists.newArrayList();
        }
        toCnsldtnBreakdownTypeT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BreakdownType instances.
     *
     */
    public final static class BreakdownTypeBuilder
    {

        private List<BreakdownTypeText> toCnsldtnBreakdownTypeT = Lists.newArrayList();

        private BreakdownType.BreakdownTypeBuilder toCnsldtnBreakdownTypeT( final List<BreakdownTypeText> value )
        {
            toCnsldtnBreakdownTypeT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnBreakdownTypeT</b> for <b>BreakdownType</b> to multiple
         * <b>BreakdownTypeText</b>.
         *
         * @param value
         *            The BreakdownTypeTexts to build this BreakdownType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BreakdownType.BreakdownTypeBuilder cnsldtnBreakdownTypeT( BreakdownTypeText... value )
        {
            return toCnsldtnBreakdownTypeT(Lists.newArrayList(value));
        }

    }

}
